/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.protocol.sip;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sip.address.Address;
import junit.framework.TestCase;
import net.java.sip.communicator.impl.protocol.sip.ContactSipImpl;
import net.java.sip.communicator.impl.protocol.sip.ProtocolProviderServiceSipImpl;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.SecurityAuthority;
import net.java.sip.communicator.service.protocol.UserCredentials;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.slick.protocol.sip.SipSlickFixture;
import net.java.sip.communicator.util.Logger;

public class TestProtocolProviderServiceSipImpl
extends TestCase {
    private static final Logger logger = Logger.getLogger(TestProtocolProviderServiceSipImpl.class);
    private SipSlickFixture fixture = new SipSlickFixture();
    public RegistrationEventCollector regEvtCollector1 = new RegistrationEventCollector();
    public RegistrationEventCollector regEvtCollector2 = new RegistrationEventCollector();

    public TestProtocolProviderServiceSipImpl(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.fixture.setUp();
    }

    protected void tearDown() throws Exception {
        this.fixture.tearDown();
        super.tearDown();
    }

    public void testRegister() throws OperationFailedException {
        this.fixture.provider1.addRegistrationStateChangeListener((RegistrationStateChangeListener)this.regEvtCollector1);
        this.fixture.provider2.addRegistrationStateChangeListener((RegistrationStateChangeListener)this.regEvtCollector2);
        this.fixture.provider1.register((SecurityAuthority)new SecurityAuthorityImpl(System.getProperty("accounts.sip.account1.PASSWORD").toCharArray()));
        this.fixture.provider2.register((SecurityAuthority)new SecurityAuthorityImpl(System.getProperty("accounts.sip.account2.PASSWORD").toCharArray()));
        logger.debug((Object)"Waiting for registration to complete ...");
        this.regEvtCollector1.waitForEvent(40000L);
        this.regEvtCollector2.waitForEvent(40000L);
        TestProtocolProviderServiceSipImpl.assertTrue((String)"No events were dispatched during the registration process.", (this.regEvtCollector1.collectedNewStates.size() > 0 ? 1 : 0) != 0);
        TestProtocolProviderServiceSipImpl.assertTrue((String)("No registration event notifying of registration was dispatched. All events were: " + this.regEvtCollector1.collectedNewStates), (boolean)this.regEvtCollector1.collectedNewStates.contains(RegistrationState.REGISTERED));
        TestProtocolProviderServiceSipImpl.assertTrue((String)"No events were dispatched during the registration process of provider2.", (this.regEvtCollector2.collectedNewStates.size() > 0 ? 1 : 0) != 0);
        TestProtocolProviderServiceSipImpl.assertTrue((String)("No registration event notifying of registration was dispatched. All events were: " + this.regEvtCollector2.collectedNewStates), (boolean)this.regEvtCollector2.collectedNewStates.contains(RegistrationState.REGISTERED));
        this.fixture.provider1.removeRegistrationStateChangeListener((RegistrationStateChangeListener)this.regEvtCollector1);
        this.fixture.provider2.removeRegistrationStateChangeListener((RegistrationStateChangeListener)this.regEvtCollector2);
    }

    public void testOperationSetTypes() throws Exception {
        Map supportedOperationSets = this.fixture.provider1.getSupportedOperationSets();
        for (Map.Entry entry : supportedOperationSets.entrySet()) {
            String setName = (String)entry.getKey();
            Object opSet = entry.getValue();
            TestProtocolProviderServiceSipImpl.assertTrue((String)(opSet + " was not an instance of " + setName + " as declared"), (boolean)Class.forName(setName).isInstance(opSet));
        }
    }

    public void testContactSipImpl() throws Exception {
        ProtocolProviderServiceSipImpl provider = (ProtocolProviderServiceSipImpl)this.fixture.provider1;
        Address reference = provider.parseAddressString("sip:User@Host");
        ContactSipImpl referenceContact = new ContactSipImpl(reference, provider);
        TestProtocolProviderServiceSipImpl.assertTrue((String)"Cannot find user-only part in a SIP Contact compare", (boolean)referenceContact.equals("User"));
        TestProtocolProviderServiceSipImpl.assertTrue((String)"Cannot find SIP Contact using strings", (boolean)referenceContact.equals("sip:User@Host"));
        TestProtocolProviderServiceSipImpl.assertTrue((String)"Cannot find SIP Contact when protocol is secure", (boolean)referenceContact.equals("sips:User@Host"));
        TestProtocolProviderServiceSipImpl.assertTrue((String)"Cannot find SIP Contact when port is specified", (boolean)referenceContact.equals("sip:User@Host:5060"));
    }

    public class SecurityAuthorityImpl
    implements SecurityAuthority {
        private char[] passwd = null;
        private boolean isUserNameEditable = false;

        public SecurityAuthorityImpl(char[] passwd) {
            this.passwd = passwd;
        }

        public UserCredentials obtainCredentials(String realm, UserCredentials defaultValues, int reasonCode) {
            return this.obtainCredentials(realm, defaultValues);
        }

        public UserCredentials obtainCredentials(String realm, UserCredentials defaultValues) {
            defaultValues.setPassword(this.passwd);
            return defaultValues;
        }

        public void setUserNameEditable(boolean isUserNameEditable) {
            this.isUserNameEditable = isUserNameEditable;
        }

        public boolean isUserNameEditable() {
            return this.isUserNameEditable;
        }
    }

    public class RegistrationEventCollector
    implements RegistrationStateChangeListener {
        public List<RegistrationState> collectedNewStates = new LinkedList<RegistrationState>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registrationStateChanged(RegistrationStateChangeEvent evt) {
            logger.debug((Object)("Received a RegistrationStateChangeEvent: " + evt));
            this.collectedNewStates.add(evt.getNewState());
            if (evt.getNewState().equals((Object)RegistrationState.REGISTERED)) {
                logger.debug((Object)"We're registered and will notify those who wait");
                RegistrationEventCollector registrationEventCollector = this;
                synchronized (registrationEventCollector) {
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForEvent(long waitFor) {
            logger.trace((Object)"Waiting for a RegistrationStateChangeEvent");
            RegistrationEventCollector registrationEventCollector = this;
            synchronized (registrationEventCollector) {
                if (this.collectedNewStates.contains(RegistrationState.REGISTERED)) {
                    logger.trace((Object)("Event already received. " + this.collectedNewStates));
                    return;
                }
                try {
                    this.wait(waitFor);
                    if (this.collectedNewStates.size() > 0) {
                        logger.trace((Object)"Received a RegistrationStateChangeEvent.");
                    } else {
                        logger.trace((Object)("No RegistrationStateChangeEvent received for " + waitFor + "ms."));
                    }
                }
                catch (InterruptedException ex) {
                    logger.debug((Object)"Interrupted while waiting for a RegistrationStateChangeEvent", (Throwable)ex);
                }
            }
        }
    }
}

