/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.ssi;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MiscTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.ssi.SsiCommand;

public class SsiDataModResponse
extends SsiCommand {
    public static final int RESULT_SUCCESS = 0;
    public static final int RESULT_NO_SUCH_ITEM = 2;
    public static final int RESULT_CANT_ADD_ANOTHER_ROOT_GROUP = 3;
    public static final int RESULT_ID_TAKEN = 10;
    public static final int RESULT_MAX_ITEMS = 12;
    public static final int RESULT_NO_ICQ = 13;
    public static final int RESULT_ICQ_AUTH_REQUIRED = 14;
    public static final int RESULT_BAD_FORMAT = 16;
    private final int[] results;

    protected SsiDataModResponse(SnacPacket packet) {
        super(14);
        DefensiveTools.checkNull(packet, "packet");
        ByteBlock snacData = packet.getData();
        int items = snacData.getLength() / 2;
        this.results = new int[items];
        for (int i = 0; i < items; ++i) {
            this.results[i] = BinaryTools.getUShort(snacData, i * 2);
        }
    }

    public SsiDataModResponse(int[] results) {
        super(14);
        this.results = DefensiveTools.getSafeMinArrayCopy(results, "results", 0);
    }

    public final int[] getResults() {
        return (int[])this.results.clone();
    }

    public void writeData(OutputStream out) throws IOException {
        for (int result : this.results) {
            BinaryTools.writeUShort(out, result);
        }
    }

    public String toString() {
        StringBuffer string = new StringBuffer();
        string.append("SsiDataModAck: results=");
        for (int i = 0; i < this.results.length; ++i) {
            int result = this.results[i];
            string.append("0x");
            string.append(Integer.toHexString(result));
            String field = MiscTools.findIntField(SsiDataModResponse.class, result, "RESULT_.*");
            if (field != null) {
                string.append(" (");
                string.append(field);
                string.append(")");
            }
            if (i == this.results.length - 1) continue;
            string.append(", ");
        }
        return string.toString();
    }
}

