/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model;

import com.google.gdata.model.MetadataKey;
import com.google.gdata.util.Version;
import com.google.gdata.wireformats.AltFormat;

public final class MetadataContext
implements Comparable<MetadataContext> {
    public static final MetadataContext ATOM = MetadataContext.forAlt(AltFormat.ATOM);
    public static final MetadataContext RSS = MetadataContext.forAlt(AltFormat.RSS);
    private final AltFormat altFormat;
    private final String projection;
    private final Version version;

    public static MetadataContext forAlt(AltFormat format) {
        return MetadataContext.forContext(format, null, null);
    }

    public static MetadataContext forProjection(String projection) {
        return MetadataContext.forContext(null, projection, null);
    }

    public static MetadataContext forVersion(Version version) {
        return MetadataContext.forContext(null, null, version);
    }

    public static MetadataContext forContext(AltFormat format, String projection, Version version) {
        if (format == null && projection == null && version == null) {
            return null;
        }
        return new MetadataContext(format, projection, version);
    }

    private MetadataContext(AltFormat format, String projection, Version version) {
        this.altFormat = format;
        this.projection = projection;
        this.version = version;
    }

    public boolean matches(MetadataContext other) {
        return !(other == null || this.altFormat != null && !this.altFormat.equals(other.altFormat) || this.projection != null && !this.projection.equals(other.projection) || this.version != null && (other.version == null || !other.version.isCompatible(this.version)));
    }

    public AltFormat getAltFormat() {
        return this.altFormat;
    }

    public String getProjection() {
        return this.projection;
    }

    public Version getVersion() {
        return this.version;
    }

    @Override
    public int compareTo(MetadataContext other) {
        if (this == other) {
            return 0;
        }
        int compare = MetadataContext.compareAltFormat(this.altFormat, other.altFormat);
        if (compare != 0) {
            return compare;
        }
        compare = MetadataContext.compareString(this.projection, other.projection);
        if (compare != 0) {
            return compare;
        }
        return MetadataContext.compareVersion(this.version, other.version);
    }

    static int compareAltFormat(AltFormat a, AltFormat b) {
        return MetadataContext.compareString(a == null ? null : a.getName(), b == null ? null : b.getName());
    }

    static int compareString(String a, String b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        return a.compareTo(b);
    }

    static int compareVersion(Version a, Version b) {
        int bMinor;
        int bMajor;
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        int compare = MetadataKey.compareClass(a.getServiceClass(), b.getServiceClass());
        if (compare != 0) {
            return compare;
        }
        int aMajor = a.getMajor();
        if (aMajor != (bMajor = b.getMajor())) {
            return aMajor < bMajor ? -1 : 1;
        }
        int aMinor = a.getMinor();
        return aMinor < (bMinor = b.getMinor()) ? -1 : (aMinor == bMinor ? 0 : 1);
    }

    public int hashCode() {
        int hash = 0;
        if (this.altFormat != null) {
            hash += this.altFormat.hashCode();
        }
        if (this.projection != null) {
            hash *= 37;
            hash += this.projection.hashCode();
        }
        if (this.version != null) {
            hash *= 37;
            hash += this.version.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MetadataContext)) {
            return false;
        }
        MetadataContext other = (MetadataContext)obj;
        if (this.altFormat == null ? other.altFormat != null : !this.altFormat.equals(other.altFormat)) {
            return false;
        }
        if (this.projection == null ? other.projection != null : !this.projection.equals(other.projection)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{MetadataContext(");
        sb.append(this.altFormat);
        sb.append(',');
        sb.append(this.projection);
        sb.append(',');
        sb.append(this.version);
        sb.append(")}");
        return sb.toString();
    }
}

