/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model.atom;

import com.google.common.collect.ImmutableMap;
import com.google.gdata.client.CoreErrorDomain;
import com.google.gdata.client.Service;
import com.google.gdata.data.ITextConstruct;
import com.google.gdata.data.ITextContent;
import com.google.gdata.model.Element;
import com.google.gdata.model.ElementCreator;
import com.google.gdata.model.ElementKey;
import com.google.gdata.model.ElementMetadata;
import com.google.gdata.model.ElementValidator;
import com.google.gdata.model.MetadataRegistry;
import com.google.gdata.model.QName;
import com.google.gdata.model.ValidationContext;
import com.google.gdata.model.XmlBlob;
import com.google.gdata.model.atom.Content;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.common.base.StringUtil;
import com.google.gdata.util.common.html.HtmlToText;

public class TextContent
extends Content
implements ITextContent,
ITextConstruct {
    public static final String KIND = "text";
    public static final ElementKey<String, TextContent> CONSTRUCT = ElementKey.of(null, String.class, TextContent.class);
    public static final ElementKey<String, TextContent> KEY = ElementKey.of(Content.KEY.getId(), String.class, TextContent.class);
    public static final ElementKey<String, XmlBlob> DIV = ElementKey.of(new QName(Namespaces.xhtmlNs, "div"), String.class, XmlBlob.class);
    private static final int UNKNOWN_TYPE = -1;
    private static final ImmutableMap<String, Integer> TYPE_MAP = ImmutableMap.builder().put((Object)"plain", (Object)1).put((Object)"text", (Object)1).put((Object)"text/plain", (Object)1).put((Object)"html", (Object)2).put((Object)"text/html", (Object)2).put((Object)"xhtml", (Object)3).build();

    public static void registerMetadata(MetadataRegistry registry) {
        if (registry.isRegistered(CONSTRUCT)) {
            return;
        }
        Content.registerMetadata(registry);
        ElementCreator constructBuilder = registry.build(CONSTRUCT).setValidator(new TextContentValidator());
        constructBuilder.addElement(DIV);
        ElementCreator builder = registry.build(KEY);
        registry.adapt(Content.KEY, KIND, KEY);
    }

    public static TextContent create(int type, String textOrHtml, XmlBlob xhtml) {
        switch (type) {
            case 1: {
                return TextContent.plainText(textOrHtml);
            }
            case 2: {
                return TextContent.html(textOrHtml);
            }
            case 3: {
                return TextContent.xhtml(xhtml);
            }
        }
        throw new IllegalArgumentException("Invalid type: " + type);
    }

    public static TextContent plainText(String text) {
        TextContent content = new TextContent();
        content.setText(text);
        return content;
    }

    public static TextContent html(String html) {
        TextContent content = new TextContent();
        content.setHtml(html);
        return content;
    }

    public static TextContent xhtml(XmlBlob div) {
        TextContent content = new TextContent();
        content.setXhtml(div);
        return content;
    }

    private static int getType(Element e) {
        String type = e.getAttributeValue(Content.TYPE);
        Integer typeVal = type == null ? 1 : (Integer)TYPE_MAP.get((Object)type);
        return typeVal == null ? -1 : typeVal;
    }

    public TextContent() {
        super(CONSTRUCT);
    }

    protected TextContent(ElementKey<?, ?> key) {
        super(key);
    }

    protected TextContent(ElementKey<?, ?> key, Content content) {
        super(key, content);
    }

    @Override
    public int getType() {
        int type = TextContent.getType(this);
        return type == -1 ? 1 : type;
    }

    public boolean isEmpty() {
        return StringUtil.isEmpty(this.getText()) && this.getElementCount() == 0;
    }

    @Override
    public String getPlainText() {
        switch (this.getType()) {
            case 3: {
                return this.getXhtml().getBlob();
            }
            case 1: {
                return this.getText();
            }
            case 2: {
                return HtmlToText.htmlToPlainText(this.getText());
            }
        }
        throw new IllegalStateException("Shouldn't be possible, getType can only return TEXT, HTML, or XHTML.");
    }

    public String getText() {
        return this.getTextValue(KEY);
    }

    public String getHtml() {
        return this.getText();
    }

    public XmlBlob getXhtml() {
        if (this.getType() != 3) {
            return null;
        }
        XmlBlob div = this.getElement(DIV);
        if (div == null) {
            div = new XmlBlob((ElementKey<?, ? extends XmlBlob>)DIV);
            this.setXhtml(div);
        }
        return div;
    }

    public void setText(String text) {
        if (Service.getVersion().isBefore(Service.Versions.V2)) {
            this.setAttributeValue(Content.TYPE, (Object)KIND);
        } else {
            this.setAttributeValue(Content.TYPE, null);
        }
        this.setTextValue(text);
    }

    public void setHtml(String html) {
        this.setAttributeValue(Content.TYPE, (Object)"html");
        this.setTextValue(html);
    }

    public void setXhtml(XmlBlob div) {
        this.setAttributeValue(Content.TYPE, (Object)"xhtml");
        this.setElement(DIV, (Element)div);
    }

    @Override
    public Element resolve(ElementMetadata<?, ?> metadata, ValidationContext vc) {
        int type = this.getType();
        if (type == 1 && Service.getVersion().isBefore(Service.Versions.V2) && this.getAttributeValue(Content.TYPE) == null) {
            this.setAttributeValue(Content.TYPE, (Object)KIND);
        }
        if ((type == 1 || type == 2) && this.getTextValue() == null) {
            this.setTextValue("");
        }
        return super.resolve(metadata, vc);
    }

    @Override
    public ITextConstruct getContent() {
        return this;
    }

    private static class TextContentValidator
    implements ElementValidator {
        private TextContentValidator() {
        }

        @Override
        public void validate(ValidationContext vc, Element e, ElementMetadata<?, ?> metadata) {
            int type = TextContent.getType(e);
            switch (type) {
                case -1: {
                    vc.addError(e, CoreErrorDomain.ERR.invalidTextContentType.withInternalReason("Invalid type: " + type));
                    break;
                }
                case 1: 
                case 2: {
                    if (!e.hasTextValue()) {
                        vc.addError(e, CoreErrorDomain.ERR.missingTextContent);
                    }
                    if (e.getElementCount() == 0) break;
                    vc.addError(e, CoreErrorDomain.ERR.invalidChildElement.withInternalReason("Child elements not allowed on text content"));
                    break;
                }
                case 3: {
                    if (!e.hasElement(DIV)) {
                        vc.addError(e, CoreErrorDomain.ERR.missingExtensionElement.withInternalReason("xhtml text content must have a div element"));
                        break;
                    }
                    if (e.getElementCount() == 1) break;
                    vc.addError(e, CoreErrorDomain.ERR.invalidChildElement.withInternalReason("xhtml must only have a single child element"));
                    break;
                }
                default: {
                    throw new IllegalStateException("Shouldn't be possible, TYPE_MAP can only map to text, html, or xhtml.");
                }
            }
        }
    }
}

