/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.lookandfeel;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.text.JTextComponent;
import net.java.sip.communicator.impl.gui.lookandfeel.SIPCommLFUtils;

public class SIPCommBorders {
    private static Border roundBorder;
    private static Border boldRoundBorder;
    private static Border textFieldBorder;

    public static Border getRoundBorder() {
        if (roundBorder == null || !(roundBorder instanceof RoundBorder)) {
            roundBorder = new BorderUIResource.CompoundBorderUIResource(new RoundBorder(), new BasicBorders.MarginBorder());
        }
        return roundBorder;
    }

    public static Border getBoldRoundBorder() {
        if (boldRoundBorder == null || !(boldRoundBorder instanceof BoldRoundBorder)) {
            boldRoundBorder = new BorderUIResource.CompoundBorderUIResource(new BoldRoundBorder(), new BasicBorders.MarginBorder());
        }
        return boldRoundBorder;
    }

    public static Border getTextFieldBorder() {
        if (textFieldBorder == null || !(textFieldBorder instanceof TextFieldBorder)) {
            textFieldBorder = new BorderUIResource.CompoundBorderUIResource(new TextFieldBorder(), new BasicBorders.MarginBorder());
        }
        return textFieldBorder;
    }

    public static class TextFieldBorder
    extends RoundBorder {
        private static final long serialVersionUID = 0L;

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            if (!(c instanceof JTextComponent)) {
                if (c.isEnabled()) {
                    SIPCommLFUtils.drawRoundBorder(g, x, y, w, h, 7, 7);
                } else {
                    SIPCommLFUtils.drawRoundDisabledBorder(g, x, y, w, h, 7, 7);
                }
                return;
            }
            if (c.isEnabled() && ((JTextComponent)c).isEditable()) {
                SIPCommLFUtils.drawRoundBorder(g, x, y, w, h, 7, 7);
            } else {
                SIPCommLFUtils.drawRoundDisabledBorder(g, x, y, w, h, 7, 7);
            }
        }
    }

    public static class BoldRoundBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = 0L;
        private static final Insets insets = new Insets(2, 2, 2, 2);

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            SIPCommLFUtils.drawBoldRoundBorder(g, x, y, w, h, 8, 8);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return insets;
        }

        @Override
        public Insets getBorderInsets(Component c, Insets newInsets) {
            newInsets.top = BoldRoundBorder.insets.top;
            newInsets.left = BoldRoundBorder.insets.left;
            newInsets.bottom = BoldRoundBorder.insets.bottom;
            newInsets.right = BoldRoundBorder.insets.right;
            return newInsets;
        }
    }

    public static class RoundBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = 0L;
        private static final Insets insets = new Insets(2, 2, 2, 2);

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            if (c.isEnabled()) {
                SIPCommLFUtils.drawRoundBorder(g, x, y, w, h, 5, 5);
            } else {
                SIPCommLFUtils.drawRoundDisabledBorder(g, x, y, w, h, 5, 5);
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return insets;
        }

        @Override
        public Insets getBorderInsets(Component c, Insets newInsets) {
            newInsets.top = RoundBorder.insets.top;
            newInsets.left = RoundBorder.insets.left;
            newInsets.bottom = RoundBorder.insets.bottom;
            newInsets.right = RoundBorder.insets.right;
            return newInsets;
        }
    }
}

