/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.contactlist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.impl.gui.main.contactlist.contactsource.ShowMoreContact;
import net.java.sip.communicator.service.contactsource.ContactChangedEvent;
import net.java.sip.communicator.service.contactsource.ContactQuery;
import net.java.sip.communicator.service.contactsource.ContactQueryListener;
import net.java.sip.communicator.service.contactsource.ContactQueryStatusEvent;
import net.java.sip.communicator.service.contactsource.ContactReceivedEvent;
import net.java.sip.communicator.service.contactsource.ContactRemovedEvent;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.contactsource.SourceContact;
import net.java.sip.communicator.service.gui.ContactList;
import net.java.sip.communicator.service.gui.FilterQuery;
import net.java.sip.communicator.service.gui.UIContact;
import net.java.sip.communicator.service.gui.event.FilterQueryListener;
import net.java.sip.communicator.service.gui.event.MetaContactQuery;
import net.java.sip.communicator.service.gui.event.MetaContactQueryEvent;
import net.java.sip.communicator.service.gui.event.MetaContactQueryListener;
import net.java.sip.communicator.service.gui.event.MetaContactQueryStatusEvent;
import net.java.sip.communicator.service.gui.event.MetaGroupQueryEvent;

public class UIFilterQuery
extends FilterQuery
implements ContactQueryListener,
MetaContactQueryListener {
    private FilterQueryListener filterQueryListener;
    private boolean isSucceeded = false;
    private boolean isCanceled = false;
    private boolean isRunning = false;
    private boolean isClosed = false;
    private final Map<Object, List<SourceContact>> filterQueries = Collections.synchronizedMap(new Hashtable());
    private int runningQueries = 0;
    private final ContactList contactList;
    private final Map<ContactQuery, ShowMoreContact> showMoreContactMap = new HashMap<ContactQuery, ShowMoreContact>();

    public UIFilterQuery(ContactList contactList) {
        this.contactList = contactList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContactQuery(Object contactQuery) {
        Map<Object, List<SourceContact>> map = this.filterQueries;
        synchronized (map) {
            if (this.isCanceled) {
                this.cancelQuery(contactQuery);
                return;
            }
            ArrayList queryResults = new ArrayList();
            if (contactQuery instanceof ContactQuery) {
                ContactQuery externalQuery = (ContactQuery)contactQuery;
                externalQuery.addContactQueryListener((ContactQueryListener)this);
            } else if (contactQuery instanceof MetaContactQuery) {
                ((MetaContactQuery)contactQuery).addContactQueryListener((MetaContactQueryListener)this);
            }
            this.isRunning = true;
            this.filterQueries.put(contactQuery, queryResults);
            ++this.runningQueries;
        }
    }

    public void setSucceeded(boolean isSucceeded) {
        this.isSucceeded = isSucceeded;
    }

    public boolean isSucceeded() {
        return this.isSucceeded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCanceled() {
        Map<Object, List<SourceContact>> map = this.filterQueries;
        synchronized (map) {
            return this.isCanceled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Map<Object, List<SourceContact>> map = this.filterQueries;
        synchronized (map) {
            return this.isRunning;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Map<Object, List<SourceContact>> map = this.filterQueries;
        synchronized (map) {
            this.isCanceled = true;
            Iterator<Object> queriesIter = this.filterQueries.keySet().iterator();
            while (queriesIter.hasNext()) {
                this.cancelQuery(queriesIter.next());
            }
        }
    }

    public void close() {
        this.isClosed = true;
        if (this.runningQueries == 0) {
            this.fireFilterQueryEvent();
        }
    }

    public void setQueryListener(FilterQueryListener l) {
        this.filterQueryListener = l;
    }

    private void fireFilterQueryEvent() {
        this.isRunning = false;
        if (this.filterQueryListener == null) {
            return;
        }
        if (this.isSucceeded) {
            this.filterQueryListener.filterQuerySucceeded((FilterQuery)this);
        } else {
            this.filterQueryListener.filterQueryFailed((FilterQuery)this);
        }
    }

    public void queryStatusChanged(ContactQueryStatusEvent event) {
        ContactQuery query = event.getQuerySource();
        if (!this.filterQueries.containsKey(query) || event.getEventType() == 3) {
            return;
        }
        this.removeQuery(query);
    }

    public void removeQuery(ContactQuery query) {
        if (!this.isSucceeded() && !query.getQueryResults().isEmpty()) {
            this.setSucceeded(true);
        }
        --this.runningQueries;
        query.removeContactQueryListener((ContactQueryListener)this);
        if (this.runningQueries == 0 && this.isClosed) {
            this.fireFilterQueryEvent();
        }
    }

    public void metaContactQueryStatusChanged(MetaContactQueryStatusEvent event) {
        MetaContactQuery query = event.getQuerySource();
        if (!this.filterQueries.containsKey(query)) {
            return;
        }
        if (!this.isSucceeded() && query.getResultCount() > 0) {
            this.setSucceeded(true);
        }
        --this.runningQueries;
        query.removeContactQueryListener((MetaContactQueryListener)this);
        if (this.runningQueries == 0 && this.isClosed) {
            this.fireFilterQueryEvent();
        }
    }

    private void cancelQuery(Object query) {
        if (query instanceof ContactQuery) {
            ShowMoreContact showMoreContact;
            ContactQuery contactQuery = (ContactQuery)query;
            contactQuery.cancel();
            contactQuery.removeContactQueryListener((ContactQueryListener)this.contactList);
            if (!this.isSucceeded && contactQuery.getQueryResults().size() > 0) {
                this.isSucceeded = true;
            }
            if ((showMoreContact = this.showMoreContactMap.remove(contactQuery)) != null) {
                showMoreContact.setContactNode(null);
            }
        } else if (query instanceof MetaContactQuery) {
            MetaContactQuery metaContactQuery = (MetaContactQuery)query;
            metaContactQuery.cancel();
            metaContactQuery.removeContactQueryListener((MetaContactQueryListener)this.contactList);
            if (!this.isSucceeded && metaContactQuery.getResultCount() > 0) {
                this.isSucceeded = true;
            }
        }
    }

    public boolean containsQuery(Object query) {
        return this.filterQueries.containsKey(query);
    }

    public void contactReceived(ContactReceivedEvent event) {
        ContactQuery query = event.getQuerySource();
        SourceContact contact = event.getContact();
        if (!this.isSucceeded() && !query.getQueryResults().isEmpty()) {
            this.setSucceeded(true);
        }
        this.fireFilterQueryEvent();
        List<SourceContact> queryResults = this.filterQueries.get(query);
        queryResults.add(contact);
        if (this.getMaxResultShown() > -1 && event.isShowMoreEnabled() && queryResults.size() == this.getMaxResultShown()) {
            query.removeContactQueryListener((ContactQueryListener)this.contactList);
            ShowMoreContact moreInfoContact = new ShowMoreContact(query, queryResults, this.getMaxResultShown());
            this.showMoreContactMap.put(query, moreInfoContact);
            ContactSourceService contactSource = query.getContactSource();
            this.contactList.addContact(query, (UIContact)moreInfoContact, this.contactList.getContactSource(contactSource).getUIGroup(), false);
        }
    }

    public void contactRemoved(ContactRemovedEvent event) {
    }

    public void contactChanged(ContactChangedEvent event) {
    }

    public void metaContactReceived(MetaContactQueryEvent event) {
        if (!this.isSucceeded() && event.getQuerySource().getResultCount() > 0) {
            this.setSucceeded(true);
        }
        this.fireFilterQueryEvent();
    }

    public void metaGroupReceived(MetaGroupQueryEvent event) {
        if (!this.isSucceeded() && event.getQuerySource().getResultCount() > 0) {
            this.setSucceeded(true);
        }
        this.fireFilterQueryEvent();
    }
}

