/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.stats;

import java.util.concurrent.atomic.AtomicLong;
import org.ice4j.util.RateStatistics;
import org.jitsi.impl.neomedia.stats.AbstractTrackStats;
import org.jitsi.service.neomedia.stats.ReceiveTrackStats;
import org.jitsi.util.RTPUtils;

public class ReceiveTrackStatsImpl
extends AbstractTrackStats
implements ReceiveTrackStats {
    private int highestSeq = -1;
    private RateStatistics packetLossRate;
    private AtomicLong packetsLost = new AtomicLong();

    ReceiveTrackStatsImpl(int interval, long ssrc) {
        super(interval, ssrc);
        this.packetLossRate = new RateStatistics(interval, 1000.0f);
    }

    @Override
    public long getPacketsLost() {
        return this.packetsLost.get();
    }

    public void rtpPacketReceived(int seq, int length) {
        long now = System.currentTimeMillis();
        super.packetProcessed(length, now, true);
        if (this.highestSeq == -1) {
            this.highestSeq = seq;
            return;
        }
        int diff = RTPUtils.sequenceNumberDiff(seq, this.highestSeq);
        if (diff <= 0) {
            if (diff > -10) {
                this.packetsLost.addAndGet(-1L);
                this.packetLossRate.update(-1, now);
            }
        } else {
            this.highestSeq = seq;
            if (diff > 1) {
                this.packetsLost.addAndGet(diff - 1);
                this.packetLossRate.update(diff - 1, now);
            }
        }
    }

    @Override
    public long getCurrentPacketsLost() {
        return this.packetLossRate.getAccumulatedCount();
    }

    public void rtcpPacketReceived(int length) {
        super.packetProcessed(length, System.currentTimeMillis(), false);
    }

    @Override
    public double getLossRate() {
        long lost = this.getCurrentPacketsLost();
        long expected = lost + this.getCurrentPackets();
        return expected == 0L ? 0.0 : (double)(lost / expected);
    }
}

