/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.srtp;

import java.util.Arrays;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.jitsi.bccontrib.params.ParametersForSkein;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.transform.srtp.BaseSRTPCryptoContext;
import org.jitsi.impl.neomedia.transform.srtp.SRTPPolicy;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.util.Logger;

public class SRTPCryptoContext
extends BaseSRTPCryptoContext {
    public static final String CHECK_REPLAY_PNAME = SRTPCryptoContext.class.getName() + ".checkReplay";
    private static boolean checkReplay = true;
    private static final Logger logger = Logger.getLogger(SRTPCryptoContext.class);
    private static boolean readConfigurationServicePropertiesOnce = true;
    private int guessedROC;
    private final long keyDerivationRate;
    private int roc;
    private int s_l = 0;
    private final boolean sender;
    private boolean seqNumSet = false;

    private static synchronized void readConfigurationServicePropertiesOnce() {
        if (!readConfigurationServicePropertiesOnce) {
            return;
        }
        readConfigurationServicePropertiesOnce = false;
        ConfigurationService cfg = LibJitsi.getConfigurationService();
        if (cfg != null) {
            checkReplay = cfg.getBoolean(CHECK_REPLAY_PNAME, checkReplay);
        }
    }

    public SRTPCryptoContext(boolean sender, int ssrc) {
        super(ssrc);
        this.sender = sender;
        this.keyDerivationRate = 0L;
        this.roc = 0;
    }

    public SRTPCryptoContext(boolean sender, int ssrc, int roc, long keyDerivationRate, byte[] masterK, byte[] masterS, SRTPPolicy policy) {
        super(ssrc, masterK, masterS, policy);
        this.sender = sender;
        this.roc = roc;
        this.keyDerivationRate = keyDerivationRate;
        SRTPCryptoContext.readConfigurationServicePropertiesOnce();
    }

    private boolean authenticatePacket(RawPacket pkt) {
        if (this.policy.getAuthType() != 0) {
            int tagLength = this.policy.getAuthTagLength();
            pkt.readRegionToBuff(pkt.getLength() - tagLength, tagLength, this.tempStore);
            pkt.shrink(tagLength);
            this.authenticatePacketHMAC(pkt, this.guessedROC);
            int nonEqual = 0;
            for (int i = 0; i < tagLength; ++i) {
                nonEqual |= this.tempStore[i] ^ this.tagStore[i];
            }
            if (nonEqual != 0) {
                return false;
            }
        }
        return true;
    }

    boolean checkReplay(int seqNo, long guessedIndex) {
        if (!checkReplay) {
            return true;
        }
        long localIndex = (long)this.roc << 16 | (long)this.s_l;
        long delta = guessedIndex - localIndex;
        if (delta > 0L) {
            return true;
        }
        if (-delta > 64L) {
            if (this.sender) {
                logger.error("Discarding RTP packet with sequence number " + seqNo + ", SSRC " + Long.toString(0xFFFFFFFFL & (long)this.ssrc) + " because it is outside the replay window! (roc " + this.roc + ", s_l " + this.s_l + ", guessedROC " + this.guessedROC);
            }
            return false;
        }
        if ((this.replayWindow >> (int)(-delta) & 1L) != 0L) {
            if (this.sender) {
                logger.error("Discarding RTP packet with sequence number " + seqNo + ", SSRC " + Long.toString(0xFFFFFFFFL & (long)this.ssrc) + " because it has been received already! (roc " + this.roc + ", s_l " + this.s_l + ", guessedROC " + this.guessedROC);
            }
            return false;
        }
        return true;
    }

    private void computeIv(long label, long index) {
        int i;
        long key_id = this.keyDerivationRate == 0L ? label << 48 : label << 48 | index / this.keyDerivationRate;
        for (i = 0; i < 7; ++i) {
            this.ivStore[i] = this.masterSalt[i];
        }
        for (i = 7; i < 14; ++i) {
            this.ivStore[i] = (byte)((byte)(0xFFL & key_id >> 8 * (13 - i)) ^ this.masterSalt[i]);
        }
        this.ivStore[15] = 0;
        this.ivStore[14] = 0;
    }

    public SRTPCryptoContext deriveContext(int ssrc, int roc, long deriveRate) {
        return new SRTPCryptoContext(this.sender, ssrc, roc, deriveRate, this.masterKey, this.masterSalt, this.policy);
    }

    public synchronized void deriveSrtpKeys(long index) {
        this.computeIv(0L, index);
        this.cipherCtr.init(this.masterKey);
        Arrays.fill(this.masterKey, (byte)0);
        Arrays.fill(this.encKey, (byte)0);
        this.cipherCtr.process(this.encKey, 0, this.policy.getEncKeyLength(), this.ivStore);
        if (this.authKey != null) {
            this.computeIv(1L, index);
            Arrays.fill(this.authKey, (byte)0);
            this.cipherCtr.process(this.authKey, 0, this.policy.getAuthKeyLength(), this.ivStore);
            switch (this.policy.getAuthType()) {
                case 1: {
                    this.mac.init((CipherParameters)new KeyParameter(this.authKey));
                    break;
                }
                case 2: {
                    this.mac.init((CipherParameters)new ParametersForSkein((CipherParameters)new KeyParameter(this.authKey), 512, this.tagStore.length * 8));
                }
            }
            Arrays.fill(this.authKey, (byte)0);
        }
        this.computeIv(2L, index);
        Arrays.fill(this.saltKey, (byte)0);
        this.cipherCtr.process(this.saltKey, 0, this.policy.getSaltKeyLength(), this.ivStore);
        Arrays.fill(this.masterSalt, (byte)0);
        if (this.cipherF8 != null) {
            this.cipherF8.init(this.encKey, this.saltKey);
        }
        this.cipherCtr.init(this.encKey);
        Arrays.fill(this.encKey, (byte)0);
    }

    private long guessIndex(int seqNo) {
        this.guessedROC = this.s_l < 32768 ? (seqNo - this.s_l > 32768 ? this.roc - 1 : this.roc) : (this.s_l - 32768 > seqNo ? this.roc + 1 : this.roc);
        return (long)this.guessedROC << 16 | (long)seqNo;
    }

    public void processPacketAESCM(RawPacket pkt) {
        int i;
        int ssrc = pkt.getSSRC();
        int seqNo = pkt.getSequenceNumber();
        long index = (long)this.guessedROC << 16 | (long)seqNo;
        this.ivStore[0] = this.saltKey[0];
        this.ivStore[1] = this.saltKey[1];
        this.ivStore[2] = this.saltKey[2];
        this.ivStore[3] = this.saltKey[3];
        for (i = 4; i < 8; ++i) {
            this.ivStore[i] = (byte)(0xFF & ssrc >> (7 - i) * 8 ^ this.saltKey[i]);
        }
        for (i = 8; i < 14; ++i) {
            this.ivStore[i] = (byte)(0xFF & (byte)(index >> (13 - i) * 8) ^ this.saltKey[i]);
        }
        this.ivStore[15] = 0;
        this.ivStore[14] = 0;
        int payloadOffset = pkt.getHeaderLength();
        int payloadLength = pkt.getPayloadLength();
        this.cipherCtr.process(pkt.getBuffer(), pkt.getOffset() + payloadOffset, payloadLength, this.ivStore);
    }

    public void processPacketAESF8(RawPacket pkt) {
        System.arraycopy(pkt.getBuffer(), pkt.getOffset(), this.ivStore, 0, 12);
        this.ivStore[0] = 0;
        int roc = this.guessedROC;
        this.ivStore[12] = (byte)(roc >> 24);
        this.ivStore[13] = (byte)(roc >> 16);
        this.ivStore[14] = (byte)(roc >> 8);
        this.ivStore[15] = (byte)roc;
        int payloadOffset = pkt.getHeaderLength();
        int payloadLength = pkt.getPayloadLength();
        this.cipherF8.process(pkt.getBuffer(), pkt.getOffset() + payloadOffset, payloadLength, this.ivStore);
    }

    public synchronized boolean reverseTransformPacket(RawPacket pkt) {
        if (logger.isDebugEnabled()) {
            logger.debug("Reverse transform for SSRC " + this.ssrc + " SeqNo=" + pkt.getSequenceNumber() + " s_l=" + this.s_l + " seqNumSet=" + this.seqNumSet + " guessedROC=" + this.guessedROC + " roc=" + this.roc);
        }
        int seqNo = pkt.getSequenceNumber();
        if (!this.seqNumSet) {
            this.seqNumSet = true;
            this.s_l = seqNo;
        }
        long guessedIndex = this.guessIndex(seqNo);
        boolean b = false;
        if (this.checkReplay(seqNo, guessedIndex)) {
            if (this.authenticatePacket(pkt)) {
                if ((pkt.getFlags() & 6) == 0) {
                    switch (this.policy.getEncType()) {
                        case 1: 
                        case 3: {
                            this.processPacketAESCM(pkt);
                            break;
                        }
                        case 2: 
                        case 4: {
                            this.processPacketAESF8(pkt);
                        }
                    }
                }
                this.update(seqNo, guessedIndex);
                b = true;
            } else if (logger.isDebugEnabled()) {
                logger.debug("SRTP auth failed for SSRC " + this.ssrc);
            }
        }
        return b;
    }

    public synchronized boolean transformPacket(RawPacket pkt) {
        long guessedIndex;
        int seqNo = pkt.getSequenceNumber();
        if (!this.seqNumSet) {
            this.seqNumSet = true;
            this.s_l = seqNo;
        }
        if (!this.checkReplay(seqNo, guessedIndex = this.guessIndex(seqNo))) {
            return false;
        }
        switch (this.policy.getEncType()) {
            case 1: 
            case 3: {
                this.processPacketAESCM(pkt);
                break;
            }
            case 2: 
            case 4: {
                this.processPacketAESF8(pkt);
            }
        }
        if (this.policy.getAuthType() != 0) {
            this.authenticatePacketHMAC(pkt, this.guessedROC);
            pkt.append(this.tagStore, this.policy.getAuthTagLength());
        }
        this.update(seqNo, guessedIndex);
        return true;
    }

    private void update(int seqNo, long guessedIndex) {
        long delta = guessedIndex - ((long)this.roc << 16 | (long)this.s_l);
        if (delta > 0L) {
            this.replayWindow <<= (int)delta;
            this.replayWindow |= 1L;
        } else {
            this.replayWindow |= (long)(1 << (int)(-delta));
        }
        if (this.guessedROC == this.roc) {
            if (seqNo > this.s_l) {
                this.s_l = seqNo & 0xFFFF;
            }
        } else if (this.guessedROC == this.roc + 1) {
            this.s_l = seqNo & 0xFFFF;
            this.roc = this.guessedROC;
        }
    }
}

