/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.osdependent.jdic;

import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.Logger;

public class ProviderUnRegistration
extends Thread {
    ProtocolProviderService protocolProvider;
    private Logger logger = Logger.getLogger((String)ProviderUnRegistration.class.getName());

    ProviderUnRegistration(ProtocolProviderService protocolProvider) {
        this.protocolProvider = protocolProvider;
    }

    @Override
    public void run() {
        try {
            this.protocolProvider.unregister();
        }
        catch (OperationFailedException ex) {
            int errorCode = ex.getErrorCode();
            if (errorCode == 1) {
                this.logger.error((Object)"Provider could not be unregistered due to the following general error: ", (Throwable)ex);
            }
            if (errorCode == 4) {
                this.logger.error((Object)"Provider could not be unregistered due to the following internal error: ", (Throwable)ex);
            }
            if (errorCode == 2) {
                this.logger.error((Object)("Provider could not be unregistered due to a network failure: " + (Object)((Object)ex)));
            }
            if (errorCode == 7) {
                this.logger.error((Object)"Provider could not be unregistered due to an invalid account property: ", (Throwable)ex);
            }
            this.logger.error((Object)"Provider could not be unregistered.", (Throwable)ex);
        }
    }
}

