/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.addrbook.msoutlook;

import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import net.java.sip.communicator.plugin.addrbook.AddrBookActivator;

public class RegistryHandler {
    private static String REGISTRY_DEFAULT_IM_APPLICATION_KEY = "Software\\IM Providers";
    private static String REGISTRY_DEFAULT_IM_APPLICATION_VALUE = "DefaultIMApp";
    private static String REGISTRY_DEFAULT_IM_APPLICATION_COMMUNICATOR = "Communicator";
    private static String REGISTRY_DEFAULT_MAIL_CLIENT_KEY = "Software\\Clients\\Mail";

    public static boolean isDefaultIMApp(String appName) {
        return Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)REGISTRY_DEFAULT_IM_APPLICATION_KEY, (String)REGISTRY_DEFAULT_IM_APPLICATION_VALUE).equals(appName);
    }

    public static boolean isJitsiDefaultIMApp() {
        if (!Advapi32Util.registryValueExists((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)REGISTRY_DEFAULT_IM_APPLICATION_KEY, (String)REGISTRY_DEFAULT_IM_APPLICATION_VALUE)) {
            return false;
        }
        return Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)REGISTRY_DEFAULT_IM_APPLICATION_KEY, (String)REGISTRY_DEFAULT_IM_APPLICATION_VALUE).equals(RegistryHandler.getApplicationName());
    }

    public static void setDefaultIMApp(String appName) {
        Advapi32Util.registrySetStringValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)REGISTRY_DEFAULT_IM_APPLICATION_KEY, (String)REGISTRY_DEFAULT_IM_APPLICATION_VALUE, (String)appName);
    }

    public static void setOutlookAsDefaultMailClient() {
        Advapi32Util.registrySetStringValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)REGISTRY_DEFAULT_MAIL_CLIENT_KEY, null, (String)"Microsoft Outlook");
    }

    public static void setJitsiAsDefaultApp() {
        String appName = RegistryHandler.getApplicationName();
        if (!RegistryHandler.isDefaultIMApp(appName)) {
            RegistryHandler.setDefaultIMApp(appName);
        }
    }

    public static void unsetDefaultApp() {
        if (RegistryHandler.isDefaultIMApp(RegistryHandler.getApplicationName())) {
            RegistryHandler.setDefaultIMApp(REGISTRY_DEFAULT_IM_APPLICATION_COMMUNICATOR);
        }
    }

    private static String getApplicationName() {
        return AddrBookActivator.getResources().getSettingsString("service.gui.APPLICATION_NAME");
    }
}

