/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.net;

import java.net.InetAddress;
import net.kano.joscar.DefensiveTools;

public class ConnDescriptor {
    private final String host;
    private final InetAddress address;
    private final int port;

    public ConnDescriptor(String host, int port) {
        DefensiveTools.checkNull(host, "host");
        DefensiveTools.checkRange(port, "port", 0);
        this.host = host;
        this.address = null;
        this.port = port;
    }

    public ConnDescriptor(InetAddress address, int port) {
        DefensiveTools.checkNull(address, "address");
        DefensiveTools.checkRange(port, "port", 0);
        this.host = null;
        this.address = address;
        this.port = port;
    }

    public final String getHost() {
        return this.host;
    }

    public final InetAddress getAddress() {
        return this.address;
    }

    public final int getPort() {
        return this.port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConnDescriptor)) {
            return false;
        }
        ConnDescriptor cd = (ConnDescriptor)o;
        if (this.port != cd.port) {
            return false;
        }
        if (this.address != null ? !this.address.equals(cd.address) : cd.address != null) {
            return false;
        }
        return !(this.host != null ? !this.host.equals(cd.host) : cd.host != null);
    }

    public int hashCode() {
        int result = this.host != null ? this.host.hashCode() : 0;
        result = 29 * result + (this.address != null ? this.address.hashCode() : 0);
        result = 29 * result + this.port;
        return result;
    }

    public String toString() {
        Object first = this.host == null ? this.address : this.host;
        return "ConnDescriptor: " + first + ":" + this.port;
    }
}

