/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import javax.net.SocketFactory;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.AbstractConnectionController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.OutgoingConnector;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.state.SocketStreamInfo;

public abstract class AbstractOutgoingConnectionController
extends AbstractConnectionController {

    protected abstract class DefaultOutgoingConnector
    implements OutgoingConnector {
        protected DefaultOutgoingConnector() {
        }

        public SocketStreamInfo createStream() throws IOException {
            AbstractOutgoingConnectionController.this.handleResolvingState();
            InetAddress ip = this.getIpAddress();
            if (ip == null) {
                throw new IllegalStateException("no IP address");
            }
            AbstractOutgoingConnectionController.this.handleConnectingState();
            SocketFactory factory = AbstractOutgoingConnectionController.this.getRvConnection().getSettings().getProxyInfo().getSocketFactory();
            int port = this.getConnectionPort();
            Socket socket = factory == null ? SocketChannel.open(new InetSocketAddress(ip, port)).socket() : factory.createSocket(ip, port);
            socket.setKeepAlive(true);
            socket.setSoTimeout(6000);
            return new SocketStreamInfo(socket.getChannel());
        }

        public void checkConnectionInfo() throws Exception {
        }

        public void prepareStream() throws IOException {
        }
    }
}

