/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import net.kano.joscar.rvproto.rvproxy.DefaultRvProxyCmdFactory;
import net.kano.joscar.rvproto.rvproxy.RvProxyCmd;
import net.kano.joscar.rvproto.rvproxy.RvProxyPacket;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.ProxyConnection;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.StreamInfoProvider;

public class StreamProxyConnection
implements ProxyConnection {
    private static final Logger LOGGER = Logger.getLogger(StreamProxyConnection.class.getName());
    private StreamInfoProvider provider;

    public StreamProxyConnection(StreamInfoProvider stream) {
        this.provider = stream;
    }

    public RvProxyCmd readPacket() throws IOException {
        InputStream in = this.provider.getStreamInfo().getInputStream();
        RvProxyPacket packet = RvProxyPacket.readPacket(in);
        LOGGER.fine("Got proxy packet: " + packet);
        DefaultRvProxyCmdFactory factory = new DefaultRvProxyCmdFactory();
        return factory.getRvProxyCmd(packet);
    }

    public void sendProxyPacket(RvProxyCmd initCmd) throws IOException {
        RvProxyPacket packet = new RvProxyPacket(initCmd);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        packet.write(bout);
        bout.writeTo(this.provider.getStreamInfo().getOutputStream());
    }
}

