/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip;

import net.java.sip.communicator.impl.protocol.sip.CallPeerMediaHandlerSipImpl;
import net.java.sip.communicator.impl.protocol.sip.CallPeerSipImpl;
import net.java.sip.communicator.impl.protocol.sip.ProtocolProviderServiceSipImpl;
import net.java.sip.communicator.impl.protocol.sip.dtmf.DTMFInfo;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.media.AbstractOperationSetDTMF;
import net.java.sip.communicator.service.protocol.media.MediaAwareCallPeer;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.neomedia.AudioMediaStream;
import org.jitsi.service.neomedia.DTMFMethod;
import org.jitsi.service.neomedia.DTMFTone;
import org.jitsi.service.neomedia.MediaType;

public class OperationSetDTMFSipImpl
extends AbstractOperationSetDTMF {
    private static final Logger logger = Logger.getLogger(OperationSetDTMFSipImpl.class);
    private final DTMFInfo dtmfModeInfo;

    public OperationSetDTMFSipImpl(ProtocolProviderServiceSipImpl pps) {
        super((ProtocolProviderService)pps);
        this.dtmfModeInfo = new DTMFInfo(pps);
    }

    public synchronized void startSendingDTMF(CallPeer callPeer, DTMFTone tone) throws OperationFailedException {
        if (callPeer == null || tone == null) {
            throw new NullPointerException("Argument is null");
        }
        if (!(callPeer instanceof CallPeerSipImpl)) {
            throw new IllegalArgumentException();
        }
        CallPeerSipImpl cp = (CallPeerSipImpl)callPeer;
        if (this.dtmfMethod == DTMFMethod.SIP_INFO_DTMF) {
            this.dtmfModeInfo.startSendingDTMF(cp, tone);
        } else {
            DTMFMethod cpDTMFMethod = this.dtmfMethod;
            if (this.dtmfMethod == DTMFMethod.AUTO_DTMF) {
                cpDTMFMethod = OperationSetDTMFSipImpl.isRFC4733Active((MediaAwareCallPeer)cp) ? DTMFMethod.RTP_DTMF : DTMFMethod.INBAND_DTMF;
            }
            if (this.dtmfMethod == DTMFMethod.RTP_DTMF && !OperationSetDTMFSipImpl.isRFC4733Active((MediaAwareCallPeer)cp)) {
                logger.debug((Object)"RTP DTMF used without telephone-event capacity");
            }
            ((AudioMediaStream)((CallPeerMediaHandlerSipImpl)cp.getMediaHandler()).getStream(MediaType.AUDIO)).startSendingDTMF(tone, cpDTMFMethod, this.minimalToneDuration, this.maximalToneDuration, this.volume);
        }
    }

    public synchronized void stopSendingDTMF(CallPeer callPeer) {
        if (callPeer == null) {
            throw new NullPointerException("Argument is null");
        }
        if (!(callPeer instanceof CallPeerSipImpl)) {
            throw new IllegalArgumentException();
        }
        CallPeerSipImpl cp = (CallPeerSipImpl)callPeer;
        if (this.dtmfMethod == DTMFMethod.SIP_INFO_DTMF) {
            this.dtmfModeInfo.stopSendingDTMF(cp);
        } else {
            DTMFMethod cpDTMFMethod = this.dtmfMethod;
            if (this.dtmfMethod == DTMFMethod.AUTO_DTMF) {
                cpDTMFMethod = OperationSetDTMFSipImpl.isRFC4733Active((MediaAwareCallPeer)cp) ? DTMFMethod.RTP_DTMF : DTMFMethod.INBAND_DTMF;
            }
            if (this.dtmfMethod == DTMFMethod.RTP_DTMF && !OperationSetDTMFSipImpl.isRFC4733Active((MediaAwareCallPeer)cp)) {
                logger.debug((Object)"RTP DTMF used without telephon-event capacities");
            }
            ((AudioMediaStream)((CallPeerMediaHandlerSipImpl)cp.getMediaHandler()).getStream(MediaType.AUDIO)).stopSendingDTMF(cpDTMFMethod);
        }
    }

    DTMFInfo getDtmfModeInfo() {
        return this.dtmfModeInfo;
    }
}

