/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil;

import java.awt.Component;
import java.awt.Point;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.plugin.desktoputil.SIPCommPopupMenu;
import net.java.sip.communicator.util.skin.Skinnable;

public class ExtendedPopupMenu
extends SIPCommPopupMenu
implements Skinnable {
    private static final long serialVersionUID = 0L;
    private final Component invoker;

    public ExtendedPopupMenu(Component invoker, String title, List<JMenuItem> menuItems) {
        this.invoker = invoker != null ? invoker : new JPanel();
        this.init(title);
        for (JMenuItem menuItem : menuItems) {
            this.add(menuItem);
        }
    }

    private void init(String infoString) {
        this.setInvoker(this.invoker);
        if (infoString != null) {
            this.add(this.createInfoLabel(infoString));
            this.addSeparator();
        }
        this.setFocusable(true);
    }

    public void showPopupMenu(int x, int y) {
        this.setLocation(x, y);
        this.setVisible(true);
    }

    public void showPopupMenu() {
        Point location = new Point(this.invoker.getX(), this.invoker.getY() + this.invoker.getHeight());
        SwingUtilities.convertPointToScreen(location, this.invoker.getParent());
        this.setLocation(location);
        this.setVisible(true);
    }

    private Component createInfoLabel(String infoString) {
        JMenuItem infoLabel = new JMenuItem();
        infoLabel.setEnabled(false);
        infoLabel.setFocusable(false);
        infoLabel.setText("<html><b>" + infoString + "</b></html>");
        return infoLabel;
    }

    public void loadSkin() {
        Component[] components;
        for (Component component : components = this.getComponents()) {
            if (!(component instanceof Skinnable)) continue;
            Skinnable skinnableComponent = (Skinnable)component;
            skinnableComponent.loadSkin();
        }
    }
}

