/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Formatter;
import java.util.HashMap;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.security.auth.x500.X500Principal;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.BevelBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import net.java.sip.communicator.plugin.desktoputil.DesktopUtilActivator;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import org.jitsi.service.resources.ResourceManagementService;

public class X509CertificatePanel
extends TransparentPanel {
    private static final long serialVersionUID = -8368302061995971947L;
    private final JEditorPane infoTextPane = new JEditorPane();
    private final ResourceManagementService R = DesktopUtilActivator.getResources();

    public X509CertificatePanel(Certificate certificate) {
        this(new Certificate[]{certificate});
    }

    public X509CertificatePanel(Certificate[] certificates) {
        DefaultMutableTreeNode top;
        this.setLayout(new BorderLayout(5, 5));
        TransparentPanel topPanel = new TransparentPanel(new BorderLayout());
        topPanel.add(new JLabel("<html><body><b>" + this.R.getI18NString("service.gui.CERT_INFO_CHAIN") + "</b></body></html>"), "North");
        DefaultMutableTreeNode previous = top = new DefaultMutableTreeNode();
        for (int i = certificates.length - 1; i >= 0; --i) {
            Certificate cert = certificates[i];
            DefaultMutableTreeNode next = new DefaultMutableTreeNode(cert);
            previous.add(next);
            previous = next;
        }
        JTree tree = new JTree(top);
        tree.setBorder(new BevelBorder(1));
        tree.setRootVisible(false);
        tree.setExpandsSelectedPaths(true);
        tree.getSelectionModel().setSelectionMode(1);
        tree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                JLabel component = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                if (value instanceof DefaultMutableTreeNode) {
                    Object o = ((DefaultMutableTreeNode)value).getUserObject();
                    if (o instanceof X509Certificate) {
                        component.setText(X509CertificatePanel.getSimplifiedName((X509Certificate)o));
                    } else {
                        String text = o.toString();
                        if (text.length() > 20) {
                            text = text.substring(0, 20);
                        }
                        component.setText(text);
                    }
                }
                return component;
            }
        });
        tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                X509CertificatePanel.this.valueChangedPerformed(e);
            }
        });
        tree.setSelectionPath(new TreePath(((DefaultTreeModel)tree.getModel()).getPathToRoot(previous)));
        topPanel.add(tree, "Center");
        this.add((Component)((Object)topPanel), "North");
        Caret caret = this.infoTextPane.getCaret();
        if (caret instanceof DefaultCaret) {
            ((DefaultCaret)caret).setUpdatePolicy(1);
        }
        this.infoTextPane.putClientProperty("JEditorPane.honorDisplayProperties", true);
        this.infoTextPane.setOpaque(false);
        this.infoTextPane.setEditable(false);
        this.infoTextPane.setContentType("text/html");
        this.infoTextPane.setText(this.toString(certificates[0]));
        JScrollPane certScroll = new JScrollPane(this.infoTextPane);
        certScroll.setPreferredSize(new Dimension(300, 500));
        this.add(certScroll, "Center");
    }

    private String toString(Object certificate) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><body>\n");
        if (certificate instanceof X509Certificate) {
            this.renderX509(sb, (X509Certificate)certificate);
        } else {
            sb.append("<pre>\n");
            sb.append(certificate.toString());
            sb.append("</pre>\n");
        }
        sb.append("</body></html>");
        return sb.toString();
    }

    private void renderX509(StringBuilder sb, X509Certificate certificate) {
        PublicKey key;
        String value;
        byte[] nameValueAsByteArray;
        Object nameValue;
        String lbl;
        String lblKey;
        String nameType;
        X500Principal issuer = certificate.getIssuerX500Principal();
        X500Principal subject = certificate.getSubjectX500Principal();
        sb.append("<table cellspacing='1' cellpadding='1'>\n");
        this.addTitle(sb, this.R.getI18NString("service.gui.CERT_INFO_ISSUED_TO"));
        try {
            for (Rdn name : new LdapName(subject.getName()).getRdns()) {
                nameType = name.getType();
                lblKey = "service.gui.CERT_INFO_" + nameType;
                lbl = this.R.getI18NString(lblKey);
                if (lbl == null || ("!" + lblKey + "!").equals(lbl)) {
                    lbl = nameType;
                }
                if ((nameValue = name.getValue()) instanceof byte[]) {
                    nameValueAsByteArray = (byte[])nameValue;
                    value = this.getHex(nameValueAsByteArray) + " (" + new String(nameValueAsByteArray) + ")";
                } else {
                    value = nameValue.toString();
                }
                this.addField(sb, lbl, value);
            }
        }
        catch (InvalidNameException ine) {
            this.addField(sb, this.R.getI18NString("service.gui.CERT_INFO_CN"), subject.getName());
        }
        this.addTitle(sb, this.R.getI18NString("service.gui.CERT_INFO_ISSUED_BY"));
        try {
            for (Rdn name : new LdapName(issuer.getName()).getRdns()) {
                nameType = name.getType();
                lblKey = "service.gui.CERT_INFO_" + nameType;
                lbl = this.R.getI18NString(lblKey);
                if (lbl == null || ("!" + lblKey + "!").equals(lbl)) {
                    lbl = nameType;
                }
                if ((nameValue = name.getValue()) instanceof byte[]) {
                    nameValueAsByteArray = (byte[])nameValue;
                    value = this.getHex(nameValueAsByteArray) + " (" + new String(nameValueAsByteArray) + ")";
                } else {
                    value = nameValue.toString();
                }
                this.addField(sb, lbl, value);
            }
        }
        catch (InvalidNameException ine) {
            this.addField(sb, this.R.getI18NString("service.gui.CERT_INFO_CN"), issuer.getName());
        }
        this.addTitle(sb, this.R.getI18NString("service.gui.CERT_INFO_VALIDITY"));
        this.addField(sb, this.R.getI18NString("service.gui.CERT_INFO_ISSUED_ON"), certificate.getNotBefore().toString());
        this.addField(sb, this.R.getI18NString("service.gui.CERT_INFO_EXPIRES_ON"), certificate.getNotAfter().toString());
        this.addTitle(sb, this.R.getI18NString("service.gui.CERT_INFO_FINGERPRINTS"));
        try {
            String sha256String = X509CertificatePanel.getThumbprint(certificate, "SHA-256");
            String sha1String = X509CertificatePanel.getThumbprint(certificate, "SHA1");
            this.addField(sb, "SHA256:", sha256String, 48);
            this.addField(sb, "SHA1:", sha1String, 72);
        }
        catch (CertificateException sha256String) {
            // empty catch block
        }
        this.addTitle(sb, this.R.getI18NString("service.gui.CERT_INFO_CERT_DETAILS"));
        this.addField(sb, this.R.getI18NString("service.gui.CERT_INFO_SER_NUM"), certificate.getSerialNumber().toString());
        this.addField(sb, this.R.getI18NString("service.gui.CERT_INFO_VER"), String.valueOf(certificate.getVersion()));
        this.addField(sb, this.R.getI18NString("service.gui.CERT_INFO_SIGN_ALG"), String.valueOf(certificate.getSigAlgName()));
        this.addTitle(sb, this.R.getI18NString("service.gui.CERT_INFO_PUB_KEY_INFO"));
        this.addField(sb, this.R.getI18NString("service.gui.CERT_INFO_ALG"), certificate.getPublicKey().getAlgorithm());
        if (certificate.getPublicKey().getAlgorithm().equals("RSA")) {
            key = (RSAPublicKey)certificate.getPublicKey();
            this.addField(sb, this.R.getI18NString("service.gui.CERT_INFO_PUB_KEY"), this.R.getI18NString("service.gui.CERT_INFO_KEY_BITS_PRINT", new String[]{String.valueOf((key.getModulus().toByteArray().length - 1) * 8)}), this.getHex(key.getModulus().toByteArray()), 48);
            this.addField(sb, this.R.getI18NString("service.gui.CERT_INFO_EXP"), key.getPublicExponent().toString());
            this.addField(sb, this.R.getI18NString("service.gui.CERT_INFO_KEY_SIZE"), this.R.getI18NString("service.gui.CERT_INFO_KEY_BITS_PRINT", new String[]{String.valueOf(key.getModulus().bitLength())}));
        } else if (certificate.getPublicKey().getAlgorithm().equals("DSA")) {
            key = (DSAPublicKey)certificate.getPublicKey();
            this.addField(sb, "Y:", key.getY().toString(16));
        }
        this.addField(sb, this.R.getI18NString("service.gui.CERT_INFO_SIGN"), this.R.getI18NString("service.gui.CERT_INFO_KEY_BITS_PRINT", new String[]{String.valueOf(certificate.getSignature().length * 8)}), this.getHex(certificate.getSignature()), 48);
        sb.append("</table>\n");
    }

    private void addTitle(StringBuilder sb, String title) {
        sb.append("<tr><td colspan='2'").append(" style='margin-top: 5pt; white-space: nowrap'><p><b>").append(title).append("</b></p></td></tr>\n");
    }

    private void addField(StringBuilder sb, String field, String value) {
        this.addField(sb, field, value, null, 0);
    }

    private void addField(StringBuilder sb, String field, String value, int wrap) {
        this.addField(sb, field, value, null, wrap);
    }

    private void addField(StringBuilder sb, String field, String value, String otherValue, int wrap) {
        sb.append("<tr><td style='margin-left: 5pt; margin-right: 25pt;").append("white-space: nowrap' valign='top'>").append(field).append("</td><td><span");
        if (otherValue != null) {
            sb.append('>').append(value).append("</span><br/><span");
            value = otherValue;
        }
        if (wrap > 0) {
            sb.append(" style='font-family:monospace'>");
            for (int i = 0; i < value.length(); ++i) {
                if (i % wrap == 0 && i > 0) {
                    sb.append("<br/>");
                }
                sb.append(value.charAt(i));
            }
        } else {
            sb.append(">");
            sb.append(value);
        }
        sb.append("</span></td></tr>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getHex(byte[] raw) {
        if (raw == null) {
            return null;
        }
        StringBuilder hex = new StringBuilder(2 * raw.length);
        try (Formatter f = new Formatter(hex);){
            for (byte b : raw) {
                f.format("%02X:", b);
            }
        }
        return hex.substring(0, hex.length() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getThumbprint(X509Certificate cert, String algorithm) throws CertificateException {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CertificateException(e);
        }
        byte[] encodedCert = cert.getEncoded();
        StringBuilder sb = new StringBuilder(encodedCert.length * 2);
        try (Formatter f = new Formatter(sb);){
            for (byte b : digest.digest(encodedCert)) {
                f.format("%02X:", b);
            }
        }
        return sb.substring(0, sb.length() - 1);
    }

    private static String getSimplifiedName(X509Certificate cert) {
        String result;
        HashMap<String, String> parts = new HashMap<String, String>();
        try {
            for (Rdn name : new LdapName(cert.getSubjectX500Principal().getName()).getRdns()) {
                if (name.getType() == null || name.getValue() == null) continue;
                parts.put(name.getType(), name.getValue().toString());
            }
        }
        catch (InvalidNameException invalidNameException) {
            // empty catch block
        }
        if ((result = (String)parts.get("CN")) == null) {
            result = (String)parts.get("OU");
        }
        if (result == null) {
            result = (String)parts.get("O");
        }
        if (result == null) {
            result = cert.getSubjectX500Principal().getName();
        }
        return result;
    }

    private void valueChangedPerformed(TreeSelectionEvent e) {
        Object o = e.getNewLeadSelectionPath().getLastPathComponent();
        if (o instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)o;
            this.infoTextPane.setText(this.toString(node.getUserObject()));
        }
    }
}

