/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil.presence;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.java.sip.communicator.plugin.desktoputil.DesktopUtilActivator;
import net.java.sip.communicator.plugin.desktoputil.ImageCanvas;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.desktoputil.presence.AbstractStatusMessageMenu;
import net.java.sip.communicator.util.skin.Skinnable;
import org.jitsi.service.resources.ResourceManagementService;

public class NewStatusMessageDialog
extends SIPCommDialog
implements ActionListener,
Skinnable {
    private static final String RENAME_DIALOG_ICON = "service.gui.icons.RENAME_DIALOG_ICON";
    private final JTextField messageTextField = new JTextField();
    private final JButton cancelButton = new JButton(DesktopUtilActivator.getResources().getI18NString("service.gui.CANCEL"));
    private final String currentStatusMessage;
    private JPanel messagePanel;
    private final AbstractStatusMessageMenu parentMenu;
    private JCheckBox saveNewMessage;

    public NewStatusMessageDialog(String currentStatusMessage, AbstractStatusMessageMenu parentMenu) {
        super(false);
        this.currentStatusMessage = currentStatusMessage;
        this.parentMenu = parentMenu;
        this.init();
        this.pack();
    }

    private void init() {
        ResourceManagementService r = DesktopUtilActivator.getResources();
        JLabel messageLabel = new JLabel(r.getI18NString("service.gui.NEW_STATUS_MESSAGE"));
        TransparentPanel dataPanel = new TransparentPanel(new BorderLayout(5, 5));
        JTextArea infoArea = new JTextArea(r.getI18NString("service.gui.STATUS_MESSAGE_INFO"));
        JLabel infoTitleLabel = new JLabel(r.getI18NString("service.gui.NEW_STATUS_MESSAGE"));
        TransparentPanel labelsPanel = new TransparentPanel(new GridLayout(0, 1));
        JButton okButton = new JButton(r.getI18NString("service.gui.OK"));
        TransparentPanel buttonsPanel = new TransparentPanel(new FlowLayout(2));
        this.saveNewMessage = new JCheckBox(r.getI18NString("service.gui.NEW_STATUS_MESSAGE_SAVE"));
        this.setTitle(r.getI18NString("service.gui.NEW_STATUS_MESSAGE"));
        this.getRootPane().setDefaultButton(okButton);
        this.setPreferredSize(new Dimension(550, 200));
        infoArea.setEditable(false);
        infoArea.setLineWrap(true);
        infoArea.setWrapStyleWord(true);
        infoArea.setOpaque(false);
        ((Container)((Object)dataPanel)).add(messageLabel, "West");
        this.messageTextField.setText(this.currentStatusMessage);
        ((Container)((Object)dataPanel)).add(this.messageTextField, "Center");
        infoTitleLabel.setHorizontalAlignment(0);
        infoTitleLabel.setFont(infoTitleLabel.getFont().deriveFont(1, 18.0f));
        this.saveNewMessage.setSelected(true);
        TransparentPanel saveToCustomPanel = new TransparentPanel(new FlowLayout(2));
        ((Container)((Object)saveToCustomPanel)).add(this.saveNewMessage);
        ((Container)((Object)labelsPanel)).add(infoTitleLabel);
        ((Container)((Object)labelsPanel)).add(infoArea);
        ((Container)((Object)labelsPanel)).add((Component)((Object)dataPanel));
        ((Container)((Object)labelsPanel)).add((Component)((Object)saveToCustomPanel));
        this.messagePanel = new TransparentPanel(new GridBagLayout());
        GridBagConstraints messagePanelConstraints = new GridBagConstraints();
        messagePanelConstraints.anchor = 18;
        messagePanelConstraints.fill = 0;
        messagePanelConstraints.gridx = 0;
        messagePanelConstraints.gridy = 0;
        messagePanelConstraints.insets = new Insets(5, 0, 5, 10);
        messagePanelConstraints.weightx = 0.0;
        messagePanelConstraints.weighty = 0.0;
        this.messagePanel.add((Component)((Object)new ImageCanvas(DesktopUtilActivator.getImage(RENAME_DIALOG_ICON))), messagePanelConstraints);
        messagePanelConstraints.anchor = 11;
        messagePanelConstraints.fill = 2;
        messagePanelConstraints.gridx = 1;
        messagePanelConstraints.insets = new Insets(0, 0, 0, 0);
        messagePanelConstraints.weightx = 1.0;
        this.messagePanel.add((Component)((Object)labelsPanel), messagePanelConstraints);
        okButton.setName("ok");
        this.cancelButton.setName("cancel");
        okButton.setMnemonic(r.getI18nMnemonic("service.gui.OK"));
        this.cancelButton.setMnemonic(r.getI18nMnemonic("service.gui.CANCEL"));
        okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        ((Container)((Object)buttonsPanel)).add(okButton);
        ((Container)((Object)buttonsPanel)).add(this.cancelButton);
        TransparentPanel mainPanel = new TransparentPanel(new GridBagLayout());
        ((JComponent)((Object)mainPanel)).setBorder(BorderFactory.createEmptyBorder(5, 10, 0, 10));
        GridBagConstraints mainPanelConstraints = new GridBagConstraints();
        mainPanelConstraints.anchor = 11;
        mainPanelConstraints.fill = 1;
        mainPanelConstraints.gridx = 0;
        mainPanelConstraints.gridy = 0;
        mainPanelConstraints.weightx = 1.0;
        mainPanelConstraints.weighty = 1.0;
        ((Container)((Object)mainPanel)).add(this.messagePanel, mainPanelConstraints);
        mainPanelConstraints.anchor = 14;
        mainPanelConstraints.fill = 0;
        mainPanelConstraints.gridy = 1;
        mainPanelConstraints.weightx = 0.0;
        mainPanelConstraints.weighty = 0.0;
        ((Container)((Object)mainPanel)).add((Component)((Object)buttonsPanel), mainPanelConstraints);
        this.getContentPane().add((Component)((Object)mainPanel));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JButton button = (JButton)e.getSource();
        String name = button.getName();
        if (name.equals("ok")) {
            this.parentMenu.setCurrentMessage(this.messageTextField.getText(), this.parentMenu.getNewMessageItem(), this.saveNewMessage.isSelected());
            this.parentMenu.publishStatusMessage(this.messageTextField.getText(), this.parentMenu.getNewMessageItem(), this.saveNewMessage.isSelected());
        }
        this.dispose();
    }

    public void requestFocusInField() {
        this.messageTextField.requestFocus();
    }

    @Override
    protected void close(boolean isEscaped) {
        if (isEscaped) {
            this.cancelButton.doClick();
        }
    }

    public void loadSkin() {
        if (this.messagePanel != null) {
            for (Component component : this.messagePanel.getComponents()) {
                if (!(component instanceof ImageCanvas)) continue;
                ImageCanvas cmp = (ImageCanvas)((Object)component);
                cmp.setImage(DesktopUtilActivator.getImage(RENAME_DIALOG_ICON));
            }
        }
    }
}

