/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.constants.DNSState;
import javax.jmdns.impl.tasks.DNSTask;

public interface DNSStatefulObject {
    public JmDNSImpl getDns();

    public void associateWithTask(DNSTask var1, DNSState var2);

    public void removeAssociationWithTask(DNSTask var1);

    public boolean isAssociatedWithTask(DNSTask var1, DNSState var2);

    public boolean advanceState(DNSTask var1);

    public boolean revertState();

    public boolean cancelState();

    public boolean closeState();

    public boolean recoverState();

    public boolean isProbing();

    public boolean isAnnouncing();

    public boolean isAnnounced();

    public boolean isCanceling();

    public boolean isCanceled();

    public boolean isClosing();

    public boolean isClosed();

    public boolean waitForAnnounced(long var1);

    public boolean waitForCanceled(long var1);

    public static class DefaultImplementation
    extends ReentrantLock
    implements DNSStatefulObject {
        private static Logger logger = Logger.getLogger(DefaultImplementation.class.getName());
        private static final long serialVersionUID = -3264781576883412227L;
        private volatile JmDNSImpl _dns = null;
        protected volatile DNSTask _task = null;
        protected volatile DNSState _state = DNSState.PROBING_1;
        private final DNSStatefulObjectSemaphore _announcing = new DNSStatefulObjectSemaphore("Announce");
        private final DNSStatefulObjectSemaphore _canceling = new DNSStatefulObjectSemaphore("Cancel");

        @Override
        public JmDNSImpl getDns() {
            return this._dns;
        }

        protected void setDns(JmDNSImpl jmDNSImpl) {
            this._dns = jmDNSImpl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void associateWithTask(DNSTask dNSTask, DNSState dNSState) {
            if (this._task == null && this._state == dNSState) {
                this.lock();
                try {
                    if (this._task == null && this._state == dNSState) {
                        this.setTask(dNSTask);
                    }
                }
                finally {
                    this.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAssociationWithTask(DNSTask dNSTask) {
            if (this._task == dNSTask) {
                this.lock();
                try {
                    if (this._task == dNSTask) {
                        this.setTask(null);
                    }
                }
                finally {
                    this.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isAssociatedWithTask(DNSTask dNSTask, DNSState dNSState) {
            this.lock();
            try {
                boolean bl = this._task == dNSTask && this._state == dNSState;
                return bl;
            }
            finally {
                this.unlock();
            }
        }

        protected void setTask(DNSTask dNSTask) {
            this._task = dNSTask;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setState(DNSState dNSState) {
            this.lock();
            try {
                this._state = dNSState;
                if (this.isAnnounced()) {
                    this._announcing.signalEvent();
                }
                if (this.isCanceled()) {
                    this._canceling.signalEvent();
                    this._announcing.signalEvent();
                }
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean advanceState(DNSTask dNSTask) {
            boolean bl = true;
            if (this._task == dNSTask) {
                this.lock();
                try {
                    if (this._task == dNSTask) {
                        this.setState(this._state.advance());
                    } else {
                        logger.warning("Trying to advance state whhen not the owner. owner: " + this._task + " perpetrator: " + dNSTask);
                    }
                }
                finally {
                    this.unlock();
                }
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean revertState() {
            boolean bl = true;
            if (!this.willCancel()) {
                this.lock();
                try {
                    if (!this.willCancel()) {
                        this.setState(this._state.revert());
                        this.setTask(null);
                    }
                }
                finally {
                    this.unlock();
                }
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancelState() {
            boolean bl = false;
            if (!this.willCancel()) {
                this.lock();
                try {
                    if (!this.willCancel()) {
                        this.setState(DNSState.CANCELING_1);
                        this.setTask(null);
                        bl = true;
                    }
                }
                finally {
                    this.unlock();
                }
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean closeState() {
            boolean bl = false;
            if (!this.willClose()) {
                this.lock();
                try {
                    if (!this.willClose()) {
                        this.setState(DNSState.CLOSING);
                        this.setTask(null);
                        bl = true;
                    }
                }
                finally {
                    this.unlock();
                }
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean recoverState() {
            boolean bl = false;
            this.lock();
            try {
                this.setState(DNSState.PROBING_1);
                this.setTask(null);
            }
            finally {
                this.unlock();
            }
            return bl;
        }

        @Override
        public boolean isProbing() {
            return this._state.isProbing();
        }

        @Override
        public boolean isAnnouncing() {
            return this._state.isAnnouncing();
        }

        @Override
        public boolean isAnnounced() {
            return this._state.isAnnounced();
        }

        @Override
        public boolean isCanceling() {
            return this._state.isCanceling();
        }

        @Override
        public boolean isCanceled() {
            return this._state.isCanceled();
        }

        @Override
        public boolean isClosing() {
            return this._state.isClosing();
        }

        @Override
        public boolean isClosed() {
            return this._state.isClosed();
        }

        private boolean willCancel() {
            return this._state.isCanceled() || this._state.isCanceling();
        }

        private boolean willClose() {
            return this._state.isClosed() || this._state.isClosing();
        }

        @Override
        public boolean waitForAnnounced(long l) {
            if (!this.isAnnounced() && !this.willCancel()) {
                this._announcing.waitForEvent(l);
            }
            if (!this.isAnnounced()) {
                if (this.willCancel() || this.willClose()) {
                    logger.fine("Wait for announced cancelled: " + this);
                } else {
                    logger.warning("Wait for announced timed out: " + this);
                }
            }
            return this.isAnnounced();
        }

        @Override
        public boolean waitForCanceled(long l) {
            if (!this.isCanceled()) {
                this._canceling.waitForEvent(l);
            }
            if (!this.isCanceled() && !this.willClose()) {
                logger.warning("Wait for canceled timed out: " + this);
            }
            return this.isCanceled();
        }

        @Override
        public String toString() {
            return (this._dns != null ? "DNS: " + this._dns.getName() : "NO DNS") + " state: " + (Object)((Object)this._state) + " task: " + this._task;
        }
    }

    public static final class DNSStatefulObjectSemaphore {
        private static Logger logger = Logger.getLogger(DNSStatefulObjectSemaphore.class.getName());
        private final String _name;
        private final ConcurrentMap<Thread, Semaphore> _semaphores;

        public DNSStatefulObjectSemaphore(String string) {
            this._name = string;
            this._semaphores = new ConcurrentHashMap<Thread, Semaphore>(50);
        }

        public void waitForEvent(long l) {
            Thread thread = Thread.currentThread();
            Semaphore semaphore = (Semaphore)this._semaphores.get(thread);
            if (semaphore == null) {
                semaphore = new Semaphore(1, true);
                semaphore.drainPermits();
                this._semaphores.putIfAbsent(thread, semaphore);
            }
            semaphore = (Semaphore)this._semaphores.get(thread);
            try {
                semaphore.tryAcquire(l, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                logger.log(Level.FINER, "Exception ", interruptedException);
            }
        }

        public void signalEvent() {
            Collection collection = this._semaphores.values();
            for (Semaphore semaphore : collection) {
                semaphore.release();
                collection.remove(semaphore);
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(1000);
            stringBuilder.append("Semaphore: ");
            stringBuilder.append(this._name);
            if (this._semaphores.size() == 0) {
                stringBuilder.append(" no semaphores.");
            } else {
                stringBuilder.append(" semaphores:\n");
                for (Thread thread : this._semaphores.keySet()) {
                    stringBuilder.append("\tThread: ");
                    stringBuilder.append(thread.getName());
                    stringBuilder.append(' ');
                    stringBuilder.append(this._semaphores.get(thread));
                    stringBuilder.append('\n');
                }
            }
            return stringBuilder.toString();
        }
    }
}

