/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl.tasks.resolver;

import java.io.IOException;
import javax.jmdns.ServiceInfo;
import javax.jmdns.impl.DNSOutgoing;
import javax.jmdns.impl.DNSQuestion;
import javax.jmdns.impl.DNSRecord;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.constants.DNSRecordClass;
import javax.jmdns.impl.constants.DNSRecordType;
import javax.jmdns.impl.tasks.resolver.DNSResolverTask;

public class ServiceResolver
extends DNSResolverTask {
    private final String _type;

    public ServiceResolver(JmDNSImpl jmDNSImpl, String string) {
        super(jmDNSImpl);
        this._type = string;
    }

    @Override
    public String getName() {
        return "ServiceResolver(" + (this.getDns() != null ? this.getDns().getName() : "") + ")";
    }

    @Override
    protected DNSOutgoing addAnswers(DNSOutgoing dNSOutgoing) throws IOException {
        DNSOutgoing dNSOutgoing2 = dNSOutgoing;
        long l = System.currentTimeMillis();
        for (ServiceInfo serviceInfo : this.getDns().getServices().values()) {
            dNSOutgoing2 = this.addAnswer(dNSOutgoing2, new DNSRecord.Pointer(serviceInfo.getType(), DNSRecordClass.CLASS_IN, false, 3600, serviceInfo.getQualifiedName()), l);
        }
        return dNSOutgoing2;
    }

    @Override
    protected DNSOutgoing addQuestions(DNSOutgoing dNSOutgoing) throws IOException {
        DNSOutgoing dNSOutgoing2 = dNSOutgoing;
        dNSOutgoing2 = this.addQuestion(dNSOutgoing2, DNSQuestion.newQuestion(this._type, DNSRecordType.TYPE_PTR, DNSRecordClass.CLASS_IN, false));
        return dNSOutgoing2;
    }

    @Override
    protected String description() {
        return "querying service";
    }
}

