/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl.tasks.state;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import javax.jmdns.impl.DNSOutgoing;
import javax.jmdns.impl.DNSRecord;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.ServiceInfoImpl;
import javax.jmdns.impl.constants.DNSState;
import javax.jmdns.impl.tasks.state.DNSStateTask;

public class Renewer
extends DNSStateTask {
    static Logger logger = Logger.getLogger(Renewer.class.getName());

    public Renewer(JmDNSImpl jmDNSImpl) {
        super(jmDNSImpl, Renewer.defaultTTL());
        this.setTaskState(DNSState.ANNOUNCED);
        this.associate(DNSState.ANNOUNCED);
    }

    @Override
    public String getName() {
        return "Renewer(" + (this.getDns() != null ? this.getDns().getName() : "") + ")";
    }

    @Override
    public String toString() {
        return super.toString() + " state: " + (Object)((Object)this.getTaskState());
    }

    @Override
    public void start(Timer timer) {
        if (!this.getDns().isCanceling() && !this.getDns().isCanceled()) {
            timer.schedule((TimerTask)this, 1800000L, 1800000L);
        }
    }

    @Override
    public boolean cancel() {
        this.removeAssociation();
        return super.cancel();
    }

    @Override
    public String getTaskDescription() {
        return "renewing";
    }

    @Override
    protected boolean checkRunCondition() {
        return !this.getDns().isCanceling() && !this.getDns().isCanceled();
    }

    @Override
    protected DNSOutgoing createOugoing() {
        return new DNSOutgoing(33792);
    }

    @Override
    protected DNSOutgoing buildOutgoingForDNS(DNSOutgoing dNSOutgoing) throws IOException {
        DNSOutgoing dNSOutgoing2 = dNSOutgoing;
        for (DNSRecord dNSRecord : this.getDns().getLocalHost().answers(true, this.getTTL())) {
            dNSOutgoing2 = this.addAnswer(dNSOutgoing2, null, dNSRecord);
        }
        return dNSOutgoing2;
    }

    @Override
    protected DNSOutgoing buildOutgoingForInfo(ServiceInfoImpl serviceInfoImpl, DNSOutgoing dNSOutgoing) throws IOException {
        DNSOutgoing dNSOutgoing2 = dNSOutgoing;
        for (DNSRecord dNSRecord : serviceInfoImpl.answers(true, this.getTTL(), this.getDns().getLocalHost())) {
            dNSOutgoing2 = this.addAnswer(dNSOutgoing2, null, dNSRecord);
        }
        return dNSOutgoing2;
    }

    @Override
    protected void recoverTask(Throwable throwable) {
        this.getDns().recover();
    }

    @Override
    protected void advanceTask() {
        this.setTaskState(this.getTaskState().advance());
        if (!this.getTaskState().isAnnounced()) {
            this.cancel();
        }
    }
}

