/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.core.stub;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import junit.framework.AssertionFailedError;
import org.jmock.core.CoreMock;
import org.jmock.core.Formatting;
import org.jmock.core.Invocation;
import org.jmock.core.Stub;

public class DefaultResultStub
implements Stub {
    private Map resultValuesByType = new HashMap();

    public DefaultResultStub() {
        this.createDefaultResults();
    }

    @Override
    public StringBuffer describeTo(StringBuffer stringBuffer) {
        return stringBuffer.append("returns a default value");
    }

    public void addResult(Class clazz, Object object) {
        this.resultValuesByType.put(clazz, object);
    }

    @Override
    public Object invoke(Invocation invocation) throws Throwable {
        Class<?> clazz = invocation.invokedMethod.getReturnType();
        if (this.resultValuesByType.containsKey(clazz)) {
            return this.resultValuesByType.get(clazz);
        }
        if (clazz.isArray()) {
            return Array.newInstance(clazz.getComponentType(), 0);
        }
        if (clazz.isInterface()) {
            CoreMock coreMock = new CoreMock(clazz, "null" + Formatting.classShortName(clazz));
            coreMock.setDefaultStub(this);
            return coreMock.proxy();
        }
        throw new AssertionFailedError(this.createErrorMessage(invocation));
    }

    public String createErrorMessage(Invocation invocation) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("unexpected result type: ");
        stringBuffer.append(invocation.invokedMethod.getReturnType().toString());
        stringBuffer.append("\n");
        if (this.resultValuesByType.isEmpty()) {
            stringBuffer.append("no result types are registered!");
        } else {
            stringBuffer.append("expected one of: ");
            Iterator iterator = this.resultValuesByType.keySet().iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(((Class)iterator.next()).getName());
                bl = true;
            }
        }
        return stringBuffer.toString();
    }

    protected void createDefaultResults() {
        this.addResult(Boolean.TYPE, Boolean.FALSE);
        this.addResult(Void.TYPE, null);
        this.addResult(Byte.TYPE, new Byte(0));
        this.addResult(Short.TYPE, new Short(0));
        this.addResult(Integer.TYPE, new Integer(0));
        this.addResult(Long.TYPE, new Long(0L));
        this.addResult(Character.TYPE, new Character('\u0000'));
        this.addResult(Float.TYPE, new Float(0.0f));
        this.addResult(Double.TYPE, new Double(0.0));
        this.addResult(Boolean.class, Boolean.FALSE);
        this.addResult(Byte.class, new Byte(0));
        this.addResult(Short.class, new Short(0));
        this.addResult(Integer.class, new Integer(0));
        this.addResult(Long.class, new Long(0L));
        this.addResult(Character.class, new Character('\u0000'));
        this.addResult(Float.class, new Float(0.0f));
        this.addResult(Double.class, new Double(0.0));
        this.addResult(String.class, "");
        this.addResult(Object.class, new Object());
    }
}

