/*
 * Decompiled with CFR 0.152.
 */
package JavaViewer;

import JavaViewer.VncViewer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class FTPFrame
extends JFrame
implements ActionListener,
MouseListener {
    private VncViewer viewer;
    private JPanel jContentPane = null;
    private JPanel topPanel = null;
    private JPanel topPanelLocal = null;
    private JPanel topPanelRemote = null;
    private JPanel statusPanel = null;
    private JPanel remotePanel = null;
    private JPanel localPanel = null;
    private JPanel buttonPanel = null;
    private JButton sendButton = null;
    private JButton receiveButton = null;
    private JButton deleteButton = null;
    private JButton newFolderButton = null;
    private JButton stopButton = null;
    private JButton closeButton = null;
    private JComboBox localDrivesComboBox = null;
    private JComboBox remoteDrivesComboBox = null;
    private JTextField localMachineLabel = null;
    private JTextField remoteMachineLabel = null;
    private JButton localTopButton = null;
    private JButton remoteTopButton = null;
    private JScrollPane localScrollPane = null;
    private JList localFileTable = null;
    private JScrollPane remoteScrollPane = null;
    private JList remoteFileTable = null;
    private JTextField remoteLocation = null;
    private JTextField localLocation = null;
    private JTextField localStatus = null;
    public JTextField remoteStatus = null;
    public JComboBox historyComboBox = null;
    public JProgressBar jProgressBar = null;
    public JTextField connectionStatus = null;
    public boolean updateDriveList;
    private Vector remoteList = null;
    private Vector localList = null;
    private File currentLocalDirectory = null;
    public String selectedTable = null;
    private ArrayList localDirList;
    private ArrayList localFileList;
    private static final boolean DEBUG = false;

    FTPFrame(VncViewer v) {
        super("Ultr@VNC File Transfer");
        this.viewer = v;
        this.initialize();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        System.out.println(evt.getSource());
        if (evt.getSource() == this.closeButton) {
            this.doClose();
        } else if (evt.getSource() == this.sendButton) {
            Dimension dim = this.localPanel.getSize();
            this.doSend();
            this.repaint();
        } else if (evt.getSource() == this.receiveButton) {
            this.doReceive();
            this.repaint();
        } else if (evt.getSource() == this.localDrivesComboBox) {
            this.changeLocalDrive();
            this.repaint();
        } else if (evt.getSource() == this.remoteDrivesComboBox) {
            this.changeRemoteDrive();
            this.remoteList.clear();
            this.remoteFileTable.setListData(this.remoteList);
        } else if (evt.getSource() == this.localTopButton) {
            this.changeLocalDrive();
            this.repaint();
        } else if (evt.getSource() == this.remoteTopButton) {
            this.changeRemoteDrive();
            this.repaint();
        } else if (evt.getSource() == this.deleteButton) {
            this.doDelete();
            this.repaint();
            this.repaint();
        } else if (evt.getSource() == this.newFolderButton) {
            this.doNewFolder();
            this.repaint();
            this.repaint();
        } else if (evt.getSource() == this.stopButton) {
            this.doStop();
            this.repaint();
            this.repaint();
        }
    }

    public void disableButtons() {
        this.closeButton.setEnabled(false);
        this.deleteButton.setEnabled(false);
        this.localTopButton.setEnabled(false);
        this.newFolderButton.setEnabled(false);
        this.stopButton.setVisible(true);
        this.stopButton.setEnabled(true);
        this.receiveButton.setEnabled(false);
        this.remoteTopButton.setEnabled(false);
        this.sendButton.setEnabled(false);
        this.remoteFileTable.setEnabled(false);
        this.localFileTable.setEnabled(false);
        this.localLocation.setEnabled(false);
        this.remoteLocation.setEnabled(false);
        this.remoteDrivesComboBox.setEnabled(false);
        this.localDrivesComboBox.setEnabled(false);
        this.setDefaultCloseOperation(0);
    }

    public void enableButtons() {
        this.closeButton.setEnabled(true);
        this.deleteButton.setEnabled(true);
        this.localTopButton.setEnabled(true);
        this.newFolderButton.setEnabled(true);
        this.stopButton.setVisible(false);
        this.stopButton.setEnabled(false);
        this.receiveButton.setEnabled(true);
        this.remoteTopButton.setEnabled(true);
        this.sendButton.setEnabled(true);
        this.remoteFileTable.setEnabled(true);
        this.localFileTable.setEnabled(true);
        this.localLocation.setEnabled(true);
        this.remoteLocation.setEnabled(true);
        this.remoteDrivesComboBox.setEnabled(true);
        this.localDrivesComboBox.setEnabled(true);
    }

    public void changeRemoteDrive() {
        if (!this.updateDriveList) {
            String drive = this.remoteDrivesComboBox.getSelectedItem().toString().substring(0, 1) + ":\\";
            this.viewer.rfb.readServerDirectory(drive);
            this.remoteLocation.setText(drive);
        }
        this.remoteList.clear();
        this.remoteFileTable.setListData(this.remoteList);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 1) {
            if (e.getSource() == this.localFileTable) {
                this.updateLocalFileTableSelection();
            } else if (e.getSource() == this.remoteFileTable) {
                this.updateRemoteFileTableSelection();
            }
        } else if (e.getClickCount() == 2) {
            if (e.getSource() == this.localFileTable) {
                this.updateLocalFileTable();
            } else if (e.getSource() == this.remoteFileTable) {
                this.updateRemoteFileTable();
            }
        }
    }

    public void refreshLocalLocation() {
        File f = new File(this.localLocation.getText());
        this.changeLocalDirectory(f);
    }

    public void refreshRemoteLocation() {
        this.remoteList.clear();
        this.remoteFileTable.setListData(this.remoteList);
        this.viewer.rfb.readServerDirectory(this.remoteLocation.getText());
    }

    public String[] printDrives(String str) {
        this.updateDriveList = true;
        this.remoteDrivesComboBox.removeAllItems();
        int size = str.length();
        String driveType = null;
        String[] drive = new String[str.length() / 3];
        for (int i = 0; i < size; i += 3) {
            drive[i / 3] = str.substring(i, i + 2);
            driveType = str.substring(i + 2, i + 3);
            if (driveType.compareTo("f") == 0) {
                int n = i / 3;
                drive[n] = drive[n] + "\\ Floppy";
            }
            if (driveType.compareTo("l") == 0) {
                int n = i / 3;
                drive[n] = drive[n] + "\\ Local Disk";
            }
            if (driveType.compareTo("c") == 0) {
                int n = i / 3;
                drive[n] = drive[n] + "\\ CD-ROM";
            }
            if (driveType.compareTo("n") == 0) {
                int n = i / 3;
                drive[n] = drive[n] + "\\ Network";
            }
            this.remoteDrivesComboBox.addItem(drive[i / 3]);
        }
        boolean bFound = false;
        for (int i = 0; i < this.remoteDrivesComboBox.getItemCount(); ++i) {
            if (!this.remoteDrivesComboBox.getItemAt(i).toString().substring(0, 1).toUpperCase().equals("C")) continue;
            this.remoteDrivesComboBox.setSelectedIndex(i);
            bFound = true;
        }
        if (!bFound) {
            this.remoteDrivesComboBox.setSelectedIndex(0);
        }
        this.updateDriveList = false;
        return drive;
    }

    public void printRemoteDirectory(ArrayList a) {
        this.remoteList.clear();
        ArrayList<String> files = new ArrayList<String>();
        ArrayList<String> dirs = new ArrayList<String>();
        for (String name : a) {
            if (name.equals("[..]")) {
                this.remoteList.add(name);
                continue;
            }
            if (name.startsWith(" [") && name.endsWith("]")) {
                dirs.add(name.substring(2, name.length() - 1));
                continue;
            }
            files.add(name);
        }
        Collections.sort(dirs, new StrComp());
        Collections.sort(files, new StrComp());
        for (String dirname : dirs) {
            this.remoteList.add(" [" + dirname + "]");
        }
        for (String filename : files) {
            this.remoteList.add(filename);
        }
        this.remoteFileTable.setListData(this.remoteList);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    private void doNewFolder() {
        String name = JOptionPane.showInputDialog(null, "Enter new directory name", "Create New Directory", 3);
        if (name == null) {
            return;
        }
        if (this.selectedTable.equals("remote")) {
            name = this.remoteLocation.getText() + name;
            this.viewer.rfb.createRemoteDirectory(name);
        } else {
            name = this.localLocation.getText() + name;
            File f = new File(name);
            f.mkdir();
            this.refreshLocalLocation();
            this.historyComboBox.insertItemAt(new String("Created Local Directory: " + name), 0);
            this.historyComboBox.setSelectedIndex(0);
        }
    }

    private void doClose() {
        try {
            this.setVisible(false);
            this.viewer.rfb.writeFramebufferUpdateRequest(0, 0, this.viewer.rfb.framebufferWidth, this.viewer.rfb.framebufferHeight, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void doDelete() {
        System.out.println("Delete Button Pressed");
        if (this.selectedTable.equals("remote")) {
            int r;
            String sFileName = (String)this.remoteFileTable.getSelectedValue();
            if (sFileName.substring(0, 2).equals(" [") && sFileName.substring(sFileName.length() - 1, sFileName.length()).equals("]")) {
                JOptionPane.showMessageDialog(null, "Directory Deletion is not yet available in this version...", "FileTransfer Info", 1);
                return;
            }
            if (this.remoteList.contains(sFileName) && (r = JOptionPane.showConfirmDialog(null, "Are you sure you want to delete the file \n< " + sFileName + " >\n on Remote Machine ?", "File Transfer Warning", 0)) == 1) {
                return;
            }
            String fileName = this.remoteLocation.getText() + sFileName.substring(1);
            this.viewer.rfb.deleteRemoteFile(fileName);
        } else {
            int r;
            String sFileName = (String)this.localFileTable.getSelectedValue();
            if (sFileName.substring(0, 2).equals(" [") && sFileName.substring(sFileName.length() - 1, sFileName.length()).equals("]")) {
                JOptionPane.showMessageDialog(null, "Directory Deletion is not yet available in this version...", "FileTransfer Info", 1);
                return;
            }
            if (this.localList.contains(sFileName) && (r = JOptionPane.showConfirmDialog(null, "Are you sure you want to delete the file \n< " + sFileName + " >\n on Local Machine ?", "File Transfer Warning", 0)) == 1) {
                return;
            }
            String s = this.localLocation.getText() + sFileName.substring(1);
            File f = new File(s);
            f.delete();
            this.refreshLocalLocation();
            this.historyComboBox.insertItemAt(new String("Deleted On Local Disk: " + s), 0);
            this.historyComboBox.setSelectedIndex(0);
        }
    }

    private void doReceive() {
        int r;
        System.out.println("Received Button Pressed");
        String sFileName = (String)this.remoteFileTable.getSelectedValue();
        if (sFileName.substring(0, 2).equals(" [") && sFileName.substring(sFileName.length() - 1, sFileName.length()).equals("]")) {
            JOptionPane.showMessageDialog(null, "Directory Transfer is not yet available in this version...", "FileTransfer Info", 1);
            return;
        }
        if (this.localList.contains(sFileName) && (r = JOptionPane.showConfirmDialog(null, "The file < " + sFileName + " >\n already exists on Local Machine\n Are you sure you want to overwrite it ?", "File Transfer Warning", 0)) == 1) {
            return;
        }
        String remoteFileName = this.remoteLocation.getText();
        remoteFileName = remoteFileName + ((String)this.remoteFileTable.getSelectedValue()).substring(1);
        String localDestinationPath = this.localLocation.getText() + ((String)this.remoteFileTable.getSelectedValue()).substring(1);
        this.viewer.rfb.requestRemoteFile(remoteFileName, localDestinationPath);
    }

    private void doSend() {
        int r;
        System.out.println("Send Button Pressed");
        String sFileName = (String)this.localFileTable.getSelectedValue();
        if (sFileName.substring(0, 2).equals(" [") && sFileName.substring(sFileName.length() - 1, sFileName.length()).equals("]")) {
            JOptionPane.showMessageDialog(null, "Directory Transfer is not yet available in this version...", "FileTransfer Info", 1);
            return;
        }
        if (this.remoteList.contains(sFileName) && (r = JOptionPane.showConfirmDialog(null, "The file < " + sFileName + " >\n already exists on Remote Machine\n Are you sure you want to overwrite it ?", "File Transfer Warning", 0)) == 1) {
            return;
        }
        String source = this.localLocation.getText();
        source = source + ((String)this.localFileTable.getSelectedValue()).substring(1);
        String destinationPath = this.remoteLocation.getText();
        this.viewer.rfb.offerLocalFile(source, destinationPath);
    }

    private void doStop() {
        this.viewer.rfb.fAbort = true;
    }

    private void changeLocalDrive() {
        File currentDrive = new File(this.localDrivesComboBox.getSelectedItem().toString());
        if (currentDrive.canRead()) {
            this.localStatus.setText("");
            this.changeLocalDirectory(currentDrive);
        } else {
            this.localList.clear();
            this.localStatus.setText("WARNING: Drive " + this.localDrivesComboBox.getSelectedItem().toString());
            this.connectionStatus.setText(" > WARNING - Local Drive unavailable (possibly restricted access or media not present)");
        }
    }

    private void updateRemoteFileTableSelection() {
        this.selectedTable = "remote";
        this.localFileTable.setBackground(new Color(238, 238, 238));
        this.remoteFileTable.setBackground(new Color(255, 255, 255));
    }

    private void updateLocalFileTableSelection() {
        this.selectedTable = "local";
        this.remoteFileTable.setBackground(new Color(238, 238, 238));
        this.localFileTable.setBackground(new Color(255, 255, 255));
    }

    public void updateRemoteFileTable() {
        String name = null;
        String drive = null;
        name = this.remoteFileTable.getSelectedValue().toString().substring(1);
        if (name.equals("[..]")) {
            drive = this.remoteLocation.getText().substring(0, this.remoteLocation.getText().length() - 1);
            int index = drive.lastIndexOf("\\");
            drive = drive.substring(0, index + 1);
            this.remoteLocation.setText(drive);
            this.viewer.rfb.readServerDirectory(drive);
            this.remoteList.clear();
            this.remoteFileTable.setListData(this.remoteList);
        } else if (!name.substring(0, 2).equals(" [") && !name.substring(name.length() - 1, name.length()).equals("]")) {
            drive = this.remoteLocation.getText();
        } else {
            name = name.substring(1, name.length() - 1);
            drive = this.remoteLocation.getText() + name + "\\";
            this.remoteLocation.setText(drive);
            this.viewer.rfb.readServerDirectory(drive);
            this.remoteList.clear();
            this.remoteFileTable.setListData(this.remoteList);
        }
    }

    private void updateLocalFileTable() {
        this.localStatus.setText("");
        File currentSelection = new File(this.currentLocalDirectory, this.getTrimmedSelection());
        if (this.getTrimmedSelection().equals("..")) {
            currentSelection = this.currentLocalDirectory.getParentFile();
            if (currentSelection != null) {
                this.changeLocalDirectory(currentSelection);
            } else {
                this.localStatus.setText("You are at the root !");
            }
        } else if (currentSelection.isDirectory()) {
            this.changeLocalDirectory(currentSelection);
        }
    }

    private String getTrimmedSelection() {
        String currentSelection = this.localFileTable.getSelectedValue().toString().substring(1);
        if (currentSelection.substring(0, 1).equals("[") && currentSelection.substring(currentSelection.length() - 1, currentSelection.length()).equals("]")) {
            return currentSelection.substring(1, currentSelection.length() - 1);
        }
        return currentSelection;
    }

    public File getFirstReadableLocalDrive() {
        File currentDrive;
        int i;
        for (i = 0; i < this.localDrivesComboBox.getItemCount(); ++i) {
            currentDrive = new File(this.localDrivesComboBox.getItemAt(i).toString());
            if (!this.localDrivesComboBox.getItemAt(i).toString().substring(0, 1).toUpperCase().equals("C") || !currentDrive.canRead()) continue;
            this.localDrivesComboBox.setSelectedIndex(i);
            return currentDrive;
        }
        for (i = 0; i < this.localDrivesComboBox.getItemCount(); ++i) {
            currentDrive = new File(this.localDrivesComboBox.getItemAt(i).toString());
            if (!currentDrive.canRead()) continue;
            this.localDrivesComboBox.setSelectedIndex(i);
            return currentDrive;
        }
        this.localStatus.setText("ERROR!: No Local Drives are Readable");
        return null;
    }

    public void changeLocalDirectory(File dir) {
        int i;
        this.currentLocalDirectory = dir;
        Object[] contents = dir.list();
        this.localList.clear();
        this.localList.addElement(" [..]");
        Arrays.sort(contents);
        for (i = 0; i < contents.length; ++i) {
            if (new File(dir.getAbsolutePath() + System.getProperty("file.separator") + (String)contents[i]).isDirectory()) {
                this.localDirList.add(" [" + (String)contents[i] + "]");
                continue;
            }
            this.localFileList.add(" " + (String)contents[i]);
        }
        Collections.sort(this.localDirList, new StrComp());
        Collections.sort(this.localFileList, new StrComp());
        for (i = 0; i < this.localDirList.size(); ++i) {
            this.localList.addElement(this.localDirList.get(i));
        }
        for (i = 0; i < this.localFileList.size(); ++i) {
            this.localList.addElement(this.localFileList.get(i));
        }
        this.localFileList.clear();
        this.localDirList.clear();
        this.localFileTable.setListData(this.localList);
        if (dir.toString().charAt(dir.toString().length() - 1) == File.separatorChar) {
            this.localLocation.setText(dir.toString());
        } else {
            this.localLocation.setText(dir.toString() + File.separator);
        }
        this.localStatus.setText("Total Files / Folders: " + (this.localList.size() - 1));
    }

    private void initialize() {
        this.setResizable(false);
        this.setSize(794, 500);
        this.setContentPane(this.getJContentPane());
        this.localDirList = new ArrayList();
        this.localFileList = new ArrayList();
        this.updateDriveList = true;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getTopPanel(), "North");
            this.jContentPane.add((Component)this.getStatusPanel(), "South");
            this.jContentPane.add((Component)this.getRemotePanel(), "East");
            this.jContentPane.add((Component)this.getLocalPanel(), "West");
            this.jContentPane.add((Component)this.getButtonPanel(), "Center");
            this.localPanel.setMaximumSize(new Dimension(325, 398));
            this.localPanel.setMinimumSize(new Dimension(325, 398));
            this.localPanel.setPreferredSize(new Dimension(325, 398));
            this.remotePanel.setMaximumSize(new Dimension(325, 398));
            this.remotePanel.setMinimumSize(new Dimension(325, 398));
            this.remotePanel.setPreferredSize(new Dimension(325, 398));
        }
        return this.jContentPane;
    }

    private JPanel getTopPanelLocal() {
        if (this.topPanelLocal == null) {
            this.topPanelLocal = new JPanel();
            this.topPanelLocal.setLayout(new BorderLayout());
            this.topPanelLocal.setPreferredSize(new Dimension(325, 22));
            this.topPanelLocal.add((Component)this.getLocalDrivesComboBox(), "West");
            this.topPanelLocal.add((Component)this.getLocalMachineLabel(), "Center");
            this.topPanelLocal.add((Component)this.getLocalTopButton(), "East");
            this.topPanelLocal.setBackground(Color.lightGray);
        }
        return this.topPanelLocal;
    }

    private JPanel getTopPanelRemote() {
        if (this.topPanelRemote == null) {
            this.topPanelRemote = new JPanel();
            this.topPanelRemote.setLayout(new BorderLayout());
            this.topPanelRemote.setPreferredSize(new Dimension(325, 20));
            this.topPanelRemote.add((Component)this.getRemoteDrivesComboBox(), "West");
            this.topPanelRemote.add((Component)this.getRemoteMachineLabel(), "Center");
            this.topPanelRemote.add((Component)this.getRemoteTopButton(), "East");
            this.topPanelRemote.setBackground(Color.lightGray);
        }
        return this.topPanelRemote;
    }

    private JPanel getTopPanel() {
        if (this.topPanel == null) {
            this.topPanel = new JPanel();
            this.topPanel.setLayout(new BorderLayout());
            this.topPanel.add((Component)this.getTopPanelLocal(), "West");
            this.topPanel.add((Component)this.getTopPanelRemote(), "East");
        }
        return this.topPanel;
    }

    private JPanel getStatusPanel() {
        if (this.statusPanel == null) {
            this.statusPanel = new JPanel();
            this.statusPanel.setLayout(new BoxLayout(this.statusPanel, 1));
            this.statusPanel.add((Component)this.getHistoryComboBox(), null);
            this.statusPanel.add((Component)this.getJProgressBar(), null);
            this.statusPanel.add((Component)this.getConnectionStatus(), null);
            this.statusPanel.setBackground(Color.lightGray);
        }
        return this.statusPanel;
    }

    private JPanel getRemotePanel() {
        if (this.remotePanel == null) {
            this.remotePanel = new JPanel();
            this.remotePanel.setLayout(new BoxLayout(this.remotePanel, 1));
            this.remotePanel.add((Component)this.getRemoteLocation(), null);
            this.remotePanel.add((Component)this.getRemoteScrollPane(), null);
            this.remotePanel.add((Component)this.getRemoteStatus(), null);
            this.remotePanel.setBackground(Color.lightGray);
        }
        return this.remotePanel;
    }

    private JPanel getLocalPanel() {
        if (this.localPanel == null) {
            this.localPanel = new JPanel();
            this.localPanel.setLayout(new BoxLayout(this.localPanel, 1));
            this.localPanel.add((Component)this.getLocalLocation(), null);
            this.localPanel.add((Component)this.getLocalScrollPane(), null);
            this.localPanel.add((Component)this.getLocalStatus(), null);
            this.localPanel.setBackground(Color.lightGray);
            this.localPanel.setComponentOrientation(ComponentOrientation.UNKNOWN);
            this.localPanel.setName("localPanel");
            Dimension dimension = this.localPanel.getSize();
        }
        return this.localPanel;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(null);
            this.buttonPanel.add((Component)this.getReceiveButton(), null);
            this.buttonPanel.add((Component)this.getNewFolderButton(), null);
            this.buttonPanel.add((Component)this.getCloseButton(), null);
            this.buttonPanel.add((Component)this.getDeleteButton(), null);
            this.buttonPanel.add((Component)this.getSendButton(), null);
            this.buttonPanel.add((Component)this.getStopButton(), null);
            this.buttonPanel.setBackground(Color.lightGray);
        }
        return this.buttonPanel;
    }

    private JButton getSendButton() {
        if (this.sendButton == null) {
            this.sendButton = new JButton();
            this.sendButton.setBounds(20, 30, 97, 25);
            this.sendButton.setText("Send >>");
            this.sendButton.setName("sendButton");
            this.sendButton.addActionListener(this);
        }
        return this.sendButton;
    }

    private JButton getReceiveButton() {
        if (this.receiveButton == null) {
            this.receiveButton = new JButton();
            this.receiveButton.setBounds(20, 60, 97, 25);
            this.receiveButton.setText("<< Receive");
            this.receiveButton.setName("receiveButton");
            this.receiveButton.addActionListener(this);
        }
        return this.receiveButton;
    }

    private JButton getDeleteButton() {
        if (this.deleteButton == null) {
            this.deleteButton = new JButton();
            this.deleteButton.setBounds(20, 110, 97, 25);
            this.deleteButton.setText("Delete File");
            this.deleteButton.setName("deleteButton");
            this.deleteButton.addActionListener(this);
        }
        return this.deleteButton;
    }

    private JButton getNewFolderButton() {
        if (this.newFolderButton == null) {
            this.newFolderButton = new JButton();
            this.newFolderButton.setBounds(20, 140, 97, 25);
            this.newFolderButton.setText("New Folder");
            this.newFolderButton.setName("newFolderButton");
            this.newFolderButton.addActionListener(this);
        }
        return this.newFolderButton;
    }

    private JButton getStopButton() {
        if (this.stopButton == null) {
            this.stopButton = new JButton();
            this.stopButton.setBounds(20, 200, 97, 25);
            this.stopButton.setText("Stop");
            this.stopButton.setName("stopButton");
            this.stopButton.addActionListener(this);
            this.stopButton.setVisible(false);
        }
        return this.stopButton;
    }

    private JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new JButton();
            this.closeButton.setBounds(20, 325, 97, 25);
            this.closeButton.setText("Close");
            this.closeButton.setName("closeButton");
            this.closeButton.addActionListener(this);
        }
        return this.closeButton;
    }

    private JComboBox getLocalDrivesComboBox() {
        this.updateDriveList = true;
        File[] roots = File.listRoots();
        String[] localDisks = new String[roots.length];
        for (int i = 0; i < roots.length; ++i) {
            localDisks[i] = roots[i].toString();
        }
        if (this.localDrivesComboBox == null) {
            this.localDrivesComboBox = new JComboBox<String>(localDisks);
            this.localDrivesComboBox.setName("LocalDisks");
            this.localDrivesComboBox.setFont(new Font("Dialog", 0, 10));
            this.localDrivesComboBox.addActionListener(this);
        }
        this.updateDriveList = false;
        return this.localDrivesComboBox;
    }

    private JComboBox getRemoteDrivesComboBox() {
        if (this.remoteDrivesComboBox == null) {
            this.remoteDrivesComboBox = new JComboBox();
            this.remoteDrivesComboBox.setName("remoteDisks");
            this.remoteDrivesComboBox.setFont(new Font("Dialog", 0, 10));
            this.remoteDrivesComboBox.addActionListener(this);
        }
        return this.remoteDrivesComboBox;
    }

    private JTextField getLocalMachineLabel() {
        if (this.localMachineLabel == null) {
            this.localMachineLabel = new JTextField();
            this.localMachineLabel.setAlignmentX(0.5f);
            this.localMachineLabel.setBackground(Color.lightGray);
            this.localMachineLabel.setText("             LOCAL MACHINE");
            this.localMachineLabel.setName("localLocation");
            this.localMachineLabel.setFont(new Font("Dialog", 1, 11));
            this.localMachineLabel.setEditable(false);
        }
        return this.localMachineLabel;
    }

    private JTextField getRemoteMachineLabel() {
        if (this.remoteMachineLabel == null) {
            this.remoteMachineLabel = new JTextField();
            this.remoteMachineLabel.setName("remoteLocation");
            this.remoteMachineLabel.setText("        REMOTE MACHINE");
            this.remoteMachineLabel.setBackground(Color.lightGray);
            this.remoteMachineLabel.setFont(new Font("Dialog", 1, 11));
            this.remoteMachineLabel.setEditable(false);
        }
        return this.remoteMachineLabel;
    }

    private JButton getLocalTopButton() {
        if (this.localTopButton == null) {
            this.localTopButton = new JButton();
            this.localTopButton.setText("Root (\\)");
            this.localTopButton.setFont(new Font("Dialog", 1, 10));
            this.localTopButton.addActionListener(this);
        }
        return this.localTopButton;
    }

    private JButton getRemoteTopButton() {
        if (this.remoteTopButton == null) {
            this.remoteTopButton = new JButton();
            this.remoteTopButton.setText("Root (\\)");
            this.remoteTopButton.setFont(new Font("Dialog", 1, 10));
            this.remoteTopButton.addActionListener(this);
        }
        return this.remoteTopButton;
    }

    private JList getLocalFileTable() {
        if (this.localFileTable == null) {
            this.localList = new Vector(0);
            this.localFileTable = new JList(this.localList);
            this.localFileTable.addMouseListener(this);
            this.localFileTable.setSelectionMode(0);
        }
        return this.localFileTable;
    }

    private JScrollPane getLocalScrollPane() {
        if (this.localScrollPane == null) {
            this.localScrollPane = new JScrollPane();
            this.localScrollPane.setViewportView(this.getLocalFileTable());
            this.localScrollPane.setPreferredSize(new Dimension(325, 418));
            this.localScrollPane.setFont(new Font("Dialog", 0, 10));
            this.localScrollPane.setName("localFileList");
        }
        return this.localScrollPane;
    }

    private JList getRemoteFileTable() {
        if (this.remoteFileTable == null) {
            this.remoteList = new Vector(0);
            this.remoteFileTable = new JList(this.remoteList);
            this.remoteFileTable.addMouseListener(this);
            this.remoteFileTable.setSelectedValue("C:\\", false);
            this.remoteFileTable.setSelectionMode(0);
        }
        return this.remoteFileTable;
    }

    private JScrollPane getRemoteScrollPane() {
        if (this.remoteScrollPane == null) {
            this.remoteScrollPane = new JScrollPane();
            this.remoteScrollPane.setViewportView(this.getRemoteFileTable());
            this.remoteScrollPane.setPreferredSize(new Dimension(325, 418));
        }
        return this.remoteScrollPane;
    }

    private JTextField getRemoteLocation() {
        if (this.remoteLocation == null) {
            this.remoteLocation = new JTextField();
            this.remoteLocation.setText("");
            this.remoteLocation.setEditable(false);
            this.remoteLocation.setBackground(new Color(255, 255, 238));
            this.remoteLocation.setFont(new Font("Dialog", 0, 10));
        }
        return this.remoteLocation;
    }

    private JTextField getLocalLocation() {
        if (this.localLocation == null) {
            this.localLocation = new JTextField();
            this.localLocation.setText("");
            this.localLocation.setEditable(false);
            this.localLocation.setBackground(new Color(255, 255, 238));
            this.localLocation.setFont(new Font("Dialog", 0, 10));
        }
        return this.localLocation;
    }

    private JTextField getLocalStatus() {
        if (this.localStatus == null) {
            this.localStatus = new JTextField();
            this.localStatus.setBackground(Color.lightGray);
            this.localStatus.setFont(new Font("Dialog", 0, 10));
            this.localStatus.setEditable(false);
        }
        return this.localStatus;
    }

    private JTextField getRemoteStatus() {
        if (this.remoteStatus == null) {
            this.remoteStatus = new JTextField();
            this.remoteStatus.setBackground(Color.lightGray);
            this.remoteStatus.setFont(new Font("Dialog", 0, 10));
            this.remoteStatus.setEditable(false);
        }
        return this.remoteStatus;
    }

    private JComboBox getHistoryComboBox() {
        if (this.historyComboBox == null) {
            this.historyComboBox = new JComboBox();
            this.historyComboBox.setFont(new Font("Dialog", 1, 10));
            this.historyComboBox.insertItemAt(new String("Pulldown to view history ..."), 0);
            this.historyComboBox.setSelectedIndex(0);
            this.historyComboBox.addActionListener(this);
        }
        return this.historyComboBox;
    }

    private JProgressBar getJProgressBar() {
        if (this.jProgressBar == null) {
            this.jProgressBar = new JProgressBar();
        }
        return this.jProgressBar;
    }

    private JTextField getConnectionStatus() {
        if (this.connectionStatus == null) {
            this.connectionStatus = new JTextField();
            this.connectionStatus.setText("Connected...");
            this.connectionStatus.setBackground(Color.lightGray);
            this.connectionStatus.setFont(new Font("Dialog", 0, 10));
        }
        this.connectionStatus.setEditable(false);
        return this.connectionStatus;
    }

    private class StrComp
    implements Comparator {
        private StrComp() {
        }

        public int compare(Object obj1, Object obj2) {
            String str1 = obj1.toString().toUpperCase();
            String str2 = obj2.toString().toUpperCase();
            return str1.compareTo(str2);
        }
    }
}

