/*
 * Decompiled with CFR 0.152.
 */
package JavaViewer;

import JavaViewer.SessionRecorder;
import JavaViewer.VncViewer;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

class RfbProto {
    private static final boolean DEBUG = false;
    final String versionMsg = "RFB 003.003\n";
    static final int ConnFailed = 0;
    static final int NoAuth = 1;
    static final int VncAuth = 2;
    static final int MsLogon = -6;
    static final int VncAuthOK = 0;
    static final int VncAuthFailed = 1;
    static final int VncAuthTooMany = 2;
    static final int FramebufferUpdate = 0;
    static final int SetColourMapEntries = 1;
    static final int Bell = 2;
    static final int ServerCutText = 3;
    static final int rfbFileTransfer = 7;
    final int SetPixelFormat = 0;
    final int FixColourMapEntries = 1;
    final int SetEncodings = 2;
    final int FramebufferUpdateRequest = 3;
    final int KeyboardEvent = 4;
    final int PointerEvent = 5;
    final int ClientCutText = 6;
    static final int EncodingRaw = 0;
    static final int EncodingCopyRect = 1;
    static final int EncodingRRE = 2;
    static final int EncodingCoRRE = 4;
    static final int EncodingHextile = 5;
    static final int EncodingZlib = 6;
    static final int EncodingTight = 7;
    static final int EncodingCompressLevel0 = -256;
    static final int EncodingQualityLevel0 = -32;
    static final int EncodingXCursor = -240;
    static final int EncodingRichCursor = -239;
    static final int EncodingPointerPos = -232;
    static final int EncodingLastRect = -224;
    static final int EncodingNewFBSize = -223;
    final int HextileRaw = 1;
    final int HextileBackgroundSpecified = 2;
    final int HextileForegroundSpecified = 4;
    final int HextileAnySubrects = 8;
    final int HextileSubrectsColoured = 16;
    static final int TightExplicitFilter = 4;
    static final int TightFill = 8;
    static final int TightJpeg = 9;
    static final int TightMaxSubencoding = 9;
    static final int TightFilterCopy = 0;
    static final int TightFilterPalette = 1;
    static final int TightFilterGradient = 2;
    static final int TightMinToCompress = 12;
    ArrayList remoteDirsList;
    ArrayList remoteFilesList;
    ArrayList a;
    boolean fFTInit = true;
    boolean fFTAllowed = true;
    boolean fAbort = false;
    boolean fFileReceptionError = false;
    boolean fFileReceptionRunning = false;
    boolean inDirectory2;
    FileOutputStream fos;
    FileInputStream fis;
    String sendFileSource;
    String receivePath;
    long fileSize;
    long receiveFileSize;
    long fileChunkCounter;
    static final int sz_rfbFileTransferMsg = 12;
    static final int rfbDirContentRequest = 1;
    static final int rfbDirPacket = 2;
    static final int rfbFileTransferRequest = 3;
    static final int rfbFileHeader = 4;
    static final int rfbFilePacket = 5;
    static final int rfbEndOfFile = 6;
    static final int rfbAbortFileTransfer = 7;
    static final int rfbFileTransferOffer = 8;
    static final int rfbFileAcceptHeader = 9;
    static final int rfbCommand = 10;
    static final int rfbCommandReturn = 11;
    static final int rfbFileChecksums = 12;
    static final int rfbRDirContent = 1;
    static final int rfbRDrivesList = 2;
    static final int rfbADirectory = 1;
    static final int rfbAFile = 2;
    static final int rfbADrivesList = 3;
    static final int rfbADirCreate = 4;
    static final int rfbADirDelete = 5;
    static final int rfbAFileCreate = 6;
    static final int rfbAFileDelete = 7;
    static final int rfbCDirCreate = 1;
    static final int rfbCDirDelete = 2;
    static final int rfbCFileCreate = 3;
    static final int rfbCFileDelete = 4;
    static final int rfbRErrorUnknownCmd = 1;
    static final int rfbRErrorCmd = -1;
    static final int sz_rfbBlockSize = 8192;
    static final int sz_rfbZipDirectoryPrefix = 9;
    String rfbZipDirectoryPrefix = "!UVNCDIR-\u0000";
    String host;
    int port;
    Socket sock;
    DataInputStream is;
    OutputStream os;
    OutputStreamWriter osw;
    SessionRecorder rec;
    boolean inNormalProtocol = false;
    VncViewer viewer;
    boolean brokenKeyPressed = false;
    boolean wereZlibUpdates = false;
    boolean recordFromBeginning = true;
    boolean zlibWarningShown;
    boolean tightWarningShown;
    int numUpdatesInSession;
    int serverMajor;
    int serverMinor;
    String desktopName;
    int framebufferWidth;
    int framebufferHeight;
    int bitsPerPixel;
    int depth;
    boolean bigEndian;
    boolean trueColour;
    int redMax;
    int greenMax;
    int blueMax;
    int redShift;
    int greenShift;
    int blueShift;
    int updateNRects;
    int updateRectX;
    int updateRectY;
    int updateRectW;
    int updateRectH;
    int updateRectEncoding;
    int copyRectSrcX;
    int copyRectSrcY;
    byte[] eventBuf = new byte[72];
    int eventBufLen;
    static final int CTRL_MASK = 2;
    static final int SHIFT_MASK = 1;
    static final int META_MASK = 4;
    static final int ALT_MASK = 8;
    int pointerMask = 0;
    int oldModifiers = 0;

    RfbProto(String h, int p, VncViewer v, String repeaterHost, int repeaterPort) throws IOException {
        this.viewer = v;
        this.host = h;
        this.port = p;
        if (repeaterHost != null) {
            this.sock = new Socket(repeaterHost, repeaterPort);
            this.doRepeater(this.sock, this.host, this.port);
        } else {
            this.sock = new Socket(this.host, this.port);
        }
        this.is = new DataInputStream(new BufferedInputStream(this.sock.getInputStream(), 16384));
        this.os = this.sock.getOutputStream();
        this.osw = new OutputStreamWriter(this.sock.getOutputStream());
        this.inDirectory2 = false;
        this.a = new ArrayList();
        this.remoteDirsList = new ArrayList();
        this.remoteFilesList = new ArrayList();
        this.sendFileSource = "";
    }

    private void doRepeater(Socket sock, String host, int port) throws IOException {
        String buf2 = "";
        sock.getOutputStream().write("".getBytes());
        DataInputStream is = new DataInputStream(sock.getInputStream());
        String line = is.readLine();
        String dest = host + ":" + port;
        byte[] buf = new byte[250];
        System.arraycopy(dest.getBytes("ISO-8859-1"), 0, buf, 0, dest.length());
        sock.getOutputStream().write(buf);
    }

    void close() {
        try {
            this.sock.close();
            if (this.rec != null) {
                this.rec.close();
                this.rec = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void readVersionMsg() throws Exception {
        byte[] b = new byte[12];
        this.is.readFully(b);
        if (b[0] != 82 || b[1] != 70 || b[2] != 66 || b[3] != 32 || b[4] < 48 || b[4] > 57 || b[5] < 48 || b[5] > 57 || b[6] < 48 || b[6] > 57 || b[7] != 46 || b[8] < 48 || b[8] > 57 || b[9] < 48 || b[9] > 57 || b[10] < 48 || b[10] > 57 || b[11] != 10) {
            throw new Exception("Host " + this.host + " port " + this.port + " is not an RFB server");
        }
        this.serverMajor = (b[4] - 48) * 100 + (b[5] - 48) * 10 + (b[6] - 48);
        this.serverMinor = (b[8] - 48) * 100 + (b[9] - 48) * 10 + (b[10] - 48);
    }

    void writeVersionMsg() throws IOException {
        this.os.write("RFB 003.003\n".getBytes());
    }

    int readAuthScheme() throws Exception {
        int authScheme = this.is.readInt();
        switch (authScheme) {
            case 0: {
                int reasonLen = this.is.readInt();
                byte[] reason = new byte[reasonLen];
                this.is.readFully(reason);
                throw new Exception(new String(reason));
            }
            case -6: 
            case 1: 
            case 2: {
                return authScheme;
            }
        }
        throw new Exception("Unknown authentication scheme from RFB server: " + authScheme);
    }

    void writeClientInit() throws IOException {
        if (this.viewer.options.shareDesktop) {
            this.os.write(1);
        } else {
            this.os.write(0);
        }
        this.viewer.options.disableShareDesktop();
    }

    void readServerInit() throws IOException {
        this.framebufferWidth = this.is.readUnsignedShort();
        this.framebufferHeight = this.is.readUnsignedShort();
        this.bitsPerPixel = this.is.readUnsignedByte();
        this.depth = this.is.readUnsignedByte();
        this.bigEndian = this.is.readUnsignedByte() != 0;
        this.trueColour = this.is.readUnsignedByte() != 0;
        this.redMax = this.is.readUnsignedShort();
        this.greenMax = this.is.readUnsignedShort();
        this.blueMax = this.is.readUnsignedShort();
        this.redShift = this.is.readUnsignedByte();
        this.greenShift = this.is.readUnsignedByte();
        this.blueShift = this.is.readUnsignedByte();
        byte[] pad = new byte[3];
        this.is.readFully(pad);
        int nameLength = this.is.readInt();
        byte[] name = new byte[nameLength];
        this.is.readFully(name);
        this.desktopName = new String(name);
        this.inNormalProtocol = true;
    }

    void startSession(String fname) throws IOException {
        this.rec = new SessionRecorder(fname);
        this.rec.writeHeader();
        this.rec.write("RFB 003.003\n".getBytes());
        this.rec.writeIntBE(1);
        this.rec.writeShortBE(this.framebufferWidth);
        this.rec.writeShortBE(this.framebufferHeight);
        byte[] fbsServerInitMsg = new byte[]{32, 24, 0, 1, 0, -1, 0, -1, 0, -1, 16, 8, 0, 0, 0, 0};
        this.rec.write(fbsServerInitMsg);
        this.rec.writeIntBE(this.desktopName.length());
        this.rec.write(this.desktopName.getBytes());
        this.numUpdatesInSession = 0;
        if (this.wereZlibUpdates) {
            this.recordFromBeginning = false;
        }
        this.zlibWarningShown = false;
        this.tightWarningShown = false;
    }

    void closeSession() throws IOException {
        if (this.rec != null) {
            this.rec.close();
            this.rec = null;
        }
    }

    void setFramebufferSize(int width, int height) {
        this.framebufferWidth = width;
        this.framebufferHeight = height;
    }

    int readServerMessageType() throws IOException {
        int msgType = this.is.readUnsignedByte();
        if (this.rec != null && msgType == 2) {
            this.rec.writeByte(msgType);
            if (this.numUpdatesInSession > 0) {
                this.rec.flush();
            }
        }
        return msgType;
    }

    void readFramebufferUpdate() throws IOException {
        this.is.readByte();
        this.updateNRects = this.is.readUnsignedShort();
        if (this.rec != null) {
            this.rec.writeByte(0);
            this.rec.writeByte(0);
            this.rec.writeShortBE(this.updateNRects);
        }
        ++this.numUpdatesInSession;
    }

    void readFramebufferUpdateRectHdr() throws Exception {
        this.updateRectX = this.is.readUnsignedShort();
        this.updateRectY = this.is.readUnsignedShort();
        this.updateRectW = this.is.readUnsignedShort();
        this.updateRectH = this.is.readUnsignedShort();
        this.updateRectEncoding = this.is.readInt();
        if (this.updateRectEncoding == 6 || this.updateRectEncoding == 7) {
            this.wereZlibUpdates = true;
        }
        if (this.rec != null) {
            if (this.numUpdatesInSession > 1) {
                this.rec.flush();
            }
            this.rec.writeShortBE(this.updateRectX);
            this.rec.writeShortBE(this.updateRectY);
            this.rec.writeShortBE(this.updateRectW);
            this.rec.writeShortBE(this.updateRectH);
            if (this.updateRectEncoding == 6 && !this.recordFromBeginning) {
                if (!this.zlibWarningShown) {
                    System.out.println("Warning: Raw encoding will be used instead of Zlib in recorded session.");
                    this.zlibWarningShown = true;
                }
                this.rec.writeIntBE(0);
            } else {
                this.rec.writeIntBE(this.updateRectEncoding);
                if (this.updateRectEncoding == 7 && !this.recordFromBeginning && !this.tightWarningShown) {
                    System.out.println("Warning: Re-compressing Tight-encoded updates for session recording.");
                    this.tightWarningShown = true;
                }
            }
        }
        if (this.updateRectEncoding == -224 || this.updateRectEncoding == -223) {
            return;
        }
        if (this.updateRectX + this.updateRectW > this.framebufferWidth || this.updateRectY + this.updateRectH > this.framebufferHeight) {
            throw new Exception("Framebuffer update rectangle too large: " + this.updateRectW + "x" + this.updateRectH + " at (" + this.updateRectX + "," + this.updateRectY + ")");
        }
    }

    void readCopyRect() throws IOException {
        this.copyRectSrcX = this.is.readUnsignedShort();
        this.copyRectSrcY = this.is.readUnsignedShort();
        if (this.rec != null) {
            this.rec.writeShortBE(this.copyRectSrcX);
            this.rec.writeShortBE(this.copyRectSrcY);
        }
    }

    String readServerCutText() throws IOException {
        byte[] pad = new byte[3];
        this.is.readFully(pad);
        int len = this.is.readInt();
        byte[] text = new byte[len];
        this.is.readFully(text);
        return new String(text);
    }

    int readCompactLen() throws IOException {
        int[] portion = new int[3];
        portion[0] = this.is.readUnsignedByte();
        int byteCount = 1;
        int len = portion[0] & 0x7F;
        if ((portion[0] & 0x80) != 0) {
            portion[1] = this.is.readUnsignedByte();
            ++byteCount;
            len |= (portion[1] & 0x7F) << 7;
            if ((portion[1] & 0x80) != 0) {
                portion[2] = this.is.readUnsignedByte();
                ++byteCount;
                len |= (portion[2] & 0xFF) << 14;
            }
        }
        if (this.rec != null && this.recordFromBeginning) {
            for (int i = 0; i < byteCount; ++i) {
                this.rec.writeByte(portion[i]);
            }
        }
        return len;
    }

    void readRfbFileTransferMsg() throws IOException {
        int contentParamT;
        int contentType = this.is.readUnsignedByte();
        int contentParam = contentParamT = this.is.readUnsignedByte();
        contentParamT = this.is.readUnsignedByte();
        contentParam |= (contentParamT <<= 8);
        if (contentType == 2 || contentType == 2) {
            this.readDriveOrDirectory(contentParam);
        } else if (contentType == 4) {
            this.receiveFileHeader();
        } else if (contentType == 5) {
            this.receiveFileChunk();
        } else if (contentType == 6) {
            this.endOfReceiveFile(true);
        } else if (contentType == 7) {
            if (this.fFileReceptionRunning) {
                this.endOfReceiveFile(false);
            }
        } else if (contentType == 11) {
            this.createDirectoryorDeleteFile(contentParam);
        } else if (contentType == 9) {
            this.sendFile();
        } else if (contentType == 12) {
            this.ReceiveDestinationFileChecksums();
        }
    }

    public void createDirectoryorDeleteFile(int contentParam) throws IOException {
        if (contentParam == 4) {
            this.createRemoteDirectoryFeedback();
        } else if (contentParam == 7) {
            this.deleteRemoteFileFeedback();
        }
    }

    public void readDriveOrDirectory(int contentParam) throws IOException {
        if (contentParam == 3) {
            this.readFTPMsgDriveList();
        } else if (contentParam == 1 && !this.inDirectory2) {
            this.inDirectory2 = true;
            this.readFTPMsgDirectoryList();
        } else if (contentParam == 1 && this.inDirectory2) {
            this.readFTPMsgDirectoryListContent();
        } else if (contentParam == 0) {
            this.readFTPMsgDirectoryListEndContent();
            this.inDirectory2 = false;
        }
    }

    void writeRfbFileTransferMsg(int contentType, int contentParam, long size, long length, String text) throws IOException {
        byte[] b = new byte[12];
        b[0] = 7;
        b[1] = (byte)contentType;
        b[2] = (byte)contentParam;
        byte by = 0;
        long c = 0L;
        ++length;
        c = size & 0xFFFFFFFFFF000000L;
        b[4] = by = (byte)(c >>> 24);
        c = size & 0xFF0000L;
        b[5] = by = (byte)(c >>> 16);
        c = size & 0xFF00L;
        b[6] = by = (byte)(c >>> 8);
        c = size & 0xFFL;
        b[7] = by = (byte)c;
        c = length & 0xFFFFFFFFFF000000L;
        b[8] = by = (byte)(c >>> 24);
        c = length & 0xFF0000L;
        b[9] = by = (byte)(c >>> 16);
        c = length & 0xFF00L;
        b[10] = by = (byte)(c >>> 8);
        c = length & 0xFFL;
        b[11] = by = (byte)c;
        this.os.write(b);
        if (text != null) {
            byte[] byteArray = text.getBytes();
            byte[] byteArray2 = new byte[byteArray.length + 1];
            for (int i = 0; i < byteArray.length; ++i) {
                byteArray2[i] = byteArray[i];
            }
            byteArray2[byteArray2.length - 1] = 0;
            this.os.write(byteArray2);
        }
    }

    int writeRfbFileTransferMsgForSendFile(int contentType, int contentParam, long size, long length, String source) throws IOException {
        File f = new File(source);
        this.fis = new FileInputStream(f);
        byte[] byteBuffer = new byte[8192];
        int bytesRead = this.fis.read(byteBuffer);
        long counter = 0L;
        boolean fError = false;
        boolean fCompress = true;
        Deflater myDeflater = new Deflater();
        byte[] CompressionBuffer = new byte[9216];
        int compressedSize = 0;
        while (bytesRead != -1) {
            counter += (long)bytesRead;
            myDeflater.setInput(byteBuffer, 0, bytesRead);
            myDeflater.finish();
            compressedSize = myDeflater.deflate(CompressionBuffer);
            myDeflater.reset();
            if (compressedSize > bytesRead) {
                fCompress = false;
            }
            this.writeRfbFileTransferMsg(contentType, contentParam, fCompress ? 1 : 0, fCompress ? compressedSize - 1 : bytesRead - 1, null);
            this.os.write(fCompress ? CompressionBuffer : byteBuffer, 0, fCompress ? compressedSize : bytesRead);
            bytesRead = this.fis.read(byteBuffer);
            this.viewer.ftp.jProgressBar.setValue((int)(counter * 100L / f.length()));
            this.viewer.ftp.connectionStatus.setText(">>> Sending File: " + source + " - Size: " + f.length() + " bytes - Progress: " + counter * 100L / f.length() + "%");
            if (this.fAbort) {
                this.fAbort = false;
                fError = true;
                break;
            }
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                System.err.println("Interrupted");
            }
        }
        this.writeRfbFileTransferMsg(fError ? 7 : 6, 0, 0L, 0L, null);
        this.fis.close();
        return fError ? -1 : 1;
    }

    void sendFile() {
        try {
            this.viewer.ftp.disableButtons();
            int size = this.is.readInt();
            int length = this.is.readInt();
            for (int i = 0; i < length; ++i) {
                System.out.print((char)this.is.readUnsignedByte());
            }
            int ret = this.writeRfbFileTransferMsgForSendFile(5, 0, 0L, 0L, this.sendFileSource);
            this.viewer.ftp.refreshRemoteLocation();
            if (ret != 1) {
                this.viewer.ftp.connectionStatus.setText(" > Error - File NOT sent");
                this.viewer.ftp.historyComboBox.insertItemAt(new String(" > Error - File: <" + this.sendFileSource) + "> was not correctly sent (aborted by user or error)", 0);
            } else {
                this.viewer.ftp.connectionStatus.setText(" > File sent");
                this.viewer.ftp.historyComboBox.insertItemAt(new String(" > File: <" + this.sendFileSource) + "> was sent to Remote Machine", 0);
            }
            this.viewer.ftp.historyComboBox.setSelectedIndex(0);
            this.viewer.ftp.enableButtons();
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    void offerLocalFile(String source, String destinationPath) {
        try {
            this.sendFileSource = source;
            File f = new File(source);
            long lSize = f.length();
            int iLowSize = (int)(lSize & 0xFFFFFFFFFFFFFFFFL);
            int iHighSize = (int)(lSize >> 32);
            String temp = destinationPath + f.getName();
            this.writeRfbFileTransferMsg(8, 0, iLowSize, temp.length(), temp);
            byte[] b = new byte[4];
            byte by = 0;
            long c = 0L;
            c = iHighSize & 0xFF000000;
            b[0] = by = (byte)(c >>> 24);
            c = iHighSize & 0xFF0000;
            b[1] = by = (byte)(c >>> 16);
            c = iHighSize & 0xFF00;
            b[2] = by = (byte)(c >>> 8);
            c = iHighSize & 0xFF;
            b[3] = by = (byte)c;
            this.os.write(b);
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    void deleteRemoteFileFeedback() throws IOException {
        this.is.readInt();
        int length = this.is.readInt();
        String f = "";
        for (int i = 0; i < length; ++i) {
            f = f + (char)this.is.readUnsignedByte();
        }
        this.viewer.ftp.refreshRemoteLocation();
        this.viewer.ftp.historyComboBox.insertItemAt(new String(" > Deleted File On Remote Machine: " + f.substring(0, f.length() - 1)), 0);
        this.viewer.ftp.historyComboBox.setSelectedIndex(0);
        this.viewer.ftp.setEnabled(false);
        this.viewer.ftp.repaint();
        this.viewer.ftp.setEnabled(true);
    }

    void deleteRemoteFile(String text) {
        try {
            String temp = text;
            this.writeRfbFileTransferMsg(10, 4, 0L, temp.length(), temp);
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    void createRemoteDirectoryFeedback() throws IOException {
        this.is.readInt();
        int length = this.is.readInt();
        String f = "";
        for (int i = 0; i < length; ++i) {
            f = f + (char)this.is.readUnsignedByte();
        }
        this.viewer.ftp.refreshRemoteLocation();
        this.viewer.ftp.historyComboBox.insertItemAt(new String(" > Created Directory on Remote Machine: " + f.substring(0, f.length() - 1)), 0);
        this.viewer.ftp.historyComboBox.setSelectedIndex(0);
    }

    void createRemoteDirectory(String text) {
        try {
            String temp = text;
            this.writeRfbFileTransferMsg(10, 1, 0L, temp.length(), temp);
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    void requestRemoteFile(String text, String localPath) {
        try {
            String temp = text;
            this.receivePath = localPath;
            this.writeRfbFileTransferMsg(3, 0, 1L, temp.length(), temp);
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    void receiveFileHeader() throws IOException {
        long lSize;
        this.fFileReceptionRunning = true;
        this.fFileReceptionError = false;
        this.viewer.ftp.disableButtons();
        int size = this.is.readInt();
        int length = this.is.readInt();
        String tempName = "";
        for (int i = 0; i < length; ++i) {
            tempName = tempName + (char)this.is.readUnsignedByte();
        }
        int sizeH = this.is.readInt();
        this.receiveFileSize = lSize = ((long)sizeH << 32) + (long)size;
        this.viewer.ftp.connectionStatus.setText("Received: 0 bytes of " + lSize + " bytes");
        this.fileSize = 0L;
        this.fileChunkCounter = 0L;
        String fileName = this.receivePath;
        this.fos = new FileOutputStream(fileName);
        this.writeRfbFileTransferMsg(4, 0, 0L, 0L, null);
    }

    void receiveFileChunk() throws IOException {
        int size = this.is.readInt();
        boolean fCompressed = size != 0;
        int length = this.is.readInt();
        ++this.fileChunkCounter;
        byte[] ReceptionBuffer = new byte[length + 32];
        this.is.readFully(ReceptionBuffer, 0, length);
        if (fCompressed) {
            int bufSize = 9216;
            int decompressedSize = 0;
            byte[] DecompressionBuffer = new byte[bufSize];
            Inflater myInflater = new Inflater();
            myInflater.setInput(ReceptionBuffer);
            try {
                decompressedSize = myInflater.inflate(DecompressionBuffer);
            }
            catch (DataFormatException e) {
                System.err.println(e);
            }
            this.fos.write(DecompressionBuffer, 0, decompressedSize);
            this.fileSize += (long)decompressedSize;
        } else {
            this.fos.write(ReceptionBuffer, 0, length);
            this.fileSize += (long)length;
        }
        this.viewer.ftp.jProgressBar.setValue((int)(this.fileSize * 100L / this.receiveFileSize));
        this.viewer.ftp.connectionStatus.setText(">>> Receiving File: " + this.receivePath + " - Size: " + this.receiveFileSize + " bytes - Progress: " + this.fileSize * 100L / this.receiveFileSize + "%");
        if (this.fAbort) {
            this.fAbort = false;
            this.fFileReceptionError = true;
            this.writeRfbFileTransferMsg(7, 0, 0L, 0L, null);
        }
    }

    void endOfReceiveFile(boolean fReceptionOk) throws IOException {
        int size = this.is.readInt();
        int length = this.is.readInt();
        this.fileSize = 0L;
        this.fos.close();
        this.viewer.ftp.refreshLocalLocation();
        if (fReceptionOk && !this.fFileReceptionError) {
            this.viewer.ftp.connectionStatus.setText(" > File successfully received");
            this.viewer.ftp.historyComboBox.insertItemAt(new String(" > File: <" + this.receivePath + "> received from Remote Machine"), 0);
        } else {
            File f = new File(this.receivePath);
            f.delete();
            this.viewer.ftp.connectionStatus.setText(" > Error - File NOT received");
            this.viewer.ftp.historyComboBox.insertItemAt(new String(" > Error - File: <" + this.receivePath + "> not correctly received from Remote Machine (aborted by user or error)"), 0);
        }
        this.fFileReceptionError = false;
        this.fFileReceptionRunning = false;
        this.viewer.ftp.historyComboBox.setSelectedIndex(0);
        this.viewer.ftp.enableButtons();
    }

    void readServerDirectory(String text) {
        try {
            String temp = text;
            this.writeRfbFileTransferMsg(1, 1, 0L, temp.length(), temp);
        }
        catch (IOException e) {
            System.out.println("IOException in readServerDirectory(String text) in RfbProto!");
            System.out.println(e);
            System.out.println("End of exception");
        }
    }

    void readFTPMsgDriveList() throws IOException {
        String str = "";
        for (int i = 0; i < 4; ++i) {
            this.is.readUnsignedByte();
        }
        int length = this.is.readInt();
        for (int i = 0; i < length; ++i) {
            char temp = (char)this.is.readUnsignedByte();
            if (temp == '\u0000') continue;
            str = str + temp;
        }
        this.viewer.ftp.printDrives(str);
        this.viewer.ftp.changeLocalDirectory(this.viewer.ftp.getFirstReadableLocalDrive());
        this.viewer.ftp.changeRemoteDrive();
        this.viewer.ftp.refreshRemoteLocation();
    }

    void readFTPMsgDirectoryList() throws IOException {
        this.is.readInt();
        int length = this.is.readInt();
        if (length == 0) {
            this.readFTPMsgDirectorydriveNotReady();
            this.inDirectory2 = false;
        } else {
            String str = "";
            for (int i = 0; i < length; ++i) {
                char temp = (char)this.is.readUnsignedByte();
                if (temp == '\u0000') continue;
                str = str + temp;
            }
        }
    }

    void readFTPMsgDirectoryListContent() throws IOException {
        String fileName = "";
        String alternateFileName = "";
        boolean contentType = false;
        boolean contentParamT = false;
        boolean contentParam = false;
        boolean temp = false;
        int length = 0;
        this.is.readInt();
        length = this.is.readInt();
        int dwFileAttributes = this.is.readInt();
        length -= 4;
        long ftCreationTime = this.is.readLong();
        length -= 8;
        long ftLastAccessTime = this.is.readLong();
        length -= 8;
        long ftLastWriteTime = this.is.readLong();
        length -= 8;
        int nFileSizeHigh = this.is.readInt();
        length -= 4;
        int nFileSizeLow = this.is.readInt();
        length -= 4;
        int dwReserved0 = this.is.readInt();
        length -= 4;
        int dwReserved1 = this.is.readInt();
        length -= 4;
        char cFileName = (char)this.is.readUnsignedByte();
        --length;
        while (cFileName != '\u0000') {
            fileName = fileName + cFileName;
            cFileName = (char)this.is.readUnsignedByte();
            --length;
        }
        char cAlternateFileName = (char)this.is.readByte();
        --length;
        while (length != 0) {
            alternateFileName = alternateFileName + cAlternateFileName;
            cAlternateFileName = (char)this.is.readUnsignedByte();
            --length;
        }
        if ((dwFileAttributes & 0x10000000) == 0x10000000) {
            fileName = " [" + fileName + "]";
            this.remoteDirsList.add(fileName);
        } else {
            this.remoteFilesList.add(" " + fileName);
        }
    }

    void readFTPMsgDirectoryListEndContent() throws IOException {
        int i;
        this.is.readInt();
        int length = this.is.readInt();
        this.a.clear();
        for (i = 0; i < this.remoteDirsList.size(); ++i) {
            this.a.add(this.remoteDirsList.get(i));
        }
        for (i = 0; i < this.remoteFilesList.size(); ++i) {
            this.a.add(this.remoteFilesList.get(i));
        }
        this.remoteDirsList.clear();
        this.remoteFilesList.clear();
        this.viewer.ftp.printRemoteDirectory(this.a);
    }

    void readFTPMsgDirectorydriveNotReady() throws IOException {
        System.out.println("Remote Drive unavailable");
        this.viewer.ftp.connectionStatus.setText(" > WARNING - Remote Drive unavailable (possibly restricted access or media not present)");
        this.viewer.ftp.remoteStatus.setText("WARNING: Remote Drive unavailable");
    }

    void readServerDriveList() {
        try {
            this.viewer.rfb.writeRfbFileTransferMsg(1, 2, 0L, 0L, null);
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    void ReceiveDestinationFileChecksums() throws IOException {
        int size = this.is.readInt();
        int length = this.is.readInt();
        byte[] ReceptionBuffer = new byte[length + 32];
        this.is.readFully(ReceptionBuffer, 0, length);
    }

    void writeFramebufferUpdateRequest(int x, int y, int w, int h, boolean incremental) throws IOException {
        if (!this.viewer.ftp.isVisible()) {
            byte[] b = new byte[]{3, (byte)(incremental ? 1 : 0), (byte)(x >> 8 & 0xFF), (byte)(x & 0xFF), (byte)(y >> 8 & 0xFF), (byte)(y & 0xFF), (byte)(w >> 8 & 0xFF), (byte)(w & 0xFF), (byte)(h >> 8 & 0xFF), (byte)(h & 0xFF)};
            this.os.write(b);
        }
    }

    void writeSetPixelFormat(int bitsPerPixel, int depth, boolean bigEndian, boolean trueColour, int redMax, int greenMax, int blueMax, int redShift, int greenShift, int blueShift, boolean fGreyScale) throws IOException {
        byte[] b = new byte[20];
        b[0] = 0;
        b[4] = (byte)bitsPerPixel;
        b[5] = (byte)depth;
        b[6] = (byte)(bigEndian ? 1 : 0);
        b[7] = (byte)(trueColour ? 1 : 0);
        b[8] = (byte)(redMax >> 8 & 0xFF);
        b[9] = (byte)(redMax & 0xFF);
        b[10] = (byte)(greenMax >> 8 & 0xFF);
        b[11] = (byte)(greenMax & 0xFF);
        b[12] = (byte)(blueMax >> 8 & 0xFF);
        b[13] = (byte)(blueMax & 0xFF);
        b[14] = (byte)redShift;
        b[15] = (byte)greenShift;
        b[16] = (byte)blueShift;
        b[17] = (byte)(fGreyScale ? 1 : 0);
        this.os.write(b);
    }

    void writeFixColourMapEntries(int firstColour, int nColours, int[] red, int[] green, int[] blue) throws IOException {
        byte[] b = new byte[6 + nColours * 6];
        b[0] = 1;
        b[2] = (byte)(firstColour >> 8 & 0xFF);
        b[3] = (byte)(firstColour & 0xFF);
        b[4] = (byte)(nColours >> 8 & 0xFF);
        b[5] = (byte)(nColours & 0xFF);
        for (int i = 0; i < nColours; ++i) {
            b[6 + i * 6] = (byte)(red[i] >> 8 & 0xFF);
            b[6 + i * 6 + 1] = (byte)(red[i] & 0xFF);
            b[6 + i * 6 + 2] = (byte)(green[i] >> 8 & 0xFF);
            b[6 + i * 6 + 3] = (byte)(green[i] & 0xFF);
            b[6 + i * 6 + 4] = (byte)(blue[i] >> 8 & 0xFF);
            b[6 + i * 6 + 5] = (byte)(blue[i] & 0xFF);
        }
        this.os.write(b);
    }

    void writeSetEncodings(int[] encs, int len) throws IOException {
        byte[] b = new byte[4 + 4 * len];
        b[0] = 2;
        b[2] = (byte)(len >> 8 & 0xFF);
        b[3] = (byte)(len & 0xFF);
        for (int i = 0; i < len; ++i) {
            b[4 + 4 * i] = (byte)(encs[i] >> 24 & 0xFF);
            b[5 + 4 * i] = (byte)(encs[i] >> 16 & 0xFF);
            b[6 + 4 * i] = (byte)(encs[i] >> 8 & 0xFF);
            b[7 + 4 * i] = (byte)(encs[i] & 0xFF);
        }
        this.os.write(b);
    }

    void writeClientCutText(String text) throws IOException {
        byte[] b = new byte[8 + text.length()];
        b[0] = 6;
        b[4] = (byte)(text.length() >> 24 & 0xFF);
        b[5] = (byte)(text.length() >> 16 & 0xFF);
        b[6] = (byte)(text.length() >> 8 & 0xFF);
        b[7] = (byte)(text.length() & 0xFF);
        System.arraycopy(text.getBytes(), 0, b, 8, text.length());
        this.os.write(b);
    }

    void writePointerEvent(MouseEvent evt) throws IOException {
        if (!this.viewer.ftp.isVisible()) {
            int modifiers = evt.getModifiers();
            int mask2 = 2;
            int mask3 = 4;
            if (this.viewer.options.reverseMouseButtons2And3) {
                mask2 = 4;
                mask3 = 2;
            }
            if (evt.getID() == 501) {
                if ((modifiers & 8) != 0) {
                    this.pointerMask = mask2;
                    modifiers &= 0xFFFFFFF7;
                } else if ((modifiers & 4) != 0) {
                    this.pointerMask = mask3;
                    modifiers &= 0xFFFFFFFB;
                } else {
                    this.pointerMask = 1;
                }
            } else if (evt.getID() == 502) {
                this.pointerMask = 0;
                if ((modifiers & 8) != 0) {
                    modifiers &= 0xFFFFFFF7;
                } else if ((modifiers & 4) != 0) {
                    modifiers &= 0xFFFFFFFB;
                }
            }
            this.eventBufLen = 0;
            this.writeModifierKeyEvents(modifiers);
            int x = evt.getX();
            int y = evt.getY();
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            this.eventBuf[this.eventBufLen++] = 5;
            this.eventBuf[this.eventBufLen++] = (byte)this.pointerMask;
            this.eventBuf[this.eventBufLen++] = (byte)(x >> 8 & 0xFF);
            this.eventBuf[this.eventBufLen++] = (byte)(x & 0xFF);
            this.eventBuf[this.eventBufLen++] = (byte)(y >> 8 & 0xFF);
            this.eventBuf[this.eventBufLen++] = (byte)(y & 0xFF);
            if (this.pointerMask == 0) {
                this.writeModifierKeyEvents(0);
            }
            this.os.write(this.eventBuf, 0, this.eventBufLen);
        }
    }

    void writeKeyEvent(KeyEvent evt) throws IOException {
        block43: {
            int key;
            boolean down;
            block45: {
                int keyChar;
                block44: {
                    int code;
                    if (this.viewer.ftp.isVisible()) break block43;
                    keyChar = evt.getKeyChar();
                    if (keyChar == 0) {
                        keyChar = 65535;
                    }
                    if (keyChar == 65535 && ((code = evt.getKeyCode()) == 17 || code == 16 || code == 157 || code == 18)) {
                        return;
                    }
                    boolean bl = down = evt.getID() == 401;
                    if (!evt.isActionKey()) break block44;
                    switch (evt.getKeyCode()) {
                        case 36: {
                            key = 65360;
                            break block45;
                        }
                        case 37: {
                            key = 65361;
                            break block45;
                        }
                        case 38: {
                            key = 65362;
                            break block45;
                        }
                        case 39: {
                            key = 65363;
                            break block45;
                        }
                        case 40: {
                            key = 65364;
                            break block45;
                        }
                        case 33: {
                            key = 65365;
                            break block45;
                        }
                        case 34: {
                            key = 65366;
                            break block45;
                        }
                        case 35: {
                            key = 65367;
                            break block45;
                        }
                        case 155: {
                            key = 65379;
                            break block45;
                        }
                        case 112: {
                            key = 65470;
                            break block45;
                        }
                        case 113: {
                            key = 65471;
                            break block45;
                        }
                        case 114: {
                            key = 65472;
                            break block45;
                        }
                        case 115: {
                            key = 65473;
                            break block45;
                        }
                        case 116: {
                            key = 65474;
                            break block45;
                        }
                        case 117: {
                            key = 65475;
                            break block45;
                        }
                        case 118: {
                            key = 65476;
                            break block45;
                        }
                        case 119: {
                            key = 65477;
                            break block45;
                        }
                        case 120: {
                            key = 65478;
                            break block45;
                        }
                        case 121: {
                            key = 65479;
                            break block45;
                        }
                        case 122: {
                            key = 65480;
                            break block45;
                        }
                        case 123: {
                            key = 65481;
                            break block45;
                        }
                        default: {
                            return;
                        }
                    }
                }
                key = keyChar;
                if (key < 32) {
                    if (evt.isControlDown()) {
                        key += 96;
                    } else {
                        switch (key) {
                            case 8: {
                                key = 65288;
                                break;
                            }
                            case 9: {
                                key = 65289;
                                break;
                            }
                            case 10: {
                                key = 65293;
                                break;
                            }
                            case 27: {
                                key = 65307;
                            }
                        }
                    }
                } else if (key == 127) {
                    key = 65535;
                } else if (key > 255 && (key < 65280 || key > 65535)) {
                    return;
                }
            }
            if (key == 229 || key == 197 || key == 228 || key == 196 || key == 246 || key == 214 || key == 167 || key == 189 || key == 163) {
                if (down) {
                    this.brokenKeyPressed = true;
                }
                if (!down && !this.brokenKeyPressed) {
                    this.eventBufLen = 0;
                    this.writeModifierKeyEvents(evt.getModifiers());
                    this.writeKeyEvent(key, true);
                    this.os.write(this.eventBuf, 0, this.eventBufLen);
                }
                if (!down) {
                    this.brokenKeyPressed = false;
                }
            }
            this.eventBufLen = 0;
            this.writeModifierKeyEvents(evt.getModifiers());
            this.writeKeyEvent(key, down);
            if (!down) {
                this.writeModifierKeyEvents(0);
            }
            this.os.write(this.eventBuf, 0, this.eventBufLen);
        }
    }

    void writeKeyEvent(int keysym, boolean down) {
        this.eventBuf[this.eventBufLen++] = 4;
        this.eventBuf[this.eventBufLen++] = (byte)(down ? 1 : 0);
        this.eventBuf[this.eventBufLen++] = 0;
        this.eventBuf[this.eventBufLen++] = 0;
        this.eventBuf[this.eventBufLen++] = (byte)(keysym >> 24 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(keysym >> 16 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(keysym >> 8 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(keysym & 0xFF);
    }

    void writeModifierKeyEvents(int newModifiers) {
        if ((newModifiers & 2) != (this.oldModifiers & 2)) {
            this.writeKeyEvent(65507, (newModifiers & 2) != 0);
        }
        if ((newModifiers & 1) != (this.oldModifiers & 1)) {
            this.writeKeyEvent(65505, (newModifiers & 1) != 0);
        }
        if ((newModifiers & 4) != (this.oldModifiers & 4)) {
            this.writeKeyEvent(65511, (newModifiers & 4) != 0);
        }
        if ((newModifiers & 8) != (this.oldModifiers & 8)) {
            this.writeKeyEvent(65513, (newModifiers & 8) != 0);
        }
        this.oldModifiers = newModifiers;
    }

    void recordCompressedData(byte[] data, int off, int len) throws IOException {
        Deflater deflater = new Deflater();
        deflater.setInput(data, off, len);
        int bufSize = len + len / 100 + 12;
        byte[] buf = new byte[bufSize];
        deflater.finish();
        int compressedSize = deflater.deflate(buf);
        this.recordCompactLen(compressedSize);
        this.rec.write(buf, 0, compressedSize);
    }

    void recordCompressedData(byte[] data) throws IOException {
        this.recordCompressedData(data, 0, data.length);
    }

    void recordCompactLen(int len) throws IOException {
        byte[] buf = new byte[3];
        int bytes = 0;
        buf[bytes++] = (byte)(len & 0x7F);
        if (len > 127) {
            int n = bytes - 1;
            buf[n] = (byte)(buf[n] | 0x80);
            buf[bytes++] = (byte)(len >> 7 & 0x7F);
            if (len > 16383) {
                int n2 = bytes - 1;
                buf[n2] = (byte)(buf[n2] | 0x80);
                buf[bytes++] = (byte)(len >> 14 & 0xFF);
            }
        }
        this.rec.write(buf, 0, bytes);
    }
}

