/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.graphlayout.graphelements;

import com.touchgraph.graphlayout.Edge;
import com.touchgraph.graphlayout.Node;
import com.touchgraph.graphlayout.TGException;
import com.touchgraph.graphlayout.graphelements.GraphEltSet;
import com.touchgraph.graphlayout.graphelements.Locality;
import com.touchgraph.graphlayout.graphelements.TGForEachEdge;
import com.touchgraph.graphlayout.graphelements.TGForEachNode;

public class VisibleLocality
extends Locality {
    public VisibleLocality(GraphEltSet ges) {
        super(ges);
    }

    @Override
    public synchronized void addNode(Node node) throws TGException {
        super.addNode(node);
        node.setVisible(true);
    }

    @Override
    public void addEdge(Edge edge) {
        if (!this.contains(edge)) {
            super.addEdge(edge);
            ++edge.from.visibleEdgeCnt;
            ++edge.to.visibleEdgeCnt;
        }
    }

    @Override
    public boolean removeEdge(Edge edge) {
        boolean removed = super.removeEdge(edge);
        if (removed) {
            edge.setVisible(false);
            --edge.from.visibleEdgeCnt;
            --edge.to.visibleEdgeCnt;
        }
        return removed;
    }

    @Override
    public boolean removeNode(Node node) {
        boolean removed = super.removeNode(node);
        if (removed) {
            node.setVisible(false);
        }
        return removed;
    }

    @Override
    public synchronized void removeAll() {
        int i;
        for (i = 0; i < this.nodeCount(); ++i) {
            this.nodeAt(i).setVisible(false);
        }
        for (i = 0; i < this.edgeCount(); ++i) {
            this.edgeAt(i).setVisible(false);
        }
        super.removeAll();
    }

    public void updateLocalityFromVisibility() throws TGException {
        TGForEachNode fen = new TGForEachNode(){

            @Override
            public void forEachNode(Node node) {
                try {
                    if (node.isVisible() && !VisibleLocality.this.contains(node)) {
                        VisibleLocality.this.addNode(node);
                    } else if (!node.isVisible() && VisibleLocality.this.contains(node)) {
                        VisibleLocality.this.removeNode(node);
                    }
                }
                catch (TGException ex) {
                    ex.printStackTrace();
                }
            }
        };
        this.completeEltSet.forAllNodes(fen);
        TGForEachEdge fee = new TGForEachEdge(){

            @Override
            public void forEachEdge(Edge edge) {
                if (edge.isVisible() && !VisibleLocality.this.contains(edge)) {
                    VisibleLocality.this.addEdge(edge);
                } else if (!edge.isVisible() && VisibleLocality.this.contains(edge)) {
                    VisibleLocality.this.removeEdge(edge);
                }
            }
        };
        this.completeEltSet.forAllEdges(fee);
    }
}

