/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.graphlayout.interaction;

import com.touchgraph.graphlayout.GraphListener;
import com.touchgraph.graphlayout.Node;
import com.touchgraph.graphlayout.TGAbstractLens;
import com.touchgraph.graphlayout.TGLensSet;
import com.touchgraph.graphlayout.TGPanel;
import com.touchgraph.graphlayout.TGPoint2D;
import com.touchgraph.graphlayout.interaction.TGAbstractClickUI;
import com.touchgraph.graphlayout.interaction.TGAbstractDragUI;
import java.awt.Point;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;

public class HVScroll
implements GraphListener {
    private DScrollbar horizontalSB;
    private DScrollbar verticalSB;
    HVLens hvLens;
    HVDragUI hvDragUI;
    HVScrollToCenterUI hvScrollToCenterUI;
    public boolean scrolling;
    private boolean adjustmentIsInternal;
    private TGPanel tgPanel;
    private TGLensSet tgLensSet;
    TGPoint2D offset;
    Thread noRepaintThread;
    Thread scrollThread;

    public HVScroll(TGPanel tgp, TGLensSet tgls) {
        this.tgPanel = tgp;
        this.tgLensSet = tgls;
        this.offset = new TGPoint2D(0.0, 0.0);
        this.scrolling = false;
        this.adjustmentIsInternal = false;
        this.horizontalSB = new DScrollbar(0, 0, 100, -1000, 1100);
        this.horizontalSB.setBlockIncrement(100);
        this.horizontalSB.setUnitIncrement(20);
        this.horizontalSB.addAdjustmentListener(new horizAdjustmentListener());
        this.verticalSB = new DScrollbar(1, 0, 100, -1000, 1100);
        this.verticalSB.setBlockIncrement(100);
        this.verticalSB.setUnitIncrement(20);
        this.verticalSB.addAdjustmentListener(new vertAdjustmentListener());
        this.hvLens = new HVLens();
        this.hvDragUI = new HVDragUI();
        this.hvScrollToCenterUI = new HVScrollToCenterUI();
        this.tgPanel.addGraphListener(this);
    }

    public Scrollbar getHorizontalSB() {
        return this.horizontalSB;
    }

    public Scrollbar getVerticalSB() {
        return this.verticalSB;
    }

    public HVDragUI getHVDragUI() {
        return this.hvDragUI;
    }

    public HVLens getLens() {
        return this.hvLens;
    }

    public TGAbstractClickUI getHVScrollToCenterUI() {
        return this.hvScrollToCenterUI;
    }

    public TGPoint2D getTopLeftDraw() {
        TGPoint2D tld = this.tgPanel.getTopLeftDraw();
        tld.setLocation(tld.x - (double)(this.tgPanel.getSize().width / 4), tld.y - (double)(this.tgPanel.getSize().height / 4));
        return tld;
    }

    public TGPoint2D getBottomRightDraw() {
        TGPoint2D brd = this.tgPanel.getBottomRightDraw();
        brd.setLocation(brd.x + (double)(this.tgPanel.getSize().width / 4), brd.y + (double)(this.tgPanel.getSize().height / 4));
        return brd;
    }

    public TGPoint2D getDrawCenter() {
        return new TGPoint2D(this.tgPanel.getSize().width / 2, this.tgPanel.getSize().height / 2);
    }

    @Override
    public void graphMoved() {
        if (this.tgPanel.getDragNode() == null && this.tgPanel.getSize().height > 0) {
            TGPoint2D drawCenter = this.getDrawCenter();
            TGPoint2D tld = this.getTopLeftDraw();
            TGPoint2D brd = this.getBottomRightDraw();
            double newH = -(tld.x - drawCenter.x) / (brd.x - tld.x) * 2000.0 - 1000.0;
            double newV = -(tld.y - drawCenter.y) / (brd.y - tld.y) * 2000.0 - 1000.0;
            boolean beyondBorder = true;
            if (newH < (double)this.horizontalSB.getMaximum() && newH > (double)this.horizontalSB.getMinimum() && newV < (double)this.verticalSB.getMaximum() && newV > (double)this.verticalSB.getMinimum()) {
                beyondBorder = false;
            }
            this.adjustmentIsInternal = true;
            this.horizontalSB.setDValue(newH);
            this.verticalSB.setDValue(newV);
            this.adjustmentIsInternal = false;
            if (beyondBorder) {
                this.adjustHOffset();
                this.adjustVOffset();
                this.tgPanel.repaint();
            }
        }
        if (this.noRepaintThread != null && this.noRepaintThread.isAlive()) {
            this.noRepaintThread.interrupt();
        }
        this.noRepaintThread = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.currentThread();
                    Thread.sleep(40L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        this.noRepaintThread.start();
    }

    @Override
    public void graphReset() {
        this.horizontalSB.setDValue(0.0);
        this.verticalSB.setDValue(0.0);
        this.adjustHOffset();
        this.adjustVOffset();
    }

    private void adjustHOffset() {
        for (int iterate = 0; iterate < 3; ++iterate) {
            TGPoint2D center = this.tgPanel.getCenter();
            TGPoint2D tld = this.getTopLeftDraw();
            TGPoint2D brd = this.getBottomRightDraw();
            double newx = (this.horizontalSB.getDValue() + 1000.0) / 2000.0 * (brd.x - tld.x) + tld.x;
            double newy = this.tgPanel.getSize().height / 2;
            TGPoint2D newCenter = this.tgLensSet.convDrawToReal(newx, newy);
            this.offset.setX(this.offset.x + (newCenter.x - center.x));
            this.offset.setY(this.offset.y + (newCenter.y - center.y));
            this.tgPanel.processGraphMove();
        }
    }

    private void adjustVOffset() {
        for (int iterate = 0; iterate < 10; ++iterate) {
            TGPoint2D center = this.tgPanel.getCenter();
            TGPoint2D tld = this.getTopLeftDraw();
            TGPoint2D brd = this.getBottomRightDraw();
            double newx = this.tgPanel.getSize().width / 2;
            double newy = (this.verticalSB.getDValue() + 1000.0) / 2000.0 * (brd.y - tld.y) + tld.y;
            TGPoint2D newCenter = this.tgLensSet.convDrawToReal(newx, newy);
            this.offset.setX(this.offset.x + (newCenter.x - center.x));
            this.offset.setY(this.offset.y + (newCenter.y - center.y));
            this.tgPanel.processGraphMove();
        }
    }

    public void setOffset(Point p) {
        this.offset.setLocation(p.x, p.y);
        this.tgPanel.processGraphMove();
        this.graphMoved();
    }

    public Point getOffset() {
        return new Point((int)this.offset.x, (int)this.offset.y);
    }

    public void scrollAtoB(TGPoint2D drawFrom, TGPoint2D drawTo) {
        TGPoint2D from = this.tgLensSet.convDrawToReal(drawFrom);
        TGPoint2D to = this.tgLensSet.convDrawToReal(drawTo);
        this.offset.setX(this.offset.x + (from.x - to.x));
        this.offset.setY(this.offset.y + (from.y - to.y));
    }

    public void slowScrollToCenter(final Node n) {
        TGPoint2D drawFrom = new TGPoint2D(n.drawx, n.drawy);
        TGPoint2D drawTo = this.getDrawCenter();
        this.scrolling = true;
        if (this.scrollThread != null && this.scrollThread.isAlive()) {
            this.scrollThread.interrupt();
        }
        this.scrollThread = new Thread(){

            @Override
            public void run() {
                double nx = -999.0;
                double ny = -999.0;
                boolean keepScrolling = true;
                boolean stopScrollingAttempt = false;
                int scrollSteps = 0;
                while (keepScrolling && scrollSteps++ < 250) {
                    double newy;
                    double newx;
                    nx = n.drawx;
                    double cx = HVScroll.this.getDrawCenter().x;
                    ny = n.drawy;
                    double cy = HVScroll.this.getDrawCenter().y;
                    double distFromCenter = Math.sqrt((nx - cx) * (nx - cx) + (ny - cy) * (ny - cy));
                    if (distFromCenter > 5.0) {
                        newx = cx + (nx - cx) * ((distFromCenter - 5.0) / distFromCenter);
                        newy = cy + (ny - cy) * ((distFromCenter - 5.0) / distFromCenter);
                    } else {
                        newx = cx;
                        newy = cy;
                    }
                    HVScroll.this.scrollAtoB(new TGPoint2D(nx, ny), new TGPoint2D(newx, newy));
                    if (HVScroll.this.noRepaintThread == null || !HVScroll.this.noRepaintThread.isAlive()) {
                        HVScroll.this.tgPanel.repaintAfterMove();
                    } else {
                        HVScroll.this.tgPanel.processGraphMove();
                    }
                    try {
                        Thread.currentThread();
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException ex) {
                        keepScrolling = false;
                    }
                    if (!(distFromCenter < 3.0)) continue;
                    try {
                        Thread.currentThread();
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException ex) {
                        keepScrolling = false;
                    }
                    if (!((distFromCenter = Math.sqrt(((nx = n.drawx) - (cx = HVScroll.this.getDrawCenter().x)) * (nx - cx) + ((ny = n.drawy) - (cy = HVScroll.this.getDrawCenter().y)) * (ny - cy))) < 3.0)) continue;
                    keepScrolling = false;
                }
                HVScroll.this.scrollAtoB(new TGPoint2D(n.drawx, n.drawy), HVScroll.this.getDrawCenter());
                HVScroll.this.tgPanel.repaintAfterMove();
                HVScroll.this.scrolling = false;
            }
        };
        this.scrollThread.start();
    }

    class HVDragUI
    extends TGAbstractDragUI {
        TGPoint2D lastMousePos;

        HVDragUI() {
            super(HVScroll.this.tgPanel);
        }

        @Override
        public void preActivate() {
        }

        @Override
        public void preDeactivate() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.lastMousePos = new TGPoint2D(e.getX(), e.getY());
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!HVScroll.this.scrolling) {
                HVScroll.this.scrollAtoB(this.lastMousePos, new TGPoint2D(e.getX(), e.getY()));
            }
            this.lastMousePos.setLocation(e.getX(), e.getY());
            this.tgPanel.repaintAfterMove();
        }
    }

    class HVScrollToCenterUI
    extends TGAbstractClickUI {
        HVScrollToCenterUI() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }
    }

    class HVLens
    extends TGAbstractLens {
        HVLens() {
        }

        @Override
        protected void applyLens(TGPoint2D p) {
            p.x -= HVScroll.this.offset.x;
            p.y -= HVScroll.this.offset.y;
        }

        @Override
        protected void undoLens(TGPoint2D p) {
            p.x += HVScroll.this.offset.x;
            p.y += HVScroll.this.offset.y;
        }
    }

    private class vertAdjustmentListener
    implements AdjustmentListener {
        private vertAdjustmentListener() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent e) {
            if (!HVScroll.this.adjustmentIsInternal) {
                HVScroll.this.adjustVOffset();
                HVScroll.this.tgPanel.repaintAfterMove();
            }
        }
    }

    private class horizAdjustmentListener
    implements AdjustmentListener {
        private horizAdjustmentListener() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent e) {
            if (!HVScroll.this.adjustmentIsInternal) {
                HVScroll.this.adjustHOffset();
                HVScroll.this.tgPanel.repaintAfterMove();
            }
        }
    }

    class DScrollbar
    extends Scrollbar {
        private double doubleValue;

        DScrollbar(int orient, int val, int vis, int min, int max) {
            super(orient, val, vis, min, max);
            this.doubleValue = val;
        }

        @Override
        public void setValue(int v) {
            this.doubleValue = v;
            super.setValue(v);
        }

        public void setIValue(int v) {
            super.setValue(v);
        }

        public void setDValue(double v) {
            this.doubleValue = Math.max((double)this.getMinimum(), Math.min((double)this.getMaximum(), v));
            this.setIValue((int)v);
        }

        public double getDValue() {
            return this.doubleValue;
        }
    }
}

