/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.generators.random;

import edu.uci.ics.jung.algorithms.generators.GraphGenerator;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.UndirectedGraph;
import java.util.ArrayList;
import java.util.Random;
import org.apache.commons.collections15.Factory;

public class ErdosRenyiGenerator<V, E>
implements GraphGenerator<V, E> {
    private int mNumVertices;
    private double mEdgeConnectionProbability;
    private Random mRandom;
    Factory<UndirectedGraph<V, E>> graphFactory;
    Factory<V> vertexFactory;
    Factory<E> edgeFactory;

    public ErdosRenyiGenerator(Factory<UndirectedGraph<V, E>> graphFactory, Factory<V> vertexFactory, Factory<E> edgeFactory, int numVertices, double p) {
        if (numVertices <= 0) {
            throw new IllegalArgumentException("A positive # of vertices must be specified.");
        }
        this.mNumVertices = numVertices;
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("p must be between 0 and 1.");
        }
        this.graphFactory = graphFactory;
        this.vertexFactory = vertexFactory;
        this.edgeFactory = edgeFactory;
        this.mEdgeConnectionProbability = p;
        this.mRandom = new Random();
    }

    @Override
    public Graph<V, E> create() {
        UndirectedGraph<Object, E> g = this.graphFactory.create();
        for (int i = 0; i < this.mNumVertices; ++i) {
            g.addVertex(this.vertexFactory.create());
        }
        ArrayList list = new ArrayList(g.getVertices());
        for (int i = 0; i < this.mNumVertices - 1; ++i) {
            Object v_i = list.get(i);
            for (int j = i + 1; j < this.mNumVertices; ++j) {
                Object v_j = list.get(j);
                if (!(this.mRandom.nextDouble() < this.mEdgeConnectionProbability)) continue;
                g.addEdge(this.edgeFactory.create(), v_i, v_j);
            }
        }
        return g;
    }

    public void setSeed(long seed) {
        this.mRandom.setSeed(seed);
    }
}

