/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.shortestpath;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.collections15.Factory;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.functors.ConstantTransformer;

public class PrimMinimumSpanningTree<V, E>
implements Transformer<Graph<V, E>, Graph<V, E>> {
    protected Factory<? extends Graph<V, E>> treeFactory;
    protected Transformer<E, Double> weights;

    public PrimMinimumSpanningTree(Factory<? extends Graph<V, E>> factory) {
        this(factory, new ConstantTransformer<Double>(1.0));
    }

    public PrimMinimumSpanningTree(Factory<? extends Graph<V, E>> factory, Transformer<E, Double> weights) {
        this.treeFactory = factory;
        if (weights != null) {
            this.weights = weights;
        }
    }

    @Override
    public Graph<V, E> transform(Graph<V, E> graph) {
        HashSet unfinishedEdges = new HashSet(graph.getEdges());
        Graph tree = this.treeFactory.create();
        V root = this.findRoot(graph);
        if (graph.getVertices().contains(root)) {
            tree.addVertex(root);
        } else if (graph.getVertexCount() > 0) {
            tree.addVertex(graph.getVertices().iterator().next());
        }
        this.updateTree(tree, graph, unfinishedEdges);
        return tree;
    }

    protected V findRoot(Graph<V, E> graph) {
        for (Object v : graph.getVertices()) {
            if (graph.getInEdges(v).size() != 0) continue;
            return v;
        }
        if (graph.getVertexCount() > 0) {
            return graph.getVertices().iterator().next();
        }
        return null;
    }

    protected void updateTree(Graph<V, E> tree, Graph<V, E> graph, Collection<E> unfinishedEdges) {
        Collection tv = tree.getVertices();
        double minCost = Double.MAX_VALUE;
        Object nextEdge = null;
        Object nextVertex = null;
        Object currentVertex = null;
        for (Object object : unfinishedEdges) {
            if (tree.getEdges().contains(object)) continue;
            Pair<V> endpoints = graph.getEndpoints(object);
            V first = endpoints.getFirst();
            V second = endpoints.getSecond();
            if (tv.contains(first) && !tv.contains(second)) {
                if (!(this.weights.transform(object) < minCost)) continue;
                minCost = this.weights.transform(object);
                nextEdge = object;
                currentVertex = first;
                nextVertex = second;
                continue;
            }
            if (!tv.contains(second) || tv.contains(first) || !(this.weights.transform(object) < minCost)) continue;
            minCost = this.weights.transform(object);
            nextEdge = object;
            currentVertex = second;
            nextVertex = first;
        }
        if (nextVertex != null && nextEdge != null) {
            unfinishedEdges.remove(nextEdge);
            tree.addEdge(nextEdge, currentVertex, nextVertex);
            this.updateTree(tree, graph, unfinishedEdges);
        }
    }
}

