/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.bin;

import cern.colt.list.DoubleArrayList;
import cern.jet.random.engine.DRand;
import cern.jet.random.engine.RandomEngine;
import cern.jet.stat.quantile.DoubleQuantileFinder;
import cern.jet.stat.quantile.QuantileFinderFactory;
import hep.aida.IAxis;
import hep.aida.bin.AbstractBin1D;
import hep.aida.bin.MightyStaticBin1D;
import hep.aida.ref.Converter;
import java.util.Date;

public class QuantileBin1D
extends MightyStaticBin1D {
    protected DoubleQuantileFinder finder = null;

    protected QuantileBin1D() {
        super(false, false, 2);
    }

    public QuantileBin1D(double epsilon) {
        this(false, Long.MAX_VALUE, epsilon, 0.001, 10000, new DRand(new Date()));
    }

    public QuantileBin1D(boolean known_N, long N, double epsilon, double delta, int quantiles, RandomEngine randomGenerator) {
        this(known_N, N, epsilon, delta, quantiles, randomGenerator, false, false, 2);
    }

    public QuantileBin1D(boolean known_N, long N, double epsilon, double delta, int quantiles, RandomEngine randomGenerator, boolean hasSumOfLogarithms, boolean hasSumOfInversions, int maxOrderForSumOfPowers) {
        super(hasSumOfLogarithms, hasSumOfInversions, maxOrderForSumOfPowers);
        this.finder = QuantileFinderFactory.newDoubleQuantileFinder(known_N, N, epsilon, delta, quantiles, randomGenerator);
        this.clear();
    }

    @Override
    public synchronized void addAllOfFromTo(DoubleArrayList list, int from, int to) {
        super.addAllOfFromTo(list, from, to);
        if (this.finder != null) {
            this.finder.addAllOfFromTo(list, from, to);
        }
    }

    @Override
    public synchronized void clear() {
        super.clear();
        if (this.finder != null) {
            this.finder.clear();
        }
    }

    @Override
    public synchronized Object clone() {
        QuantileBin1D clone = (QuantileBin1D)super.clone();
        if (this.finder != null) {
            clone.finder = (DoubleQuantileFinder)clone.finder.clone();
        }
        return clone;
    }

    @Override
    public String compareWith(AbstractBin1D other) {
        StringBuffer buf = new StringBuffer(super.compareWith(other));
        if (other instanceof QuantileBin1D) {
            QuantileBin1D q = (QuantileBin1D)other;
            buf.append("25%, 50% and 75% Quantiles: " + this.relError(this.quantile(0.25), q.quantile(0.25)) + ", " + this.relError(this.quantile(0.5), q.quantile(0.5)) + ", " + this.relError(this.quantile(0.75), q.quantile(0.75)));
            buf.append("\nquantileInverse(mean): " + this.relError(this.quantileInverse(this.mean()), q.quantileInverse(q.mean())) + " %");
            buf.append("\n");
        }
        return buf.toString();
    }

    public double median() {
        return this.quantile(0.5);
    }

    public synchronized double quantile(double phi) {
        return this.quantiles(new DoubleArrayList(new double[]{phi})).get(0);
    }

    public synchronized double quantileInverse(double element) {
        return this.finder.phi(element);
    }

    public synchronized DoubleArrayList quantiles(DoubleArrayList phis) {
        return this.finder.quantileElements(phis);
    }

    public int sizeOfRange(double minElement, double maxElement) {
        return (int)Math.round((double)this.size() * (this.quantileInverse(maxElement) - this.quantileInverse(minElement)));
    }

    public synchronized MightyStaticBin1D[] splitApproximately(DoubleArrayList percentages, int k) {
        int percentSize = percentages.size();
        if (k < 1 || percentSize < 2) {
            throw new IllegalArgumentException();
        }
        double[] percent = percentages.elements();
        int noOfBins = percentSize - 1;
        double[] subBins = new double[1 + k * (percentSize - 1)];
        subBins[0] = percent[0];
        int c = 1;
        for (int i = 0; i < noOfBins; ++i) {
            double step = (percent[i + 1] - percent[i]) / (double)k;
            for (int j = 1; j <= k; ++j) {
                subBins[c++] = percent[i] + (double)j * step;
            }
        }
        double[] quantiles = this.quantiles(new DoubleArrayList(subBins)).elements();
        MightyStaticBin1D[] splitBins = new MightyStaticBin1D[noOfBins];
        int maxOrderForSumOfPowers = this.getMaxOrderForSumOfPowers();
        maxOrderForSumOfPowers = Math.min(10, maxOrderForSumOfPowers);
        int dataSize = this.size();
        c = 0;
        for (int i = 0; i < noOfBins; ++i) {
            double binMax;
            double binMin;
            double step = (percent[i + 1] - percent[i]) / (double)k;
            double binSum = 0.0;
            double binSumOfSquares = 0.0;
            double binSumOfLogarithms = 0.0;
            double binSumOfInversions = 0.0;
            double[] binSumOfPowers = null;
            if (maxOrderForSumOfPowers > 2) {
                binSumOfPowers = new double[maxOrderForSumOfPowers - 2];
            }
            double safe_min = binMin = quantiles[c++];
            double subIntervalSize = (double)dataSize * step;
            for (int j = 1; j <= k; ++j) {
                binMax = quantiles[c++];
                double binMean = (binMin + binMax) / 2.0;
                binSum += binMean * subIntervalSize;
                binSumOfSquares += binMean * binMean * subIntervalSize;
                if (this.hasSumOfLogarithms) {
                    binSumOfLogarithms += Math.log(binMean) * subIntervalSize;
                }
                if (this.hasSumOfInversions) {
                    binSumOfInversions += 1.0 / binMean * subIntervalSize;
                }
                if (maxOrderForSumOfPowers >= 3) {
                    binSumOfPowers[0] = binSumOfPowers[0] + binMean * binMean * binMean * subIntervalSize;
                }
                if (maxOrderForSumOfPowers >= 4) {
                    binSumOfPowers[1] = binSumOfPowers[1] + binMean * binMean * binMean * binMean * subIntervalSize;
                }
                for (int p = 5; p <= maxOrderForSumOfPowers; ++p) {
                    int n = p - 3;
                    binSumOfPowers[n] = binSumOfPowers[n] + Math.pow(binMean, p) * subIntervalSize;
                }
                binMin = binMax;
            }
            --c;
            int binSize = (int)Math.round((percent[i + 1] - percent[i]) * (double)dataSize);
            binMax = binMin;
            binMin = safe_min;
            splitBins[i] = new MightyStaticBin1D(this.hasSumOfLogarithms, this.hasSumOfInversions, maxOrderForSumOfPowers);
            if (binSize <= 0) continue;
            splitBins[i].size = binSize;
            splitBins[i].min = binMin;
            splitBins[i].max = binMax;
            splitBins[i].sum = binSum;
            splitBins[i].sum_xx = binSumOfSquares;
            splitBins[i].sumOfLogarithms = binSumOfLogarithms;
            splitBins[i].sumOfInversions = binSumOfInversions;
            splitBins[i].sumOfPowers = binSumOfPowers;
        }
        return splitBins;
    }

    public synchronized MightyStaticBin1D[] splitApproximately(IAxis axis, int k) {
        DoubleArrayList percentages = new DoubleArrayList(new Converter().edges(axis));
        percentages.beforeInsert(0, Double.NEGATIVE_INFINITY);
        percentages.add(Double.POSITIVE_INFINITY);
        int i = percentages.size();
        while (--i >= 0) {
            percentages.set(i, this.quantileInverse(percentages.get(i)));
        }
        return this.splitApproximately(percentages, k);
    }

    @Override
    public synchronized String toString() {
        StringBuffer buf = new StringBuffer(super.toString());
        buf.append("25%, 50%, 75% Quantiles: " + this.quantile(0.25) + ", " + this.quantile(0.5) + ", " + this.quantile(0.75));
        buf.append("\nquantileInverse(median): " + this.quantileInverse(this.median()));
        buf.append("\n");
        return buf.toString();
    }
}

