/*
 * Decompiled with CFR 0.152.
 */
package lcmc.data;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import lcmc.data.Cluster;
import lcmc.data.Host;
import lcmc.data.XML;
import lcmc.gui.TerminalPanel;
import lcmc.utilities.Tools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class UserConfig
extends XML {
    private static final String HOST_NAME_ATTR = "name";
    private static final String HOST_SSHPORT_ATTR = "ssh";
    private static final String HOST_COLOR_ATTR = "color";
    private static final String HOST_USESUDO_ATTR = "sudo";
    private static final String CLUSTER_NAME_ATTR = "name";
    private static final String HOST_NODE_STRING = "host";
    private static final String PROXY_HOST_NODE_STRING = "proxy-host";
    private static final String DOWNLOAD_USER_ATTR = "dwuser";
    private static final String DOWNLOAD_PASSWD_ATTR = "dwpasswd";
    public static final boolean PROXY_HOST = true;

    public String saveXML(OutputStream outputStream, boolean saveAll) throws IOException {
        Transformer t;
        Document doc;
        block13: {
            DocumentBuilder db;
            block12: {
                String encoding = "UTF-8";
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                db = null;
                try {
                    db = dbf.newDocumentBuilder();
                }
                catch (ParserConfigurationException pce) {
                    if ($assertionsDisabled) break block12;
                    throw new AssertionError();
                }
            }
            doc = db.newDocument();
            Element root = (Element)doc.appendChild(doc.createElement("drbdgui"));
            if (Tools.getConfigData().getLoginSave()) {
                String downloadUser = Tools.getConfigData().getDownloadUser();
                String downloadPasswd = Tools.getConfigData().getDownloadPassword();
                if (downloadUser != null && downloadPasswd != null) {
                    root.setAttribute(DOWNLOAD_USER_ATTR, downloadUser);
                    root.setAttribute(DOWNLOAD_PASSWD_ATTR, downloadPasswd);
                }
            }
            Element hostsNode = (Element)root.appendChild(doc.createElement("hosts"));
            Set<Host> hosts = Tools.getConfigData().getHosts().getHostSet();
            for (Host host : hosts) {
                if (!saveAll && !host.isSavable()) continue;
                host.setSavable(true);
                this.addHostConfigNode(doc, hostsNode, HOST_NODE_STRING, host);
            }
            Element clusters = (Element)root.appendChild(doc.createElement("clusters"));
            Set<Cluster> clusterSet = Tools.getConfigData().getClusters().getClusterSet();
            for (Cluster cluster : clusterSet) {
                Element hostNode;
                String hostName;
                if (!saveAll && !cluster.isSavable()) continue;
                cluster.setSavable(true);
                String clusterName = cluster.getName();
                Element clusterNode = (Element)clusters.appendChild(doc.createElement("cluster"));
                clusterNode.setAttribute("name", clusterName);
                Set<Host> clusterHosts = cluster.getHosts();
                for (Host host : clusterHosts) {
                    hostName = host.getHostname();
                    hostNode = (Element)clusterNode.appendChild(doc.createElement(HOST_NODE_STRING));
                    hostNode.appendChild(doc.createTextNode(hostName));
                }
                for (Host pHost : cluster.getProxyHosts()) {
                    if (clusterHosts.contains(pHost)) continue;
                    hostName = pHost.getHostname();
                    hostNode = (Element)clusterNode.appendChild(doc.createElement(PROXY_HOST_NODE_STRING));
                    hostNode.appendChild(doc.createTextNode(hostName));
                }
            }
            TransformerFactory tf = TransformerFactory.newInstance();
            t = null;
            try {
                t = tf.newTransformer();
                t.setOutputProperty("indent", "yes");
                t.setOutputProperty("method", "xml");
                t.setOutputProperty("encoding", "UTF-8");
            }
            catch (TransformerConfigurationException tce) {
                if ($assertionsDisabled) break block13;
                throw new AssertionError();
            }
        }
        DOMSource doms = new DOMSource(doc);
        StreamResult sr = new StreamResult(outputStream);
        try {
            t.transform(doms, sr);
        }
        catch (TransformerException te) {
            IOException ioe = new IOException();
            ioe.initCause(te);
            throw ioe;
        }
        return "";
    }

    public void startClusters(List<Cluster> selectedClusters) {
        Set<Cluster> clusters = Tools.getConfigData().getClusters().getClusterSet();
        if (clusters != null) {
            for (final Cluster cluster : clusters) {
                if (selectedClusters != null && !selectedClusters.contains(cluster)) continue;
                Tools.getGUIData().addClusterTab(cluster);
                if (cluster.getHosts().isEmpty()) continue;
                boolean ok = cluster.connect(null, true, 1);
                if (!ok) {
                    Tools.getGUIData().getClustersPanel().removeTab(cluster);
                    continue;
                }
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        for (Host host : cluster.getHosts()) {
                            host.waitOnLoading();
                        }
                        cluster.getClusterTab().addClusterView();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                cluster.getClusterTab().requestFocus();
                            }
                        });
                    }
                };
                Thread thread = new Thread(runnable);
                thread.start();
            }
        }
    }

    public void loadXML(String xml) {
        Document document = this.getXMLDocument(xml);
        if (document == null) {
            return;
        }
        Node rootNode = this.getChildNode(document, "drbdgui");
        LinkedHashMap<String, List<Host>> hostMap = new LinkedHashMap<String, List<Host>>();
        if (rootNode != null) {
            NodeList clusters;
            Node clustersNode;
            NodeList hosts;
            Node hostsNode;
            String downloadUser = this.getAttribute(rootNode, DOWNLOAD_USER_ATTR);
            String downloadPasswd = this.getAttribute(rootNode, DOWNLOAD_PASSWD_ATTR);
            if (downloadUser != null && downloadPasswd != null) {
                Tools.getConfigData().setDownloadLogin(downloadUser, downloadPasswd, true);
            }
            if ((hostsNode = this.getChildNode(rootNode, "hosts")) != null && (hosts = hostsNode.getChildNodes()) != null) {
                for (int i = 0; i < hosts.getLength(); ++i) {
                    Node hostNode = hosts.item(i);
                    if (!hostNode.getNodeName().equals(HOST_NODE_STRING)) continue;
                    String nodeName = this.getAttribute(hostNode, "name");
                    String sshPort = this.getAttribute(hostNode, HOST_SSHPORT_ATTR);
                    String color = this.getAttribute(hostNode, HOST_COLOR_ATTR);
                    String useSudo = this.getAttribute(hostNode, HOST_USESUDO_ATTR);
                    Node ipNode = this.getChildNode(hostNode, "ip");
                    String ip = null;
                    if (ipNode != null) {
                        ip = this.getText(ipNode);
                    }
                    Node usernameNode = this.getChildNode(hostNode, "user");
                    String username = this.getText(usernameNode);
                    this.setHost(hostMap, username, nodeName, ip, sshPort, color, "true".equals(useSudo), true);
                }
            }
            if ((clustersNode = this.getChildNode(rootNode, "clusters")) != null && (clusters = clustersNode.getChildNodes()) != null) {
                for (int i = 0; i < clusters.getLength(); ++i) {
                    Node clusterNode = clusters.item(i);
                    if (!clusterNode.getNodeName().equals("cluster")) continue;
                    String clusterName = this.getAttribute(clusterNode, "name");
                    Cluster cluster = new Cluster();
                    cluster.setName(clusterName);
                    Tools.getConfigData().addClusterToClusters(cluster);
                    this.loadClusterHosts(clusterNode, cluster, hostMap);
                }
            }
        }
    }

    public void setHost(Map<String, List<Host>> hostMap, String username, String nodeName, String ip, String sshPort, String color, boolean sudo, boolean savable) {
        Tools.getConfigData().setLastEnteredUser(username);
        Host host = new Host();
        host.setSavable(savable);
        host.setHostname(nodeName);
        if (sshPort == null) {
            sshPort = "22";
        }
        host.setSSHPort(sshPort);
        Tools.getConfigData().setLastEnteredSSHPort(sshPort);
        if (color != null) {
            host.setSavedColor(color);
        }
        host.setUseSudo(sudo);
        Tools.getConfigData().setLastEnteredUseSudo(sudo);
        Tools.getConfigData().addHostToHosts(host);
        new TerminalPanel(host);
        host.setIp(ip);
        if (username == null && sudo) {
            username = System.getProperty("user.name");
        }
        if (username == null) {
            username = "root";
        }
        host.setUsername(username);
        List<Host> hostList = hostMap.get(nodeName);
        if (hostList == null) {
            hostList = new ArrayList<Host>();
            hostMap.put(nodeName, hostList);
        }
        hostList.add(host);
    }

    public void setHostCluster(Map<String, List<Host>> hostMap, Cluster cluster, String nodeName, boolean proxy) {
        List<Host> hostList = hostMap.get(nodeName);
        if (hostList == null || hostList.isEmpty()) {
            return;
        }
        Host host = hostList.get(0);
        hostList.remove(0);
        if (host != null && host.getCluster() == null) {
            host.setCluster(cluster);
            if (proxy) {
                cluster.addProxyHost(host);
            } else {
                cluster.addHost(host);
            }
        }
    }

    private void loadClusterHosts(Node clusterNode, Cluster cluster, Map<String, List<Host>> hostMap) {
        NodeList hosts = clusterNode.getChildNodes();
        if (hosts != null) {
            for (int i = 0; i < hosts.getLength(); ++i) {
                String nodeName;
                Node hostNode = hosts.item(i);
                if (hostNode.getNodeName().equals(HOST_NODE_STRING)) {
                    nodeName = this.getText(hostNode);
                    this.setHostCluster(hostMap, cluster, nodeName, false);
                    continue;
                }
                if (!hostNode.getNodeName().equals(PROXY_HOST_NODE_STRING)) continue;
                nodeName = this.getText(hostNode);
                this.setHostCluster(hostMap, cluster, nodeName, true);
            }
        }
    }

    private void addHostConfigNode(Document doc, Element parent, String nodeName, Host host) {
        String hostName = host.getHostname();
        String ip = host.getIp();
        String username = host.getUsername();
        String sshPort = host.getSSHPort();
        Boolean useSudo = host.isUseSudo();
        String color = host.getColor();
        Element hostNode = (Element)parent.appendChild(doc.createElement(nodeName));
        hostNode.setAttribute("name", hostName);
        hostNode.setAttribute(HOST_SSHPORT_ATTR, sshPort);
        if (color != null) {
            hostNode.setAttribute(HOST_COLOR_ATTR, color);
        }
        if (useSudo != null && useSudo.booleanValue()) {
            hostNode.setAttribute(HOST_USESUDO_ATTR, "true");
        }
        if (ip != null) {
            Element ipNode = (Element)hostNode.appendChild(doc.createElement("ip"));
            ipNode.appendChild(doc.createTextNode(ip));
        }
        if (username != null) {
            Element usernameNode = (Element)hostNode.appendChild(doc.createElement("user"));
            usernameNode.appendChild(doc.createTextNode(username));
        }
    }
}

