/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import lcmc.EditClusterDialog;
import lcmc.data.Cluster;
import lcmc.data.ConfigData;
import lcmc.gui.Browser;
import lcmc.gui.ViewPanel;
import lcmc.utilities.AllHostsUpdatable;
import lcmc.utilities.MyButton;
import lcmc.utilities.Tools;

public final class ClusterViewPanel
extends ViewPanel
implements AllHostsUpdatable {
    private static final long serialVersionUID = 1L;
    private final Cluster cluster;
    private static final Color STATUS_BACKGROUND = Tools.getDefaultColor("ViewPanel.Status.Background");
    private final JComboBox<String> operatingModesCB;
    private final JCheckBox advancedModeCB;

    ClusterViewPanel(final Cluster cluster) {
        this.cluster = cluster;
        cluster.createClusterBrowser();
        this.getTree(cluster.getBrowser());
        cluster.getBrowser().initClusterBrowser();
        cluster.getBrowser().setClusterViewPanel(this);
        JPanel buttonPanel = new JPanel(new FlowLayout());
        buttonPanel.setBackground(STATUS_BACKGROUND);
        MyButton clusterWizardButton = new MyButton(Tools.getString("ClusterViewPanel.ClusterWizard"));
        clusterWizardButton.setBackgroundColor(Browser.STATUS_BACKGROUND);
        clusterWizardButton.setPreferredSize(new Dimension(Tools.getConfigData().scaled(150), Tools.getConfigData().scaled(20)));
        clusterWizardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        EditClusterDialog dialog = new EditClusterDialog(cluster);
                        dialog.showDialogs();
                    }
                });
                t.start();
            }
        });
        JPanel clusterButtonsPanel = new JPanel();
        clusterButtonsPanel.setBackground(STATUS_BACKGROUND);
        TitledBorder titledBorder = Tools.getBorder(Tools.getString("ClusterViewPanel.ClusterButtons"));
        clusterButtonsPanel.setBorder(titledBorder);
        clusterButtonsPanel.add(clusterWizardButton);
        buttonPanel.add(clusterButtonsPanel);
        this.advancedModeCB = this.createAdvancedModeButton();
        JPanel opModePanel = new JPanel(new BorderLayout());
        opModePanel.setPreferredSize(new Dimension(350, 0));
        opModePanel.setBackground(STATUS_BACKGROUND);
        TitledBorder vmBorder = Tools.getBorder(Tools.getString("ClusterViewPanel.OperatingMode"));
        opModePanel.setBorder(vmBorder);
        String[] modes = Tools.getConfigData().getOperatingModes();
        JComboBox<String> opModeCB = new JComboBox<String>(modes);
        ConfigData.AccessType accessType = Tools.getConfigData().getAccessType();
        opModeCB.setSelectedItem(ConfigData.OP_MODES_MAP.get((Object)accessType));
        opModeCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                final String opMode = (String)e.getItem();
                if (e.getStateChange() == 1) {
                    Thread thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            ConfigData.AccessType type = ConfigData.ACCESS_TYPE_MAP.get(opMode);
                            if (type == null) {
                                Tools.appError("unknown mode: " + opMode);
                                type = ConfigData.AccessType.RO;
                            }
                            Tools.getConfigData().setAccessType(type);
                            Tools.getGUIData().setOperatingModeGlobally(cluster, opMode);
                            cluster.getBrowser().checkAccessOfEverything();
                        }
                    });
                    thread.start();
                }
            }
        });
        buttonPanel.add(Tools.getGUIData().getClustersPanel().registerUpgradeTextField());
        JPanel buttonArea = new JPanel(new BorderLayout());
        buttonArea.setBackground(STATUS_BACKGROUND);
        buttonArea.add((Component)buttonPanel, "West");
        JPanel omPanel = new JPanel();
        omPanel.add(opModeCB);
        omPanel.setBackground(STATUS_BACKGROUND);
        opModePanel.add((Component)omPanel, "West");
        opModePanel.add((Component)this.advancedModeCB, "East");
        buttonArea.add((Component)opModePanel, "East");
        this.operatingModesCB = opModeCB;
        this.add((Component)buttonArea, "North");
        this.allHostsUpdate();
        Tools.getGUIData().registerAllHostsUpdate(this);
    }

    JCheckBox createAdvancedModeButton() {
        JCheckBox emCB = new JCheckBox(Tools.getString("Browser.AdvancedMode"));
        emCB.setBackground(Tools.getDefaultColor("ViewPanel.Status.Background"));
        emCB.setSelected(Tools.getConfigData().isAdvancedMode());
        emCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean selected;
                boolean bl = selected = e.getStateChange() == 1;
                if (selected != Tools.getConfigData().isAdvancedMode()) {
                    Thread thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            Tools.getConfigData().setAdvancedMode(selected);
                            Tools.getGUIData().setAdvancedModeGlobally(ClusterViewPanel.this.cluster, selected);
                            ClusterViewPanel.this.cluster.getBrowser().checkAccessOfEverything();
                        }
                    });
                    thread.start();
                }
            }
        });
        return emCB;
    }

    @Override
    public void allHostsUpdate() {
        this.cluster.getBrowser().updateClusterResources(this.cluster.getHostsArray(), this.cluster.getCommonFileSystems(), this.cluster.getCommonMountPoints());
    }

    void refresh() {
        this.cluster.getBrowser().getTreeModel().reload();
    }

    Cluster getCluster() {
        return this.cluster;
    }

    void resetOperatingModes(final boolean godMode) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (godMode) {
                    ClusterViewPanel.this.operatingModesCB.addItem(ConfigData.OP_MODE_GOD);
                    ClusterViewPanel.this.operatingModesCB.setSelectedItem(ConfigData.OP_MODE_GOD);
                } else {
                    ClusterViewPanel.this.operatingModesCB.removeItem(ConfigData.OP_MODE_GOD);
                }
            }
        });
    }

    void setOperatingMode(final String opMode) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ClusterViewPanel.this.operatingModesCB.setSelectedItem(opMode);
            }
        });
    }

    void setAdvancedMode(final boolean advancedMode) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ClusterViewPanel.this.advancedModeCB.setSelected(advancedMode);
            }
        });
    }
}

