/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileFilter;
import lcmc.AddClusterDialog;
import lcmc.AddHostDialog;
import lcmc.data.AccessMode;
import lcmc.data.ConfigData;
import lcmc.data.Host;
import lcmc.gui.ClusterBrowser;
import lcmc.gui.dialog.About;
import lcmc.utilities.Tools;

public final class MainMenu
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final JMenuBar menuBar = new JMenuBar();
    private static final Map<String, String> LOOK_AND_FEEL_MAP = new HashMap<String, String>();
    private boolean turnOff = false;
    private static final ImageIcon HOST_ICON = Tools.createImageIcon(Tools.getDefault("MainMenu.HostIcon"));

    public MainMenu() {
        JMenu submenu = this.addMenu(Tools.getString("MainMenu.Session"), 83);
        JMenu menuNew = this.addMenu(Tools.getString("MainMenu.New"), 69);
        JMenuItem hostItem = this.addMenuItem(Tools.getString("MainMenu.Host"), menuNew, 72, 78, this.newHostActionListener(), HOST_ICON);
        Tools.getGUIData().registerAddHostButton(hostItem);
        JMenuItem cmi = this.addMenuItem(Tools.getString("MainMenu.Cluster"), menuNew, 0, 0, this.newClusterActionListener(), ClusterBrowser.CLUSTER_ICON_SMALL);
        Tools.getGUIData().registerAddClusterButton(cmi);
        Tools.getGUIData().checkAddClusterButtons();
        submenu.add(menuNew);
        JMenuItem loadItem = this.addMenuItem(Tools.getString("MainMenu.Load"), submenu, 76, 76, this.loadActionListener(), null);
        Tools.getGUIData().addToEnabledInAccessType(loadItem, new AccessMode(ConfigData.AccessType.GOD, false));
        JMenuItem item = this.addMenuItem(Tools.getString("MainMenu.RemoveEverything"), submenu, 0, 0, this.removeEverythingActionListener(), null);
        Tools.getGUIData().addToVisibleInAccessType(item, new AccessMode(ConfigData.AccessType.GOD, false));
        this.addMenuItem(Tools.getString("MainMenu.Save"), submenu, 83, 0, this.saveActionListener(), null);
        this.addMenuItem(Tools.getString("MainMenu.SaveAs"), submenu, 65, 0, this.saveAsActionListener(), null);
        submenu.addSeparator();
        if (!Tools.getGUIData().isApplet()) {
            this.addMenuItem(Tools.getString("MainMenu.Exit"), submenu, 88, 88, this.exitActionListener(), null);
        }
        this.menuBar.add(submenu);
        submenu = this.addMenu(Tools.getString("MainMenu.Settings"), 0);
        Tools.getGUIData().addToVisibleInAccessType(submenu, new AccessMode(ConfigData.AccessType.GOD, false));
        JMenu menuLookAndFeel = this.addMenu(Tools.getString("MainMenu.LookAndFeel"), 0);
        UIManager.LookAndFeelInfo[] lookAndFeels = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < lookAndFeels.length; ++i) {
            String className = lookAndFeels[i].getClassName();
            String classNamePart = className.substring(className.lastIndexOf(46) + 1);
            LOOK_AND_FEEL_MAP.put(classNamePart, className);
            this.addMenuItem(classNamePart, menuLookAndFeel, 0, 0, this.lookAndFeelActionListener(), null);
        }
        submenu.add(menuLookAndFeel);
        this.menuBar.add(submenu);
        submenu = this.addMenu(Tools.getString("MainMenu.Edit"), 69);
        this.addMenuItem(Tools.getString("MainMenu.Copy"), submenu, 79, 67, this.copyActionListener(), null);
        this.addMenuItem(Tools.getString("MainMenu.Paste"), submenu, 80, 86, this.pasteActionListener(), null);
        this.menuBar.add(submenu);
        submenu = this.addMenu(Tools.getString("MainMenu.Help"), 72);
        this.addMenuItem(Tools.getString("MainMenu.About"), submenu, 65, 0, this.aboutActionListener(), null);
        this.menuBar.add(submenu);
    }

    void turnOn() {
        this.turnOff = false;
    }

    void turnOff() {
        this.turnOff = true;
    }

    private ActionListener exitActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Tools.getConfigData().disconnectAllHosts();
                        System.exit(0);
                    }
                });
                t.start();
            }
        };
    }

    private ActionListener newHostActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainMenu.this.turnOff) {
                    return;
                }
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        AddHostDialog h = new AddHostDialog(new Host());
                        h.showDialogs();
                    }
                });
                t.start();
            }
        };
    }

    private ActionListener loadActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainMenu.this.turnOff) {
                    return;
                }
                JFileChooser fc = new JFileChooser();
                fc.setSelectedFile(new File(Tools.getConfigData().getSaveFile()));
                FileFilter filter = new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        String ext;
                        if (f.isDirectory()) {
                            return true;
                        }
                        String name = f.getName();
                        int i = name.lastIndexOf(46);
                        return i > 0 && i < name.length() - 1 && (ext = name.substring(i + 1)).equals(Tools.getDefault("MainMenu.DrbdGuiFiles.Extension"));
                    }

                    @Override
                    public String getDescription() {
                        return Tools.getString("MainMenu.DrbdGuiFiles");
                    }
                };
                fc.setFileFilter(filter);
                int ret = fc.showOpenDialog(Tools.getGUIData().getMainFrame());
                if (ret == 0) {
                    String name = fc.getSelectedFile().getAbsolutePath();
                    Tools.getConfigData().setSaveFile(name);
                    Tools.loadConfigData(name);
                }
            }
        };
    }

    private ActionListener removeEverythingActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Tools.removeEverything();
                    }
                });
                thread.start();
            }
        };
    }

    private ActionListener saveActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainMenu.this.turnOff) {
                    return;
                }
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Tools.save(Tools.getConfigData().getSaveFile(), true);
                    }
                });
                thread.start();
            }
        };
    }

    private ActionListener saveAsActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainMenu.this.turnOff) {
                    return;
                }
                JFileChooser fc = new JFileChooser();
                fc.setSelectedFile(new File(Tools.getConfigData().getSaveFile()));
                FileFilter filter = new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        String ext;
                        if (f.isDirectory()) {
                            return true;
                        }
                        String name = f.getName();
                        int i = name.lastIndexOf(46);
                        return i > 0 && i < name.length() - 1 && (ext = name.substring(i + 1)).equals(Tools.getDefault("MainMenu.DrbdGuiFiles.Extension"));
                    }

                    @Override
                    public String getDescription() {
                        return "LCMC GUI Files";
                    }
                };
                fc.setFileFilter(filter);
                int ret = fc.showSaveDialog(Tools.getGUIData().getMainFrame());
                if (ret == 0) {
                    String name = fc.getSelectedFile().getAbsolutePath();
                    Tools.getConfigData().setSaveFile(name);
                    Tools.save(Tools.getConfigData().getSaveFile(), true);
                }
            }
        };
    }

    private ActionListener newClusterActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainMenu.this.turnOff) {
                    return;
                }
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        AddClusterDialog c = new AddClusterDialog();
                        c.showDialogs();
                    }
                });
                t.start();
            }
        };
    }

    private ActionListener lookAndFeelActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainMenu.this.turnOff) {
                    return;
                }
                try {
                    String lookAndFeel = (String)LOOK_AND_FEEL_MAP.get(((JMenuItem)e.getSource()).getText());
                    UIManager.setLookAndFeel(lookAndFeel);
                    JRootPane componentToSwitch = Tools.getGUIData().getMainFrameRootPane();
                    SwingUtilities.updateComponentTreeUI(componentToSwitch);
                    componentToSwitch.invalidate();
                    componentToSwitch.validate();
                    componentToSwitch.repaint();
                }
                catch (ClassNotFoundException ex) {
                    ex.printStackTrace();
                }
                catch (InstantiationException ex) {
                    ex.printStackTrace();
                }
                catch (IllegalAccessException ex) {
                    ex.printStackTrace();
                }
                catch (UnsupportedLookAndFeelException ex) {
                    ex.printStackTrace();
                }
            }
        };
    }

    private ActionListener copyActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Tools.getGUIData().copy();
                    }
                });
                t.start();
            }
        };
    }

    private ActionListener pasteActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Tools.getGUIData().paste();
                    }
                });
                t.start();
            }
        };
    }

    private ActionListener aboutActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        About a = new About();
                        a.showDialog();
                    }
                });
                t.start();
            }
        };
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JMenuItem source = (JMenuItem)e.getSource();
        Tools.appError("action \"" + source.getText() + "\" not implemented");
    }

    private JMenu addMenu(String name, int shortcut) {
        JMenu submenu = new JMenu(name);
        if (shortcut != 0) {
            submenu.setMnemonic(shortcut);
        }
        return submenu;
    }

    private JMenuItem addMenuItem(String name, JMenu parentMenu, int shortcut, int accelerator, ActionListener al, ImageIcon icon) {
        JMenuItem item = new JMenuItem(name);
        if (shortcut != 0) {
            item.setMnemonic(shortcut);
        }
        if (accelerator != 0) {
            item.setAccelerator(KeyStroke.getKeyStroke(accelerator, 2));
        }
        if (al == null) {
            item.addActionListener(this);
        } else {
            item.addActionListener(al);
        }
        if (icon != null) {
            item.setIcon(icon);
        }
        parentMenu.add(item);
        return item;
    }
}

