/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JApplet;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import lcmc.data.Host;
import lcmc.gui.ProgressBar;
import lcmc.utilities.Tools;

public final class SSHGui {
    private final Container rootPane;
    private final Host host;
    private final ProgressBar progressBar;
    private static final int DEFAULT_FIELD_LENGTH = 20;

    public SSHGui(Container rootPane, Host host, ProgressBar progressBar) {
        this.rootPane = rootPane;
        this.host = host;
        this.progressBar = progressBar;
    }

    public int getConfirmDialogChoice(String message) {
        Tools.debug(this, "get confirm dialog");
        return JOptionPane.showConfirmDialog(this.rootPane, message);
    }

    public boolean isConfirmDialogYes(int choice) {
        return choice == 0;
    }

    public boolean isConfirmDialogCancel(int choice) {
        return choice == 2;
    }

    public String enterSomethingDialog(String title, String[] content, String underText, String defaultValue, boolean isPassword) {
        EnterSomethingDialog esd = this.rootPane instanceof JDialog ? new EnterSomethingDialog((JDialog)this.rootPane, title, content, underText, defaultValue, isPassword) : (this.rootPane instanceof JApplet ? new EnterSomethingDialog((JApplet)this.rootPane, title, content, underText, defaultValue, isPassword) : new EnterSomethingDialog((Frame)this.rootPane, title, content, underText, defaultValue, isPassword));
        esd.setVisible(true);
        return esd.answer;
    }

    private class EnterSomethingDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;
        private JTextField answerField;
        private JPasswordField passwordField;
        private boolean isPassword;
        private String answer;

        EnterSomethingDialog(Container parent, String title, String content, String underText, boolean isPasswordA) {
            this((JDialog)parent, title, new String[]{content}, underText, null, isPasswordA);
        }

        EnterSomethingDialog(JDialog parent, String title, String[] content, String underText, String defaultValue, boolean isPasswordA) {
            super(parent, title, true);
            this.init(content, underText, defaultValue, isPasswordA);
            this.setLocationRelativeTo(parent);
        }

        EnterSomethingDialog(Frame parent, String title, String[] content, String underText, String defaultValue, boolean isPasswordA) {
            super(parent, title, true);
            this.init(content, underText, defaultValue, isPasswordA);
            this.setLocationRelativeTo(parent);
        }

        EnterSomethingDialog(JApplet parent, String title, String[] content, String underText, String defaultValue, boolean isPasswordA) {
            super((Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent), title, true);
            this.init(content, underText, defaultValue, isPasswordA);
            this.setLocationRelativeTo(parent);
        }

        private void init(String[] content, String underText, String defaultValue, boolean isPassword) {
            this.isPassword = isPassword;
            ArrayList<String> strippedContent = new ArrayList<String>();
            for (String s : content) {
                if (s == null || s.equals("")) continue;
                strippedContent.add(s.replaceAll("\\<.*?\\>", "").replaceAll("&nbsp;", " "));
            }
            SSHGui.this.host.getTerminalPanel().addCommandOutput(strippedContent.toArray(new String[strippedContent.size()]));
            if (SSHGui.this.progressBar != null) {
                SSHGui.this.progressBar.hold();
            }
            JPanel pan = new JPanel();
            pan.setBorder(new LineBorder(Tools.getDefaultColor("ConfigDialog.Background.Light"), 5));
            pan.setBackground(Color.WHITE);
            pan.setLayout(new BoxLayout(pan, 1));
            if (SSHGui.this.host != null && SSHGui.this.host.getName() != null) {
                pan.add(new JLabel("host: " + SSHGui.this.host.getName()));
            }
            for (String el : content) {
                if (el == null || el.equals("")) continue;
                JLabel contentLabel = new JLabel(el);
                pan.add(contentLabel);
            }
            this.answerField = new JTextField(20);
            this.passwordField = new JPasswordField(20);
            if (isPassword) {
                if (defaultValue != null) {
                    this.passwordField.setText(defaultValue);
                    this.passwordField.selectAll();
                }
                pan.add(this.passwordField);
            } else {
                if (defaultValue != null) {
                    this.answerField.setText(defaultValue);
                    this.answerField.selectAll();
                }
                pan.add(this.answerField);
            }
            KeyAdapter kl = new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    if (e.getKeyChar() == '\n') {
                        EnterSomethingDialog.this.finish();
                    }
                }
            };
            this.answerField.addKeyListener(kl);
            this.passwordField.addKeyListener(kl);
            this.getContentPane().add("Center", pan);
            if (underText != null) {
                JLabel l = new JLabel(underText);
                Font font = l.getFont();
                String name = font.getFontName();
                int style = 2;
                int size = font.getSize();
                l.setFont(new Font(name, 2, size - 3));
                l.setForeground(Color.GRAY);
                pan.add(l);
            }
            this.setResizable(false);
            this.pack();
        }

        private void finish() {
            this.answer = this.isPassword ? new String(this.passwordField.getPassword()) : this.answerField.getText();
            if (SSHGui.this.progressBar != null) {
                SSHGui.this.progressBar.cont();
            }
            SSHGui.this.host.getTerminalPanel().addCommandOutput("\n");
            this.dispose();
        }
    }
}

