/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.dialog;

import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import lcmc.gui.dialog.ConfigDialog;
import lcmc.utilities.Tools;

public final class ConfirmDialog
extends ConfigDialog {
    private static final long serialVersionUID = 1L;
    private final String description;
    private final String title;
    private final String yesButton;
    private final String noButton;

    public ConfirmDialog(String title, String description, String yesButton, String noButton) {
        this.title = title;
        this.description = description;
        this.yesButton = yesButton;
        this.noButton = noButton;
    }

    protected String yesButton() {
        if (this.yesButton == null) {
            return Tools.getString("ConfirmDialog.Yes");
        }
        return this.yesButton;
    }

    protected String noButton() {
        if (this.noButton == null) {
            return Tools.getString("ConfirmDialog.No");
        }
        return this.noButton;
    }

    @Override
    protected String defaultButton() {
        return this.noButton();
    }

    @Override
    protected ImageIcon icon() {
        return null;
    }

    @Override
    protected int dialogWidth() {
        return Tools.getDefaultInt("ConfirmDialog.width");
    }

    @Override
    protected int dialogHeight() {
        return Tools.getDefaultInt("ConfirmDialog.height");
    }

    @Override
    protected int getMessageType() {
        return 2;
    }

    public boolean isPressedYesButton() {
        return this.isPressedButton(this.yesButton());
    }

    @Override
    protected String[] buttons() {
        return new String[]{this.yesButton(), this.noButton()};
    }

    @Override
    protected ImageIcon[] getIcons() {
        return new ImageIcon[]{null, null};
    }

    @Override
    protected void initDialog() {
        super.initDialog();
        this.enableComponentsLater(new JComponent[]{this.buttonClass(this.noButton())});
        this.enableComponents();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConfirmDialog.this.buttonClass(ConfirmDialog.this.noButton()).setEnabled(true);
            }
        });
    }

    @Override
    protected void initDialogAfterVisible() {
        super.initDialogAfterVisible();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConfirmDialog.this.buttonClass(ConfirmDialog.this.noButton()).requestFocus();
            }
        });
    }

    @Override
    protected String getDialogTitle() {
        if (this.title == null) {
            return Tools.getString("ConfirmDialog.Title");
        }
        return this.title;
    }

    @Override
    protected String getDescription() {
        if (this.description == null) {
            return Tools.getString("ConfirmDialog.Description");
        }
        return this.description;
    }

    @Override
    protected JComponent getInputPane() {
        return null;
    }
}

