/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.dialog.cluster;

import java.awt.Color;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import lcmc.data.AccessMode;
import lcmc.data.Cluster;
import lcmc.data.ConfigData;
import lcmc.data.Host;
import lcmc.gui.SpringUtilities;
import lcmc.gui.dialog.WizardDialog;
import lcmc.gui.dialog.cluster.CoroConfig;
import lcmc.gui.dialog.cluster.DialogCluster;
import lcmc.gui.dialog.cluster.HbConfig;
import lcmc.gui.widget.Widget;
import lcmc.gui.widget.WidgetFactory;
import lcmc.utilities.ExecCallback;
import lcmc.utilities.SSH;
import lcmc.utilities.Tools;

final class CommStack
extends DialogCluster {
    private static final long serialVersionUID = 1L;
    private Widget chooseStackCombo;

    CommStack(WizardDialog previousDialog, Cluster cluster) {
        super(previousDialog, cluster);
    }

    @Override
    public WizardDialog nextDialog() {
        if ("Heartbeat".equals(this.chooseStackCombo.getValue())) {
            Tools.getConfigData().setLastInstalledClusterStack("Heartbeat");
            return new HbConfig(this, this.getCluster());
        }
        Tools.getConfigData().setLastInstalledClusterStack("Corosync/OpenAIS");
        return new CoroConfig(this, this.getCluster());
    }

    @Override
    protected String getClusterDialogTitle() {
        return Tools.getString("Dialog.Cluster.CommStack.Title");
    }

    @Override
    protected String getDescription() {
        return Tools.getString("Dialog.Cluster.CommStack.Description");
    }

    @Override
    protected void initDialog() {
        super.initDialog();
        this.enableComponentsLater(new JComponent[0]);
    }

    @Override
    protected void initDialogAfterVisible() {
        Host[] hosts = this.getCluster().getHostsArray();
        SSH.ExecCommandThread[] infoThreads = new SSH.ExecCommandThread[hosts.length];
        int i = 0;
        this.getProgressBar().start(10000);
        for (final Host host : hosts) {
            infoThreads[i] = host.execCommand("Cluster.Init.getInstallationInfo", this.getProgressBar(), new ExecCallback(){

                @Override
                public void done(String ans) {
                    for (String line : ans.split("\\r?\\n")) {
                        host.parseInstallationInfo(line);
                    }
                }

                @Override
                public void doneError(String ans, int exitCode) {
                    Tools.appWarning("could not get install info");
                }
            }, null, false, SSH.DEFAULT_COMMAND_TIMEOUT);
            ++i;
        }
        for (SSH.ExecCommandThread t : infoThreads) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.progressBarDone();
        boolean aisIsPossible = true;
        boolean hbIsPossible = true;
        for (Host host : hosts) {
            if (host.getCorosyncVersion() == null && host.getOpenaisVersion() == null) {
                aisIsPossible = false;
            }
            if (host.getHeartbeatVersion() != null) continue;
            hbIsPossible = false;
        }
        if (!aisIsPossible && hbIsPossible) {
            this.chooseStackCombo.setValue("Heartbeat");
        }
        final boolean ais = aisIsPossible;
        final boolean hb = hbIsPossible;
        if (ais || hb) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (ais) {
                        CommStack.this.chooseStackCombo.setEnabled("Corosync/OpenAIS", true);
                    }
                    if (hb) {
                        CommStack.this.chooseStackCombo.setEnabled("Heartbeat", true);
                    }
                }
            });
        }
        this.enableComponents();
        if (ais || hb) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CommStack.this.buttonClass(CommStack.this.nextButton()).setEnabled(true);
                    CommStack.this.makeDefaultAndRequestFocus(CommStack.this.buttonClass(CommStack.this.nextButton()));
                }
            });
            if (!Tools.getConfigData().getAutoClusters().isEmpty()) {
                Tools.sleep(1000);
                this.pressNextButton();
            }
        }
    }

    @Override
    protected JComponent getInputPane() {
        JPanel inputPane = new JPanel(new SpringLayout());
        Host[] hosts = this.getCluster().getHostsArray();
        boolean hbImpossible = false;
        boolean aisImpossible = false;
        int aisIsRc = 0;
        int hbIsRc = 0;
        int aisIsRunning = 0;
        int hbIsRunning = 0;
        for (Host host : hosts) {
            if (host.getHeartbeatVersion() == null) {
                hbImpossible = true;
            }
            if (host.getCorosyncVersion() == null && host.getOpenaisVersion() == null) {
                aisImpossible = true;
            }
            if (host.isCsRc() || host.isAisRc()) {
                ++aisIsRc;
            }
            if (host.isHeartbeatRc()) {
                ++hbIsRc;
            }
            if (host.isCsRunning() || host.isAisRunning()) {
                ++aisIsRunning;
            }
            if (!host.isHeartbeatRunning()) continue;
            ++hbIsRunning;
        }
        String defaultValue = null;
        defaultValue = hbImpossible ? "Corosync/OpenAIS" : (aisImpossible ? "Heartbeat" : (aisIsRc < hbIsRc ? "Heartbeat" : (aisIsRc > hbIsRc ? "Corosync/OpenAIS" : (aisIsRunning < hbIsRunning ? "Heartbeat" : (aisIsRunning > hbIsRunning ? "Corosync/OpenAIS" : Tools.getConfigData().getLastInstalledClusterStack())))));
        if (defaultValue == null) {
            defaultValue = "Corosync/OpenAIS";
        }
        this.chooseStackCombo = WidgetFactory.createInstance(Widget.Type.RADIOGROUP, defaultValue, new String[]{"Heartbeat", "Corosync/OpenAIS"}, Widget.NO_REGEXP, 500, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.ADMIN, false), Widget.NO_BUTTON);
        this.chooseStackCombo.setEnabled("Corosync/OpenAIS", false);
        this.chooseStackCombo.setEnabled("Heartbeat", false);
        this.chooseStackCombo.setBackgroundColor(Color.WHITE);
        inputPane.add(this.getProgressBarPane(null));
        inputPane.add(this.chooseStackCombo);
        SpringUtilities.makeCompactGrid(inputPane, 2, 1, 0, 0, 0, 0);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(inputPane);
        panel.add(Box.createVerticalStrut(100));
        return panel;
    }

    @Override
    protected boolean skipButtonEnabled() {
        return true;
    }
}

