/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.dialog.cluster;

import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import lcmc.data.Cluster;
import lcmc.data.Host;
import lcmc.gui.SpringUtilities;
import lcmc.gui.dialog.WizardDialog;
import lcmc.gui.dialog.cluster.CommStack;
import lcmc.gui.dialog.cluster.DialogCluster;
import lcmc.utilities.Tools;

final class Connect
extends DialogCluster {
    private static final long serialVersionUID = 1L;

    Connect(WizardDialog previousDialog, Cluster cluster) {
        super(previousDialog, cluster);
    }

    @Override
    public WizardDialog nextDialog() {
        return new CommStack(this.getPreviousDialog(), this.getCluster());
    }

    @Override
    protected String getClusterDialogTitle() {
        return Tools.getString("Dialog.Cluster.Connect.Title");
    }

    @Override
    protected String getDescription() {
        return Tools.getString("Dialog.Cluster.Connect.Description");
    }

    protected void checkHosts() {
        StringBuilder text = new StringBuilder();
        boolean pending = false;
        boolean oneFailed = false;
        for (Host host : this.getCluster().getHosts()) {
            String status;
            if (host.getSSH().isConnectionFailed()) {
                status = "failed.";
                oneFailed = true;
            } else if (host.isConnected()) {
                status = "connected.";
            } else {
                pending = true;
                status = "connecting...";
            }
            text.append(host.getName() + " " + status + "\n");
        }
        Tools.debug(this, "pending: " + pending + ", one failed: " + oneFailed);
        if (pending) {
            this.answerPaneSetText(text.toString());
        } else if (oneFailed) {
            this.printErrorAndRetry(text.toString());
        } else {
            this.answerPaneSetText(text.toString());
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Connect.this.buttonClass(Connect.this.nextButton()).pressButton();
                }
            });
        }
    }

    protected void connectHosts() {
        this.getCluster().connect(this.getDialogPanel(), true, 1);
        for (Host host : this.getCluster().getHosts()) {
            host.waitOnLoading();
        }
        this.checkHosts();
    }

    @Override
    protected void initDialog() {
        super.initDialog();
        this.enableComponentsLater(new JComponent[]{this.buttonClass(this.nextButton())});
    }

    @Override
    protected void initDialogAfterVisible() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                Connect.this.connectHosts();
            }
        });
        t.start();
    }

    @Override
    protected JComponent getInputPane() {
        JPanel pane = new JPanel(new SpringLayout());
        StringBuilder text = new StringBuilder();
        for (Host host : this.getCluster().getHosts()) {
            text.append(host.getName());
            text.append(" connecting...\n");
        }
        pane.add(this.getAnswerPane(text.toString()));
        SpringUtilities.makeCompactGrid(pane, 1, 1, 1, 1, 1, 1);
        return pane;
    }

    @Override
    protected boolean skipButtonEnabled() {
        return true;
    }
}

