/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.dialog.drbd;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import lcmc.data.Host;
import lcmc.gui.dialog.HostLogs;

public final class DrbdLog
extends HostLogs {
    private static final long serialVersionUID = 1L;
    private final String deviceName;

    public DrbdLog(Host host, String device) {
        super(host);
        this.deviceName = device.substring(device.lastIndexOf(47) + 1);
    }

    @Override
    protected String logFileCommand() {
        return "DrbdLog.log";
    }

    @Override
    protected Set<String> getSelectedSet() {
        HashSet<String> selected = new HashSet<String>();
        selected.add(this.deviceName);
        return selected;
    }

    @Override
    protected Map<String, String> getPatternMap() {
        LinkedHashMap<String, String> pm = new LinkedHashMap<String, String>();
        pm.put(this.deviceName, this.wordBoundary(this.deviceName));
        return pm;
    }
}

