/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.dialog.drbdConfig;

import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import lcmc.Exceptions;
import lcmc.gui.ClusterBrowser;
import lcmc.gui.SpringUtilities;
import lcmc.gui.dialog.WizardDialog;
import lcmc.gui.dialog.drbdConfig.CreateMD;
import lcmc.gui.dialog.drbdConfig.DrbdConfig;
import lcmc.gui.resources.BlockDevInfo;
import lcmc.gui.resources.DrbdVolumeInfo;
import lcmc.utilities.DRBD;
import lcmc.utilities.Tools;

final class BlockDev
extends DrbdConfig {
    private static final long serialVersionUID = 1L;
    private final BlockDevInfo blockDevInfo;

    BlockDev(WizardDialog previousDialog, DrbdVolumeInfo dli, BlockDevInfo blockDevInfo) {
        super(previousDialog, dli);
        this.blockDevInfo = blockDevInfo;
        dli.getDrbdResourceInfo().getDrbdInfo().setSelectedNode(blockDevInfo);
        dli.getDrbdResourceInfo().getDrbdInfo().selectMyself();
    }

    @Override
    protected void finishDialog() {
        Tools.waitForSwing();
        this.blockDevInfo.apply(false);
    }

    private String getGI(BlockDevInfo bdi) {
        boolean testOnly = false;
        String gi = DRBD.getGI(bdi.getHost(), bdi.getDrbdVolumeInfo().getDrbdResourceInfo().getName(), bdi.getDrbdVolumeInfo().getName(), false);
        return gi;
    }

    @Override
    public WizardDialog nextDialog() {
        if (this.getDrbdVolumeInfo().isFirstBlockDevInfo(this.blockDevInfo)) {
            BlockDevInfo oBdi = this.getDrbdVolumeInfo().getOtherBlockDevInfo(this.blockDevInfo);
            return new BlockDev(this, this.getDrbdVolumeInfo(), oBdi);
        }
        BlockDevInfo oBdi = this.getDrbdVolumeInfo().getOtherBlockDevInfo(this.blockDevInfo);
        try {
            boolean testOnly = false;
            this.getDrbdVolumeInfo().getDrbdResourceInfo().getDrbdInfo().createDrbdConfig(false);
            String gi1 = this.getGI(this.blockDevInfo);
            String gi2 = this.getGI(oBdi);
            if (gi1 == null || gi2 == null) {
                this.getDrbdVolumeInfo().getDrbdResourceInfo().setHaveToCreateMD(true);
            }
            ClusterBrowser browser = this.getDrbdVolumeInfo().getDrbdResourceInfo().getBrowser();
            browser.reloadAllComboBoxes(null);
            Tools.getGUIData().expandTerminalSplitPane(1);
            Tools.getGUIData().getMainFrame().requestFocus();
        }
        catch (Exceptions.DrbdConfigException dce) {
            Tools.appError("config failed", dce);
        }
        return new CreateMD(this, this.getDrbdVolumeInfo());
    }

    @Override
    protected String getDialogTitle() {
        return Tools.getString("Dialog.DrbdConfig.BlockDev.Title");
    }

    @Override
    protected String getDescription() {
        return Tools.getString("Dialog.DrbdConfig.BlockDev.Description");
    }

    @Override
    protected void initDialog() {
        super.initDialog();
        this.enableComponentsLater(new JComponent[]{this.buttonClass(this.nextButton())});
    }

    @Override
    protected void initDialogAfterVisible() {
        this.enableComponents();
        final String[] params = this.blockDevInfo.getParametersFromXML();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BlockDev.this.buttonClass(BlockDev.this.nextButton()).setEnabled(BlockDev.this.blockDevInfo.checkResourceFieldsCorrect(null, params));
            }
        });
        if (Tools.getConfigData().getAutoOptionGlobal("autodrbd") != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BlockDev.this.pressNextButton();
                }
            });
        }
    }

    @Override
    protected JComponent getInputPane() {
        JPanel inputPane = new JPanel(new SpringLayout());
        JPanel optionsPanel = new JPanel();
        optionsPanel.setLayout(new BoxLayout(optionsPanel, 1));
        optionsPanel.setAlignmentX(0.0f);
        String[] params = this.blockDevInfo.getParametersFromXML();
        this.blockDevInfo.selectMyself();
        this.blockDevInfo.waitForInfoPanel();
        this.blockDevInfo.addWizardParams(optionsPanel, params, this.buttonClass(this.nextButton()), Tools.getDefaultSize("Dialog.DrbdConfig.BlockDev.LabelWidth"), Tools.getDefaultSize("Dialog.DrbdConfig.BlockDev.FieldWidth"), null);
        JPanel p = new JPanel();
        p.setBackground(Tools.getDefaultColor("ConfigDialog.Background.Dark"));
        p.add(new JLabel(this.blockDevInfo.getHost().getName()));
        inputPane.add(p);
        inputPane.add(optionsPanel);
        SpringUtilities.makeCompactGrid(inputPane, 2, 1, 0, 0, 0, 0);
        return inputPane;
    }
}

