/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.dialog.drbdConfig;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import lcmc.configs.AppDefaults;
import lcmc.data.Host;
import lcmc.gui.ClusterBrowser;
import lcmc.gui.dialog.WizardDialog;
import lcmc.gui.dialog.drbdConfig.DrbdConfig;
import lcmc.gui.dialog.drbdConfig.NewProxyHost;
import lcmc.gui.dialog.drbdConfig.Volume;
import lcmc.gui.resources.DrbdInfo;
import lcmc.gui.resources.DrbdResourceInfo;
import lcmc.gui.resources.DrbdVolumeInfo;
import lcmc.utilities.MyButton;
import lcmc.utilities.Tools;

public final class Resource
extends DrbdConfig {
    private static final long serialVersionUID = 1L;
    private static final String WFC_TIMEOUT_PARAM = "wfc-timeout";
    private static final String DEGR_WFC_TIMEOUT_PARAM = "degr-wfc-timeout";
    private static final String ALLOW_TWO_PRIMARIES = "allow-two-primaries";
    private static final String CRAM_HMAC_ALG = "cram-hmac-alg";
    private static final String SHARED_SECRET = "shared-secret";
    private static final String ON_IO_ERROR = "on-io-error";
    private static final String PROXY_MEMLIMIT = "memlimit";
    private static final String PROXY_PLUGIN_ZLIB = "plugin-zlib";
    private static final String PROXY_PLUGIN_LZMA = "plugin-lzma";
    private static final String[] COMMON_PARAMS = new String[]{"protocol", "ping-timeout", "cram-hmac-alg", "shared-secret", "wfc-timeout", "degr-wfc-timeout", "on-io-error", "memlimit", "plugin-zlib", "plugin-lzma"};
    private static final String[] PARAMS = new String[]{"name", "protocol", "ping-timeout", "allow-two-primaries", "cram-hmac-alg", "shared-secret", "wfc-timeout", "degr-wfc-timeout", "on-io-error", "memlimit", "plugin-zlib", "plugin-lzma"};
    private static final int SECRET_STRING_LENGTH = 32;
    private boolean proxyHostNextDialog = false;

    public Resource(WizardDialog previousDialog, DrbdVolumeInfo dvi) {
        super(previousDialog, dvi);
    }

    private String getRandomSecret() {
        return Tools.getRandomSecret(32);
    }

    @Override
    public WizardDialog nextDialog() {
        DrbdResourceInfo dri = this.getDrbdVolumeInfo().getDrbdResourceInfo();
        if (this.proxyHostNextDialog) {
            this.proxyHostNextDialog = false;
            Host proxyHost = new Host();
            proxyHost.setCluster(dri.getCluster());
            return new NewProxyHost(this, proxyHost, this.getDrbdVolumeInfo(), this);
        }
        DrbdInfo drbdInfo = dri.getDrbdInfo();
        boolean protocolInNetSection = drbdInfo.atLeastVersion("8.4");
        if (drbdInfo.getDrbdResources().size() <= 1) {
            for (String commonP : COMMON_PARAMS) {
                if (!protocolInNetSection && "protocol".equals(commonP)) continue;
                String value = dri.getComboBoxValue(commonP);
                drbdInfo.getResource().setValue(commonP, value);
                drbdInfo.getWidget(commonP, null).setValue(value);
            }
        }
        Tools.waitForSwing();
        drbdInfo.apply(false);
        dri.apply(false);
        return new Volume(this, this.getDrbdVolumeInfo());
    }

    @Override
    protected String getDialogTitle() {
        return Tools.getString("Dialog.DrbdConfig.Resource.Title");
    }

    @Override
    protected String getDescription() {
        return Tools.getString("Dialog.DrbdConfig.Resource.Description");
    }

    @Override
    protected void initDialog() {
        super.initDialog();
        this.enableComponentsLater(new JComponent[]{this.buttonClass(this.nextButton())});
    }

    @Override
    protected void initDialogAfterVisible() {
        DrbdResourceInfo dri = this.getDrbdVolumeInfo().getDrbdResourceInfo();
        boolean ch = dri.checkResourceFieldsChanged(null, PARAMS);
        boolean cor = dri.checkResourceFieldsCorrect(null, PARAMS);
        if (cor) {
            this.enableComponents();
        } else {
            this.enableComponents(new JComponent[]{this.buttonClass(this.nextButton())});
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Resource.this.makeDefaultButton(Resource.this.buttonClass(Resource.this.nextButton()));
            }
        });
        if (Tools.getConfigData().getAutoOptionGlobal("autodrbd") != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Resource.this.pressNextButton();
                }
            });
        }
    }

    @Override
    protected JComponent getInputPane() {
        DrbdResourceInfo dri = this.getDrbdVolumeInfo().getDrbdResourceInfo();
        DrbdInfo drbdInfo = dri.getDrbdInfo();
        dri.waitForInfoPanel();
        Tools.waitForSwing();
        JPanel inputPane = new JPanel();
        inputPane.setLayout(new BoxLayout(inputPane, 0));
        JPanel optionsPanel = new JPanel();
        optionsPanel.setLayout(new BoxLayout(optionsPanel, 1));
        HashMap<String, String> commonPreferredValue = new HashMap<String, String>();
        commonPreferredValue.put("protocol", "C");
        commonPreferredValue.put(DEGR_WFC_TIMEOUT_PARAM, "0");
        commonPreferredValue.put(CRAM_HMAC_ALG, "sha1");
        commonPreferredValue.put(SHARED_SECRET, this.getRandomSecret());
        commonPreferredValue.put(ON_IO_ERROR, "detach");
        commonPreferredValue.put(PROXY_MEMLIMIT, "100M");
        commonPreferredValue.put(PROXY_PLUGIN_ZLIB, "level 9");
        if (drbdInfo.getDrbdResources().size() <= 1) {
            for (String commonP : COMMON_PARAMS) {
                String commonValue = drbdInfo.getResource().getValue(commonP);
                if (!commonPreferredValue.containsKey(commonP)) continue;
                String defaultValue = drbdInfo.getParamDefault(commonP);
                if (defaultValue == null && "".equals(commonValue) || defaultValue != null && defaultValue.equals(commonValue)) {
                    drbdInfo.getWidget(commonP, null).setValue(commonPreferredValue.get(commonP));
                    dri.getResource().setValue(commonP, (String)commonPreferredValue.get(commonP));
                    continue;
                }
                dri.getResource().setValue(commonP, commonValue);
            }
        } else {
            for (String commonP : COMMON_PARAMS) {
                String commonValue = drbdInfo.getResource().getValue(commonP);
                if (!"".equals(commonValue) || !commonPreferredValue.containsKey(commonP)) continue;
                dri.getResource().setValue(commonP, (String)commonPreferredValue.get(commonP));
            }
        }
        dri.addHostAddresses(optionsPanel, ClusterBrowser.SERVICE_LABEL_WIDTH, ClusterBrowser.SERVICE_FIELD_WIDTH * 2, true, this.buttonClass(this.nextButton()));
        dri.addWizardParams(optionsPanel, PARAMS, this.buttonClass(this.nextButton()), Tools.getDefaultSize("Dialog.DrbdConfig.Resource.LabelWidth"), Tools.getDefaultSize("Dialog.DrbdConfig.Resource.FieldWidth") * 2, null);
        inputPane.add(optionsPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.getProxyHostsPanel());
        inputPane.add(buttonPanel);
        JScrollPane sp = new JScrollPane(inputPane);
        sp.setMaximumSize(new Dimension(Short.MAX_VALUE, 200));
        sp.setPreferredSize(new Dimension(Short.MAX_VALUE, 200));
        return sp;
    }

    private JPanel getProxyHostsPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(Tools.getBorder(Tools.getString("Dialog.DrbdConfig.Resource.ProxyHosts")));
        final MyButton btn = new MyButton(Tools.getString("Dialog.DrbdConfig.Resource.AddHost"));
        btn.setBackgroundColor(AppDefaults.LIGHT_ORANGE);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                btn.setEnabled(false);
                                Resource.this.proxyHostNextDialog = true;
                                Resource.this.buttonClass(Resource.this.nextButton()).pressButton();
                            }
                        });
                    }
                });
                t.start();
            }
        });
        panel.add(btn);
        DrbdResourceInfo dri = this.getDrbdVolumeInfo().getDrbdResourceInfo();
        for (Host h : dri.getCluster().getProxyHosts()) {
            panel.add(new JLabel(h.getName()));
        }
        return panel;
    }
}

