/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.dialog.host;

import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import lcmc.data.AccessMode;
import lcmc.data.ConfigData;
import lcmc.data.Host;
import lcmc.gui.SpringUtilities;
import lcmc.gui.dialog.WizardDialog;
import lcmc.gui.dialog.host.DialogHost;
import lcmc.gui.dialog.host.DrbdCommandInst;
import lcmc.gui.widget.Widget;
import lcmc.gui.widget.WidgetFactory;
import lcmc.utilities.ComboInfo;
import lcmc.utilities.ExecCallback;
import lcmc.utilities.SSH;
import lcmc.utilities.Tools;
import lcmc.utilities.WidgetListener;

final class DrbdAvailSourceFiles
extends DialogHost {
    private static final long serialVersionUID = 1L;
    private WizardDialog nextDialogObject = null;
    private Widget drbdTarballCombo = null;
    private boolean listenersAdded = false;

    DrbdAvailSourceFiles(WizardDialog previousDialog, Host host) {
        super(previousDialog, host);
    }

    @Override
    protected void initDialog() {
        super.initDialog();
        this.enableComponentsLater(new JComponent[]{this.buttonClass(this.nextButton())});
        this.disableComponents(new JComponent[]{this.drbdTarballCombo});
    }

    @Override
    protected void initDialogAfterVisible() {
        this.getProgressBar().start(2000);
        this.availTarballs();
    }

    protected void availTarballs() {
        this.getHost().execCommand("DrbdAvailVersionsSource", null, new ExecCallback(){

            @Override
            public void done(String ans) {
                String[] versions = ans.split("\\r?\\n");
                if (versions.length == 0) {
                    DrbdAvailSourceFiles.this.allDone(null);
                    return;
                }
                final ArrayList<ComboInfo> items = new ArrayList<ComboInfo>();
                for (String versionString : versions) {
                    if (versionString == null || versionString.length() <= 16) continue;
                    String version2 = versionString.substring(9, versionString.length() - 7);
                    items.add(new ComboInfo(version2, versionString));
                }
                DrbdAvailSourceFiles.this.drbdTarballCombo.clear();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DrbdAvailSourceFiles.this.drbdTarballCombo.reloadComboBox(((ComboInfo)items.get(0)).toString(), items.toArray(new ComboInfo[items.size()]));
                        ComboInfo selectedItem = (ComboInfo)DrbdAvailSourceFiles.this.drbdTarballCombo.getValue();
                        DrbdAvailSourceFiles.this.drbdTarballCombo.setEnabled(true);
                        DrbdAvailSourceFiles.this.allDone(selectedItem);
                    }
                });
            }

            @Override
            public void doneError(final String ans, final int exitCode) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DrbdAvailSourceFiles.this.progressBarDoneError();
                        DrbdAvailSourceFiles.this.printErrorAndRetry(Tools.getString("Dialog.Host.DrbdAvailSourceFiles.NoBuilds"), ans, exitCode);
                    }
                });
            }
        }, null, false, SSH.DEFAULT_COMMAND_TIMEOUT);
    }

    protected void allDone(ComboInfo versionInfo) {
        if (versionInfo != null) {
            this.answerPaneSetText("http://oss.linbit.com/drbd/" + versionInfo.getStringValue());
            this.getHost().setDrbdVersionToInstall(versionInfo.toString());
            this.getHost().setDrbdVersionUrlStringToInstall(versionInfo.getStringValue());
        }
        this.drbdTarballCombo.setEnabled(true);
        this.nextDialogObject = new DrbdCommandInst(this, this.getHost());
        this.progressBarDone();
        this.enableComponents();
        this.buttonClass(this.nextButton()).requestFocus();
        if (!this.listenersAdded) {
            this.addListeners();
            this.listenersAdded = true;
        }
        if (Tools.getConfigData().getAutoOptionHost("drbdinst") != null) {
            this.pressNextButton();
        }
    }

    @Override
    public WizardDialog nextDialog() {
        return this.nextDialogObject;
    }

    @Override
    protected String getHostDialogTitle() {
        return Tools.getString("Dialog.Host.DrbdAvailSourceFiles.Title");
    }

    @Override
    protected String getDescription() {
        return Tools.getString("Dialog.Host.DrbdAvailSourceFiles.Description");
    }

    protected JPanel getChoiceBoxes() {
        JPanel pane = new JPanel(new SpringLayout());
        this.drbdTarballCombo = WidgetFactory.createInstance(Widget.Type.COMBOBOX, Widget.NO_DEFAULT, Widget.NO_ITEMS, Widget.NO_REGEXP, 0, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.RO, false), Widget.NO_BUTTON);
        pane.add(this.drbdTarballCombo);
        SpringUtilities.makeCompactGrid(pane, 1, 1, 1, 1, 1, 1);
        return pane;
    }

    private void addListeners() {
        this.drbdTarballCombo.addListeners(new WidgetListener(){

            @Override
            public void check(Object value) {
                ComboInfo item = (ComboInfo)DrbdAvailSourceFiles.this.drbdTarballCombo.getValue();
                DrbdAvailSourceFiles.this.allDone(item);
            }
        });
    }

    @Override
    protected JComponent getInputPane() {
        JPanel pane = new JPanel(new SpringLayout());
        pane.add(this.getChoiceBoxes());
        pane.add(this.getProgressBarPane());
        pane.add(this.getAnswerPane(Tools.getString("Dialog.Host.DrbdAvailSourceFiles.Executing")));
        SpringUtilities.makeCompactGrid(pane, 3, 1, 0, 0, 0, 0);
        return pane;
    }
}

