/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.resources;

import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import lcmc.gui.Browser;
import lcmc.gui.HostBrowser;
import lcmc.gui.resources.Info;
import lcmc.utilities.SSH;
import lcmc.utilities.Tools;

public final class FSInfo
extends Info {
    private String modinfo = null;
    private static final ImageIcon FS_ICON = Tools.createImageIcon(Tools.getDefault("HostBrowser.FileSystemIcon"));

    public FSInfo(String name, Browser browser) {
        super(name, browser);
    }

    @Override
    protected HostBrowser getBrowser() {
        return (HostBrowser)super.getBrowser();
    }

    @Override
    public ImageIcon getMenuIcon(boolean testOnly) {
        return FS_ICON;
    }

    @Override
    protected String getInfoType() {
        return "text/html";
    }

    @Override
    String getInfo() {
        return "<html><pre>" + this.getName() + "</html></pre>";
    }

    @Override
    public void updateInfo(final JEditorPane ep) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (FSInfo.this.modinfo == null) {
                    SSH.SSHOutput ret = Tools.execCommand(FSInfo.this.getBrowser().getHost(), "/sbin/modinfo " + FSInfo.this.getName(), null, false, SSH.DEFAULT_COMMAND_TIMEOUT);
                    FSInfo.this.modinfo = ret.getOutput();
                }
                ep.setText("<html><pre>" + FSInfo.this.modinfo + "</html></pre>");
            }
        };
        Thread thread = new Thread(runnable);
        thread.setPriority(1);
        thread.start();
    }
}

