/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.resources;

import java.util.Map;
import lcmc.data.AccessMode;
import lcmc.data.Host;
import lcmc.data.ResourceAgent;
import lcmc.gui.Browser;
import lcmc.gui.resources.CommonDeviceInterface;
import lcmc.gui.resources.DrbdVolumeInfo;
import lcmc.gui.resources.DrbddiskInfo;
import lcmc.gui.resources.Info;
import lcmc.gui.resources.LinbitDrbdInfo;
import lcmc.gui.resources.ServiceInfo;
import lcmc.gui.resources.StringInfo;
import lcmc.gui.widget.Widget;
import lcmc.gui.widget.WidgetFactory;
import lcmc.utilities.SSH;
import lcmc.utilities.Tools;
import lcmc.utilities.WidgetListener;

final class FilesystemInfo
extends ServiceInfo {
    private LinbitDrbdInfo linbitDrbdInfo = null;
    private DrbddiskInfo drbddiskInfo = null;
    private Widget blockDeviceParamWi = null;
    private Widget fstypeParamWi = null;
    private boolean drbddiskIsPreferred = false;
    private static final String FS_RES_PARAM_DEV = "device";

    FilesystemInfo(String name, ResourceAgent ra, Browser browser) {
        super(name, ra, browser);
    }

    FilesystemInfo(String name, ResourceAgent ra, String hbId, Map<String, String> resourceNode, Browser browser) {
        super(name, ra, hbId, resourceNode, browser);
    }

    void setLinbitDrbdInfo(LinbitDrbdInfo linbitDrbdInfo) {
        this.linbitDrbdInfo = linbitDrbdInfo;
    }

    LinbitDrbdInfo getLinbitDrbdInfo() {
        return this.linbitDrbdInfo;
    }

    void setDrbddiskInfo(DrbddiskInfo drbddiskInfo) {
        this.drbddiskInfo = drbddiskInfo;
    }

    DrbddiskInfo getDrbddiskInfo() {
        return this.drbddiskInfo;
    }

    @Override
    boolean checkResourceFieldsCorrect(String param, String[] params) {
        boolean ret = super.checkResourceFieldsCorrect(param, params);
        if (!ret) {
            return false;
        }
        Widget wi = this.getWidget(FS_RES_PARAM_DEV, null);
        return wi != null && wi.getValue() != null;
    }

    @Override
    void apply(Host dcHost, boolean testOnly) {
        if (!testOnly) {
            Tools.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    FilesystemInfo.this.getApplyButton().setEnabled(false);
                    FilesystemInfo.this.getRevertButton().setEnabled(false);
                }
            });
            this.getInfoPanel();
            this.waitForInfoPanel();
            String dir = this.getComboBoxValue("directory");
            boolean confirm = false;
            for (Host host : this.getBrowser().getClusterHosts()) {
                String statCmd = "@DMCSUDO@stat -c \"%F\" " + dir + "||true";
                SSH.SSHOutput ret = Tools.execCommandProgressIndicator(host, statCmd, null, true, statCmd.replaceAll("@DMCSUDO@", ""), SSH.DEFAULT_COMMAND_TIMEOUT);
                if (ret != null && "directory".equals(ret.getOutput().trim())) continue;
                String title = Tools.getString("ClusterBrowser.CreateDir.Title");
                String desc = Tools.getString("ClusterBrowser.CreateDir.Description");
                title = title.replaceAll("@DIR@", dir);
                title = title.replaceAll("@HOST@", host.getName());
                desc = desc.replaceAll("@DIR@", dir);
                desc = desc.replaceAll("@HOST@", host.getName());
                if (!confirm && !Tools.confirmDialog(title, desc, Tools.getString("ClusterBrowser.CreateDir.Yes"), Tools.getString("ClusterBrowser.CreateDir.No"))) continue;
                String cmd = "@DMCSUDO@/bin/mkdir " + dir;
                Tools.execCommandProgressIndicator(host, cmd, null, true, cmd.replaceAll("@DMCSUDO@", ""), SSH.DEFAULT_COMMAND_TIMEOUT);
                confirm = true;
            }
        }
        super.apply(dcHost, testOnly);
    }

    private void addParamComboListeners(Widget paramWi) {
        paramWi.addListeners(new WidgetListener(){

            @Override
            public void check(Object value) {
                if (FilesystemInfo.this.fstypeParamWi != null) {
                    String createdFs;
                    if (!(value instanceof Info)) {
                        return;
                    }
                    Info item = (Info)value;
                    if (item.getInternalValue() == null || "".equals(item.getInternalValue())) {
                        return;
                    }
                    String selectedValue = FilesystemInfo.this.getParamSaved("fstype");
                    if (selectedValue == null || "".equals(selectedValue)) {
                        CommonDeviceInterface cdi = (CommonDeviceInterface)((Object)item);
                        createdFs = cdi.getCreatedFs();
                    } else {
                        createdFs = selectedValue;
                    }
                    if (createdFs != null && !"".equals(createdFs)) {
                        FilesystemInfo.this.fstypeParamWi.setValue(createdFs);
                    }
                }
            }
        });
    }

    @Override
    protected Widget createWidget(String param, String prefix, int width) {
        Widget paramWi;
        if (FS_RES_PARAM_DEV.equals(param)) {
            DrbdVolumeInfo selectedInfo;
            String selectedValue = this.getPreviouslySelected(param, prefix);
            if (selectedValue == null) {
                selectedValue = this.getParamSaved(param);
            }
            if ((selectedInfo = this.getBrowser().getDrbdVolumeFromDev(selectedValue)) != null) {
                selectedValue = selectedInfo.toString();
            }
            StringInfo defaultValue = null;
            if (selectedValue == null || "".equals(selectedValue)) {
                defaultValue = new StringInfo(Tools.getString("ClusterBrowser.SelectBlockDevice"), "", this.getBrowser());
            }
            Object[] commonBlockDevInfos = this.getCommonBlockDevInfos(defaultValue, this.getName());
            this.blockDeviceParamWi = WidgetFactory.createInstance(Widget.GUESS_TYPE, selectedValue, commonBlockDevInfos, Widget.NO_REGEXP, width, Widget.NO_ABBRV, new AccessMode(this.getAccessType(param), this.isEnabledOnlyInAdvancedMode(param)), Widget.NO_BUTTON);
            this.blockDeviceParamWi.setAlwaysEditable(true);
            paramWi = this.blockDeviceParamWi;
            this.addParamComboListeners(paramWi);
            this.widgetAdd(param, prefix, paramWi);
        } else if ("fstype".equals(param)) {
            String defaultValue = Tools.getString("ClusterBrowser.SelectFilesystem");
            String selectedValue = this.getPreviouslySelected(param, prefix);
            if (selectedValue == null) {
                selectedValue = this.getParamSaved(param);
            }
            if (selectedValue == null || "".equals(selectedValue)) {
                selectedValue = defaultValue;
            }
            this.fstypeParamWi = paramWi = WidgetFactory.createInstance(Widget.GUESS_TYPE, selectedValue, this.getBrowser().getCommonFileSystems(defaultValue), Widget.NO_REGEXP, width, Widget.NO_ABBRV, new AccessMode(this.getAccessType(param), this.isEnabledOnlyInAdvancedMode(param)), Widget.NO_BUTTON);
            this.widgetAdd(param, prefix, paramWi);
            paramWi.setEditable(false);
        } else if ("directory".equals(param)) {
            String[] cmp = this.getBrowser().getCommonMountPoints();
            Object[] items = new Object[cmp.length + 1];
            System.arraycopy(cmp, 0, items, 1, cmp.length);
            String defaultValue = Tools.getString("ClusterBrowser.SelectMountPoint");
            items[0] = new StringInfo(defaultValue, null, this.getBrowser());
            this.getResource().setPossibleChoices(param, items);
            String selectedValue = this.getPreviouslySelected(param, prefix);
            if (selectedValue == null) {
                selectedValue = this.getParamSaved(param);
            }
            if (selectedValue == null || "".equals(selectedValue)) {
                selectedValue = defaultValue;
            }
            String regexp = "^.+$";
            paramWi = WidgetFactory.createInstance(Widget.GUESS_TYPE, selectedValue, items, "^.+$", width, Widget.NO_ABBRV, new AccessMode(this.getAccessType(param), this.isEnabledOnlyInAdvancedMode(param)), Widget.NO_BUTTON);
            this.widgetAdd(param, prefix, paramWi);
            paramWi.setAlwaysEditable(true);
        } else {
            paramWi = super.createWidget(param, prefix, width);
        }
        return paramWi;
    }

    @Override
    public String toString() {
        String id = this.getService().getId();
        if (id == null) {
            return super.toString();
        }
        StringBuilder s = new StringBuilder(this.getName());
        DrbdVolumeInfo dvi = this.getBrowser().getDrbdVolumeFromDev(this.getParamSaved(FS_RES_PARAM_DEV));
        if (dvi == null) {
            id = this.getParamSaved(FS_RES_PARAM_DEV);
        } else {
            id = dvi.getDrbdResourceInfo().getName();
            s.delete(0, s.length());
            s.append("Filesystem / Drbd");
        }
        if (id == null || "".equals(id)) {
            id = Tools.getString("ClusterBrowser.ClusterBlockDevice.Unconfigured");
        }
        s.append(" (");
        s.append(id);
        s.append(')');
        return s.toString();
    }

    @Override
    protected void removeMyselfNoConfirm(Host dcHost, boolean testOnly) {
        final DrbdVolumeInfo oldDvi = this.getBrowser().getDrbdVolumeFromDev(this.getParamSaved(FS_RES_PARAM_DEV));
        super.removeMyselfNoConfirm(dcHost, testOnly);
        if (oldDvi != null && !testOnly) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    oldDvi.updateMenus(null);
                }
            });
            t.start();
        }
    }

    @Override
    void addResourceBefore(Host dcHost, boolean testOnly) {
        if (this.getGroupInfo() != null) {
            return;
        }
        final DrbdVolumeInfo oldDvi = this.getBrowser().getDrbdVolumeFromDev(this.getParamSaved(FS_RES_PARAM_DEV));
        if (oldDvi != null) {
            return;
        }
        DrbdVolumeInfo newDvi = this.getBrowser().getDrbdVolumeFromDev(this.getComboBoxValue(FS_RES_PARAM_DEV));
        if (newDvi == null || newDvi.equals(oldDvi)) {
            return;
        }
        boolean oldDrbddisk = false;
        oldDrbddisk = this.getDrbddiskInfo() == null ? this.drbddiskIsPreferred : true;
        if (oldDvi != null) {
            if (oldDrbddisk) {
                oldDvi.removeDrbdDisk(this, dcHost, testOnly);
            } else {
                oldDvi.removeLinbitDrbd(this, dcHost, testOnly);
            }
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    oldDvi.updateMenus(null);
                }
            });
            t.start();
            oldDvi.getDrbdResourceInfo().setUsedByCRM(null);
            if (oldDrbddisk) {
                this.setDrbddiskInfo(null);
            } else {
                this.setLinbitDrbdInfo(null);
            }
        }
        if (newDvi != null) {
            if (oldDrbddisk) {
                newDvi.addDrbdDisk(this, dcHost, testOnly);
            } else {
                newDvi.addLinbitDrbd(this, dcHost, testOnly);
            }
        }
    }

    @Override
    public int getUsed() {
        if (this.blockDeviceParamWi != null) {
            Object value = this.blockDeviceParamWi.getValue();
            if (Tools.isStringClass(value)) {
                return -1;
            }
            Info item = (Info)value;
            String sValue = item.getInternalValue();
            if (sValue == null || "".equals(sValue)) {
                return -1;
            }
            CommonDeviceInterface cdi = (CommonDeviceInterface)((Object)item);
            return cdi.getUsed();
        }
        return -1;
    }

    void setDrbddiskIsPreferred(boolean drbddiskIsPreferred) {
        this.drbddiskIsPreferred = drbddiskIsPreferred;
    }

    @Override
    public void reloadComboBoxes() {
        super.reloadComboBoxes();
        DrbdVolumeInfo selectedInfo = this.getBrowser().getDrbdVolumeFromDev(this.getParamSaved(FS_RES_PARAM_DEV));
        String selectedValue = null;
        selectedValue = selectedInfo == null ? this.getParamSaved(FS_RES_PARAM_DEV) : selectedInfo.toString();
        StringInfo defaultValue = null;
        if (selectedValue == null || "".equals(selectedValue)) {
            defaultValue = new StringInfo(Tools.getString("ClusterBrowser.SelectBlockDevice"), "", this.getBrowser());
        }
        Object[] commonBlockDevInfos = this.getCommonBlockDevInfos(defaultValue, this.getName());
        if (this.blockDeviceParamWi != null) {
            String value = this.blockDeviceParamWi.getStringValue();
            this.blockDeviceParamWi.reloadComboBox(value, commonBlockDevInfos);
        }
    }
}

