/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.resources;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import lcmc.data.AccessMode;
import lcmc.data.CRMXML;
import lcmc.data.ClusterStatus;
import lcmc.data.ConfigData;
import lcmc.data.Host;
import lcmc.data.HostLocation;
import lcmc.data.PtestData;
import lcmc.data.ResourceAgent;
import lcmc.data.Subtext;
import lcmc.data.resources.Service;
import lcmc.gui.Browser;
import lcmc.gui.ClusterBrowser;
import lcmc.gui.SpringUtilities;
import lcmc.gui.dialog.EditConfig;
import lcmc.gui.dialog.pacemaker.ServiceLogs;
import lcmc.gui.resources.CloneInfo;
import lcmc.gui.resources.CommonDeviceInterface;
import lcmc.gui.resources.ConstraintPHInfo;
import lcmc.gui.resources.DrbdResourceInfo;
import lcmc.gui.resources.DrbddiskInfo;
import lcmc.gui.resources.EditableInfo;
import lcmc.gui.resources.FilesystemInfo;
import lcmc.gui.resources.GroupInfo;
import lcmc.gui.resources.HbConnectionInfo;
import lcmc.gui.resources.HostInfo;
import lcmc.gui.resources.IPaddrInfo;
import lcmc.gui.resources.Info;
import lcmc.gui.resources.LinbitDrbdInfo;
import lcmc.gui.resources.PcmkRscSetsInfo;
import lcmc.gui.resources.ServicesInfo;
import lcmc.gui.resources.StringInfo;
import lcmc.gui.resources.VMSVirtualDomainInfo;
import lcmc.gui.resources.VirtualDomainInfo;
import lcmc.gui.widget.TextfieldWithUnit;
import lcmc.gui.widget.Widget;
import lcmc.gui.widget.WidgetFactory;
import lcmc.utilities.ButtonCallback;
import lcmc.utilities.CRM;
import lcmc.utilities.MyList;
import lcmc.utilities.MyListModel;
import lcmc.utilities.MyMenu;
import lcmc.utilities.MyMenuItem;
import lcmc.utilities.Tools;
import lcmc.utilities.Unit;
import lcmc.utilities.UpdatableItem;
import lcmc.utilities.WidgetListener;
import org.apache.commons.collections15.map.MultiKeyMap;

public class ServiceInfo
extends EditableInfo {
    private final Map<HostInfo, Widget> scoreComboBoxHash = new HashMap<HostInfo, Widget>();
    private final Map<HostInfo, HostLocation> savedHostLocations = new HashMap<HostInfo, HostLocation>();
    private Widget pingComboBox = null;
    private String savedPingOperation = null;
    private String savedMetaAttrsId = null;
    private String savedOperationsId = null;
    private final MultiKeyMap<String, String> savedOperation = new MultiKeyMap();
    private ServiceInfo savedMetaAttrInfoRef = null;
    private Widget sameAsMetaAttrsWi = null;
    private ServiceInfo savedOperationIdRef = null;
    private Widget sameAsOperationsWi = null;
    private final Lock mSavedOperationsLock = new ReentrantLock();
    private final ReadWriteLock mOperationsComboBoxHashLock = new ReentrantReadWriteLock();
    private final Lock mOperationsComboBoxHashReadLock = this.mOperationsComboBoxHashLock.readLock();
    private final Lock mOperationsComboBoxHashWriteLock = this.mOperationsComboBoxHashLock.writeLock();
    private final MultiKeyMap<String, Widget> operationsComboBoxHash = new MultiKeyMap();
    private JComponent infoPanel = null;
    private GroupInfo groupInfo = null;
    private volatile CloneInfo cloneInfo = null;
    private final ResourceAgent resourceAgent;
    private Widget typeRadioGroup;
    private static final String META_ATTRS_DEFAULT_VALUES_TEXT = "default values";
    private static final String META_ATTRS_DEFAULT_VALUES = "default";
    private static final String OPERATIONS_DEFAULT_VALUES_TEXT = "advisory minimum";
    private static final String OPERATIONS_DEFAULT_VALUES = "default";
    protected static final String CACHED_FIELD = "cached";
    static final String MASTER_SLAVE_TYPE_STRING = "Master/Slave";
    static final ImageIcon MANAGE_BY_CRM_ICON = Tools.createImageIcon(Tools.getDefault("ServiceInfo.ManageByCRMIcon"));
    static final ImageIcon UNMANAGE_BY_CRM_ICON = Tools.createImageIcon(Tools.getDefault("ServiceInfo.UnmanageByCRMIcon"));
    private static final ImageIcon UNMANAGE_ICON = Tools.createImageIcon(Tools.getDefault("CRMGraph.ServiceUnmanagedIcon"));
    public static final ImageIcon SERVICE_RUNNING_ICON_SMALL = Tools.createImageIcon(Tools.getDefault("ServiceInfo.ServiceRunningIconSmall"));
    private static final ImageIcon SERVICE_RUNNING_FAILED_ICON_SMALL = Tools.createImageIcon(Tools.getDefault("ServiceInfo.ServiceRunningFailedIconSmall"));
    private static final ImageIcon SERVICE_STARTED_ICON_SMALL = Tools.createImageIcon(Tools.getDefault("ServiceInfo.ServiceStartedIconSmall"));
    private static final ImageIcon SERVICE_STOPPING_ICON_SMALL = Tools.createImageIcon(Tools.getDefault("ServiceInfo.ServiceStoppingIconSmall"));
    public static final ImageIcon SERVICE_STOPPED_ICON_SMALL = Tools.createImageIcon(Tools.getDefault("ServiceInfo.ServiceStoppedIconSmall"));
    private static final ImageIcon SERVICE_STOPPED_FAILED_ICON_SMALL = Tools.createImageIcon(Tools.getDefault("ServiceInfo.ServiceStoppedFailedIconSmall"));
    static final ImageIcon SERVICE_RUNNING_ICON = Tools.createImageIcon(Tools.getDefault("CRMGraph.ServiceRunningIcon"));
    private static final ImageIcon SERVICE_STOPPED_ICON = Tools.createImageIcon(Tools.getDefault("CRMGraph.ServiceStoppedIcon"));
    static final ImageIcon START_ICON = SERVICE_RUNNING_ICON;
    static final ImageIcon STOP_ICON = SERVICE_STOPPED_ICON;
    protected static final ImageIcon MIGRATE_ICON = Tools.createImageIcon(Tools.getDefault("CRMGraph.MigrateIcon"));
    static final ImageIcon UNMIGRATE_ICON = Tools.createImageIcon(Tools.getDefault("CRMGraph.UnmigrateIcon"));
    static final ImageIcon GROUP_UP_ICON = Tools.createImageIcon(Tools.getDefault("CRMGraph.GroupUp"));
    static final ImageIcon GROUP_DOWN_ICON = Tools.createImageIcon(Tools.getDefault("CRMGraph.GroupDown"));
    private static final Subtext ORPHANED_SUBTEXT = new Subtext("(LRM)", null, Color.BLACK);
    private static final Subtext ORPHANED_FAILED_SUBTEXT = new Subtext("(ORPHANED)", null, Color.RED);
    private static final Subtext UNMANAGED_SUBTEXT = new Subtext("(unmanaged)", null, Color.RED);
    private static final Subtext MIGRATED_SUBTEXT = new Subtext("(migrated)", null, Color.RED);
    protected static final String CLONE_TYPE_STRING = "Clone";
    private static final String PRIMITIVE_TYPE_STRING = "Primitive";
    public static final String GUI_ID = "__drbdmcid";
    public static final String PCMK_ID = "__pckmkid";
    static final String IS_BEING_REMOVED_STRING = "it is being removed";
    static final String IS_ORPHANED_STRING = "cannot do that to an ophan";
    static final String IS_NEW_STRING = "it is not applied yet";
    private static final Map<String, String> PING_ATTRIBUTES = new HashMap<String, String>();

    ServiceInfo(String name, ResourceAgent resourceAgent, Browser browser) {
        super(name, browser);
        this.resourceAgent = resourceAgent;
        if (resourceAgent != null && resourceAgent.isStonith()) {
            this.setResource(new Service(name.replaceAll("/", "_")));
            this.getService().setStonith(true);
        } else {
            this.setResource(new Service(name));
        }
        this.getService().setNew(true);
    }

    ServiceInfo(String name, ResourceAgent ra, String heartbeatId, Map<String, String> resourceNode, Browser browser) {
        this(name, ra, browser);
        this.getService().setHeartbeatId(heartbeatId);
        this.setParameters(resourceNode);
    }

    @Override
    public String getId() {
        return this.getService().getHeartbeatId();
    }

    @Override
    protected ClusterBrowser getBrowser() {
        return (ClusterBrowser)super.getBrowser();
    }

    public void setInfoPanel(JPanel infoPanel) {
        this.infoPanel = infoPanel;
    }

    boolean isOfflineNode(String node) {
        return "no".equals(this.getBrowser().getClusterStatus().isOnlineNode(node));
    }

    @Override
    boolean checkResourceFieldsCorrect(String param, String[] params) {
        return this.checkResourceFieldsCorrect(param, params, false, false, false);
    }

    boolean checkResourceFieldsCorrect(String param, String[] params, boolean fromServicesInfo, boolean fromCloneInfo, boolean fromGroupInfo) {
        if (this.getComboBoxValue(GUI_ID) == null) {
            return true;
        }
        CloneInfo ci = this.getCloneInfo();
        if (!fromCloneInfo && ci != null) {
            return ci.checkResourceFieldsCorrect(param, ci.getParametersFromXML(), fromServicesInfo);
        }
        GroupInfo gi = this.getGroupInfo();
        if (!fromGroupInfo && gi != null && !gi.checkResourceFieldsCorrect(param, gi.getParametersFromXML(), fromServicesInfo, fromCloneInfo)) {
            return false;
        }
        if (!fromGroupInfo && gi != null && !fromServicesInfo) {
            gi.setApplyButtons(null, gi.getParametersFromXML());
        }
        if (this.getService().isOrphaned()) {
            return false;
        }
        String id = this.getComboBoxValue(GUI_ID);
        ServiceInfo si = this.getBrowser().getServiceInfoFromId(this.getService().getName(), id);
        if (si != null && si != this && !si.getService().isOrphaned()) {
            return false;
        }
        if (!super.checkResourceFieldsCorrect(param, params)) {
            return false;
        }
        if (ci == null) {
            boolean on = false;
            for (Host host : this.getBrowser().getClusterHosts()) {
                JLabel label;
                HostInfo hi = host.getBrowser().getHostInfo();
                Widget wi = this.scoreComboBoxHash.get(hi);
                if (wi == null || (label = wi.getLabel()) == null) continue;
                String op = this.getOpFromLabel(hi.getName(), label.getText());
                if (wi.getValue() != null && !"eq".equals(op)) continue;
                on = true;
                break;
            }
            if (!on) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean checkResourceFieldsChanged(String param, String[] params) {
        return this.checkResourceFieldsChanged(param, params, false, false, false);
    }

    public boolean checkResourceFieldsChanged(String param, String[] params, boolean fromServicesInfo, boolean fromCloneInfo, boolean fromGroupInfo) {
        String id = this.getComboBoxValue(GUI_ID);
        CloneInfo ci = this.getCloneInfo();
        if (!fromCloneInfo && ci != null) {
            return ci.checkResourceFieldsChanged(param, ci.getParametersFromXML(), fromServicesInfo);
        }
        GroupInfo gi = this.getGroupInfo();
        if (!fromGroupInfo && gi != null && !fromServicesInfo) {
            gi.setApplyButtons(null, gi.getParametersFromXML());
        }
        if (id == null) {
            return false;
        }
        boolean changed = false;
        if (super.checkResourceFieldsChanged(param, params)) {
            changed = true;
        }
        boolean allMetaAttrsAreDefaultValues = true;
        if (params != null) {
            for (String otherParam : params) {
                String defaultValue;
                Object newValue;
                Widget wi;
                if (!this.isMetaAttr(otherParam) || (wi = this.getWidget(otherParam, null)) == null || Tools.areEqual(newValue = wi.getValue(), defaultValue = this.getParamDefault(otherParam))) continue;
                allMetaAttrsAreDefaultValues = false;
            }
        }
        String heartbeatId = this.getService().getHeartbeatId();
        if ("Group".equals(this.getName())) {
            if (heartbeatId == null) {
                changed = true;
            } else if (heartbeatId.equals("grp_" + id) || heartbeatId.equals(id)) {
                if (this.checkHostLocationsFieldsChanged() || this.checkOperationFieldsChanged()) {
                    changed = true;
                }
            } else {
                changed = true;
            }
        } else if ("Clone Set".equals(this.getName()) || "Master/Slave Set".equals(this.getName())) {
            String prefix = this.getService().isMaster() ? "ms_" : "cl_";
            if (heartbeatId.equals(prefix + id) || heartbeatId.equals(id)) {
                if (this.checkHostLocationsFieldsChanged()) {
                    changed = true;
                }
            } else {
                changed = true;
            }
        } else if (heartbeatId != null) {
            if (heartbeatId.equals("res_" + this.getService().getName() + "_" + id) || heartbeatId.equals("stonith_" + this.getService().getName() + "_" + id) || heartbeatId.equals(id)) {
                if (this.checkHostLocationsFieldsChanged() || this.checkOperationFieldsChanged()) {
                    changed = true;
                }
            } else {
                changed = true;
            }
        }
        String cl = this.getService().getResourceClass();
        if (cl != null && (cl.equals("heartbeat") || ResourceAgent.SERVICE_CLASSES.contains(cl))) {
            boolean visible = false;
            Component wi = null;
            for (int i = params.length - 1; i >= 0; --i) {
                Widget prevWi = this.getWidget(params[i], null);
                if (prevWi == null) continue;
                if (!visible && !prevWi.getStringValue().equals("")) {
                    visible = true;
                }
                if (wi != null && wi.isVisible() != visible) {
                    boolean v = visible;
                    Component c = wi;
                    SwingUtilities.invokeLater(new Runnable((Widget)c, v){
                        final /* synthetic */ Widget val$c;
                        final /* synthetic */ boolean val$v;
                        {
                            this.val$c = widget;
                            this.val$v = bl;
                        }

                        @Override
                        public void run() {
                            this.val$c.setVisible(this.val$v);
                            ServiceInfo.this.getLabel(this.val$c).setVisible(this.val$v);
                        }
                    });
                }
                wi = prevWi;
            }
        }
        if (this.sameAsMetaAttrsWi != null) {
            boolean nothingSelected;
            Info info = this.sameAsMetaAttrsWiValue();
            boolean defaultValues = info != null && META_ATTRS_DEFAULT_VALUES_TEXT.equals(info.toString());
            boolean bl = nothingSelected = info == null || Widget.NOTHING_SELECTED_DISPLAY.equals(info.toString());
            if (!nothingSelected && !defaultValues && info != this.savedMetaAttrInfoRef) {
                changed = true;
            } else {
                if ((nothingSelected || defaultValues) && this.savedMetaAttrInfoRef != null) {
                    changed = true;
                }
                if (this.savedMetaAttrInfoRef == null && defaultValues != allMetaAttrsAreDefaultValues) {
                    if (allMetaAttrsAreDefaultValues) {
                        this.sameAsMetaAttrsWi.setValueNoListeners(META_ATTRS_DEFAULT_VALUES_TEXT);
                    } else {
                        this.sameAsMetaAttrsWi.setValueNoListeners(Widget.NOTHING_SELECTED_INTERNAL);
                    }
                }
            }
            this.sameAsMetaAttrsWi.processAccessMode();
        }
        if (!fromServicesInfo) {
            ServicesInfo sis = this.getBrowser().getServicesInfo();
            sis.setApplyButtons(null, sis.getParametersFromXML());
        }
        return changed;
    }

    private String getOpDefaultsDefault(String param) {
        assert (param != null);
        ClusterStatus cs = this.getBrowser().getClusterStatus();
        if (cs != null) {
            return cs.getOpDefaultsValuePairs().get(param);
        }
        return null;
    }

    void setParameters(Map<String, String> resourceNode) {
        Widget wi;
        if (resourceNode == null) {
            return;
        }
        boolean infoPanelOk = this.isInfoPanelOk();
        CRMXML crmXML = this.getBrowser().getCRMXML();
        if (crmXML == null) {
            Tools.appError("crmXML is null");
            return;
        }
        String[] params = this.getEnabledSectionParams(crmXML.getParameters(this.resourceAgent, this.getService().isMaster()));
        ClusterStatus cs = this.getBrowser().getClusterStatus();
        if (params != null) {
            boolean allMetaAttrsAreDefaultValues = true;
            boolean allSavedMetaAttrsAreDefaultValues = true;
            String newMetaAttrsId = cs.getMetaAttrsId(this.getService().getHeartbeatId());
            if (this.savedMetaAttrsId == null && newMetaAttrsId != null || this.savedMetaAttrsId != null && !this.savedMetaAttrsId.equals(newMetaAttrsId)) {
                this.getBrowser().reloadAllComboBoxes(this);
            }
            this.savedMetaAttrsId = newMetaAttrsId;
            String refCRMId = cs.getMetaAttrsRef(this.getService().getHeartbeatId());
            ServiceInfo metaAttrInfoRef = this.getBrowser().getServiceInfoFromCRMId(refCRMId);
            if (refCRMId == null) {
                refCRMId = this.getService().getHeartbeatId();
            }
            resourceNode.put(PCMK_ID, this.getService().getHeartbeatId());
            resourceNode.put(GUI_ID, this.getService().getId());
            for (String param : params) {
                boolean haveChanged;
                String value = this.isMetaAttr(param) && refCRMId != null ? cs.getParameter(refCRMId, param, false) : resourceNode.get(param);
                String defaultValue = this.getParamDefault(param);
                if (value == null) {
                    value = defaultValue;
                }
                if (value == null) {
                    value = "";
                }
                String oldValue = this.getResource().getValue(param);
                if (this.isMetaAttr(param)) {
                    if (!Tools.areEqual(defaultValue, value)) {
                        allMetaAttrsAreDefaultValues = false;
                    }
                    if (!Tools.areEqual(defaultValue, oldValue)) {
                        allSavedMetaAttrsAreDefaultValues = false;
                    }
                }
                if (!infoPanelOk) continue;
                Widget wi2 = this.getWidget(param, null);
                boolean bl = haveChanged = !Tools.areEqual(value, oldValue) || !Tools.areEqual(defaultValue, this.getResource().getDefaultValue(param));
                if (!haveChanged && (metaAttrInfoRef == null || !this.isMetaAttr(param))) continue;
                this.getResource().setValue(param, value);
                this.getResource().setDefaultValue(param, defaultValue);
                if (wi2 == null || metaAttrInfoRef != null) continue;
                wi2.setValue(value);
            }
            if (!Tools.areEqual(metaAttrInfoRef, this.savedMetaAttrInfoRef)) {
                this.savedMetaAttrInfoRef = metaAttrInfoRef;
                if (this.sameAsMetaAttrsWi != null) {
                    if (metaAttrInfoRef == null) {
                        if (allMetaAttrsAreDefaultValues) {
                            if (!allSavedMetaAttrsAreDefaultValues) {
                                this.sameAsMetaAttrsWi.setValue(META_ATTRS_DEFAULT_VALUES_TEXT);
                            }
                        } else if (metaAttrInfoRef != null) {
                            this.sameAsMetaAttrsWi.setValue(Widget.NOTHING_SELECTED_INTERNAL);
                        }
                    } else {
                        this.sameAsMetaAttrsWi.setValue(metaAttrInfoRef);
                    }
                }
            }
        }
        for (Host host : this.getBrowser().getClusterHosts()) {
            Widget wi3;
            HostLocation savedLocation;
            HostInfo hi = host.getBrowser().getHostInfo();
            HostLocation hostLocation = cs.getScore(this.getService().getHeartbeatId(), hi.getName(), false);
            if (Tools.areEqual(hostLocation, savedLocation = this.savedHostLocations.get(hi))) continue;
            if (hostLocation == null) {
                this.savedHostLocations.remove(hi);
            } else {
                this.savedHostLocations.put(hi, hostLocation);
            }
            if (!infoPanelOk || (wi3 = this.scoreComboBoxHash.get(hi)) == null) continue;
            String score = null;
            String op = null;
            if (hostLocation != null) {
                score = hostLocation.getScore();
                op = hostLocation.getOperation();
            }
            wi3.setValue(score);
            JLabel label = wi3.getLabel();
            String text = this.getHostLocationLabel(hi.getName(), op);
            label.setText(text);
        }
        HostLocation hostLocation = cs.getPingScore(this.getService().getHeartbeatId(), false);
        String pingOperation = null;
        if (hostLocation != null) {
            String op = hostLocation.getOperation();
            String value = hostLocation.getValue();
            pingOperation = "eq".equals(op) && "0".equals(value) ? "eq0" : hostLocation.getOperation();
        }
        if (!Tools.areEqual(pingOperation, this.savedPingOperation)) {
            this.savedPingOperation = pingOperation;
        }
        if (infoPanelOk && (wi = this.pingComboBox) != null) {
            if (pingOperation == null) {
                wi.setValue(Widget.NOTHING_SELECTED_INTERNAL);
            } else {
                wi.setValue(PING_ATTRIBUTES.get(pingOperation));
            }
        }
        boolean allAreDefaultValues = true;
        boolean allSavedAreDefaultValues = true;
        String newOperationsId = cs.getOperationsId(this.getService().getHeartbeatId());
        if (this.savedOperationsId == null && newOperationsId != null || this.savedOperationsId != null && !this.savedOperationsId.equals(newOperationsId)) {
            this.getBrowser().reloadAllComboBoxes(this);
        }
        this.savedOperationsId = newOperationsId;
        String refCRMId = cs.getOperationsRef(this.getService().getHeartbeatId());
        final ServiceInfo operationIdRef = this.getBrowser().getServiceInfoFromCRMId(refCRMId);
        if (refCRMId == null) {
            refCRMId = this.getService().getHeartbeatId();
        }
        this.mSavedOperationsLock.lock();
        for (String op : this.getResourceAgent().getOperationNames()) {
            for (String param : this.getBrowser().getCRMOperationParams(op)) {
                String value;
                String defaultValue = this.resourceAgent.getOperationDefault(op, param);
                if (defaultValue == null) continue;
                if (ClusterBrowser.HB_OP_IGNORE_DEFAULT.contains(op)) {
                    defaultValue = "";
                }
                if ((value = cs.getOperation(refCRMId, op, param)) == null || "".equals(value)) {
                    value = this.getOpDefaultsDefault(param);
                }
                if (value == null) {
                    value = "";
                }
                if (!defaultValue.equals(value)) {
                    allAreDefaultValues = false;
                }
                if (defaultValue.equals(this.savedOperation.get((K[])new String[]{op, param}))) continue;
                allSavedAreDefaultValues = false;
            }
        }
        boolean sameAs = false;
        if (!Tools.areEqual(operationIdRef, this.savedOperationIdRef)) {
            this.savedOperationIdRef = operationIdRef;
            if (this.sameAsOperationsWi != null) {
                if (operationIdRef == null) {
                    if (allAreDefaultValues) {
                        if (!allSavedAreDefaultValues) {
                            this.sameAsOperationsWi.setValue(OPERATIONS_DEFAULT_VALUES_TEXT);
                        }
                    } else if (this.savedOperationIdRef != null) {
                        this.sameAsOperationsWi.setValue(Widget.NOTHING_SELECTED_INTERNAL);
                    }
                } else {
                    sameAs = false;
                    this.sameAsOperationsWi.setValue(operationIdRef);
                }
            }
        }
        if (!sameAs) {
            for (String op : this.getResourceAgent().getOperationNames()) {
                for (String param : this.getBrowser().getCRMOperationParams(op)) {
                    String value;
                    String defaultValue = this.resourceAgent.getOperationDefault(op, param);
                    if (defaultValue == null) continue;
                    if (ClusterBrowser.HB_OP_IGNORE_DEFAULT.contains(op)) {
                        defaultValue = "";
                    }
                    if ((value = cs.getOperation(refCRMId, op, param)) == null || "".equals(value)) {
                        value = this.getOpDefaultsDefault(param);
                    }
                    if (value == null) {
                        value = "";
                    }
                    if (value.equals(this.savedOperation.get((K[])new String[]{op, param}))) continue;
                    this.savedOperation.put(op, param, value);
                    if (!infoPanelOk) continue;
                    this.mOperationsComboBoxHashReadLock.lock();
                    final Widget wi4 = this.operationsComboBoxHash.get((K[])new String[]{op, param});
                    this.mOperationsComboBoxHashReadLock.unlock();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            wi4.setEnabled(operationIdRef == null);
                        }
                    });
                    if (value == null) continue;
                    wi4.setValue(value);
                }
            }
        }
        this.mSavedOperationsLock.unlock();
        this.getService().setAvailable();
        if (cs.isOrphaned(this.getHeartbeatId(false))) {
            this.getService().setOrphaned(true);
            this.getService().setNew(false);
            CloneInfo ci = this.getCloneInfo();
            if (ci != null) {
                ci.getService().setNew(false);
            }
        } else {
            this.getService().setOrphaned(false);
        }
    }

    String getNameForLog() {
        return this.getName();
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder(30);
        String provider = this.resourceAgent.getProvider();
        if (!"heartbeat".equals(provider) && !"".equals(provider)) {
            s.append(provider);
            s.append(':');
        }
        s.append(this.getName());
        String string = this.getService().getId();
        if (string == null) {
            s.insert(0, "new ");
        } else if (!"".equals(string)) {
            s.append(" (");
            s.append(string);
            s.append(')');
        }
        return s.toString();
    }

    List<String> getMasterOnNodes(boolean testOnly) {
        return this.getBrowser().getClusterStatus().getMasterOnNodes(this.getHeartbeatId(testOnly), testOnly);
    }

    List<String> getRunningOnNodes(boolean testOnly) {
        return this.getBrowser().getClusterStatus().getRunningOnNodes(this.getHeartbeatId(testOnly), testOnly);
    }

    boolean isStarted(boolean testOnly) {
        String targetRole;
        Host dcHost = this.getBrowser().getDCHost();
        String hbV = dcHost.getHeartbeatVersion();
        String pmV = dcHost.getPacemakerVersion();
        String targetRoleString = "target-role";
        if (Tools.versionBeforePacemaker(dcHost)) {
            targetRoleString = "target_role";
        }
        String crmId = this.getHeartbeatId(testOnly);
        ClusterStatus cs = this.getBrowser().getClusterStatus();
        String refCRMId = cs.getMetaAttrsRef(crmId);
        if (refCRMId != null) {
            crmId = refCRMId;
        }
        if ((targetRole = cs.getParameter(crmId, targetRoleString, testOnly)) == null) {
            targetRole = this.getParamDefault(targetRoleString);
        }
        return !"stopped".equals(targetRole);
    }

    public boolean isEnslaved(boolean testOnly) {
        String targetRole;
        Host dcHost = this.getBrowser().getDCHost();
        String targetRoleString = "target-role";
        if (Tools.versionBeforePacemaker(dcHost)) {
            targetRoleString = "target_role";
        }
        String crmId = this.getHeartbeatId(testOnly);
        ClusterStatus cs = this.getBrowser().getClusterStatus();
        String refCRMId = cs.getMetaAttrsRef(crmId);
        if (refCRMId != null) {
            crmId = refCRMId;
        }
        if ((targetRole = cs.getParameter(crmId, targetRoleString, testOnly)) == null) {
            targetRole = this.getParamDefault(targetRoleString);
        }
        return "slave".equals(targetRole);
    }

    public boolean isStopped(boolean testOnly) {
        String targetRole;
        Host dcHost = this.getBrowser().getDCHost();
        String targetRoleString = "target-role";
        if (Tools.versionBeforePacemaker(dcHost)) {
            targetRoleString = "target_role";
        }
        String crmId = this.getHeartbeatId(testOnly);
        ClusterStatus cs = this.getBrowser().getClusterStatus();
        String refCRMId = cs.getMetaAttrsRef(crmId);
        if (refCRMId != null) {
            crmId = refCRMId;
        }
        if ((targetRole = cs.getParameter(crmId, targetRoleString, testOnly)) == null) {
            targetRole = this.getParamDefault(targetRoleString);
        }
        return "stopped".equals(targetRole);
    }

    boolean isGroupStopped(boolean testOnly) {
        return false;
    }

    public boolean isManaged(boolean testOnly) {
        return this.getBrowser().getClusterStatus().isManaged(this.getHeartbeatId(testOnly), testOnly);
    }

    public List<Host> getMigratedTo(boolean testOnly) {
        ClusterStatus cs = this.getBrowser().getClusterStatus();
        for (Host host : this.getBrowser().getClusterHosts()) {
            String locationId = cs.getLocationId(this.getHeartbeatId(testOnly), host.getName(), testOnly);
            if (locationId == null || !locationId.startsWith("cli-prefer-") && !locationId.startsWith("cli-standby-")) continue;
            HostInfo hi = host.getBrowser().getHostInfo();
            HostLocation hostLocation = cs.getScore(this.getHeartbeatId(testOnly), hi.getName(), testOnly);
            String score = null;
            String op = null;
            if (hostLocation != null) {
                score = hostLocation.getScore();
                op = hostLocation.getOperation();
            }
            if (!"INFINITY".equals(score) && !"+INFINITY".equals(score) || !"eq".equals(op)) continue;
            ArrayList<Host> hosts = new ArrayList<Host>();
            hosts.add(host);
            return hosts;
        }
        return null;
    }

    public List<Host> getMigratedFrom(boolean testOnly) {
        ClusterStatus cs = this.getBrowser().getClusterStatus();
        for (Host host : this.getBrowser().getClusterHosts()) {
            String locationId = cs.getLocationId(this.getHeartbeatId(testOnly), host.getName(), testOnly);
            if (locationId == null || !locationId.startsWith("cli-prefer-") && !locationId.startsWith("cli-standby-")) continue;
            HostInfo hi = host.getBrowser().getHostInfo();
            HostLocation hostLocation = cs.getScore(this.getHeartbeatId(testOnly), hi.getName(), testOnly);
            String score = null;
            String op = null;
            if (hostLocation != null) {
                score = hostLocation.getScore();
                op = hostLocation.getOperation();
            }
            if (!"-INFINITY".equals(score) || !"eq".equals(op)) continue;
            ArrayList<Host> hosts = new ArrayList<Host>();
            hosts.add(host);
            return hosts;
        }
        return null;
    }

    public boolean isRunning(boolean testOnly) {
        List<String> runningOnNodes = this.getRunningOnNodes(testOnly);
        return runningOnNodes != null && !runningOnNodes.isEmpty();
    }

    private String getFailCountString(String hostName, boolean testOnly) {
        String fcString = "";
        String failCount = this.getFailCount(hostName, testOnly);
        if (failCount != null) {
            fcString = "INFINITY".equals(failCount) ? " failed" : " failed: " + failCount;
        }
        return fcString;
    }

    protected String getFailCount(String hostName, boolean testOnly) {
        ClusterStatus cs = this.getBrowser().getClusterStatus();
        return cs.getFailCount(hostName, this.getHeartbeatId(testOnly), testOnly);
    }

    protected String getPingCount(String hostName, boolean testOnly) {
        ClusterStatus cs = this.getBrowser().getClusterStatus();
        return cs.getPingCount(hostName, testOnly);
    }

    protected String getPingCountString(String hostName, boolean testOnly) {
        if (!this.resourceAgent.isPingService()) {
            return "";
        }
        String pingCount = this.getPingCount(hostName, testOnly);
        if (pingCount == null || "0".equals(pingCount)) {
            return " / no ping";
        }
        return " / ping: " + pingCount;
    }

    protected final boolean isInLRMOnHost(String hostName, boolean testOnly) {
        ClusterStatus cs = this.getBrowser().getClusterStatus();
        return cs.isInLRMOnHost(hostName, this.getHeartbeatId(testOnly), testOnly);
    }

    protected final boolean failedOnHost(String hostName, boolean testOnly) {
        String failCount = this.getFailCount(hostName, testOnly);
        return failCount != null && "INFINITY".equals(failCount);
    }

    public boolean isFailed(boolean testOnly) {
        if (this.isRunning(testOnly)) {
            return false;
        }
        for (Host host : this.getBrowser().getClusterHosts()) {
            if (!host.isClStatus() || !this.failedOnHost(host.getName(), testOnly)) continue;
            return true;
        }
        return false;
    }

    boolean isOneFailed(boolean testOnly) {
        for (Host host : this.getBrowser().getClusterHosts()) {
            if (!this.failedOnHost(host.getName(), testOnly)) continue;
            return true;
        }
        return false;
    }

    boolean isOneFailedCount(boolean testOnly) {
        for (Host host : this.getBrowser().getClusterHosts()) {
            if (this.getFailCount(host.getName(), testOnly) == null) continue;
            return true;
        }
        return false;
    }

    void setManaged(boolean isManaged, Host dcHost, boolean testOnly) {
        if (!testOnly) {
            this.setUpdated(true);
        }
        CRM.setManaged(dcHost, this.getHeartbeatId(testOnly), isManaged, testOnly);
    }

    public List<Color> getHostColors(boolean testOnly) {
        return this.getBrowser().getCluster().getHostColors(this.getRunningOnNodes(testOnly));
    }

    @Override
    public ImageIcon getMenuIcon(boolean testOnly) {
        if (this.isFailed(testOnly)) {
            if (this.isRunning(testOnly)) {
                return SERVICE_RUNNING_FAILED_ICON_SMALL;
            }
            return SERVICE_STOPPED_FAILED_ICON_SMALL;
        }
        if (this.isStopped(testOnly) || this.getBrowser().allHostsDown()) {
            if (this.isRunning(testOnly)) {
                return SERVICE_STOPPING_ICON_SMALL;
            }
            return SERVICE_STOPPED_ICON_SMALL;
        }
        if (this.isRunning(testOnly)) {
            return SERVICE_RUNNING_ICON_SMALL;
        }
        return SERVICE_STARTED_ICON_SMALL;
    }

    Map<HostInfo, HostLocation> getSavedHostLocations() {
        return this.savedHostLocations;
    }

    List<String> getHostNames() {
        ArrayList<String> hostNames = new ArrayList<String>();
        Enumeration<TreeNode> e = this.getBrowser().getClusterHostsNode().children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
            String hostName = ((HostInfo)n.getUserObject()).getName();
            hostNames.add(hostName);
        }
        return hostNames;
    }

    protected Info[] enumToInfoArray(Info defaultValue, String serviceName, Enumeration<DefaultMutableTreeNode> e) {
        ArrayList<Info> list = new ArrayList<Info>();
        if (defaultValue != null) {
            list.add(defaultValue);
        }
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode n = e.nextElement();
            Info i = (Info)n.getUserObject();
            String name = i.getName();
            ServiceInfo si = this.getBrowser().getServiceInfoFromId(serviceName, i.getName());
            if (si != null || name.equals(defaultValue)) continue;
            list.add(i);
        }
        return list.toArray(new Info[list.size()]);
    }

    private void storeHostLocations() {
        this.savedHostLocations.clear();
        for (Host host : this.getBrowser().getClusterHosts()) {
            HostInfo hi = host.getBrowser().getHostInfo();
            Widget wi = this.scoreComboBoxHash.get(hi);
            String score = wi.getStringValue();
            String op = this.getOpFromLabel(hi.getName(), wi.getLabel().getText());
            if (score == null || "".equals(score)) {
                this.savedHostLocations.remove(hi);
                continue;
            }
            this.savedHostLocations.put(hi, new HostLocation(score, op, null, null));
        }
        Object o = this.pingComboBox.getValue();
        String value = null;
        if (o != null) {
            value = ((StringInfo)o).getInternalValue();
        }
        this.savedPingOperation = value;
    }

    private boolean checkOperationFieldsChanged() {
        boolean changed = false;
        boolean allAreDefaultValues = true;
        this.mSavedOperationsLock.lock();
        for (String op : this.getResourceAgent().getOperationNames()) {
            for (String param : this.getBrowser().getCRMOperationParams(op)) {
                String defaultValue = this.resourceAgent.getOperationDefault(op, param);
                if (defaultValue == null) continue;
                if (ClusterBrowser.HB_OP_IGNORE_DEFAULT.contains(op)) {
                    defaultValue = "";
                }
                this.mOperationsComboBoxHashReadLock.lock();
                Widget wi = this.operationsComboBoxHash.get((K[])new String[]{op, param});
                this.mOperationsComboBoxHashReadLock.unlock();
                if (wi == null) continue;
                if ("OCF_CHECK_LEVEL".equals(param)) {
                    String savedOp;
                    Object value = wi.getValue();
                    if (!Tools.areEqual(value, defaultValue)) {
                        allAreDefaultValues = false;
                    }
                    if ((savedOp = this.savedOperation.get((K[])new String[]{op, param})) == null) {
                        if (!Tools.areEqual(value, defaultValue)) {
                            changed = true;
                        }
                    } else if (!Tools.areEqual(value, savedOp)) {
                        changed = true;
                    }
                    wi.setBackground(defaultValue, savedOp, false);
                    continue;
                }
                Object[] defaultValueE = Tools.extractUnit(defaultValue);
                Object[] value = wi.getValue();
                if (Tools.areEqual(value, new Object[]{"", ""})) {
                    value = new Object[]{this.getOpDefaultsDefault(param), null};
                }
                if (!Tools.areEqual(value, defaultValueE)) {
                    allAreDefaultValues = false;
                }
                String savedOp = this.savedOperation.get((K[])new String[]{op, param});
                Object[] savedOpE = Tools.extractUnit(savedOp);
                if (savedOp == null) {
                    if (!Tools.areEqual(value, defaultValueE)) {
                        changed = true;
                    }
                } else if (!Tools.areEqual(value, savedOpE)) {
                    changed = true;
                }
                wi.setBackground(defaultValueE, savedOpE, false);
            }
        }
        if (this.sameAsOperationsWi != null) {
            boolean nothingSelected;
            Info info = this.sameAsOperationsWiValue();
            boolean defaultValues = info != null && OPERATIONS_DEFAULT_VALUES_TEXT.equals(info.toString());
            boolean bl = nothingSelected = info == null || Widget.NOTHING_SELECTED_DISPLAY.equals(info.toString());
            if (!nothingSelected && !defaultValues && info != this.savedOperationIdRef) {
                changed = true;
            } else {
                if ((nothingSelected || defaultValues) && this.savedOperationIdRef != null) {
                    changed = true;
                }
                if (this.savedOperationIdRef == null && defaultValues != allAreDefaultValues) {
                    if (allAreDefaultValues) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ServiceInfo.this.sameAsOperationsWi.setValueNoListeners(ServiceInfo.OPERATIONS_DEFAULT_VALUES_TEXT);
                            }
                        });
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ServiceInfo.this.sameAsOperationsWi.setValueNoListeners(Widget.NOTHING_SELECTED_INTERNAL);
                            }
                        });
                    }
                }
            }
            this.sameAsOperationsWi.processAccessMode();
        }
        this.mSavedOperationsLock.unlock();
        return changed;
    }

    private boolean checkHostLocationsFieldsChanged() {
        boolean changed = false;
        for (Host host : this.getBrowser().getClusterHosts()) {
            HostInfo hi = host.getBrowser().getHostInfo();
            Widget wi = this.scoreComboBoxHash.get(hi);
            HostLocation hlSaved = this.savedHostLocations.get(hi);
            String hsSaved = null;
            String opSaved = null;
            if (hlSaved != null) {
                hsSaved = hlSaved.getScore();
                opSaved = hlSaved.getOperation();
            }
            String opSavedLabel = this.getHostLocationLabel(host.getName(), opSaved);
            if (wi == null) continue;
            String labelText = null;
            if (wi.getLabel() != null) {
                labelText = wi.getLabel().getText();
            }
            if (!Tools.areEqual(hsSaved, wi.getStringValue()) || !Tools.areEqual(opSavedLabel, labelText) && hsSaved != null && !"".equals(hsSaved)) {
                changed = true;
            }
            wi.setBackground(this.getHostLocationLabel(host.getName(), "eq"), null, opSavedLabel, hsSaved, false);
        }
        Widget pwi = this.pingComboBox;
        if (pwi != null) {
            if (!Tools.areEqual(this.savedPingOperation, pwi.getValue())) {
                changed = true;
            }
            pwi.setBackground(null, this.savedPingOperation, false);
        }
        return changed;
    }

    List<ResourceAgent> getAddServiceList(String cl) {
        return this.getBrowser().globalGetAddServiceList(cl);
    }

    Info[] getCommonBlockDevInfos(Info defaultValue, String serviceName) {
        ArrayList<Info> list = new ArrayList<Info>();
        Enumeration<TreeNode> drbdResources = this.getBrowser().getDrbdNode().children();
        if (defaultValue != null) {
            list.add(defaultValue);
        }
        while (drbdResources.hasMoreElements()) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)drbdResources.nextElement();
            DrbdResourceInfo drbdRes = (DrbdResourceInfo)n.getUserObject();
            DefaultMutableTreeNode drbdResNode = drbdRes.getNode();
            if (drbdResNode == null) continue;
            Enumeration<TreeNode> drbdVolumes = drbdResNode.children();
            while (drbdVolumes.hasMoreElements()) {
                DefaultMutableTreeNode vn = (DefaultMutableTreeNode)drbdVolumes.nextElement();
                CommonDeviceInterface drbdVol = (CommonDeviceInterface)vn.getUserObject();
                list.add((Info)((Object)drbdVol));
            }
        }
        Enumeration<TreeNode> wids = this.getBrowser().getCommonBlockDevicesNode().children();
        while (wids.hasMoreElements()) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)wids.nextElement();
            CommonDeviceInterface wid = (CommonDeviceInterface)n.getUserObject();
            list.add((Info)((Object)wid));
        }
        return list.toArray(new Info[list.size()]);
    }

    protected void addCloneFields(JPanel optionsPanel, int leftWidth, int rightWidth) {
        CloneInfo ci = this.getCloneInfo();
        String[] params = ci.getParametersFromXML();
        Info savedMAIdRef = ci.getSavedMetaAttrInfoRef();
        ci.getResource().setValue(GUI_ID, ci.getService().getId());
        ci.addParams(optionsPanel, params, ClusterBrowser.SERVICE_LABEL_WIDTH, ClusterBrowser.SERVICE_FIELD_WIDTH, ci.getSameAsFields(savedMAIdRef));
        if (!ci.getService().isNew()) {
            ci.getWidget(GUI_ID, null).setEnabled(false);
        }
        for (String param : params) {
            if (!ci.isMetaAttr(param)) continue;
            Widget wi = ci.getWidget(param, null);
            wi.setEnabled(savedMAIdRef == null);
        }
        ci.addHostLocations(optionsPanel, ClusterBrowser.SERVICE_LABEL_WIDTH, ClusterBrowser.SERVICE_FIELD_WIDTH);
    }

    private String getHostLocationLabel(String hostName, String op) {
        StringBuilder sb = new StringBuilder(20);
        if (op == null || "eq".equals(op)) {
            sb.append("on ");
        } else if ("ne".equals(op)) {
            sb.append("NOT on ");
        } else {
            sb.append(op);
            sb.append(' ');
        }
        sb.append(hostName);
        return sb.toString();
    }

    protected void addHostLocations(JPanel optionsPanel, int leftWidth, int rightWidth) {
        HostInfo hi;
        int rows = 0;
        JPanel panel = this.getParamPanel(Tools.getString("ClusterBrowser.HostLocations"));
        panel.setLayout(new SpringLayout());
        for (Host host : this.getBrowser().getClusterHosts()) {
            hi = host.getBrowser().getHostInfo();
            HashMap<String, String> abbreviations = new HashMap<String, String>();
            abbreviations.put("i", "INFINITY");
            abbreviations.put("+", "+INFINITY");
            abbreviations.put("I", "INFINITY");
            abbreviations.put("a", "ALWAYS");
            abbreviations.put("n", "NEVER");
            Widget wi = WidgetFactory.createInstance(Widget.Type.COMBOBOX, null, new String[]{null, "0", "2", "ALWAYS", "NEVER", "INFINITY", "-INFINITY", "INFINITY"}, "^((-?\\d*|(-|\\+)?INFINITY))|ALWAYS|NEVER|@NOTHING_SELECTED@$", rightWidth, abbreviations, new AccessMode(ConfigData.AccessType.ADMIN, false), Widget.NO_BUTTON);
            wi.setEditable(true);
            Widget prevWi = this.scoreComboBoxHash.get(hi);
            this.scoreComboBoxHash.put(hi, wi);
            if (prevWi == null) {
                HostLocation hl = this.savedHostLocations.get(hi);
                String hsSaved = null;
                if (hl != null) {
                    hsSaved = hl.getScore();
                }
                wi.setValue(hsSaved);
                continue;
            }
            wi.setValue(prevWi.getValue());
        }
        for (Host host : this.getBrowser().getClusterHosts()) {
            hi = host.getBrowser().getHostInfo();
            Widget wi = this.scoreComboBoxHash.get(hi);
            String op = null;
            HostLocation hl = this.savedHostLocations.get(hi);
            if (hl != null) {
                op = hl.getOperation();
            }
            String text = this.getHostLocationLabel(hi.getName(), op);
            final JLabel label = new JLabel(text);
            final String onText = this.getHostLocationLabel(hi.getName(), "eq");
            final String notOnText = this.getHostLocationLabel(hi.getName(), "ne");
            label.addMouseListener(new MouseListener(){

                @Override
                public final void mouseClicked(MouseEvent e) {
                }

                @Override
                public final void mouseEntered(MouseEvent e) {
                }

                @Override
                public final void mouseExited(MouseEvent e) {
                }

                @Override
                public final void mousePressed(MouseEvent e) {
                    final String currentText = label.getText();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (currentText.equals(onText)) {
                                label.setText(notOnText);
                            } else if (currentText.equals(notOnText)) {
                                label.setText(onText);
                            } else {
                                label.setText(onText);
                            }
                            String[] params = ServiceInfo.this.getParametersFromXML();
                            ServiceInfo.this.setApplyButtons(ServiceInfo.CACHED_FIELD, params);
                        }
                    });
                }

                @Override
                public final void mouseReleased(MouseEvent e) {
                }
            });
            wi.setLabel(label, text);
            this.addField(panel, label, wi, leftWidth, rightWidth, 0);
            ++rows;
        }
        SpringUtilities.makeCompactGrid(panel, rows += this.addPingField(panel, leftWidth, rightWidth), 2, 1, 1, 1, 1);
        optionsPanel.add(panel);
    }

    private int addPingField(JPanel panel, int leftWidth, int rightWidth) {
        int rows = 0;
        JLabel pingLabel = new JLabel("pingd");
        String savedPO = null;
        Widget prevWi = this.pingComboBox;
        savedPO = prevWi == null ? this.savedPingOperation : prevWi.getStringValue();
        Widget pingWi = WidgetFactory.createInstance(Widget.Type.COMBOBOX, savedPO, new StringInfo[]{new StringInfo(Widget.NOTHING_SELECTED_DISPLAY, Widget.NOTHING_SELECTED_INTERNAL, this.getBrowser()), new StringInfo(PING_ATTRIBUTES.get("defined"), "defined", this.getBrowser()), new StringInfo(PING_ATTRIBUTES.get("eq0"), "eq0", this.getBrowser())}, Widget.NO_REGEXP, rightWidth, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.ADMIN, false), Widget.NO_BUTTON);
        this.addField(panel, pingLabel, pingWi, leftWidth, rightWidth, 0);
        pingWi.setLabel(pingLabel, Tools.getString("ServiceInfo.PingdToolTip"));
        if (this.resourceAgent.isPingService() && this.savedPingOperation == null) {
            pingWi.setEnabled(false);
        }
        this.pingComboBox = pingWi;
        return ++rows;
    }

    private boolean isMetaAttrReferenced() {
        ClusterStatus cs = this.getBrowser().getClusterStatus();
        this.getBrowser().mHeartbeatIdToServiceLock();
        Map<String, ServiceInfo> services = this.getBrowser().getHeartbeatIdToServiceInfo();
        for (ServiceInfo si : services.values()) {
            String refCRMId = cs.getMetaAttrsRef(si.getService().getHeartbeatId());
            if (refCRMId == null || !refCRMId.equals(this.getService().getHeartbeatId())) continue;
            this.getBrowser().mHeartbeatIdToServiceUnlock();
            return true;
        }
        this.getBrowser().mHeartbeatIdToServiceUnlock();
        return false;
    }

    private void setMetaAttrsSameAs(Info info) {
        String[] params;
        if (this.sameAsMetaAttrsWi == null || info == null) {
            return;
        }
        boolean nothingSelected = false;
        if (Widget.NOTHING_SELECTED_DISPLAY.equals(info.toString())) {
            nothingSelected = true;
        }
        boolean sameAs = true;
        if (META_ATTRS_DEFAULT_VALUES_TEXT.equals(info.toString())) {
            sameAs = false;
        }
        if ((params = this.getParametersFromXML()) != null) {
            for (String param : params) {
                String newValue;
                Widget wi;
                if (!this.isMetaAttr(param)) continue;
                String defaultValue = this.getParamPreferred(param);
                if (defaultValue == null) {
                    defaultValue = this.getParamDefault(param);
                }
                if ((wi = this.getWidget(param, null)) == null) continue;
                Object oldValue = wi.getValue();
                if (oldValue == null) {
                    oldValue = defaultValue;
                }
                wi.setEnabled(!sameAs || nothingSelected);
                if (nothingSelected) continue;
                if (sameAs) {
                    defaultValue = ((ServiceInfo)info).getParamSaved(param);
                }
                if (Tools.areEqual(oldValue, newValue = defaultValue)) continue;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (wi != null) {
                            wi.setValue(newValue);
                        }
                    }
                });
            }
        }
    }

    private boolean isOperationReferenced() {
        ClusterStatus cs = this.getBrowser().getClusterStatus();
        this.getBrowser().mHeartbeatIdToServiceLock();
        Map<String, ServiceInfo> services = this.getBrowser().getHeartbeatIdToServiceInfo();
        for (ServiceInfo si : services.values()) {
            String refCRMId = cs.getOperationsRef(si.getService().getHeartbeatId());
            if (refCRMId == null || !refCRMId.equals(this.getService().getHeartbeatId())) continue;
            this.getBrowser().mHeartbeatIdToServiceUnlock();
            return true;
        }
        this.getBrowser().mHeartbeatIdToServiceUnlock();
        return false;
    }

    private Info getSameServiceOpIdRef() {
        this.mSavedOperationsLock.lock();
        ServiceInfo savedOpIdRef = this.savedOperationIdRef;
        this.mSavedOperationsLock.unlock();
        return savedOpIdRef;
    }

    private Info[] getSameServicesMetaAttrs() {
        ArrayList<Info> sl = new ArrayList<Info>();
        sl.add(new StringInfo(Widget.NOTHING_SELECTED_DISPLAY, Widget.NOTHING_SELECTED_INTERNAL, this.getBrowser()));
        sl.add(new StringInfo(META_ATTRS_DEFAULT_VALUES_TEXT, "default", this.getBrowser()));
        Host dcHost = this.getBrowser().getDCHost();
        if (this.isMetaAttrReferenced() || Tools.versionBeforePacemaker(dcHost)) {
            return sl.toArray(new Info[sl.size()]);
        }
        this.getBrowser().lockNameToServiceInfo();
        Map<String, ServiceInfo> idToInfoHash = this.getBrowser().getNameToServiceInfoHash().get(this.getName());
        ClusterStatus cs = this.getBrowser().getClusterStatus();
        if (idToInfoHash != null) {
            for (ServiceInfo si : new TreeSet<ServiceInfo>(idToInfoHash.values())) {
                if (si == this || cs.getMetaAttrsId(si.getService().getHeartbeatId()) == null || cs.getMetaAttrsRef(si.getService().getHeartbeatId()) != null) continue;
                sl.add(si);
            }
        }
        boolean clone = this.getResourceAgent().isClone();
        for (String name : this.getBrowser().getNameToServiceInfoHash().keySet()) {
            Map<String, ServiceInfo> idToInfo = this.getBrowser().getNameToServiceInfoHash().get(name);
            for (ServiceInfo si : new TreeSet<ServiceInfo>(idToInfo.values())) {
                if (si == this || si.getName().equals(this.getName()) || si.getResourceAgent() == null || si.getResourceAgent().isClone() != clone || cs.getMetaAttrsId(si.getService().getHeartbeatId()) == null || cs.getMetaAttrsRef(si.getService().getHeartbeatId()) != null) continue;
                sl.add(si);
            }
        }
        this.getBrowser().unlockNameToServiceInfo();
        return sl.toArray(new Info[sl.size()]);
    }

    private Info[] getSameServicesOperations() {
        ArrayList<Info> sl = new ArrayList<Info>();
        sl.add(new StringInfo(Widget.NOTHING_SELECTED_DISPLAY, Widget.NOTHING_SELECTED_INTERNAL, this.getBrowser()));
        sl.add(new StringInfo(OPERATIONS_DEFAULT_VALUES_TEXT, "default", this.getBrowser()));
        Host dcHost = this.getBrowser().getDCHost();
        String pmV = dcHost.getPacemakerVersion();
        String hbV = dcHost.getHeartbeatVersion();
        if (this.isOperationReferenced() || Tools.versionBeforePacemaker(dcHost)) {
            return sl.toArray(new Info[sl.size()]);
        }
        this.getBrowser().lockNameToServiceInfo();
        Map<String, ServiceInfo> idToInfoHash = this.getBrowser().getNameToServiceInfoHash().get(this.getName());
        ClusterStatus cs = this.getBrowser().getClusterStatus();
        if (idToInfoHash != null) {
            for (ServiceInfo si : new TreeSet<ServiceInfo>(idToInfoHash.values())) {
                if (si == this || cs.getOperationsId(si.getService().getHeartbeatId()) == null || cs.getOperationsRef(si.getService().getHeartbeatId()) != null) continue;
                sl.add(si);
            }
        }
        boolean clone = this.getResourceAgent().isClone();
        for (String name : this.getBrowser().getNameToServiceInfoHash().keySet()) {
            Map<String, ServiceInfo> idToInfo = this.getBrowser().getNameToServiceInfoHash().get(name);
            for (ServiceInfo si : new TreeSet<ServiceInfo>(idToInfo.values())) {
                if (si == this || si.getResourceAgent() == null || si.getResourceAgent().isClone() != clone || si.getName().equals(this.getName()) || cs.getOperationsId(si.getService().getHeartbeatId()) == null || cs.getOperationsRef(si.getService().getHeartbeatId()) != null) continue;
                sl.add(si);
            }
        }
        this.getBrowser().unlockNameToServiceInfo();
        return sl.toArray(new Info[sl.size()]);
    }

    private void setOperationsSameAs(Info info) {
        if (this.sameAsOperationsWi == null) {
            return;
        }
        boolean nothingSelected = false;
        if (info == null || Widget.NOTHING_SELECTED_DISPLAY.equals(info.toString())) {
            nothingSelected = true;
        }
        boolean sameAs = true;
        if (info == null || OPERATIONS_DEFAULT_VALUES_TEXT.equals(info.toString())) {
            sameAs = false;
        }
        this.mSavedOperationsLock.lock();
        for (String op : this.getResourceAgent().getOperationNames()) {
            for (String param : this.getBrowser().getCRMOperationParams(op)) {
                String newValue;
                String defaultValue = this.resourceAgent.getOperationDefault(op, param);
                if (defaultValue == null) continue;
                if (ClusterBrowser.HB_OP_IGNORE_DEFAULT.contains(op)) {
                    defaultValue = "";
                }
                this.mOperationsComboBoxHashReadLock.lock();
                Widget wi = this.operationsComboBoxHash.get((K[])new String[]{op, param});
                this.mOperationsComboBoxHashReadLock.unlock();
                Object oldValue = wi.getValue();
                wi.setEnabled(!sameAs || nothingSelected);
                if (nothingSelected) continue;
                if (sameAs) {
                    defaultValue = ((ServiceInfo)info).getSavedOperation().get((K[])new String[]{op, param});
                }
                if (Tools.areEqual(oldValue, Tools.extractUnit(newValue = defaultValue)) || wi == null) continue;
                wi.setValueNoListeners(newValue);
            }
        }
        this.mSavedOperationsLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addOperations(JPanel optionsPanel, int leftWidth, int rightWidth) {
        int rows = 0;
        JPanel sectionPanel = this.getParamPanel(Tools.getString("ClusterBrowser.Operations"));
        String defaultOpIdRef = null;
        Info savedOpIdRef = this.getSameServiceOpIdRef();
        if (savedOpIdRef != null) {
            defaultOpIdRef = savedOpIdRef.toString();
        }
        this.sameAsOperationsWi = WidgetFactory.createInstance(Widget.Type.COMBOBOX, defaultOpIdRef, this.getSameServicesOperations(), Widget.NO_REGEXP, rightWidth, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.ADMIN, false), Widget.NO_BUTTON);
        this.sameAsOperationsWi.setToolTipText(defaultOpIdRef);
        JLabel label = new JLabel(Tools.getString("ClusterBrowser.OperationsSameAs"));
        this.sameAsOperationsWi.setLabel(label, "");
        JPanel saPanel = new JPanel(new SpringLayout());
        saPanel.setBackground(ClusterBrowser.BUTTON_PANEL_BACKGROUND);
        this.addField(saPanel, label, this.sameAsOperationsWi, leftWidth, rightWidth, 0);
        SpringUtilities.makeCompactGrid(saPanel, 1, 2, 1, 1, 1, 1);
        sectionPanel.add(saPanel);
        boolean allAreDefaultValues = true;
        this.mSavedOperationsLock.lock();
        JPanel normalOpPanel = new JPanel(new SpringLayout());
        normalOpPanel.setBackground(ClusterBrowser.PANEL_BACKGROUND);
        int normalRows = 0;
        JPanel advancedOpPanel = new JPanel(new SpringLayout());
        advancedOpPanel.setBackground(ClusterBrowser.PANEL_BACKGROUND);
        this.addToAdvancedList(advancedOpPanel);
        advancedOpPanel.setVisible(Tools.getConfigData().isAdvancedMode());
        int advancedRows = 0;
        for (String op : this.getResourceAgent().getOperationNames()) {
            for (String param : this.getBrowser().getCRMOperationParams(op)) {
                JPanel panel;
                Widget wi;
                String defaultValue = this.resourceAgent.getOperationDefault(op, param);
                if (defaultValue == null) continue;
                if (ClusterBrowser.HB_OP_IGNORE_DEFAULT.contains(op)) {
                    defaultValue = "";
                }
                String regexp = "^-?\\d*$";
                if (defaultValue == null) {
                    defaultValue = "0";
                }
                String savedValue = null;
                this.mOperationsComboBoxHashWriteLock.lock();
                try {
                    Widget prevWi = this.operationsComboBoxHash.get((K[])new String[]{op, param});
                    if (prevWi != null) {
                        savedValue = prevWi.getStringValue();
                    }
                }
                finally {
                    this.mOperationsComboBoxHashWriteLock.unlock();
                }
                if (savedValue == null) {
                    savedValue = this.savedOperation.get((K[])new String[]{op, param});
                }
                if (!this.getService().isNew() && (savedValue == null || "".equals(savedValue)) && (savedValue = this.getOpDefaultsDefault(param)) == null) {
                    savedValue = "";
                }
                if (!defaultValue.equals(savedValue)) {
                    allAreDefaultValues = false;
                }
                if (savedValue != null) {
                    defaultValue = savedValue;
                }
                if ("OCF_CHECK_LEVEL".equals(param)) {
                    wi = WidgetFactory.createInstance(Widget.Type.COMBOBOX, defaultValue, new String[]{"", "10", "20"}, "^\\d*$", rightWidth, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.ADMIN, false), Widget.NO_BUTTON);
                    wi.setAlwaysEditable(true);
                } else {
                    wi = new TextfieldWithUnit(defaultValue, this.getUnits(), "^-?\\d*$", rightWidth, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.ADMIN, false), Widget.NO_BUTTON);
                }
                wi.setEnabled(savedOpIdRef == null);
                this.mOperationsComboBoxHashWriteLock.lock();
                try {
                    this.operationsComboBoxHash.put(op, param, wi);
                }
                finally {
                    this.mOperationsComboBoxHashWriteLock.unlock();
                }
                ++rows;
                final String labelText = Tools.ucfirst(op) + " / " + Tools.ucfirst(param);
                final JLabel wiLabel = new JLabel(labelText);
                wi.setLabel(wiLabel, labelText);
                if (this.getBrowser().isCRMOperationAdvanced(op, param)) {
                    panel = advancedOpPanel;
                    ++advancedRows;
                } else {
                    panel = normalOpPanel;
                    ++normalRows;
                }
                this.addField(panel, wiLabel, wi, leftWidth, rightWidth, 0);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        wiLabel.setToolTipText(labelText);
                    }
                });
            }
        }
        SpringUtilities.makeCompactGrid(normalOpPanel, normalRows, 2, 1, 1, 1, 1);
        SpringUtilities.makeCompactGrid(advancedOpPanel, advancedRows, 2, 1, 1, 1, 1);
        sectionPanel.add(normalOpPanel);
        sectionPanel.add(this.getMoreOptionsPanel(leftWidth + rightWidth + 4));
        sectionPanel.add(advancedOpPanel);
        this.mSavedOperationsLock.unlock();
        if (allAreDefaultValues && savedOpIdRef == null) {
            this.sameAsOperationsWi.setValue(OPERATIONS_DEFAULT_VALUES_TEXT);
        }
        this.sameAsOperationsWi.addListeners(new WidgetListener(){

            @Override
            public void check(Object value) {
                final Info info = ServiceInfo.this.sameAsOperationsWiValue();
                ServiceInfo.this.setOperationsSameAs(info);
                String[] params = ServiceInfo.this.getParametersFromXML();
                ServiceInfo.this.setApplyButtons(ServiceInfo.CACHED_FIELD, params);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (info != null) {
                            ServiceInfo.this.sameAsOperationsWi.setToolTipText(info.toString());
                        }
                    }
                });
            }
        });
        optionsPanel.add(sectionPanel);
    }

    @Override
    public String[] getParametersFromXML() {
        CRMXML crmXML = this.getBrowser().getCRMXML();
        return this.getEnabledSectionParams(crmXML.getParameters(this.resourceAgent, this.getService().isMaster()));
    }

    @Override
    protected String getParamRegexp(String param) {
        if (this.isInteger(param)) {
            return "^((-?\\d*|(-|\\+)?INFINITY|disabled))|@NOTHING_SELECTED@$";
        }
        return null;
    }

    @Override
    protected boolean checkParam(String param, String newValue) {
        if (param.equals("ip") && newValue != null && !Tools.isIp(newValue)) {
            return false;
        }
        CRMXML crmXML = this.getBrowser().getCRMXML();
        return crmXML.checkParam(this.resourceAgent, param, newValue);
    }

    @Override
    public String getParamDefault(String param) {
        String paramDefault;
        if (this.isMetaAttr(param) && (paramDefault = this.getBrowser().getRscDefaultsInfo().getResource().getValue(param)) != null) {
            return paramDefault;
        }
        CRMXML crmXML = this.getBrowser().getCRMXML();
        return crmXML.getParamDefault(this.resourceAgent, param);
    }

    @Override
    protected String getParamSaved(String param) {
        String crmId;
        String refCRMId;
        ClusterStatus clStatus = this.getBrowser().getClusterStatus();
        if (this.isMetaAttr(param) && (refCRMId = clStatus.getMetaAttrsRef(crmId = this.getService().getHeartbeatId())) != null) {
            String value = clStatus.getParameter(refCRMId, param, false);
            if (value == null && (value = this.getParamPreferred(param)) == null) {
                return this.getParamDefault(param);
            }
            return value;
        }
        String value = super.getParamSaved(param);
        if (value == null && (value = clStatus.getParameter(this.getService().getHeartbeatId(), param, false)) == null) {
            if (this.getService().isNew()) {
                value = this.getParamPreferred(param);
            }
            if (value == null) {
                return this.getParamDefault(param);
            }
        }
        return value;
    }

    @Override
    protected String getParamPreferred(String param) {
        CRMXML crmXML = this.getBrowser().getCRMXML();
        return crmXML.getParamPreferred(this.resourceAgent, param);
    }

    @Override
    protected Object[] getParamPossibleChoices(String param) {
        CRMXML crmXML = this.getBrowser().getCRMXML();
        if (this.isCheckBox(param)) {
            return crmXML.getCheckBoxChoices(this.resourceAgent, param);
        }
        CloneInfo ci = this.getCloneInfo();
        boolean ms = ci != null && ci.getService().isMaster();
        return crmXML.getParamPossibleChoices(this.resourceAgent, param, ms);
    }

    @Override
    protected String getParamShortDesc(String param) {
        CRMXML crmXML = this.getBrowser().getCRMXML();
        return crmXML.getParamShortDesc(this.resourceAgent, param);
    }

    @Override
    protected String getParamLongDesc(String param) {
        CRMXML crmXML = this.getBrowser().getCRMXML();
        return crmXML.getParamLongDesc(this.resourceAgent, param);
    }

    @Override
    protected String getSection(String param) {
        CRMXML crmXML = this.getBrowser().getCRMXML();
        return crmXML.getSection(this.resourceAgent, param);
    }

    @Override
    protected boolean isRequired(String param) {
        CRMXML crmXML = this.getBrowser().getCRMXML();
        return crmXML.isRequired(this.resourceAgent, param);
    }

    @Override
    protected boolean isAdvanced(String param) {
        if (!Tools.areEqual(this.getParamDefault(param), this.getParamSaved(param))) {
            return false;
        }
        CRMXML crmXML = this.getBrowser().getCRMXML();
        return crmXML.isAdvanced(this.resourceAgent, param);
    }

    @Override
    protected final String isEnabled(String param) {
        if (GUI_ID.equals(param) && !this.getResource().isNew()) {
            return "";
        }
        if (this.isMetaAttr(param)) {
            Info info = this.sameAsMetaAttrsWiValue();
            if (info == null) {
                return null;
            }
            boolean nothingSelected = false;
            if (Widget.NOTHING_SELECTED_DISPLAY.equals(info.toString())) {
                nothingSelected = true;
            }
            boolean sameAs = true;
            if (META_ATTRS_DEFAULT_VALUES_TEXT.equals(info.toString())) {
                sameAs = false;
            }
            if (!sameAs || nothingSelected) {
                return null;
            }
            return "";
        }
        return null;
    }

    @Override
    protected final boolean isEnabledOnlyInAdvancedMode(String param) {
        return false;
    }

    @Override
    protected ConfigData.AccessType getAccessType(String param) {
        CRMXML crmXML = this.getBrowser().getCRMXML();
        return crmXML.getAccessType(this.resourceAgent, param);
    }

    protected boolean isMetaAttr(String param) {
        CRMXML crmXML = this.getBrowser().getCRMXML();
        return crmXML.isMetaAttr(this.resourceAgent, param);
    }

    @Override
    protected boolean isInteger(String param) {
        CRMXML crmXML = this.getBrowser().getCRMXML();
        return crmXML.isInteger(this.resourceAgent, param);
    }

    @Override
    protected boolean isLabel(String param) {
        CRMXML crmXML = this.getBrowser().getCRMXML();
        return crmXML.isLabel(this.resourceAgent, param);
    }

    @Override
    protected boolean isTimeType(String param) {
        CRMXML crmXML = this.getBrowser().getCRMXML();
        return crmXML.isTimeType(this.resourceAgent, param);
    }

    @Override
    protected boolean isCheckBox(String param) {
        CRMXML crmXML = this.getBrowser().getCRMXML();
        return crmXML.isBoolean(this.resourceAgent, param);
    }

    @Override
    protected String getParamType(String param) {
        CRMXML crmXML = this.getBrowser().getCRMXML();
        return crmXML.getParamType(this.resourceAgent, param);
    }

    @Override
    protected Widget.Type getFieldType(String param) {
        return this.resourceAgent.getFieldType(param);
    }

    void addResourceBefore(Host dcHost, boolean testOnly) {
    }

    protected final void changeType(String value) {
        boolean masterSlave = false;
        boolean clone = false;
        if (MASTER_SLAVE_TYPE_STRING.equals(value)) {
            masterSlave = true;
            clone = true;
        } else if (CLONE_TYPE_STRING.equals(value)) {
            clone = true;
        }
        final ServiceInfo thisClass = this;
        if (clone) {
            CRMXML crmXML = this.getBrowser().getCRMXML();
            final CloneInfo oldCI = this.getCloneInfo();
            String title = "Clone Set";
            if (masterSlave) {
                title = "Master/Slave Set";
            }
            final CloneInfo ci = new CloneInfo(crmXML.getHbClone(), title, masterSlave, this.getBrowser());
            this.setCloneInfo(ci);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (oldCI == null) {
                        ServiceInfo.this.getBrowser().getCRMGraph().exchangeObjectInTheVertex(ci, thisClass);
                        ci.setPingComboBox(ServiceInfo.this.pingComboBox);
                        for (HostInfo hi : ServiceInfo.this.scoreComboBoxHash.keySet()) {
                            ci.getScoreComboBoxHash().put(hi, (Widget)ServiceInfo.this.scoreComboBoxHash.get(hi));
                        }
                        Widget prevWi = ServiceInfo.this.getWidget(ServiceInfo.GUI_ID, null);
                        if (prevWi != null) {
                            ci.getService().setId(ServiceInfo.this.getName() + "_" + prevWi.getStringValue());
                        }
                    } else {
                        oldCI.removeNodeAndWait();
                        ServiceInfo.this.getBrowser().getCRMGraph().exchangeObjectInTheVertex(ci, oldCI);
                        ServiceInfo.this.cleanup();
                        oldCI.cleanup();
                        ci.setPingComboBox(oldCI.getPingComboBox());
                        for (HostInfo hi : oldCI.getScoreComboBoxHash().keySet()) {
                            ci.getScoreComboBoxHash().put(hi, oldCI.getScoreComboBoxHash().get(hi));
                        }
                        ServiceInfo.this.getBrowser().removeFromServiceInfoHash(oldCI);
                        ServiceInfo.this.getBrowser().mHeartbeatIdToServiceLock();
                        ServiceInfo.this.getBrowser().getHeartbeatIdToServiceInfo().remove(oldCI.getService().getHeartbeatId());
                        ServiceInfo.this.getBrowser().mHeartbeatIdToServiceUnlock();
                        DefaultMutableTreeNode oldCINode = oldCI.getNode();
                        if (oldCINode != null) {
                            oldCINode.setUserObject(null);
                        }
                        ci.getService().setId(oldCI.getWidget(ServiceInfo.GUI_ID, null).getStringValue());
                    }
                    ci.setCloneServicePanel(thisClass);
                    ServiceInfo.this.infoPanel = null;
                }
            });
        } else if (PRIMITIVE_TYPE_STRING.equals(value)) {
            final CloneInfo ci = this.getCloneInfo();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ServiceInfo.this.setPingComboBox(ci.getPingComboBox());
                    for (HostInfo hi : ci.getScoreComboBoxHash().keySet()) {
                        ServiceInfo.this.scoreComboBoxHash.put(hi, ci.getScoreComboBoxHash().get(hi));
                    }
                    DefaultMutableTreeNode node = ServiceInfo.this.getNode();
                    DefaultMutableTreeNode ciNode = ci.getNode();
                    ServiceInfo.this.removeNodeAndWait();
                    ci.removeNodeAndWait();
                    ServiceInfo.this.cleanup();
                    ci.cleanup();
                    ServiceInfo.this.setNode(node);
                    ServiceInfo.this.getBrowser().getServicesNode().add(node);
                    ServiceInfo.this.getBrowser().getCRMGraph().exchangeObjectInTheVertex(thisClass, ci);
                    ServiceInfo.this.getBrowser().mHeartbeatIdToServiceLock();
                    ServiceInfo.this.getBrowser().getHeartbeatIdToServiceInfo().remove(ci.getService().getHeartbeatId());
                    ServiceInfo.this.getBrowser().mHeartbeatIdToServiceUnlock();
                    ServiceInfo.this.getBrowser().removeFromServiceInfoHash(ci);
                    ServiceInfo.this.infoPanel = null;
                    ServiceInfo.this.setCloneInfo(null);
                    ServiceInfo.this.selectMyself();
                    ciNode.setUserObject(null);
                }
            });
        }
    }

    protected void addHostLocationsListeners() {
        final String[] params = this.getParametersFromXML();
        for (Host host : this.getBrowser().getClusterHosts()) {
            HostInfo hi = host.getBrowser().getHostInfo();
            final Widget wi = this.scoreComboBoxHash.get(hi);
            wi.addListeners(new WidgetListener(){

                @Override
                public void check(Object value) {
                    ServiceInfo.this.setApplyButtons(ServiceInfo.CACHED_FIELD, params);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            wi.setEditable();
                        }
                    });
                }
            });
        }
        this.pingComboBox.addListeners(new WidgetListener(){

            @Override
            public void check(Object value) {
                ServiceInfo.this.setApplyButtons(ServiceInfo.CACHED_FIELD, params);
            }
        });
    }

    private void addOperationListeners(String op, String param) {
        String dv = this.resourceAgent.getOperationDefault(op, param);
        if (dv == null) {
            return;
        }
        this.mOperationsComboBoxHashReadLock.lock();
        Widget wi = this.operationsComboBoxHash.get((K[])new String[]{op, param});
        this.mOperationsComboBoxHashReadLock.unlock();
        final String[] params = this.getParametersFromXML();
        wi.addListeners(new WidgetListener(){

            @Override
            public void check(Object value) {
                ServiceInfo.this.setApplyButtons(ServiceInfo.CACHED_FIELD, params);
            }
        });
    }

    protected final Map<String, Widget> getSameAsFields(Info savedMAIdRef) {
        String defaultMAIdRef = null;
        if (savedMAIdRef != null) {
            defaultMAIdRef = savedMAIdRef.toString();
        }
        this.sameAsMetaAttrsWi = WidgetFactory.createInstance(Widget.Type.COMBOBOX, defaultMAIdRef, this.getSameServicesMetaAttrs(), Widget.NO_REGEXP, ClusterBrowser.SERVICE_FIELD_WIDTH, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.ADMIN, false), Widget.NO_BUTTON);
        this.sameAsMetaAttrsWi.setToolTipText(defaultMAIdRef);
        HashMap<String, Widget> sameAsFields = new HashMap<String, Widget>();
        sameAsFields.put("Meta Attributes", this.sameAsMetaAttrsWi);
        this.sameAsMetaAttrsWi.addListeners(new WidgetListener(){

            @Override
            public void check(Object value) {
                Info i = null;
                Info o = ServiceInfo.this.sameAsMetaAttrsWiValue();
                if (o instanceof Info) {
                    i = o;
                }
                final Info info = i;
                ServiceInfo.this.setMetaAttrsSameAs(info);
                String[] params = ServiceInfo.this.getParametersFromXML();
                ServiceInfo.this.setApplyButtons(ServiceInfo.CACHED_FIELD, params);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (info != null) {
                            ServiceInfo.this.sameAsMetaAttrsWi.setToolTipText(info.toString());
                        }
                    }
                });
            }
        });
        return sameAsFields;
    }

    protected final Info getSavedMetaAttrInfoRef() {
        return this.savedMetaAttrInfoRef;
    }

    @Override
    public JComponent getInfoPanel() {
        if (!this.getResourceAgent().isMetaDataLoaded()) {
            JPanel p = new JPanel();
            p.add(new JLabel(Tools.getString("ServiceInfo.LoadingMetaData")));
            return p;
        }
        CloneInfo ci = this.getCloneInfo();
        if (ci == null) {
            this.getBrowser().getCRMGraph().pickInfo(this);
        } else {
            this.getBrowser().getCRMGraph().pickInfo(ci);
        }
        if (this.infoPanel != null) {
            return this.infoPanel;
        }
        boolean abExisted = this.getApplyButton() != null;
        ServiceInfo thisClass = this;
        ButtonCallback buttonCallback = new ButtonCallback(){
            private volatile boolean mouseStillOver = false;

            @Override
            public final boolean isEnabled() {
                Host dcHost = ServiceInfo.this.getBrowser().getDCHost();
                if (dcHost == null) {
                    return false;
                }
                return !Tools.versionBeforePacemaker(dcHost);
            }

            @Override
            public final void mouseOut() {
                if (!this.isEnabled()) {
                    return;
                }
                this.mouseStillOver = false;
                ServiceInfo.this.getBrowser().getCRMGraph().stopTestAnimation(ServiceInfo.this.getApplyButton());
                ServiceInfo.this.getApplyButton().setToolTipText(null);
            }

            @Override
            public final void mouseOver() {
                if (!this.isEnabled()) {
                    return;
                }
                this.mouseStillOver = true;
                ServiceInfo.this.getApplyButton().setToolTipText(ClusterBrowser.STARTING_PTEST_TOOLTIP);
                ServiceInfo.this.getApplyButton().setToolTipBackground(Tools.getDefaultColor("ClusterBrowser.Test.Tooltip.Background"));
                Tools.sleep(250);
                if (!this.mouseStillOver) {
                    return;
                }
                this.mouseStillOver = false;
                CountDownLatch startTestLatch = new CountDownLatch(1);
                ServiceInfo.this.getBrowser().getCRMGraph().startTestAnimation(ServiceInfo.this.getApplyButton(), startTestLatch);
                Host dcHost = ServiceInfo.this.getBrowser().getDCHost();
                ServiceInfo.this.getBrowser().ptestLockAcquire();
                ClusterStatus cs = ServiceInfo.this.getBrowser().getClusterStatus();
                cs.setPtestData(null);
                ServiceInfo.this.apply(dcHost, true);
                PtestData ptestData = new PtestData(CRM.getPtest(dcHost));
                ServiceInfo.this.getApplyButton().setToolTipText(ptestData.getToolTip());
                cs.setPtestData(ptestData);
                ServiceInfo.this.getBrowser().ptestLockRelease();
                startTestLatch.countDown();
            }
        };
        if (this.getResourceAgent().isGroup()) {
            this.initApplyButton(buttonCallback, Tools.getString("Browser.ApplyGroup"));
        } else {
            this.initApplyButton(buttonCallback);
        }
        if (ci != null) {
            ci.setApplyButton(this.getApplyButton());
            ci.setRevertButton(this.getRevertButton());
        }
        if (!abExisted) {
            this.getApplyButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Thread thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            ServiceInfo.this.getBrowser().clStatusLock();
                            ServiceInfo.this.apply(ServiceInfo.this.getBrowser().getDCHost(), false);
                            ServiceInfo.this.getBrowser().clStatusUnlock();
                        }
                    });
                    thread.start();
                }
            });
            this.getRevertButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Thread thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            ServiceInfo.this.getBrowser().clStatusLock();
                            ServiceInfo.this.revert();
                            ServiceInfo.this.getBrowser().clStatusUnlock();
                        }
                    });
                    thread.start();
                }
            });
        }
        JPanel mainPanel = new JPanel();
        mainPanel.setBackground(ClusterBrowser.PANEL_BACKGROUND);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.setBackground(ClusterBrowser.BUTTON_PANEL_BACKGROUND);
        buttonPanel.setMinimumSize(new Dimension(0, 50));
        buttonPanel.setPreferredSize(new Dimension(0, 50));
        buttonPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 50));
        JPanel optionsPanel = new JPanel();
        optionsPanel.setBackground(ClusterBrowser.PANEL_BACKGROUND);
        optionsPanel.setLayout(new BoxLayout(optionsPanel, 1));
        optionsPanel.setAlignmentX(0.0f);
        JMenuBar mb = new JMenuBar();
        mb.setBackground(ClusterBrowser.PANEL_BACKGROUND);
        JToggleButton serviceMenu = ci == null ? this.getActionsButton() : ci.getActionsButton();
        buttonPanel.add((Component)serviceMenu, "East");
        String defaultValue = PRIMITIVE_TYPE_STRING;
        if (ci != null) {
            defaultValue = ci.getService().isMaster() ? MASTER_SLAVE_TYPE_STRING : CLONE_TYPE_STRING;
        }
        if (!this.getResourceAgent().isClone() && this.getGroupInfo() == null) {
            this.typeRadioGroup = WidgetFactory.createInstance(Widget.Type.RADIOGROUP, defaultValue, new String[]{PRIMITIVE_TYPE_STRING, CLONE_TYPE_STRING, MASTER_SLAVE_TYPE_STRING}, Widget.NO_REGEXP, ClusterBrowser.SERVICE_LABEL_WIDTH + ClusterBrowser.SERVICE_FIELD_WIDTH, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.ADMIN, false), Widget.NO_BUTTON);
            if (!this.getService().isNew()) {
                this.typeRadioGroup.setEnabled(false);
            }
            this.typeRadioGroup.addListeners(new WidgetListener(){

                @Override
                public void check(Object value) {
                    ServiceInfo.this.changeType(((JRadioButton)value).getText());
                }
            });
            JPanel tp = new JPanel();
            tp.setBackground(ClusterBrowser.PANEL_BACKGROUND);
            tp.setLayout(new BoxLayout(tp, 1));
            tp.add(this.typeRadioGroup);
            this.typeRadioGroup.setBackgroundColor(ClusterBrowser.PANEL_BACKGROUND);
            optionsPanel.add(tp);
        }
        if (ci != null) {
            this.addCloneFields(optionsPanel, ClusterBrowser.SERVICE_LABEL_WIDTH, ClusterBrowser.SERVICE_FIELD_WIDTH);
        }
        this.getResource().setValue(GUI_ID, this.getService().getId());
        final String[] params = this.getParametersFromXML();
        ServiceInfo savedMAIdRef = this.savedMetaAttrInfoRef;
        this.addParams(optionsPanel, params, ClusterBrowser.SERVICE_LABEL_WIDTH, ClusterBrowser.SERVICE_FIELD_WIDTH, this.getSameAsFields(savedMAIdRef));
        if (ci == null) {
            this.addHostLocations(optionsPanel, ClusterBrowser.SERVICE_LABEL_WIDTH, ClusterBrowser.SERVICE_FIELD_WIDTH);
        }
        for (String param : params) {
            if (!this.isMetaAttr(param)) continue;
            Widget wi = this.getWidget(param, null);
            wi.setEnabled(savedMAIdRef == null);
        }
        if (!this.getService().isNew()) {
            this.getWidget(GUI_ID, null).setEnabled(false);
        }
        if (!this.getResourceAgent().isGroup() && !this.getResourceAgent().isClone()) {
            this.addOperations(optionsPanel, ClusterBrowser.SERVICE_LABEL_WIDTH, ClusterBrowser.SERVICE_FIELD_WIDTH);
            for (String op : this.getResourceAgent().getOperationNames()) {
                for (String param : this.getBrowser().getCRMOperationParams(op)) {
                    this.addOperationListeners(op, param);
                }
            }
        }
        if (ci == null) {
            this.addHostLocationsListeners();
        } else {
            ci.addHostLocationsListeners();
        }
        this.addApplyButton(buttonPanel);
        this.addRevertButton(buttonPanel);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ServiceInfo.this.setApplyButtons(null, params);
            }
        });
        mainPanel.add(optionsPanel);
        JPanel newPanel = new JPanel();
        newPanel.setBackground(ClusterBrowser.PANEL_BACKGROUND);
        newPanel.setLayout(new BoxLayout(newPanel, 1));
        newPanel.add(buttonPanel);
        newPanel.add(this.getMoreOptionsPanel(ClusterBrowser.SERVICE_LABEL_WIDTH + ClusterBrowser.SERVICE_FIELD_WIDTH + 4));
        newPanel.add(new JScrollPane(mainPanel));
        this.infoPanel = newPanel;
        this.infoPanelDone();
        return this.infoPanel;
    }

    @Override
    boolean selectAutomaticallyInTreeMenu() {
        return this.infoPanel == null;
    }

    private String getOpFromLabel(String onHost, String labelText) {
        int l = labelText.length();
        int k = onHost.length();
        String op = null;
        if (l > k) {
            String labelPart = labelText.substring(0, l - k - 1);
            op = "on".equals(labelPart) ? "eq" : ("NOT on".equals(labelPart) ? "ne" : labelPart);
        }
        return op;
    }

    protected void setLocations(String heartbeatId, Host dcHost, boolean testOnly) {
        ClusterStatus cs = this.getBrowser().getClusterStatus();
        for (Host host : this.getBrowser().getClusterHosts()) {
            String onHost;
            String op;
            HostLocation hostLoc;
            HostInfo hi = host.getBrowser().getHostInfo();
            Widget wi = this.scoreComboBoxHash.get(hi);
            String hs = wi.getStringValue();
            if ("ALWAYS".equals(hs)) {
                hs = "INFINITY";
            } else if ("NEVER".equals(hs)) {
                hs = "-INFINITY";
            }
            HostLocation hlSaved = this.savedHostLocations.get(hi);
            String hsSaved = null;
            String opSaved = null;
            if (hlSaved != null) {
                hsSaved = hlSaved.getScore();
                opSaved = hlSaved.getOperation();
            }
            if ((hostLoc = new HostLocation(hs, op = this.getOpFromLabel(onHost = hi.getName(), wi.getLabel().getText()), null, null)).equals(hlSaved)) continue;
            String locationId = cs.getLocationId(this.getHeartbeatId(testOnly), onHost, testOnly);
            if ((hs == null || "".equals(hs) || !Tools.areEqual(op, opSaved)) && locationId != null) {
                CRM.removeLocation(dcHost, locationId, this.getHeartbeatId(testOnly), testOnly);
                locationId = null;
            }
            if (hs == null || "".equals(hs)) continue;
            CRM.setLocation(dcHost, this.getHeartbeatId(testOnly), onHost, hostLoc, locationId, testOnly);
        }
        Widget pwi = this.pingComboBox;
        if (pwi != null) {
            String value = null;
            Object o = pwi.getValue();
            if (o != null) {
                value = ((StringInfo)o).getInternalValue();
            }
            Object locationId = null;
            if (!Tools.areEqual(this.savedPingOperation, value)) {
                String pingLocationId = cs.getPingLocationId(this.getHeartbeatId(testOnly), testOnly);
                if (pingLocationId != null) {
                    CRM.removeLocation(dcHost, pingLocationId, this.getHeartbeatId(testOnly), testOnly);
                }
                if (value != null) {
                    CRM.setPingLocation(dcHost, this.getHeartbeatId(testOnly), value, null, testOnly);
                }
            }
        }
        if (!testOnly) {
            this.storeHostLocations();
        }
    }

    protected Map<String, Map<String, String>> getOperations(String heartbeatId) {
        LinkedHashMap<String, Map<String, String>> operations = new LinkedHashMap<String, Map<String, String>>();
        ClusterStatus cs = this.getBrowser().getClusterStatus();
        CloneInfo ci = this.getCloneInfo();
        for (String op : this.getResourceAgent().getOperationNames()) {
            LinkedHashMap<String, String> opHash = new LinkedHashMap<String, String>();
            String opId = cs.getOpId(heartbeatId, op);
            if (opId == null) {
                opId = "op-" + heartbeatId + "-" + op;
            }
            boolean firstTime = true;
            for (String param : ClusterBrowser.HB_OPERATION_PARAM_LIST) {
                if (!this.getBrowser().getCRMOperationParams(op).contains(param) || ci == null && ("demote".equals(op) || "promote".equals(op))) continue;
                this.mOperationsComboBoxHashReadLock.lock();
                Widget wi = this.operationsComboBoxHash.get((K[])new String[]{op, param});
                this.mOperationsComboBoxHashReadLock.unlock();
                String value = wi == null ? "0" : wi.getStringValue();
                if (value == null || "".equals(value)) continue;
                if (wi != null && firstTime) {
                    opHash.put("id", opId);
                    opHash.put("name", op);
                    firstTime = false;
                    operations.put(op, opHash);
                }
                opHash.put(param, value);
            }
        }
        return operations;
    }

    protected String getMetaAttrsRefId() {
        Info i;
        String metaAttrsRefId = null;
        if (this.sameAsMetaAttrsWi != null && !Widget.NOTHING_SELECTED_DISPLAY.equals((i = this.sameAsMetaAttrsWiValue()).toString()) && !META_ATTRS_DEFAULT_VALUES_TEXT.equals(i.toString())) {
            ServiceInfo si = (ServiceInfo)i;
            ClusterStatus cs = this.getBrowser().getClusterStatus();
            metaAttrsRefId = cs.getMetaAttrsId(si.getService().getHeartbeatId());
        }
        return metaAttrsRefId;
    }

    protected String getOperationsRefId() {
        Info i;
        String operationsRefId = null;
        if (this.sameAsOperationsWi != null && !Widget.NOTHING_SELECTED_DISPLAY.equals((i = this.sameAsOperationsWiValue()).toString()) && !OPERATIONS_DEFAULT_VALUES_TEXT.equals(i.toString())) {
            ServiceInfo si = (ServiceInfo)i;
            ClusterStatus cs = this.getBrowser().getClusterStatus();
            operationsRefId = cs.getOperationsId(si.getService().getHeartbeatId());
        }
        return operationsRefId;
    }

    protected Map<String, String> getPacemakerResAttrs(boolean testOnly) {
        LinkedHashMap<String, String> pacemakerResAttrs = new LinkedHashMap<String, String>();
        String raClass = this.getService().getResourceClass();
        String type = this.getName();
        String provider = this.resourceAgent.getProvider();
        String heartbeatId = this.getHeartbeatId(testOnly);
        pacemakerResAttrs.put("id", heartbeatId);
        pacemakerResAttrs.put("class", raClass);
        if (!("heartbeat".equals(raClass) || ResourceAgent.SERVICE_CLASSES.contains(raClass) || raClass.equals("stonith"))) {
            pacemakerResAttrs.put("provider", provider);
        }
        pacemakerResAttrs.put("type", type);
        return pacemakerResAttrs;
    }

    protected Map<String, String> getPacemakerResArgs() {
        String[] params;
        LinkedHashMap<String, String> pacemakerResArgs = new LinkedHashMap<String, String>();
        for (String param : params = this.getParametersFromXML()) {
            if (this.isMetaAttr(param) || GUI_ID.equals(param) || PCMK_ID.equals(param)) continue;
            String value = this.getComboBoxValue(param);
            if (value == null) {
                value = "";
            }
            if (!this.resourceAgent.isIgnoreDefaults() && value.equals(this.getParamDefault(param)) || "".equals(value)) continue;
            pacemakerResArgs.put(param, value);
        }
        return pacemakerResArgs;
    }

    protected Map<String, String> getPacemakerMetaArgs() {
        String[] params;
        LinkedHashMap<String, String> pacemakerMetaArgs = new LinkedHashMap<String, String>();
        for (String param : params = this.getParametersFromXML()) {
            if (!this.isMetaAttr(param) || GUI_ID.equals(param) || PCMK_ID.equals(param)) continue;
            String value = this.getComboBoxValue(param);
            if (value == null) {
                value = "";
            }
            if (value.equals(this.getParamDefault(param)) || "".equals(value)) continue;
            pacemakerMetaArgs.put(param, value);
        }
        return pacemakerMetaArgs;
    }

    @Override
    public void revert() {
        CRMXML crmXML = this.getBrowser().getCRMXML();
        String[] params = this.getParametersFromXML();
        boolean allSavedMetaAttrsAreDefaultValues = true;
        boolean sameAs = false;
        if (this.sameAsMetaAttrsWi != null) {
            for (String param : params) {
                String oldValue;
                String defaultValue;
                if (!this.isMetaAttr(param) || Tools.areEqual(defaultValue = this.getParamDefault(param), oldValue = this.getResource().getValue(param))) continue;
                allSavedMetaAttrsAreDefaultValues = false;
            }
            if (this.savedMetaAttrInfoRef == null) {
                if (allSavedMetaAttrsAreDefaultValues) {
                    this.sameAsMetaAttrsWi.setValue(META_ATTRS_DEFAULT_VALUES_TEXT);
                } else {
                    this.sameAsMetaAttrsWi.setValue(Widget.NOTHING_SELECTED_INTERNAL);
                }
            } else {
                sameAs = true;
                this.sameAsMetaAttrsWi.setValue(this.savedMetaAttrInfoRef);
            }
        }
        for (String param : params) {
            if (sameAs && this.isMetaAttr(param)) continue;
            String v = this.getParamSaved(param);
            Widget wi = this.getWidget(param, null);
            if (wi == null || Tools.areEqual(wi.getStringValue(), v)) continue;
            if ("".equals(v)) {
                wi.setValue(null);
                continue;
            }
            wi.setValue(v);
        }
        GroupInfo gInfo = this.groupInfo;
        CloneInfo ci = gInfo == null ? this.getCloneInfo() : gInfo.getCloneInfo();
        CloneInfo clInfo = ci;
        if (clInfo != null) {
            clInfo.revert();
        }
        this.revertOperations();
        this.revertLocations();
    }

    protected final void revertLocations() {
        for (Host host : this.getBrowser().getClusterHosts()) {
            HostInfo hi = host.getBrowser().getHostInfo();
            HostLocation savedLocation = this.savedHostLocations.get(hi);
            Widget wi = this.scoreComboBoxHash.get(hi);
            if (wi == null) continue;
            String score = null;
            String op = null;
            if (savedLocation != null) {
                score = savedLocation.getScore();
                op = savedLocation.getOperation();
            }
            wi.setValue(score);
            JLabel label = wi.getLabel();
            String text = this.getHostLocationLabel(hi.getName(), op);
            label.setText(text);
        }
        Widget pwi = this.pingComboBox;
        if (pwi != null) {
            String spo = this.savedPingOperation;
            if (spo == null) {
                pwi.setValue(Widget.NOTHING_SELECTED_INTERNAL);
            } else {
                pwi.setValue(PING_ATTRIBUTES.get(spo));
            }
        }
    }

    protected final void revertOperations() {
        if (this.sameAsOperationsWi == null) {
            return;
        }
        ClusterStatus cs = this.getBrowser().getClusterStatus();
        this.mSavedOperationsLock.lock();
        boolean allAreDefaultValues = true;
        boolean allSavedAreDefaultValues = true;
        for (String op : this.getResourceAgent().getOperationNames()) {
            for (String param : this.getBrowser().getCRMOperationParams(op)) {
                String defaultValue = this.resourceAgent.getOperationDefault(op, param);
                if (defaultValue == null) continue;
                if (ClusterBrowser.HB_OP_IGNORE_DEFAULT.contains(op)) {
                    defaultValue = "";
                }
                this.mOperationsComboBoxHashReadLock.lock();
                Widget wi = this.operationsComboBoxHash.get((K[])new String[]{op, param});
                this.mOperationsComboBoxHashReadLock.unlock();
                String value = wi.getStringValue();
                if (value == null || "".equals(value)) {
                    value = this.getOpDefaultsDefault(param);
                }
                if (value == null) {
                    value = "";
                }
                if (!defaultValue.equals(value)) {
                    allAreDefaultValues = false;
                }
                if (defaultValue.equals(this.savedOperation.get((K[])new String[]{op, param}))) continue;
                allSavedAreDefaultValues = false;
            }
        }
        boolean sameAs = false;
        final ServiceInfo savedOpIdRef = this.savedOperationIdRef;
        ServiceInfo operationIdRef = null;
        Info ref = this.sameAsOperationsWiValue();
        if (ref instanceof ServiceInfo) {
            operationIdRef = (ServiceInfo)ref;
        }
        if (!Tools.areEqual(operationIdRef, savedOpIdRef)) {
            if (savedOpIdRef == null) {
                if (allSavedAreDefaultValues) {
                    this.sameAsOperationsWi.setValue(OPERATIONS_DEFAULT_VALUES_TEXT);
                } else if (operationIdRef != null) {
                    this.sameAsOperationsWi.setValue(Widget.NOTHING_SELECTED_INTERNAL);
                }
            } else {
                sameAs = true;
                this.sameAsOperationsWi.setValue(savedOpIdRef);
            }
        }
        if (!sameAs) {
            for (String op : this.getResourceAgent().getOperationNames()) {
                for (String param : this.getBrowser().getCRMOperationParams(op)) {
                    String value = this.savedOperation.get((K[])new String[]{op, param});
                    this.mOperationsComboBoxHashReadLock.lock();
                    final Widget wi = this.operationsComboBoxHash.get((K[])new String[]{op, param});
                    this.mOperationsComboBoxHashReadLock.unlock();
                    if (wi == null) continue;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            wi.setEnabled(savedOpIdRef == null);
                        }
                    });
                    if (value == null) continue;
                    wi.setValue(value);
                }
            }
        }
        this.mSavedOperationsLock.unlock();
    }

    void apply(Host dcHost, boolean testOnly) {
        String refCRMId;
        CloneInfo ci;
        if (!testOnly) {
            Tools.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ServiceInfo.this.getApplyButton().setEnabled(false);
                    ServiceInfo.this.getRevertButton().setEnabled(false);
                }
            });
        }
        this.getInfoPanel();
        this.waitForInfoPanel();
        if (!testOnly) {
            this.setUpdated(true);
        }
        final String[] params = this.getParametersFromXML();
        String cloneId = null;
        String[] cloneParams = null;
        boolean master = false;
        GroupInfo gInfo = this.groupInfo;
        String[] groupParams = null;
        if (gInfo == null) {
            ci = this.getCloneInfo();
        } else {
            ci = gInfo.getCloneInfo();
            groupParams = gInfo.getParametersFromXML();
        }
        final CloneInfo clInfo = ci;
        if (clInfo != null) {
            cloneId = clInfo.getHeartbeatId(testOnly);
            cloneParams = clInfo.getParametersFromXML();
            master = clInfo.getService().isMaster();
        }
        if (!testOnly) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ServiceInfo.this.getApplyButton().setToolTipText(null);
                    ServiceInfo.this.getWidget(ServiceInfo.GUI_ID, null).setEnabled(false);
                    if (clInfo != null) {
                        clInfo.getWidget(ServiceInfo.GUI_ID, null).setEnabled(false);
                    }
                }
            });
            this.getBrowser().removeFromServiceInfoHash(this);
            String oldHeartbeatId = this.getHeartbeatId(testOnly);
            if (oldHeartbeatId != null) {
                this.getBrowser().mHeartbeatIdToServiceLock();
                this.getBrowser().getHeartbeatIdToServiceInfo().remove(oldHeartbeatId);
                this.getBrowser().mHeartbeatIdToServiceUnlock();
            }
            if (this.getService().isNew()) {
                String id = this.getComboBoxValue(GUI_ID);
                this.getService().setIdAndCrmId(id);
                if (clInfo != null) {
                    String clid = clInfo.getComboBoxValue(GUI_ID);
                    clInfo.getService().setIdAndCrmId(clid);
                }
                if (this.typeRadioGroup != null) {
                    this.typeRadioGroup.setEnabled(false);
                }
            }
            this.getBrowser().addNameToServiceInfoHash(this);
            this.getBrowser().addToHeartbeatIdList(this);
        }
        if (!testOnly) {
            this.addResourceBefore(dcHost, testOnly);
        }
        LinkedHashMap<String, String> cloneMetaArgs = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> groupMetaArgs = new LinkedHashMap<String, String>();
        Map<String, String> pacemakerResAttrs = this.getPacemakerResAttrs(testOnly);
        Map<String, String> pacemakerResArgs = this.getPacemakerResArgs();
        Map<String, String> pacemakerMetaArgs = this.getPacemakerMetaArgs();
        String raClass = this.getService().getResourceClass();
        String type = this.getName();
        String provider = this.resourceAgent.getProvider();
        String heartbeatId = this.getHeartbeatId(testOnly);
        String groupId = null;
        if (gInfo != null) {
            if (gInfo.getService().isNew()) {
                gInfo.apply(dcHost, testOnly);
                return;
            }
            groupId = gInfo.getHeartbeatId(testOnly);
        }
        String cloneMetaAttrsRefIds = null;
        if (clInfo != null) {
            cloneMetaAttrsRefIds = clInfo.getMetaAttrsRefId();
        }
        String groupMetaAttrsRefIds = null;
        if (gInfo != null) {
            groupMetaAttrsRefIds = gInfo.getMetaAttrsRefId();
        }
        this.savedOperationsId = refCRMId = this.getOperationsRefId();
        this.savedOperationIdRef = this.getBrowser().getServiceInfoFromCRMId(refCRMId);
        Info i = this.sameAsOperationsWiValue();
        if (i == null || i instanceof StringInfo) {
            this.savedOperationsId = null;
        } else {
            this.savedOperationIdRef = (ServiceInfo)i;
            this.savedOperationsId = ((ServiceInfo)i).getService().getHeartbeatId();
        }
        if (this.getService().isNew()) {
            String value;
            if (clInfo != null) {
                for (String param : cloneParams) {
                    if (GUI_ID.equals(param) || PCMK_ID.equals(param) || (value = clInfo.getComboBoxValue(param)).equals(clInfo.getParamDefault(param)) || GUI_ID.equals(param) || "".equals(value)) continue;
                    cloneMetaArgs.put(param, value);
                }
            }
            if (gInfo != null) {
                for (String param : groupParams) {
                    if (GUI_ID.equals(param) || PCMK_ID.equals(param) || (value = gInfo.getComboBoxValue(param)).equals(gInfo.getParamDefault(param)) || GUI_ID.equals(param) || "".equals(value)) continue;
                    groupMetaArgs.put(param, value);
                }
            }
            String command = "-C";
            if (gInfo != null && !gInfo.getService().isNew() || clInfo != null && !clInfo.getService().isNew()) {
                command = "-U";
            }
            CRM.setParameters(dcHost, command, heartbeatId, cloneId, master, cloneMetaArgs, groupMetaArgs, groupId, pacemakerResAttrs, pacemakerResArgs, pacemakerMetaArgs, null, null, this.getOperations(heartbeatId), null, this.getMetaAttrsRefId(), cloneMetaAttrsRefIds, groupMetaAttrsRefIds, refCRMId, this.resourceAgent.isStonith(), testOnly);
            if (gInfo == null) {
                String hbId = heartbeatId;
                if (clInfo != null) {
                    hbId = clInfo.getHeartbeatId(testOnly);
                }
                ArrayList<Map<String, String>> colAttrsList = new ArrayList<Map<String, String>>();
                ArrayList<Map<String, String>> ordAttrsList = new ArrayList<Map<String, String>>();
                ArrayList<String> parentIds = new ArrayList<String>();
                ServiceInfo infoForDependency = clInfo == null ? this : clInfo;
                Set<ServiceInfo> parents = this.getBrowser().getCRMGraph().getParents(infoForDependency);
                for (ServiceInfo parentInfo : parents) {
                    if (parentInfo.isConstraintPH()) {
                        boolean colocation = true;
                        boolean order = true;
                        TreeSet<ServiceInfo> with = new TreeSet<ServiceInfo>();
                        with.add(infoForDependency);
                        TreeSet<ServiceInfo> withFrom = new TreeSet<ServiceInfo>();
                        ((ConstraintPHInfo)parentInfo).addConstraintWithPlaceholder(with, withFrom, true, true, dcHost, !parentInfo.getService().isNew(), testOnly);
                        continue;
                    }
                    String parentId = parentInfo.getService().getHeartbeatId();
                    parentIds.add(parentId);
                    LinkedHashMap<String, String> colAttrs = new LinkedHashMap<String, String>();
                    LinkedHashMap<String, String> ordAttrs = new LinkedHashMap<String, String>();
                    if (this.getBrowser().getCRMGraph().isColocation(parentInfo, infoForDependency)) {
                        colAttrs.put("score", "INFINITY");
                        if (parentInfo.getService().isMaster()) {
                            colAttrs.put("with-rsc-role", "Master");
                        }
                        colAttrsList.add(colAttrs);
                    } else {
                        colAttrsList.add(null);
                    }
                    if (this.getBrowser().getCRMGraph().isOrder(parentInfo, infoForDependency)) {
                        ordAttrs.put("score", "INFINITY");
                        if (parentInfo.getService().isMaster()) {
                            ordAttrs.put("first-action", "promote");
                            ordAttrs.put("then-action", "start");
                        }
                        ordAttrsList.add(ordAttrs);
                        continue;
                    }
                    ordAttrsList.add(null);
                }
                if (!parentIds.isEmpty()) {
                    CRM.setOrderAndColocation(dcHost, hbId, parentIds.toArray(new String[parentIds.size()]), colAttrsList, ordAttrsList, testOnly);
                }
            } else {
                gInfo.resetPopup();
            }
        } else {
            String value;
            if (clInfo != null) {
                for (String param : cloneParams) {
                    if (GUI_ID.equals(param) || PCMK_ID.equals(param) || (value = clInfo.getComboBoxValue(param)).equals(clInfo.getParamDefault(param)) || "".equals(value)) continue;
                    cloneMetaArgs.put(param, value);
                }
            }
            if (gInfo != null) {
                for (String param : groupParams) {
                    if (GUI_ID.equals(param) || PCMK_ID.equals(param) || (value = gInfo.getComboBoxValue(param)) == null || value.equals(gInfo.getParamDefault(param)) || "".equals(value)) continue;
                    groupMetaArgs.put(param, value);
                }
                cloneId = null;
            }
            groupId = null;
            ClusterStatus cs = this.getBrowser().getClusterStatus();
            CRM.setParameters(dcHost, "-R", heartbeatId, cloneId, master, cloneMetaArgs, groupMetaArgs, groupId, pacemakerResAttrs, pacemakerResArgs, pacemakerMetaArgs, cs.getResourceInstanceAttrId(heartbeatId), cs.getParametersNvpairsIds(heartbeatId), this.getOperations(heartbeatId), cs.getOperationsId(heartbeatId), this.getMetaAttrsRefId(), cloneMetaAttrsRefIds, groupMetaAttrsRefIds, refCRMId, this.resourceAgent.isStonith(), testOnly);
            if (this.isFailed(testOnly)) {
                this.cleanupResource(dcHost, testOnly);
            }
        }
        if (gInfo == null) {
            if (clInfo == null) {
                this.setLocations(heartbeatId, dcHost, testOnly);
            } else {
                clInfo.setLocations(heartbeatId, dcHost, testOnly);
            }
        } else {
            this.setLocations(heartbeatId, dcHost, testOnly);
        }
        if (!testOnly) {
            this.storeComboBoxValues(params);
            this.storeOperations();
            if (clInfo != null) {
                clInfo.storeComboBoxValues(cloneParams);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ServiceInfo.this.setApplyButtons(null, params);
                    DefaultMutableTreeNode node = ServiceInfo.this.getNode();
                    if (node != null) {
                        if (clInfo == null) {
                            ServiceInfo.this.getBrowser().reload(node, false);
                        } else {
                            ServiceInfo.this.getBrowser().reload(clInfo.getNode(), false);
                            ServiceInfo.this.getBrowser().reload(node, false);
                        }
                        ServiceInfo.this.getBrowser().getCRMGraph().repaint();
                    }
                }
            });
        }
    }

    public void removeOrder(ServiceInfo parent, Host dcHost, boolean testOnly) {
        if (this.getService().isNew() || parent.getService().isNew()) {
            return;
        }
        if (!(testOnly || this.getService().isNew() || parent.getService().isNew())) {
            parent.setUpdated(true);
            this.setUpdated(true);
        }
        ClusterStatus clStatus = this.getBrowser().getClusterStatus();
        String rscId = this.isConstraintPH() ? this.getId() : this.getHeartbeatId(testOnly);
        if (this.isConstraintPH() || parent.isConstraintPH()) {
            ConstraintPHInfo cphi = null;
            cphi = this.isConstraintPH() ? (ConstraintPHInfo)this : (ConstraintPHInfo)parent;
            LinkedHashMap<CRMXML.RscSet, Map<String, String>> rscSetsOrdAttrs = new LinkedHashMap<CRMXML.RscSet, Map<String, String>>();
            CRMXML.RscSetConnectionData rdata = cphi.getRscSetConnectionDataOrd();
            String ordId = rdata.getConstraintId();
            String idToRemove = this.isConstraintPH() ? parent.getService().getHeartbeatId() : this.getService().getHeartbeatId();
            CRMXML.RscSet modifiedRscSet = null;
            List<CRMXML.RscSet> ordRscSets = clStatus.getRscSetsOrd(ordId);
            if (ordRscSets != null) {
                for (CRMXML.RscSet rscSet : ordRscSets) {
                    if (rscSet.equals((Object)rdata.getRscSet1()) || rscSet.equals((Object)rdata.getRscSet2())) {
                        ArrayList<String> newRscIds = new ArrayList<String>();
                        newRscIds.addAll(rscSet.getRscIds());
                        if (newRscIds.remove(idToRemove) && !testOnly) {
                            modifiedRscSet = rscSet;
                        }
                        if (newRscIds.isEmpty()) continue;
                        CRMXML.RscSet newRscSet = new CRMXML.RscSet(rscSet.getId(), newRscIds, rscSet.getSequential(), rscSet.getRequireAll(), rscSet.getOrderAction(), rscSet.getColocationRole());
                        rscSetsOrdAttrs.put(newRscSet, null);
                        continue;
                    }
                    rscSetsOrdAttrs.put(rscSet, null);
                }
            }
            if (!testOnly && rscSetsOrdAttrs.isEmpty()) {
                cphi.getRscSetConnectionDataOrd().setConstraintId(null);
            }
            LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
            CRMXML.OrderData od = clStatus.getOrderData(ordId);
            if (od != null) {
                String score = od.getScore();
                attrs.put("score", score);
            }
            if (!testOnly) {
                cphi.setUpdated(false);
            }
            CRM.setRscSet(dcHost, null, false, ordId, false, null, rscSetsOrdAttrs, attrs, testOnly);
        } else {
            String rscFirstId = parent.getHeartbeatId(testOnly);
            List<CRMXML.OrderData> allData = clStatus.getOrderDatas(rscFirstId);
            if (allData != null) {
                for (CRMXML.OrderData orderData : allData) {
                    String orderId = orderData.getId();
                    String rscThenId = orderData.getRscThen();
                    if (!rscThenId.equals(this.getHeartbeatId(testOnly))) continue;
                    CRM.removeOrder(dcHost, orderId, testOnly);
                }
            }
        }
    }

    final String getHeartbeatId(boolean testOnly) {
        String heartbeatId = this.getService().getHeartbeatId();
        if (testOnly && heartbeatId == null) {
            heartbeatId = this.getService().getCrmIdFromId(this.getComboBoxValue(GUI_ID));
        }
        return heartbeatId;
    }

    public void addOrder(ServiceInfo child, Host dcHost, boolean testOnly) {
        if (!(testOnly || this.getService().isNew() || child.getService().isNew())) {
            child.setUpdated(true);
            this.setUpdated(true);
        }
        if (this.isConstraintPH() || child.isConstraintPH()) {
            ServiceInfo withService;
            ConstraintPHInfo cphi;
            if (!testOnly) {
                if (this.isConstraintPH() && ((ConstraintPHInfo)this).isReversedCol()) {
                    ((ConstraintPHInfo)this).reverseOrder();
                } else if (child.isConstraintPH() && ((ConstraintPHInfo)child).isReversedCol()) {
                    ((ConstraintPHInfo)child).reverseOrder();
                }
            }
            TreeSet<ServiceInfo> withFrom = new TreeSet<ServiceInfo>();
            if (this.isConstraintPH()) {
                cphi = (ConstraintPHInfo)this;
                withService = child;
            } else {
                cphi = (ConstraintPHInfo)child;
                withService = this;
                withFrom.add(this);
            }
            TreeSet<ServiceInfo> with = new TreeSet<ServiceInfo>();
            with.add(withService);
            cphi.addConstraintWithPlaceholder(with, withFrom, false, true, dcHost, !cphi.getService().isNew(), testOnly);
        } else {
            String childHbId = child.getHeartbeatId(testOnly);
            LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
            attrs.put("score", "INFINITY");
            CloneInfo chCI = child.getCloneInfo();
            if (chCI != null && chCI.getService().isMaster()) {
                attrs.put("first-action", "promote");
                attrs.put("then-action", "start");
            }
            CRM.addOrder(dcHost, null, this.getHeartbeatId(testOnly), childHbId, attrs, testOnly);
        }
    }

    public void removeColocation(ServiceInfo parent, Host dcHost, boolean testOnly) {
        if (this.getService().isNew() || parent.getService().isNew()) {
            return;
        }
        if (!(testOnly || this.getService().isNew() || parent.getService().isNew())) {
            parent.setUpdated(true);
            this.setUpdated(true);
        }
        ClusterStatus clStatus = this.getBrowser().getClusterStatus();
        String rscId = this.isConstraintPH() ? this.getId() : this.getHeartbeatId(testOnly);
        if (this.isConstraintPH() || parent.isConstraintPH()) {
            LinkedHashMap<CRMXML.RscSet, Map<String, String>> rscSetsColAttrs = new LinkedHashMap<CRMXML.RscSet, Map<String, String>>();
            ConstraintPHInfo cphi = null;
            cphi = this.isConstraintPH() ? (ConstraintPHInfo)this : (ConstraintPHInfo)parent;
            CRMXML.RscSetConnectionData rdata = cphi.getRscSetConnectionDataCol();
            String colId = rdata.getConstraintId();
            String idToRemove = this.isConstraintPH() ? parent.getService().getHeartbeatId() : this.getService().getHeartbeatId();
            CRMXML.RscSet modifiedRscSet = null;
            List<CRMXML.RscSet> colRscSets = clStatus.getRscSetsCol(colId);
            if (colRscSets != null) {
                for (CRMXML.RscSet rscSet : colRscSets) {
                    if (rscSet.equals((Object)rdata.getRscSet1()) || rscSet.equals((Object)rdata.getRscSet2())) {
                        ArrayList<String> newRscIds = new ArrayList<String>();
                        newRscIds.addAll(rscSet.getRscIds());
                        if (newRscIds.remove(idToRemove) && !testOnly) {
                            modifiedRscSet = rscSet;
                        }
                        if (newRscIds.isEmpty()) continue;
                        CRMXML.RscSet newRscSet = new CRMXML.RscSet(rscSet.getId(), newRscIds, rscSet.getSequential(), rscSet.getRequireAll(), rscSet.getOrderAction(), rscSet.getColocationRole());
                        rscSetsColAttrs.put(newRscSet, null);
                        continue;
                    }
                    rscSetsColAttrs.put(rscSet, null);
                }
            }
            if (!testOnly && rscSetsColAttrs.isEmpty()) {
                cphi.getRscSetConnectionDataCol().setConstraintId(null);
            }
            LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
            CRMXML.ColocationData cd = clStatus.getColocationData(colId);
            if (cd != null) {
                String score = cd.getScore();
                attrs.put("score", score);
            }
            if (!testOnly) {
                cphi.setUpdated(false);
            }
            CRM.setRscSet(dcHost, colId, false, null, false, rscSetsColAttrs, null, attrs, testOnly);
        } else {
            List<CRMXML.ColocationData> allData = clStatus.getColocationDatas(rscId);
            if (allData != null) {
                for (CRMXML.ColocationData colocationData : allData) {
                    String colId = colocationData.getId();
                    String withRscId = colocationData.getWithRsc();
                    if (!withRscId.equals(parent.getHeartbeatId(testOnly))) continue;
                    CRM.removeColocation(dcHost, colId, testOnly);
                }
            }
        }
    }

    public void addColocation(ServiceInfo child, Host dcHost, boolean testOnly) {
        if (!(testOnly || this.getService().isNew() || child.getService().isNew())) {
            child.setUpdated(true);
            this.setUpdated(true);
        }
        if (this.isConstraintPH() || child.isConstraintPH()) {
            ServiceInfo withService;
            ConstraintPHInfo cphi;
            if (!testOnly) {
                if (this.isConstraintPH() && ((ConstraintPHInfo)this).isReversedOrd()) {
                    ((ConstraintPHInfo)this).reverseColocation();
                } else if (child.isConstraintPH() && ((ConstraintPHInfo)child).isReversedOrd()) {
                    ((ConstraintPHInfo)child).reverseColocation();
                }
            }
            TreeSet<ServiceInfo> withFrom = new TreeSet<ServiceInfo>();
            if (this.isConstraintPH()) {
                cphi = (ConstraintPHInfo)this;
                withService = child;
            } else {
                cphi = (ConstraintPHInfo)child;
                withService = this;
                withFrom.add(this);
            }
            TreeSet<ServiceInfo> with = new TreeSet<ServiceInfo>();
            with.add(withService);
            cphi.addConstraintWithPlaceholder(with, withFrom, true, false, dcHost, !cphi.getService().isNew(), testOnly);
        } else {
            String childHbId = child.getHeartbeatId(testOnly);
            LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
            attrs.put("score", "INFINITY");
            CloneInfo pCI = child.getCloneInfo();
            if (pCI != null && pCI.getService().isMaster()) {
                attrs.put("with-rsc-role", "Master");
            }
            CRM.addColocation(dcHost, null, childHbId, this.getHeartbeatId(testOnly), attrs, testOnly);
        }
    }

    @Override
    public JPanel getGraphicalView() {
        return this.getBrowser().getCRMGraph().getGraphPanel();
    }

    public ServiceInfo addServicePanel(ResourceAgent newRA, Point2D pos, boolean colocation, boolean order, boolean reloadNode, boolean master, boolean testOnly) {
        ServiceInfo newServiceInfo;
        String name = newRA.getName();
        if (newRA.isFilesystem()) {
            newServiceInfo = new FilesystemInfo(name, newRA, this.getBrowser());
        } else if (newRA.isLinbitDrbd()) {
            newServiceInfo = new LinbitDrbdInfo(name, newRA, this.getBrowser());
        } else if (newRA.isDrbddisk()) {
            newServiceInfo = new DrbddiskInfo(name, newRA, this.getBrowser());
        } else if (newRA.isIPaddr()) {
            newServiceInfo = new IPaddrInfo(name, newRA, this.getBrowser());
        } else if (newRA.isVirtualDomain()) {
            newServiceInfo = new VirtualDomainInfo(name, newRA, this.getBrowser());
        } else if (newRA.isGroup()) {
            newServiceInfo = new GroupInfo(newRA, (Browser)this.getBrowser());
        } else if (newRA.isClone()) {
            String cloneName = master ? "Master/Slave Set" : "Clone Set";
            newServiceInfo = new CloneInfo(newRA, cloneName, master, this.getBrowser());
        } else {
            newServiceInfo = new ServiceInfo(name, newRA, this.getBrowser());
        }
        this.addServicePanel(newServiceInfo, pos, colocation, order, reloadNode, this.getBrowser().getDCHost(), testOnly);
        return newServiceInfo;
    }

    public void addServicePanel(final ServiceInfo serviceInfo, Point2D pos, boolean colocation, boolean order, final boolean reloadNode, Host dcHost, boolean testOnly) {
        ResourceAgent ra = serviceInfo.getResourceAgent();
        if (ra != null) {
            serviceInfo.getService().setResourceClass(ra.getResourceClass());
        }
        if (this.getBrowser().getCRMGraph().addResource(serviceInfo, this, pos, colocation, order, testOnly)) {
            Tools.waitForSwing();
            if (this.isConstraintPH() || serviceInfo.isConstraintPH()) {
                ServiceInfo withService;
                ConstraintPHInfo cphi;
                TreeSet<ServiceInfo> withFrom = new TreeSet<ServiceInfo>();
                if (this.isConstraintPH()) {
                    cphi = (ConstraintPHInfo)this;
                    withService = serviceInfo;
                } else {
                    cphi = (ConstraintPHInfo)serviceInfo;
                    withService = this;
                    withFrom.add(this);
                }
                withFrom.addAll(this.getBrowser().getCRMGraph().getParents(cphi));
                TreeSet<ServiceInfo> with = new TreeSet<ServiceInfo>();
                with.add(withService);
                cphi.addConstraintWithPlaceholder(with, withFrom, colocation, order, dcHost, !cphi.getService().isNew(), testOnly);
                if (!testOnly) {
                    PcmkRscSetsInfo prsi = cphi.getPcmkRscSetsInfo();
                    prsi.setApplyButtons(null, prsi.getParametersFromXML());
                }
            } else {
                String parentId = this.getHeartbeatId(testOnly);
                String heartbeatId = serviceInfo.getHeartbeatId(testOnly);
                ArrayList<Map<String, String>> colAttrsList = new ArrayList<Map<String, String>>();
                ArrayList<Map<String, String>> ordAttrsList = new ArrayList<Map<String, String>>();
                LinkedHashMap<String, String> colAttrs = new LinkedHashMap<String, String>();
                LinkedHashMap<String, String> ordAttrs = new LinkedHashMap<String, String>();
                colAttrs.put("score", "INFINITY");
                ordAttrs.put("score", "INFINITY");
                if (this.getService().isMaster()) {
                    colAttrs.put("with-rsc-role", "Master");
                    ordAttrs.put("first-action", "promote");
                    ordAttrs.put("then-action", "start");
                }
                if (colocation) {
                    colAttrsList.add(colAttrs);
                } else {
                    colAttrsList.add(null);
                }
                if (order) {
                    ordAttrsList.add(ordAttrs);
                } else {
                    ordAttrsList.add(null);
                }
                if (!this.getService().isNew() && !serviceInfo.getService().isNew()) {
                    CRM.setOrderAndColocation(dcHost, heartbeatId, new String[]{parentId}, colAttrsList, ordAttrsList, testOnly);
                }
            }
        } else {
            this.getBrowser().addNameToServiceInfoHash(serviceInfo);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DefaultMutableTreeNode newServiceNode = new DefaultMutableTreeNode(serviceInfo);
                    serviceInfo.setNode(newServiceNode);
                    ServiceInfo.this.getBrowser().getServicesNode().add(newServiceNode);
                    if (reloadNode) {
                        ServiceInfo.this.getBrowser().reloadAndWait(ServiceInfo.this.getBrowser().getServicesNode(), false);
                        ServiceInfo.this.getBrowser().reloadAndWait(newServiceNode, false);
                    }
                }
            });
            this.getBrowser().reloadAllComboBoxes(serviceInfo);
        }
        if (reloadNode && ra != null && serviceInfo.getResource().isNew()) {
            if (ra.isProbablyMasterSlave()) {
                serviceInfo.changeType(MASTER_SLAVE_TYPE_STRING);
            } else if (ra.isProbablyClone()) {
                serviceInfo.changeType(CLONE_TYPE_STRING);
            }
        }
        this.getBrowser().getCRMGraph().reloadServiceMenus();
        if (reloadNode) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ServiceInfo.this.getBrowser().getCRMGraph().scale();
                }
            });
        }
    }

    public Service getService() {
        return (Service)this.getResource();
    }

    void startResource(Host dcHost, boolean testOnly) {
        if (!testOnly) {
            this.setUpdated(true);
        }
        CRM.startResource(dcHost, this.getHeartbeatId(testOnly), testOnly);
    }

    void stopResource(Host dcHost, boolean testOnly) {
        if (!testOnly) {
            this.setUpdated(true);
        }
        CRM.stopResource(dcHost, this.getHeartbeatId(testOnly), testOnly);
    }

    void upResource(Host dcHost, boolean testOnly) {
        GroupInfo gi = this.groupInfo;
        DefaultMutableTreeNode giNode = gi.getNode();
        if (giNode == null) {
            return;
        }
        DefaultMutableTreeNode node = this.getNode();
        if (node == null) {
            return;
        }
        int index = giNode.getIndex(node);
        if (index > 0) {
            Enumeration<TreeNode> e = giNode.children();
            ArrayList<String> newOrder = new ArrayList<String>();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
                ServiceInfo child = (ServiceInfo)n.getUserObject();
                newOrder.add(child.getHeartbeatId(testOnly));
            }
            String el = (String)newOrder.remove(index);
            newOrder.add(index - 1, el);
            if (!testOnly) {
                this.setUpdated(true);
            }
            gi.applyWhole(dcHost, false, newOrder, testOnly);
        }
    }

    void downResource(Host dcHost, boolean testOnly) {
        GroupInfo gi = this.groupInfo;
        DefaultMutableTreeNode giNode = gi.getNode();
        if (giNode == null) {
            return;
        }
        DefaultMutableTreeNode node = this.getNode();
        if (node == null) {
            return;
        }
        int index = giNode.getIndex(node);
        if (index < giNode.getChildCount() - 1) {
            Enumeration<TreeNode> e = giNode.children();
            ArrayList<String> newOrder = new ArrayList<String>();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
                ServiceInfo child = (ServiceInfo)n.getUserObject();
                newOrder.add(child.getHeartbeatId(testOnly));
            }
            String el = (String)newOrder.remove(index);
            newOrder.add(index + 1, el);
            if (!testOnly) {
                this.setUpdated(true);
            }
            gi.applyWhole(dcHost, false, newOrder, testOnly);
        }
    }

    void migrateResource(String onHost, Host dcHost, boolean testOnly) {
        if (!testOnly) {
            this.setUpdated(true);
        }
        CRM.migrateResource(dcHost, this.getHeartbeatId(testOnly), onHost, testOnly);
    }

    void migrateFromResource(Host dcHost, String fromHost, boolean testOnly) {
        if (!testOnly) {
            this.setUpdated(true);
        }
        CRM.migrateFromResource(dcHost, this.getHeartbeatId(testOnly), testOnly);
    }

    void forceMigrateResource(String onHost, Host dcHost, boolean testOnly) {
        if (!testOnly) {
            this.setUpdated(true);
        }
        CRM.forceMigrateResource(dcHost, this.getHeartbeatId(testOnly), onHost, testOnly);
    }

    void unmigrateResource(Host dcHost, boolean testOnly) {
        if (!testOnly) {
            this.setUpdated(true);
        }
        CRM.unmigrateResource(dcHost, this.getHeartbeatId(testOnly), testOnly);
    }

    void cleanupResource(Host dcHost, boolean testOnly) {
        if (!testOnly) {
            this.setUpdated(true);
        }
        ClusterStatus cs = this.getBrowser().getClusterStatus();
        String rscId = this.getHeartbeatId(testOnly);
        boolean failedClone = false;
        for (Host host : this.getBrowser().getClusterHosts()) {
            Set<String> failedClones = cs.getFailedClones(host.getName(), rscId, testOnly);
            if (failedClones == null) continue;
            failedClone = true;
            for (String fc : failedClones) {
                CRM.cleanupResource(dcHost, rscId + ":" + fc, new Host[]{host}, testOnly);
            }
        }
        if (!failedClone) {
            ArrayList<Host> dirtyHosts = new ArrayList<Host>();
            for (Host host : this.getBrowser().getClusterHosts()) {
                if (!this.isInLRMOnHost(host.getName(), testOnly) && this.getFailCount(host.getName(), testOnly) == null) continue;
                dirtyHosts.add(host);
            }
            if (!dirtyHosts.isEmpty()) {
                CRM.cleanupResource(dcHost, rscId, dirtyHosts.toArray(new Host[dirtyHosts.size()]), testOnly);
            }
        }
    }

    protected void removeMyselfNoConfirm(Host dcHost, boolean testOnly) {
        CloneInfo ci;
        if (!testOnly) {
            if (!this.getService().isNew()) {
                this.setUpdated(true);
            }
            this.getService().setRemoved(true);
            this.cleanup();
        }
        if ((ci = this.getCloneInfo()) != null) {
            ci.removeMyselfNoConfirm(dcHost, testOnly);
            this.setCloneInfo(null);
        }
        GroupInfo gi = this.groupInfo;
        if (this.getService().isNew() && gi == null) {
            if (!testOnly) {
                this.getService().setNew(false);
                this.getBrowser().getCRMGraph().killRemovedVertices();
            }
        } else {
            ClusterStatus cs = this.getBrowser().getClusterStatus();
            if (gi == null) {
                this.removeConstraints(dcHost, testOnly);
            }
            if (!this.getResourceAgent().isGroup() && !this.getResourceAgent().isClone()) {
                String groupId = null;
                if (gi != null) {
                    if (this.getService().isNew()) {
                        if (!testOnly) {
                            super.removeMyself(false);
                        }
                    } else {
                        String group = gi.getHeartbeatId(testOnly);
                        DefaultMutableTreeNode giNode = gi.getNode();
                        if (giNode != null) {
                            Enumeration<TreeNode> e = giNode.children();
                            while (e.hasMoreElements()) {
                                DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
                                ServiceInfo child = (ServiceInfo)n.getUserObject();
                                child.getService().setModified(true);
                                child.getService().doneModifying();
                            }
                        }
                        if (cs.getGroupResources(group, testOnly).size() == 1) {
                            if (!testOnly) {
                                gi.getService().setRemoved(true);
                            }
                            gi.removeMyselfNoConfirmFromChild(dcHost, testOnly);
                            groupId = group;
                            gi.getService().doneRemoving();
                        }
                    }
                    gi.resetPopup();
                }
                if (!this.getService().isNew()) {
                    String cloneId = null;
                    boolean master = false;
                    if (ci != null) {
                        cloneId = ci.getHeartbeatId(testOnly);
                        master = ci.getService().isMaster();
                    }
                    boolean ret = CRM.removeResource(dcHost, this.getHeartbeatId(testOnly), groupId, cloneId, master, testOnly);
                    this.cleanupResource(dcHost, testOnly);
                    this.setUpdated(false);
                    if (!testOnly && !ret) {
                        Tools.progressIndicatorFailed(dcHost.getName(), "removing failed");
                    }
                }
            }
        }
        if (!testOnly) {
            this.getBrowser().removeFromServiceInfoHash(this);
            this.infoPanel = null;
            this.getService().doneRemoving();
        }
    }

    @Override
    public void removeMyself(boolean testOnly) {
        if (this.getService().isNew()) {
            this.removeMyselfNoConfirm(this.getBrowser().getDCHost(), testOnly);
            this.getService().setNew(false);
            this.getService().doneRemoving();
            return;
        }
        String desc = Tools.getString("ClusterBrowser.confirmRemoveService.Description");
        desc = desc.replaceAll("@SERVICE@", Matcher.quoteReplacement(this.toString()));
        if (Tools.confirmDialog(Tools.getString("ClusterBrowser.confirmRemoveService.Title"), desc, Tools.getString("ClusterBrowser.confirmRemoveService.Yes"), Tools.getString("ClusterBrowser.confirmRemoveService.No"))) {
            this.removeMyselfNoConfirm(this.getBrowser().getDCHost(), testOnly);
            this.removeInfo();
            this.getService().setNew(false);
        }
    }

    public void removeInfo() {
        this.getBrowser().mHeartbeatIdToServiceLock();
        this.getBrowser().getHeartbeatIdToServiceInfo().remove(this.getService().getHeartbeatId());
        this.getBrowser().mHeartbeatIdToServiceUnlock();
        this.getBrowser().removeFromServiceInfoHash(this);
        final CloneInfo ci = this.cloneInfo;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ServiceInfo.this.removeNodeAndWait();
                if (ci != null) {
                    ci.removeNodeAndWait();
                }
            }
        });
        super.removeMyself(false);
    }

    void setGroupInfo(GroupInfo groupInfo) {
        this.groupInfo = groupInfo;
    }

    void setCloneInfo(CloneInfo cloneInfo) {
        this.cloneInfo = cloneInfo;
    }

    public GroupInfo getGroupInfo() {
        return this.groupInfo;
    }

    CloneInfo getCloneInfo() {
        return this.cloneInfo;
    }

    protected void addExistingGroupServiceMenuItems(ServiceInfo asi, MyListModel<MyMenuItem> dlm, Map<MyMenuItem, ButtonCallback> callbackHash, MyList<MyMenuItem> list, JCheckBox colocationWi, JCheckBox orderWi, List<JDialog> popups, boolean testOnly) {
    }

    protected void addExistingServiceMenuItem(String name, final ServiceInfo asi, MyListModel<MyMenuItem> dlm, Map<MyMenuItem, ButtonCallback> callbackHash, MyList<MyMenuItem> list, final JCheckBox colocationWi, final JCheckBox orderWi, final List<JDialog> popups, final boolean testOnly) {
        MyMenuItem mmi = new MyMenuItem(name, null, null, new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public void action() {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ServiceInfo.this.hidePopup();
                        for (JDialog otherP : popups) {
                            otherP.dispose();
                        }
                        ServiceInfo.this.addServicePanel(asi, null, colocationWi.isSelected(), orderWi.isSelected(), true, ServiceInfo.this.getBrowser().getDCHost(), testOnly);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                this.repaint();
                            }
                        });
                    }
                });
                thread.start();
            }
        };
        dlm.addElement(mmi);
        ClusterBrowser clusterBrowser = this.getBrowser();
        clusterBrowser.getClass();
        ClusterBrowser.ClMenuItemCallback mmiCallback = new ClusterBrowser.ClMenuItemCallback(clusterBrowser, list, null){
            {
                ClusterBrowser clusterBrowser = x0;
                clusterBrowser.getClass();
                super(x1, x2);
            }

            @Override
            public void action(Host dcHost) {
                ServiceInfo.this.addServicePanel(asi, null, colocationWi.isSelected(), orderWi.isSelected(), true, dcHost, true);
            }
        };
        callbackHash.put(mmi, mmiCallback);
    }

    private MyMenu getExistingServiceMenuItem(final String name, final boolean enableForNew, final boolean testOnly) {
        final ServiceInfo thisClass = this;
        return new MyMenu(name, new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;
            private final Lock mUpdateLock;
            {
                super(x0, x1, x2);
                this.mUpdateLock = new ReentrantLock();
            }

            @Override
            public String enablePredicate() {
                if (ServiceInfo.this.getBrowser().clStatusFailed()) {
                    return "unknown cluster status";
                }
                if (ServiceInfo.this.getService().isRemoved()) {
                    return ServiceInfo.IS_BEING_REMOVED_STRING;
                }
                if (ServiceInfo.this.getService().isOrphaned()) {
                    return ServiceInfo.IS_ORPHANED_STRING;
                }
                if (!enableForNew && ServiceInfo.this.getService().isNew()) {
                    return ServiceInfo.IS_NEW_STRING;
                }
                if (ServiceInfo.this.getBrowser().getExistingServiceList(thisClass).size() == 0) {
                    return "&lt;&lt;empty;&gt;&gt;";
                }
                return null;
            }

            @Override
            public void update() {
                Thread t = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (mUpdateLock.tryLock()) {
                            try {
                                this.updateThread();
                            }
                            finally {
                                mUpdateLock.unlock();
                            }
                        }
                    }
                });
                t.start();
            }

            private void updateThread() {
                JCheckBox colocationWi = new JCheckBox("Colo", true);
                JCheckBox orderWi = new JCheckBox("Order", true);
                colocationWi.setBackground(ClusterBrowser.STATUS_BACKGROUND);
                colocationWi.setPreferredSize(colocationWi.getMinimumSize());
                orderWi.setBackground(ClusterBrowser.STATUS_BACKGROUND);
                orderWi.setPreferredSize(orderWi.getMinimumSize());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.setEnabled(false);
                    }
                });
                Tools.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        this.removeAll();
                    }
                });
                final MyListModel<MyMenuItem> dlm = new MyListModel<MyMenuItem>();
                final HashMap<MyMenuItem, ButtonCallback> callbackHash = new HashMap<MyMenuItem, ButtonCallback>();
                final MyList<MyMenuItem> list = new MyList<MyMenuItem>(dlm, this.getBackground());
                final ArrayList<JDialog> popups = new ArrayList<JDialog>();
                for (ServiceInfo asi : ServiceInfo.this.getBrowser().getExistingServiceList(thisClass)) {
                    if (asi.isConstraintPH() && ServiceInfo.this.isConstraintPH() || asi.getCloneInfo() != null || asi.getGroupInfo() != null) continue;
                    ServiceInfo.this.addExistingServiceMenuItem(asi.toString(), asi, dlm, callbackHash, list, colocationWi, orderWi, popups, testOnly);
                    asi.addExistingGroupServiceMenuItems(thisClass, dlm, callbackHash, list, colocationWi, orderWi, popups, testOnly);
                }
                final JPanel colOrdPanel = new JPanel(new FlowLayout(0, 0, 0));
                colOrdPanel.setBackground(ClusterBrowser.STATUS_BACKGROUND);
                colOrdPanel.add(colocationWi);
                colOrdPanel.add(orderWi);
                final 29 thisM = this;
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            boolean ret = Tools.getScrollingMenu(name, colOrdPanel, thisM, dlm, list, thisClass, popups, callbackHash);
                            if (!ret) {
                                this.setEnabled(false);
                            }
                        }
                    });
                }
                catch (InterruptedException ix) {
                    Thread.currentThread().interrupt();
                }
                catch (InvocationTargetException x) {
                    Tools.printStackTrace();
                }
                super.update();
            }
        };
    }

    private void addDrbdLinbitMenu(MyMenu menu, CRMXML crmXML, Point2D pos, final ResourceAgent fsService, final boolean testOnly) {
        MyMenuItem ldMenuItem = new MyMenuItem(Tools.getString("ClusterBrowser.linbitDrbdMenuName"), null, null, new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public void action() {
                ServiceInfo.this.hidePopup();
                if (!ServiceInfo.this.getBrowser().linbitDrbdConfirmDialog()) {
                    return;
                }
                FilesystemInfo fsi = (FilesystemInfo)ServiceInfo.this.addServicePanel(fsService, this.getPos(), true, true, true, false, testOnly);
                fsi.setDrbddiskIsPreferred(false);
                ServiceInfo.this.getBrowser().getCRMGraph().repaint();
            }
        };
        if (this.getBrowser().atLeastOneDrbddisk() || !crmXML.isLinbitDrbdPresent()) {
            ldMenuItem.setEnabled(false);
        }
        ldMenuItem.setPos(pos);
        menu.add(ldMenuItem);
    }

    private void addDrbddiskMenu(MyMenu menu, CRMXML crmXML, Point2D pos, final ResourceAgent fsService, final boolean testOnly) {
        ResourceAgent drbddiskService = crmXML.getHbDrbddisk();
        MyMenuItem ddMenuItem = new MyMenuItem(Tools.getString("ClusterBrowser.DrbddiskMenuName"), null, null, new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public void action() {
                ServiceInfo.this.hidePopup();
                FilesystemInfo fsi = (FilesystemInfo)ServiceInfo.this.addServicePanel(fsService, this.getPos(), true, true, true, false, testOnly);
                fsi.setDrbddiskIsPreferred(true);
                ServiceInfo.this.getBrowser().getCRMGraph().repaint();
            }
        };
        if (this.getBrowser().isOneLinbitDrbd() || !crmXML.isDrbddiskPresent()) {
            ddMenuItem.setEnabled(false);
        }
        ddMenuItem.setPos(pos);
        menu.add(ddMenuItem);
    }

    private void addIpMenu(MyMenu menu, Point2D pos, final ResourceAgent ipService, final boolean testOnly) {
        MyMenuItem ipMenuItem = new MyMenuItem(ipService.getMenuName(), null, null, new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public void action() {
                ServiceInfo.this.hidePopup();
                ServiceInfo.this.addServicePanel(ipService, this.getPos(), true, true, true, false, testOnly);
                ServiceInfo.this.getBrowser().getCRMGraph().repaint();
            }
        };
        ipMenuItem.setPos(pos);
        menu.add(ipMenuItem);
    }

    private void addFilesystemMenu(MyMenu menu, Point2D pos, final ResourceAgent fsService, final boolean testOnly) {
        MyMenuItem fsMenuItem = new MyMenuItem(fsService.getMenuName(), null, null, new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public void action() {
                ServiceInfo.this.hidePopup();
                ServiceInfo.this.addServicePanel(fsService, this.getPos(), true, true, true, false, testOnly);
                ServiceInfo.this.getBrowser().getCRMGraph().repaint();
            }
        };
        fsMenuItem.setPos(pos);
        menu.add(fsMenuItem);
    }

    private void addResourceAgentMenu(final ResourceAgent ra, MyListModel<MyMenuItem> dlm, Point2D pos, final List<JDialog> popups, final JCheckBox colocationWi, final JCheckBox orderWi, final boolean testOnly) {
        MyMenuItem mmi = new MyMenuItem(ra.getMenuName(), null, null, new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public void action() {
                ServiceInfo.this.hidePopup();
                for (JDialog otherP : popups) {
                    otherP.dispose();
                }
                if (ra.isLinbitDrbd() && !ServiceInfo.this.getBrowser().linbitDrbdConfirmDialog()) {
                    return;
                }
                if (ra.isHbDrbd() && !ServiceInfo.this.getBrowser().hbDrbdConfirmDialog()) {
                    return;
                }
                ServiceInfo.this.addServicePanel(ra, this.getPos(), colocationWi.isSelected(), orderWi.isSelected(), true, false, testOnly);
                ServiceInfo.this.getBrowser().getCRMGraph().repaint();
            }
        };
        mmi.setPos(pos);
        dlm.addElement(mmi);
    }

    private MyMenu getAddServiceMenuItem(final boolean testOnly, String name) {
        final ServiceInfo thisClass = this;
        return new MyMenu(name, new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;
            private final Lock mUpdateLock;
            {
                super(x0, x1, x2);
                this.mUpdateLock = new ReentrantLock();
            }

            @Override
            public String enablePredicate() {
                if (ServiceInfo.this.getBrowser().clStatusFailed()) {
                    return "unknown cluster status";
                }
                if (ServiceInfo.this.getService().isRemoved()) {
                    return ServiceInfo.IS_BEING_REMOVED_STRING;
                }
                if (ServiceInfo.this.getService().isOrphaned()) {
                    return ServiceInfo.IS_ORPHANED_STRING;
                }
                if (ServiceInfo.this.getService().isNew()) {
                    return ServiceInfo.IS_NEW_STRING;
                }
                return null;
            }

            @Override
            public void update() {
                Thread t = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (mUpdateLock.tryLock()) {
                            try {
                                this.updateThread();
                            }
                            finally {
                                mUpdateLock.unlock();
                            }
                        }
                    }
                });
                t.start();
            }

            private void updateThread() {
                ResourceAgent ipService;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.setEnabled(false);
                    }
                });
                Tools.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        this.removeAll();
                    }
                });
                final Point2D pos = this.getPos();
                final CRMXML crmXML = ServiceInfo.this.getBrowser().getCRMXML();
                final ResourceAgent fsService = crmXML.getResourceAgent("Filesystem", "heartbeat", "ocf");
                final 35 thisMenu = this;
                if (crmXML.isLinbitDrbdPresent()) {
                    ResourceAgent linbitDrbdService = crmXML.getHbLinbitDrbd();
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                ServiceInfo.this.addDrbdLinbitMenu(thisMenu, crmXML, pos, fsService, testOnly);
                            }
                        });
                    }
                    catch (InterruptedException ix) {
                        Thread.currentThread().interrupt();
                    }
                    catch (InvocationTargetException x) {
                        Tools.printStackTrace();
                    }
                }
                if (crmXML.isDrbddiskPresent()) {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                ServiceInfo.this.addDrbddiskMenu(thisMenu, crmXML, pos, fsService, testOnly);
                            }
                        });
                    }
                    catch (InterruptedException ix) {
                        Thread.currentThread().interrupt();
                    }
                    catch (InvocationTargetException x) {
                        Tools.printStackTrace();
                    }
                }
                if ((ipService = crmXML.getResourceAgent("IPaddr2", "heartbeat", "ocf")) != null) {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                ServiceInfo.this.addIpMenu(thisMenu, pos, ipService, testOnly);
                            }
                        });
                    }
                    catch (InterruptedException ix) {
                        Thread.currentThread().interrupt();
                    }
                    catch (InvocationTargetException x) {
                        Tools.printStackTrace();
                    }
                }
                if (fsService != null) {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                ServiceInfo.this.addFilesystemMenu(thisMenu, pos, fsService, testOnly);
                            }
                        });
                    }
                    catch (InterruptedException ix) {
                        Thread.currentThread().interrupt();
                    }
                    catch (InvocationTargetException x) {
                        Tools.printStackTrace();
                    }
                }
                final ArrayList popups = new ArrayList();
                for (final String cl : ClusterBrowser.HB_CLASSES) {
                    List<ResourceAgent> services = ServiceInfo.this.getAddServiceList(cl);
                    if (services.size() == 0) continue;
                    final JCheckBox colocationWi = new JCheckBox("Colo", true);
                    final JCheckBox orderWi = new JCheckBox("Order", true);
                    colocationWi.setBackground(ClusterBrowser.STATUS_BACKGROUND);
                    colocationWi.setPreferredSize(colocationWi.getMinimumSize());
                    orderWi.setBackground(ClusterBrowser.STATUS_BACKGROUND);
                    orderWi.setPreferredSize(orderWi.getMinimumSize());
                    final JPanel colOrdPanel = new JPanel(new FlowLayout(0, 0, 0));
                    colOrdPanel.setBackground(ClusterBrowser.STATUS_BACKGROUND);
                    colOrdPanel.add(colocationWi);
                    colOrdPanel.add(orderWi);
                    boolean mode = false;
                    if ("upstart".equals(cl) || "systemd".equals(cl)) {
                        mode = true;
                    }
                    if ("lsb".equals(cl) && !ServiceInfo.this.getAddServiceList("service").isEmpty()) {
                        mode = true;
                    }
                    final MyMenu classItem = new MyMenu(ClusterBrowser.getClassMenu(cl), new AccessMode(ConfigData.AccessType.ADMIN, mode), new AccessMode(ConfigData.AccessType.OP, mode));
                    final MyListModel dlm = new MyListModel();
                    for (final ResourceAgent ra : services) {
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ServiceInfo.this.addResourceAgentMenu(ra, dlm, pos, popups, colocationWi, orderWi, testOnly);
                                }
                            });
                        }
                        catch (InterruptedException ix) {
                            Thread.currentThread().interrupt();
                        }
                        catch (InvocationTargetException x) {
                            Tools.printStackTrace();
                        }
                    }
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                boolean ret = Tools.getScrollingMenu(ClusterBrowser.getClassMenu(cl), colOrdPanel, classItem, dlm, new MyList<MyMenuItem>(dlm, this.getBackground()), thisClass, popups, null);
                                if (!ret) {
                                    classItem.setEnabled(false);
                                }
                                thisMenu.add(classItem);
                            }
                        });
                    }
                    catch (InterruptedException ix) {
                        Thread.currentThread().interrupt();
                    }
                    catch (InvocationTargetException x) {
                        Tools.printStackTrace();
                    }
                }
                super.update();
            }
        };
    }

    protected void addDependencyMenuItems(List<UpdatableItem> items, boolean enableForNew, final boolean testOnly) {
        MyMenuItem addGroupMenuItem = new MyMenuItem(Tools.getString("ClusterBrowser.Hb.AddDependentGroup"), null, null, new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                if (ServiceInfo.this.getBrowser().clStatusFailed()) {
                    return "unknown cluster status";
                }
                if (ServiceInfo.this.getService().isRemoved()) {
                    return ServiceInfo.IS_BEING_REMOVED_STRING;
                }
                if (ServiceInfo.this.getService().isOrphaned()) {
                    return ServiceInfo.IS_ORPHANED_STRING;
                }
                if (ServiceInfo.this.getService().isNew()) {
                    return ServiceInfo.IS_NEW_STRING;
                }
                return null;
            }

            @Override
            public void action() {
                ServiceInfo.this.hidePopup();
                StringInfo gi = new StringInfo("Group", "Group", ServiceInfo.this.getBrowser());
                CRMXML crmXML = ServiceInfo.this.getBrowser().getCRMXML();
                ServiceInfo.this.addServicePanel(crmXML.getHbGroup(), this.getPos(), false, false, true, false, testOnly);
                ServiceInfo.this.getBrowser().getCRMGraph().repaint();
            }
        };
        items.add(addGroupMenuItem);
        MyMenu addServiceMenuItem = this.getAddServiceMenuItem(testOnly, Tools.getString("ClusterBrowser.Hb.AddDependency"));
        items.add(addServiceMenuItem);
        MyMenu existingServiceMenuItem = this.getExistingServiceMenuItem(Tools.getString("ClusterBrowser.Hb.AddStartBefore"), enableForNew, testOnly);
        items.add(existingServiceMenuItem);
    }

    @Override
    public List<UpdatableItem> createPopup() {
        ArrayList<UpdatableItem> items = new ArrayList<UpdatableItem>();
        boolean testOnly = false;
        CloneInfo ci = this.getCloneInfo();
        if (ci == null) {
            this.addDependencyMenuItems(items, false, false);
        }
        MyMenuItem startMenuItem = new MyMenuItem(Tools.getString("ClusterBrowser.Hb.StartResource"), START_ICON, ClusterBrowser.STARTING_PTEST_TOOLTIP, new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public final String enablePredicate() {
                if (ServiceInfo.this.getBrowser().clStatusFailed()) {
                    return "unknown cluster status";
                }
                if (ServiceInfo.this.isStarted(false)) {
                    return Tools.getString("ServiceInfo.AlreadyStarted");
                }
                return ServiceInfo.this.getService().isAvailableWithText();
            }

            @Override
            public void action() {
                ServiceInfo.this.hidePopup();
                ServiceInfo.this.startResource(ServiceInfo.this.getBrowser().getDCHost(), false);
            }
        };
        ClusterBrowser clusterBrowser = this.getBrowser();
        clusterBrowser.getClass();
        ClusterBrowser.ClMenuItemCallback startItemCallback = new ClusterBrowser.ClMenuItemCallback(clusterBrowser, startMenuItem, null){
            {
                ClusterBrowser clusterBrowser = x0;
                clusterBrowser.getClass();
                super(x1, x2);
            }

            @Override
            public void action(Host dcHost) {
                ServiceInfo.this.startResource(dcHost, true);
            }
        };
        this.addMouseOverListener(startMenuItem, startItemCallback);
        items.add(startMenuItem);
        MyMenuItem stopMenuItem = new MyMenuItem(Tools.getString("ClusterBrowser.Hb.StopResource"), STOP_ICON, ClusterBrowser.STARTING_PTEST_TOOLTIP, new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                if (ServiceInfo.this.getBrowser().clStatusFailed()) {
                    return "unknown cluster status";
                }
                if (ServiceInfo.this.isStopped(false)) {
                    return Tools.getString("ServiceInfo.AlreadyStopped");
                }
                return ServiceInfo.this.getService().isAvailableWithText();
            }

            @Override
            public void action() {
                ServiceInfo.this.hidePopup();
                ServiceInfo.this.stopResource(ServiceInfo.this.getBrowser().getDCHost(), false);
            }
        };
        ClusterBrowser clusterBrowser2 = this.getBrowser();
        clusterBrowser2.getClass();
        ClusterBrowser.ClMenuItemCallback stopItemCallback = new ClusterBrowser.ClMenuItemCallback(clusterBrowser2, stopMenuItem, null){
            {
                ClusterBrowser clusterBrowser = x0;
                clusterBrowser.getClass();
                super(x1, x2);
            }

            @Override
            public void action(Host dcHost) {
                ServiceInfo.this.stopResource(dcHost, true);
            }
        };
        this.addMouseOverListener(stopMenuItem, stopItemCallback);
        items.add(stopMenuItem);
        MyMenuItem upMenuItem = new MyMenuItem(Tools.getString("ClusterBrowser.Hb.UpResource"), GROUP_UP_ICON, ClusterBrowser.STARTING_PTEST_TOOLTIP, new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                return ServiceInfo.this.groupInfo != null;
            }

            @Override
            public String enablePredicate() {
                if (ServiceInfo.this.getResource().isNew()) {
                    return ServiceInfo.IS_NEW_STRING;
                }
                GroupInfo gi = ServiceInfo.this.groupInfo;
                if (gi == null) {
                    return "no";
                }
                if (ServiceInfo.this.getBrowser().clStatusFailed()) {
                    return "unknown cluster status";
                }
                DefaultMutableTreeNode giNode = gi.getNode();
                if (giNode == null) {
                    return "no";
                }
                DefaultMutableTreeNode node = ServiceInfo.this.getNode();
                if (node == null) {
                    return "no";
                }
                int index = giNode.getIndex(node);
                if (index == 0) {
                    return "already up";
                }
                return null;
            }

            @Override
            public void action() {
                ServiceInfo.this.hidePopup();
                ServiceInfo.this.upResource(ServiceInfo.this.getBrowser().getDCHost(), false);
            }
        };
        ClusterBrowser clusterBrowser3 = this.getBrowser();
        clusterBrowser3.getClass();
        ClusterBrowser.ClMenuItemCallback upItemCallback = new ClusterBrowser.ClMenuItemCallback(clusterBrowser3, upMenuItem, null){
            {
                ClusterBrowser clusterBrowser = x0;
                clusterBrowser.getClass();
                super(x1, x2);
            }

            @Override
            public void action(Host dcHost) {
                ServiceInfo.this.upResource(dcHost, true);
            }
        };
        this.addMouseOverListener(upMenuItem, upItemCallback);
        items.add(upMenuItem);
        MyMenuItem downMenuItem = new MyMenuItem(Tools.getString("ClusterBrowser.Hb.DownResource"), GROUP_DOWN_ICON, ClusterBrowser.STARTING_PTEST_TOOLTIP, new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                return ServiceInfo.this.groupInfo != null;
            }

            @Override
            public String enablePredicate() {
                if (ServiceInfo.this.getResource().isNew()) {
                    return ServiceInfo.IS_NEW_STRING;
                }
                GroupInfo gi = ServiceInfo.this.groupInfo;
                if (gi == null) {
                    return "no";
                }
                if (ServiceInfo.this.getBrowser().clStatusFailed()) {
                    return "unknown cluster status";
                }
                DefaultMutableTreeNode giNode = gi.getNode();
                if (giNode == null) {
                    return "no";
                }
                DefaultMutableTreeNode node = ServiceInfo.this.getNode();
                if (node == null) {
                    return "no";
                }
                int index = giNode.getIndex(node);
                if (index >= giNode.getChildCount() - 1) {
                    return "already down";
                }
                return null;
            }

            @Override
            public void action() {
                ServiceInfo.this.hidePopup();
                ServiceInfo.this.downResource(ServiceInfo.this.getBrowser().getDCHost(), false);
            }
        };
        ClusterBrowser clusterBrowser4 = this.getBrowser();
        clusterBrowser4.getClass();
        ClusterBrowser.ClMenuItemCallback downItemCallback = new ClusterBrowser.ClMenuItemCallback(clusterBrowser4, downMenuItem, null){
            {
                ClusterBrowser clusterBrowser = x0;
                clusterBrowser.getClass();
                super(x1, x2);
            }

            @Override
            public void action(Host dcHost) {
                ServiceInfo.this.downResource(dcHost, true);
            }
        };
        this.addMouseOverListener(downMenuItem, downItemCallback);
        items.add(downMenuItem);
        MyMenuItem cleanupMenuItem = new MyMenuItem(Tools.getString("ClusterBrowser.Hb.CleanUpFailedResource"), SERVICE_RUNNING_ICON, ClusterBrowser.STARTING_PTEST_TOOLTIP, Tools.getString("ClusterBrowser.Hb.CleanUpResource"), SERVICE_RUNNING_ICON, ClusterBrowser.STARTING_PTEST_TOOLTIP, new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean predicate() {
                return ServiceInfo.this.getService().isAvailable() && ServiceInfo.this.isOneFailed(false);
            }

            @Override
            public String enablePredicate() {
                if (ServiceInfo.this.getBrowser().clStatusFailed()) {
                    return "unknown cluster status";
                }
                if (!ServiceInfo.this.isOneFailedCount(false)) {
                    return "no fail count";
                }
                return ServiceInfo.this.getService().isAvailableWithText();
            }

            @Override
            public void action() {
                ServiceInfo.this.hidePopup();
                ServiceInfo.this.cleanupResource(ServiceInfo.this.getBrowser().getDCHost(), false);
            }
        };
        items.add(cleanupMenuItem);
        MyMenuItem manageMenuItem = new MyMenuItem(Tools.getString("ClusterBrowser.Hb.ManageResource"), MANAGE_BY_CRM_ICON, ClusterBrowser.STARTING_PTEST_TOOLTIP, Tools.getString("ClusterBrowser.Hb.UnmanageResource"), UNMANAGE_BY_CRM_ICON, ClusterBrowser.STARTING_PTEST_TOOLTIP, new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean predicate() {
                return !ServiceInfo.this.isManaged(false);
            }

            @Override
            public String enablePredicate() {
                if (ServiceInfo.this.getBrowser().clStatusFailed()) {
                    return "unknown cluster status";
                }
                return ServiceInfo.this.getService().isAvailableWithText();
            }

            @Override
            public void action() {
                ServiceInfo.this.hidePopup();
                if (this.getText().equals(Tools.getString("ClusterBrowser.Hb.ManageResource"))) {
                    ServiceInfo.this.setManaged(true, ServiceInfo.this.getBrowser().getDCHost(), false);
                } else {
                    ServiceInfo.this.setManaged(false, ServiceInfo.this.getBrowser().getDCHost(), false);
                }
            }
        };
        ClusterBrowser clusterBrowser5 = this.getBrowser();
        clusterBrowser5.getClass();
        ClusterBrowser.ClMenuItemCallback manageItemCallback = new ClusterBrowser.ClMenuItemCallback(clusterBrowser5, manageMenuItem, null){
            {
                ClusterBrowser clusterBrowser = x0;
                clusterBrowser.getClass();
                super(x1, x2);
            }

            @Override
            public void action(Host dcHost) {
                ServiceInfo.this.setManaged(!ServiceInfo.this.isManaged(false), dcHost, true);
            }
        };
        this.addMouseOverListener(manageMenuItem, manageItemCallback);
        items.add(manageMenuItem);
        this.addMigrateMenuItems(items);
        if (ci == null) {
            MyMenuItem removeMenuItem = new MyMenuItem(Tools.getString("ClusterBrowser.Hb.RemoveService"), ClusterBrowser.REMOVE_ICON, ClusterBrowser.STARTING_PTEST_TOOLTIP, new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
                private static final long serialVersionUID = 1L;

                @Override
                public String enablePredicate() {
                    if (ServiceInfo.this.getService().isNew()) {
                        return null;
                    }
                    if (ServiceInfo.this.getBrowser().clStatusFailed()) {
                        return "unknown cluster status";
                    }
                    if (ServiceInfo.this.getService().isRemoved()) {
                        return ServiceInfo.IS_BEING_REMOVED_STRING;
                    }
                    if (ServiceInfo.this.isRunning(false) && !Tools.getConfigData().isAdvancedMode()) {
                        return "cannot remove running resource<br>(advanced mode only)";
                    }
                    if (ServiceInfo.this.groupInfo == null) {
                        return null;
                    }
                    ClusterStatus cs = ServiceInfo.this.getBrowser().getClusterStatus();
                    List<String> gr = cs.getGroupResources(ServiceInfo.this.groupInfo.getHeartbeatId(false), false);
                    if (gr != null && gr.size() > 1) {
                        return null;
                    }
                    return "you can remove the group";
                }

                @Override
                public void action() {
                    ServiceInfo.this.hidePopup();
                    if (ServiceInfo.this.getService().isOrphaned()) {
                        ServiceInfo.this.cleanupResource(ServiceInfo.this.getBrowser().getDCHost(), false);
                    } else {
                        ServiceInfo.this.removeMyself(false);
                    }
                    ServiceInfo.this.getBrowser().getCRMGraph().repaint();
                }
            };
            ServiceInfo thisClass = this;
            ClusterBrowser clusterBrowser6 = this.getBrowser();
            clusterBrowser6.getClass();
            ClusterBrowser.ClMenuItemCallback removeItemCallback = new ClusterBrowser.ClMenuItemCallback(clusterBrowser6, removeMenuItem, null){
                {
                    ClusterBrowser clusterBrowser = x0;
                    clusterBrowser.getClass();
                    super(x1, x2);
                }

                @Override
                public final boolean isEnabled() {
                    return super.isEnabled() && !ServiceInfo.this.getService().isNew();
                }

                @Override
                public final void action(Host dcHost) {
                    ServiceInfo.this.removeMyselfNoConfirm(dcHost, true);
                }
            };
            this.addMouseOverListener(removeMenuItem, removeItemCallback);
            items.add(removeMenuItem);
        }
        MyMenuItem viewLogMenu = new MyMenuItem(Tools.getString("ClusterBrowser.Hb.ViewServiceLog"), LOGFILE_ICON, null, new AccessMode(ConfigData.AccessType.RO, false), new AccessMode(ConfigData.AccessType.RO, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                if (ServiceInfo.this.getService().isNew()) {
                    return ServiceInfo.IS_NEW_STRING;
                }
                return null;
            }

            @Override
            public void action() {
                ServiceInfo.this.hidePopup();
                ServiceLogs l = new ServiceLogs(ServiceInfo.this.getBrowser().getCluster(), ServiceInfo.this.getNameForLog(), ServiceInfo.this.getService().getHeartbeatId());
                l.showDialog();
            }
        };
        items.add(viewLogMenu);
        MyMenu migrateSubmenu = new MyMenu(Tools.getString("ClusterBrowser.MigrateSubmenu"), new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                return null;
            }
        };
        items.add(migrateSubmenu);
        this.addMoreMigrateMenuItems(migrateSubmenu);
        MyMenu filesSubmenu = new MyMenu(Tools.getString("ClusterBrowser.FilesSubmenu"), new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.ADMIN, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                return null;
            }

            @Override
            public void update() {
                super.update();
                final 52 self = this;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.removeAll();
                        ServiceInfo.this.addFilesMenuItems(self);
                    }
                });
            }
        };
        items.add(filesSubmenu);
        return items;
    }

    protected void addMigrateMenuItems(List<UpdatableItem> items) {
        boolean testOnly = false;
        ServiceInfo thisClass = this;
        for (final Host host : this.getBrowser().getClusterHosts()) {
            final String hostName = host.getName();
            MyMenuItem migrateFromMenuItem = new MyMenuItem(Tools.getString("ClusterBrowser.Hb.MigrateFromResource") + " " + hostName, MIGRATE_ICON, ClusterBrowser.STARTING_PTEST_TOOLTIP, Tools.getString("ClusterBrowser.Hb.MigrateFromResource") + " " + hostName + " (offline)", MIGRATE_ICON, ClusterBrowser.STARTING_PTEST_TOOLTIP, new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean predicate() {
                    return host.isClStatus();
                }

                @Override
                public boolean visiblePredicate() {
                    return !host.isClStatus() || this.enablePredicate() == null;
                }

                @Override
                public String enablePredicate() {
                    List<String> runningOnNodes = ServiceInfo.this.getRunningOnNodes(false);
                    if (runningOnNodes == null || runningOnNodes.size() < 1) {
                        return "must run";
                    }
                    boolean runningOnNode = false;
                    for (String ron : runningOnNodes) {
                        if (!hostName.toLowerCase(Locale.US).equals(ron.toLowerCase(Locale.US))) continue;
                        runningOnNode = true;
                        break;
                    }
                    if (!ServiceInfo.this.getBrowser().clStatusFailed() && ServiceInfo.this.getService().isAvailable() && runningOnNode && host.isClStatus()) {
                        return null;
                    }
                    return "";
                }

                @Override
                public void action() {
                    ServiceInfo.this.hidePopup();
                    ServiceInfo.this.migrateFromResource(ServiceInfo.this.getBrowser().getDCHost(), hostName, false);
                }
            };
            ClusterBrowser clusterBrowser = this.getBrowser();
            clusterBrowser.getClass();
            ClusterBrowser.ClMenuItemCallback migrateItemCallback = new ClusterBrowser.ClMenuItemCallback(clusterBrowser, migrateFromMenuItem, null){
                {
                    ClusterBrowser clusterBrowser = x0;
                    clusterBrowser.getClass();
                    super(x1, x2);
                }

                @Override
                public void action(Host dcHost) {
                    ServiceInfo.this.migrateFromResource(dcHost, hostName, true);
                }
            };
            this.addMouseOverListener(migrateFromMenuItem, migrateItemCallback);
            items.add(migrateFromMenuItem);
        }
        MyMenuItem unmigrateMenuItem = new MyMenuItem(Tools.getString("ClusterBrowser.Hb.UnmigrateResource"), UNMIGRATE_ICON, ClusterBrowser.STARTING_PTEST_TOOLTIP, new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                return this.enablePredicate() == null;
            }

            @Override
            public String enablePredicate() {
                if (!ServiceInfo.this.getBrowser().clStatusFailed() && ServiceInfo.this.getService().isAvailable() && (ServiceInfo.this.getMigratedTo(false) != null || ServiceInfo.this.getMigratedFrom(false) != null)) {
                    return null;
                }
                return "";
            }

            @Override
            public void action() {
                ServiceInfo.this.hidePopup();
                ServiceInfo.this.unmigrateResource(ServiceInfo.this.getBrowser().getDCHost(), false);
            }
        };
        ClusterBrowser clusterBrowser = this.getBrowser();
        clusterBrowser.getClass();
        ClusterBrowser.ClMenuItemCallback unmigrateItemCallback = new ClusterBrowser.ClMenuItemCallback(clusterBrowser, unmigrateMenuItem, null){
            {
                ClusterBrowser clusterBrowser = x0;
                clusterBrowser.getClass();
                super(x1, x2);
            }

            @Override
            public void action(Host dcHost) {
                ServiceInfo.this.unmigrateResource(dcHost, true);
            }
        };
        this.addMouseOverListener(unmigrateMenuItem, unmigrateItemCallback);
        items.add(unmigrateMenuItem);
    }

    protected void addMoreMigrateMenuItems(MyMenu submenu) {
        String hostName;
        boolean testOnly = false;
        ServiceInfo thisClass = this;
        for (final Host host : this.getBrowser().getClusterHosts()) {
            hostName = host.getName();
            MyMenuItem migrateMenuItem = new MyMenuItem(Tools.getString("ClusterBrowser.Hb.MigrateResource") + " " + hostName, MIGRATE_ICON, ClusterBrowser.STARTING_PTEST_TOOLTIP, Tools.getString("ClusterBrowser.Hb.MigrateResource") + " " + hostName + " (offline)", MIGRATE_ICON, ClusterBrowser.STARTING_PTEST_TOOLTIP, new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean predicate() {
                    return host.isClStatus();
                }

                @Override
                public boolean visiblePredicate() {
                    return !host.isClStatus() || this.enablePredicate() == null;
                }

                @Override
                public String enablePredicate() {
                    List<String> runningOnNodes = ServiceInfo.this.getRunningOnNodes(false);
                    if (runningOnNodes == null || runningOnNodes.isEmpty()) {
                        return Tools.getString("ServiceInfo.NotRunningAnywhere");
                    }
                    String runningOnNode = runningOnNodes.get(0).toLowerCase(Locale.US);
                    if (ServiceInfo.this.getBrowser().clStatusFailed() || !host.isClStatus()) {
                        return "unknown cluster status";
                    }
                    String tp = ServiceInfo.this.getService().isAvailableWithText();
                    if (tp != null) {
                        return tp;
                    }
                    if (hostName.toLowerCase(Locale.US).equals(runningOnNode)) {
                        return Tools.getString("ServiceInfo.AlreadyRunningOnNode");
                    }
                    return null;
                }

                @Override
                public void action() {
                    ServiceInfo.this.hidePopup();
                    ServiceInfo.this.migrateResource(hostName, ServiceInfo.this.getBrowser().getDCHost(), false);
                }
            };
            ClusterBrowser clusterBrowser = this.getBrowser();
            clusterBrowser.getClass();
            ClusterBrowser.ClMenuItemCallback migrateItemCallback = new ClusterBrowser.ClMenuItemCallback(clusterBrowser, migrateMenuItem, null){
                {
                    ClusterBrowser clusterBrowser = x0;
                    clusterBrowser.getClass();
                    super(x1, x2);
                }

                @Override
                public void action(Host dcHost) {
                    ServiceInfo.this.migrateResource(hostName, dcHost, true);
                }
            };
            this.addMouseOverListener(migrateMenuItem, migrateItemCallback);
            submenu.add(migrateMenuItem);
        }
        for (final Host host : this.getBrowser().getClusterHosts()) {
            hostName = host.getName();
            MyMenuItem forceMigrateMenuItem = new MyMenuItem(Tools.getString("ClusterBrowser.Hb.ForceMigrateResource") + " " + hostName, MIGRATE_ICON, ClusterBrowser.STARTING_PTEST_TOOLTIP, Tools.getString("ClusterBrowser.Hb.ForceMigrateResource") + " " + hostName + " (offline)", MIGRATE_ICON, ClusterBrowser.STARTING_PTEST_TOOLTIP, new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean predicate() {
                    return host.isClStatus();
                }

                @Override
                public boolean visiblePredicate() {
                    return !host.isClStatus() || this.enablePredicate() == null;
                }

                @Override
                public String enablePredicate() {
                    List<String> runningOnNodes = ServiceInfo.this.getRunningOnNodes(false);
                    if (runningOnNodes == null || runningOnNodes.isEmpty()) {
                        return Tools.getString("ServiceInfo.NotRunningAnywhere");
                    }
                    String runningOnNode = runningOnNodes.get(0).toLowerCase(Locale.US);
                    if (!ServiceInfo.this.getBrowser().clStatusFailed() && ServiceInfo.this.getService().isAvailable() && !hostName.toLowerCase(Locale.US).equals(runningOnNode) && host.isClStatus()) {
                        return null;
                    }
                    return "";
                }

                @Override
                public void action() {
                    ServiceInfo.this.hidePopup();
                    ServiceInfo.this.forceMigrateResource(hostName, ServiceInfo.this.getBrowser().getDCHost(), false);
                }
            };
            ClusterBrowser clusterBrowser = this.getBrowser();
            clusterBrowser.getClass();
            ClusterBrowser.ClMenuItemCallback forceMigrateItemCallback = new ClusterBrowser.ClMenuItemCallback(clusterBrowser, forceMigrateMenuItem, null){
                {
                    ClusterBrowser clusterBrowser = x0;
                    clusterBrowser.getClass();
                    super(x1, x2);
                }

                @Override
                public void action(Host dcHost) {
                    ServiceInfo.this.forceMigrateResource(hostName, dcHost, true);
                }
            };
            this.addMouseOverListener(forceMigrateMenuItem, forceMigrateItemCallback);
            submenu.add(forceMigrateMenuItem);
        }
    }

    private List<String> getConfigFiles() {
        ServiceInfo cs = this.getContainedService();
        String raName = cs == null ? this.getResourceAgent().getRAString() : cs.getResourceAgent().getRAString();
        Host[] hosts = this.getBrowser().getCluster().getHostsArray();
        ArrayList<String> cfs = new ArrayList<String>(hosts[0].getDistStrings(raName + ".files"));
        ArrayList<String> params = new ArrayList<String>(hosts[0].getDistStrings(raName + ".params"));
        params.add("configfile");
        params.add("config");
        params.add("conffile");
        for (String param : params) {
            Widget wi;
            String value = cs == null ? ((wi = this.getWidget(param, null)) == null ? this.getParamSaved(param) : wi.getStringValue()) : ((wi = cs.getWidget(param, null)) == null ? cs.getParamSaved(param) : wi.getStringValue());
            if (value == null || "".equals(value)) continue;
            cfs.add(value);
        }
        return cfs;
    }

    protected void addFilesMenuItems(MyMenu submenu) {
        boolean testOnly = false;
        ServiceInfo thisClass = this;
        List<String> configFiles = this.getConfigFiles();
        for (final String configFile : configFiles) {
            MyMenuItem fileItem = new MyMenuItem(configFile, null, null, new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.ADMIN, false)){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean predicate() {
                    return true;
                }

                @Override
                public boolean visiblePredicate() {
                    return true;
                }

                @Override
                public String enablePredicate() {
                    return null;
                }

                @Override
                public void action() {
                    EditConfig ed = new EditConfig(configFile, ServiceInfo.this.getBrowser().getCluster().getHosts());
                    ed.showDialog();
                }
            };
            submenu.add(fileItem);
        }
    }

    @Override
    public String getToolTipText(boolean testOnly) {
        String textNotOn;
        String textOn;
        String nodeString = null;
        List<String> nodes = this.getRunningOnNodes(testOnly);
        if (nodes != null && !nodes.isEmpty()) {
            nodeString = Tools.join(", ", nodes.toArray(new String[nodes.size()]));
        }
        Host[] hosts = this.getBrowser().getCluster().getHostsArray();
        if (this.getBrowser().allHostsDown()) {
            nodeString = "unknown";
        }
        StringBuilder sb = new StringBuilder(200);
        sb.append("<b>");
        sb.append(this.toString());
        if (this.getResourceAgent().isFilesystem()) {
            textOn = Tools.getString("ServiceInfo.Filesystem.MoutedOn");
            textNotOn = Tools.getString("ServiceInfo.Filesystem.NotMounted");
        } else {
            textOn = Tools.getString("ServiceInfo.Filesystem.RunningOn");
            textNotOn = Tools.getString("ServiceInfo.Filesystem.NotRunning");
        }
        if (this.isFailed(testOnly)) {
            sb.append("</b> <b>Failed</b>");
        } else if (this.isStopped(testOnly) || nodeString == null) {
            sb.append("</b> " + textNotOn);
        } else {
            sb.append("</b> " + textOn + ": ");
            sb.append(nodeString);
        }
        if (!this.isManaged(testOnly)) {
            sb.append(" (unmanaged)");
        }
        Map<String, String> scores = this.getBrowser().getClusterStatus().getAllocationScores(this.getHeartbeatId(testOnly), testOnly);
        for (String h : scores.keySet()) {
            sb.append("<br>allocation score on ");
            sb.append(h);
            sb.append(": ");
            sb.append(scores.get(h));
        }
        return sb.toString();
    }

    public ResourceAgent getResourceAgent() {
        return this.resourceAgent;
    }

    @Override
    public void setUpdated(boolean updated) {
        GroupInfo gi = this.groupInfo;
        if (gi != null) {
            gi.setUpdated(updated);
            return;
        }
        CloneInfo ci = this.cloneInfo;
        if (ci != null) {
            ci.setUpdated(updated);
            return;
        }
        if (updated && !this.isUpdated()) {
            this.getBrowser().getCRMGraph().startAnimation(this);
        } else if (!updated) {
            this.getBrowser().getCRMGraph().stopAnimation(this);
        }
        super.setUpdated(updated);
    }

    public Subtext getRightCornerTextForGraph(boolean testOnly) {
        if (this.getService().isOrphaned()) {
            if (this.isFailed(testOnly)) {
                return ORPHANED_FAILED_SUBTEXT;
            }
            return ORPHANED_SUBTEXT;
        }
        if (!this.isManaged(testOnly)) {
            return UNMANAGED_SUBTEXT;
        }
        if (this.getMigratedTo(testOnly) != null || this.getMigratedFrom(testOnly) != null) {
            return MIGRATED_SUBTEXT;
        }
        return null;
    }

    public Subtext[] getSubtextsForGraph(boolean testOnly) {
        String textNotOn;
        String textOn;
        Color color = null;
        ArrayList<Subtext> texts = new ArrayList<Subtext>();
        if (this.getResourceAgent().isFilesystem()) {
            textOn = Tools.getString("ServiceInfo.Filesystem.MoutedOn");
            textNotOn = Tools.getString("ServiceInfo.Filesystem.NotMounted");
        } else {
            textOn = Tools.getString("ServiceInfo.Filesystem.RunningOn");
            textNotOn = Tools.getString("ServiceInfo.Filesystem.NotRunning");
        }
        if (this.getService().isOrphaned()) {
            texts.add(new Subtext("...", null, Color.BLACK));
        } else if (this.getResource().isNew()) {
            texts.add(new Subtext(textNotOn + " (new)", ClusterBrowser.FILL_PAINT_STOPPED, Color.BLACK));
        } else if (this.isFailed(testOnly)) {
            texts.add(new Subtext(textNotOn, null, Color.BLACK));
        } else if (this.isStopped(testOnly) && !this.isRunning(testOnly)) {
            texts.add(new Subtext("stopped", ClusterBrowser.FILL_PAINT_STOPPED, Color.BLACK));
        } else {
            Color textColor = Color.BLACK;
            String runningOnNodeString = null;
            if (this.getBrowser().allHostsDown()) {
                runningOnNodeString = "unknown";
            } else {
                List<String> runningOnNodes = this.getRunningOnNodes(testOnly);
                if (runningOnNodes != null && !runningOnNodes.isEmpty()) {
                    runningOnNodeString = runningOnNodes.get(0);
                    if (this.resourceAgent.isPingService() && "0".equals(this.getPingCount(runningOnNodeString, testOnly))) {
                        color = Color.RED;
                        textColor = Color.WHITE;
                    } else {
                        color = this.getBrowser().getCluster().getHostColors(runningOnNodes).get(0);
                    }
                }
            }
            if (runningOnNodeString == null) {
                texts.add(new Subtext(textNotOn, ClusterBrowser.FILL_PAINT_STOPPED, textColor));
            } else {
                texts.add(new Subtext(textOn + ": " + runningOnNodeString + this.getPingCountString(runningOnNodeString, testOnly), color, textColor));
            }
        }
        if (this.isOneFailedCount(testOnly)) {
            for (Host host : this.getBrowser().getClusterHosts()) {
                if (!host.isClStatus() || this.getFailCount(host.getName(), testOnly) == null) continue;
                texts.add(new Subtext("    " + host.getName() + this.getFailCountString(host.getName(), testOnly), null, Color.BLACK));
            }
        }
        return texts.toArray(new Subtext[texts.size()]);
    }

    public ServiceInfo getContainedService() {
        return null;
    }

    Widget getTypeRadioGroup() {
        return this.typeRadioGroup;
    }

    @Override
    protected final Unit[] getUnits() {
        return new Unit[]{new Unit("", "s", "Second", "Seconds"), new Unit("ms", "ms", "Millisecond", "Milliseconds"), new Unit("us", "us", "Microsecond", "Microseconds"), new Unit("s", "s", "Second", "Seconds"), new Unit("min", "m", "Minute", "Minutes"), new Unit("h", "h", "Hour", "Hours")};
    }

    protected boolean isSlaveOnAllNodes(boolean testOnly) {
        return false;
    }

    public String getIconTextForGraph(boolean testOnly) {
        if (this.getBrowser().allHostsDown()) {
            return Tools.getString("ClusterBrowser.Hb.NoInfoAvailable");
        }
        Host dcHost = this.getBrowser().getDCHost();
        if (this.getService().isNew()) {
            return "new...";
        }
        if (this.getService().isOrphaned()) {
            return "";
        }
        if (this.isEnslaved(testOnly)) {
            if (this.isSlaveOnAllNodes(testOnly)) {
                return "";
            }
            return Tools.getString("ClusterBrowser.Hb.Enslaving");
        }
        if (this.isStarted(testOnly)) {
            if (this.isRunning(testOnly)) {
                List<Host> migratedTo = this.getMigratedTo(testOnly);
                if (migratedTo == null) {
                    List<Host> migratedFrom = this.getMigratedFrom(testOnly);
                    if (migratedFrom != null) {
                        List<String> runningOnNodes = this.getRunningOnNodes(testOnly);
                        boolean alreadyThere = false;
                        if (runningOnNodes == null) {
                            alreadyThere = true;
                        } else {
                            alreadyThere = true;
                            for (Host mfrom : migratedFrom) {
                                if (!runningOnNodes.contains(mfrom.getName())) continue;
                                alreadyThere = false;
                            }
                        }
                        if (!alreadyThere) {
                            return Tools.getString("ClusterBrowser.Hb.Migrating");
                        }
                    }
                } else {
                    List<String> runningOnNodes = this.getRunningOnNodes(testOnly);
                    if (runningOnNodes != null) {
                        boolean alreadyThere = false;
                        for (Host mto : migratedTo) {
                            if (runningOnNodes.contains(mto.getName())) {
                                alreadyThere = true;
                            }
                            if (alreadyThere) continue;
                            return Tools.getString("ClusterBrowser.Hb.Migrating");
                        }
                    }
                }
                return null;
            }
            if (this.isFailed(testOnly)) {
                return Tools.getString("ClusterBrowser.Hb.StartingFailed");
            }
            if (this.isGroupStopped(testOnly)) {
                return Tools.getString("ClusterBrowser.Hb.GroupStopped");
            }
            return Tools.getString("ClusterBrowser.Hb.Starting");
        }
        if (this.isStopped(testOnly)) {
            if (this.isRunning(testOnly)) {
                return Tools.getString("ClusterBrowser.Hb.Stopping");
            }
            return null;
        }
        return null;
    }

    MultiKeyMap<String, String> getSavedOperation() {
        return this.savedOperation;
    }

    @Override
    public void reloadComboBoxes() {
        String idRef;
        if (this.sameAsOperationsWi != null) {
            String defaultOpIdRef = null;
            Info savedOpIdRef = this.sameAsOperationsWiValue();
            if (savedOpIdRef != null) {
                defaultOpIdRef = savedOpIdRef.toString();
            }
            idRef = defaultOpIdRef;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ServiceInfo.this.sameAsOperationsWi.reloadComboBox(idRef, ServiceInfo.this.getSameServicesOperations());
                }
            });
        }
        if (this.sameAsMetaAttrsWi != null) {
            String defaultMAIdRef = null;
            Info savedMAIdRef = this.sameAsMetaAttrsWiValue();
            if (savedMAIdRef != null) {
                defaultMAIdRef = savedMAIdRef.toString();
            }
            idRef = defaultMAIdRef;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ServiceInfo.this.sameAsMetaAttrsWi.reloadComboBox(idRef, ServiceInfo.this.getSameServicesMetaAttrs());
                }
            });
        }
    }

    boolean isInfoPanelOk() {
        return this.infoPanel != null;
    }

    public VMSVirtualDomainInfo connectWithVMS() {
        return null;
    }

    public boolean isConstraintPH() {
        return false;
    }

    void removeConstraints(Host dcHost, boolean testOnly) {
        HbConnectionInfo[] hbcis;
        ClusterStatus cs = this.getBrowser().getClusterStatus();
        for (HbConnectionInfo hbci : hbcis = this.getBrowser().getCRMGraph().getHbConnections(this)) {
            if (hbci == null) continue;
            this.getBrowser().getCRMGraph().removeOrder(hbci, dcHost, testOnly);
            this.getBrowser().getCRMGraph().removeColocation(hbci, dcHost, testOnly);
        }
        for (String locId : cs.getLocationIds(this.getHeartbeatId(testOnly), testOnly)) {
            CRM.removeLocation(dcHost, locId, this.getHeartbeatId(testOnly), testOnly);
        }
    }

    final Info sameAsOperationsWiValue() {
        if (this.sameAsOperationsWi == null) {
            return null;
        }
        Info i = null;
        Object o = this.sameAsOperationsWi.getValue();
        if (o instanceof Info) {
            i = (Info)o;
        }
        return i;
    }

    final Info sameAsMetaAttrsWiValue() {
        if (this.sameAsMetaAttrsWi == null) {
            return null;
        }
        Info i = null;
        Object o = this.sameAsMetaAttrsWi.getValue();
        if (o instanceof Info) {
            i = (Info)o;
        }
        return i;
    }

    final void storeOperations() {
        this.mSavedOperationsLock.lock();
        for (String op : this.getResourceAgent().getOperationNames()) {
            for (String param : this.getBrowser().getCRMOperationParams(op)) {
                String defaultValue = this.resourceAgent.getOperationDefault(op, param);
                if (defaultValue == null) continue;
                this.mOperationsComboBoxHashReadLock.lock();
                Widget wi = this.operationsComboBoxHash.get((K[])new String[]{op, param});
                this.mOperationsComboBoxHashReadLock.unlock();
                this.savedOperation.put(op, param, wi.getStringValue());
            }
        }
        this.mSavedOperationsLock.unlock();
    }

    protected final Map<HostInfo, Widget> getScoreComboBoxHash() {
        return this.scoreComboBoxHash;
    }

    public final Widget getPingComboBox() {
        return this.pingComboBox;
    }

    protected final void setPingComboBox(Widget pingComboBox) {
        this.pingComboBox = pingComboBox;
    }

    public final Widget getOperationsComboBox(String op, String param) {
        this.mOperationsComboBoxHashReadLock.lock();
        Widget wi = this.operationsComboBoxHash.get((K[])new String[]{op, param});
        this.mOperationsComboBoxHashReadLock.unlock();
        return wi;
    }

    public final Widget getSameAsOperationsWi() {
        return this.sameAsOperationsWi;
    }

    static {
        PING_ATTRIBUTES.put("eq0", "no ping: stop");
        PING_ATTRIBUTES.put("defined", "most connections");
    }
}

