/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.resources;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import lcmc.data.AccessMode;
import lcmc.data.ConfigData;
import lcmc.data.Host;
import lcmc.data.VMSXML;
import lcmc.gui.Browser;
import lcmc.gui.resources.BlockDevInfo;
import lcmc.gui.resources.StringInfo;
import lcmc.gui.resources.VMSHardwareInfo;
import lcmc.gui.resources.VMSVirtualDomainInfo;
import lcmc.gui.widget.Widget;
import lcmc.gui.widget.WidgetFactory;
import lcmc.utilities.MyButton;
import lcmc.utilities.Tools;
import org.w3c.dom.Node;

public final class VMSDiskInfo
extends VMSHardwareInfo {
    private final Map<String, Widget> sourceFileWi = new HashMap<String, Widget>();
    private final Map<String, Widget> sourceDeviceWi = new HashMap<String, Widget>();
    private final Map<String, Widget> targetDeviceWi = new HashMap<String, Widget>();
    private final Map<String, Widget> driverNameWi = new HashMap<String, Widget>();
    private final Map<String, Widget> driverTypeWi = new HashMap<String, Widget>();
    private final Map<String, Widget> driverCacheWi = new HashMap<String, Widget>();
    private final Map<String, Widget> readonlyWi = new HashMap<String, Widget>();
    private String prevTargetBus = null;
    private static final String[] PARAMETERS = new String[]{"type", "target_bus_type", "target_device", "source_file", "source_dev", "driver_name", "driver_type", "driver_cache", "readonly", "shareable"};
    private static final String[] BLOCK_PARAMETERS = new String[]{"type", "target_bus_type", "target_device", "source_dev", "driver_name", "driver_type", "driver_cache", "readonly", "shareable"};
    private static final String[] FILE_PARAMETERS = new String[]{"type", "target_device", "source_file", "target_bus_type", "driver_name", "driver_type", "driver_cache", "readonly", "shareable"};
    private static final Set<String> IS_ENABLED_ONLY_IN_ADVANCED = new HashSet<String>(Arrays.asList("target_device", "driver_name", "driver_type", "driver_cache"));
    private static final Set<String> IS_REQUIRED = new HashSet<String>(Arrays.asList("type"));
    private static final Map<String, Widget.Type> FIELD_TYPES = new HashMap<String, Widget.Type>();
    private static final Map<String, String[]> TARGET_DEVICES_MAP = new HashMap<String, String[]>();
    private static final Map<String, String> SHORTNAME_MAP;
    private static final Map<String, String> PREFERRED_MAP;
    private static final Map<String, String> DEFAULTS_MAP;
    private static final Map<String, Object[]> POSSIBLE_VALUES;
    public static final String LIBVIRT_IMAGE_LOCATION = "/var/lib/libvirt/images/";
    private static final Map<String, String> TARGET_BUS_TYPES;
    private static final String FILE_TYPE = "file";
    private static final String BLOCK_TYPE = "block";
    private static final String DRIVER_NAME_DEFUALT;
    private static final String DRIVER_NAME_FILE = "file";
    private static final String DRIVER_NAME_QEMU = "qemu";
    private static final String DRIVER_NAME_PHY = "phy";
    private JComponent tablePanel = null;

    VMSDiskInfo(String name, Browser browser, VMSVirtualDomainInfo vmsVirtualDomainInfo) {
        super(name, browser, vmsVirtualDomainInfo);
    }

    @Override
    protected void addHardwareTable(JPanel mainPanel) {
        this.tablePanel = this.getTablePanel("Disk", "disks", VMSDiskInfo.getNewBtn(this.getVMSVirtualDomainInfo()));
        if (this.getResource().isNew()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    VMSDiskInfo.this.tablePanel.setVisible(false);
                }
            });
        }
        mainPanel.add(this.tablePanel);
    }

    @Override
    public ImageIcon getMenuIcon(boolean testOnly) {
        return BlockDevInfo.HARDDISK_ICON;
    }

    @Override
    protected String getParamLongDesc(String param) {
        return this.getParamShortDesc(param);
    }

    @Override
    protected String getParamShortDesc(String param) {
        String name = SHORTNAME_MAP.get(param);
        if (name == null) {
            return param;
        }
        return name;
    }

    @Override
    protected String getParamPreferred(String param) {
        String domainType = this.getVMSVirtualDomainInfo().getWidget("domain-type", null).getStringValue();
        if ("driver_name".equals(param) && "kvm".equals(domainType)) {
            return DRIVER_NAME_QEMU;
        }
        return PREFERRED_MAP.get(param);
    }

    @Override
    protected String getParamDefault(String param) {
        return DEFAULTS_MAP.get(param);
    }

    @Override
    public String[] getParametersFromXML() {
        return (String[])PARAMETERS.clone();
    }

    @Override
    public String[] getRealParametersFromXML() {
        if (BLOCK_TYPE.equals(this.getComboBoxValue("type"))) {
            return (String[])BLOCK_PARAMETERS.clone();
        }
        return (String[])FILE_PARAMETERS.clone();
    }

    @Override
    protected Object[] getParamPossibleChoices(String param) {
        if ("source_file".equals(param)) {
            TreeSet<String> sourceFileDirs = new TreeSet<String>();
            sourceFileDirs.add(LIBVIRT_IMAGE_LOCATION);
            for (Host h : this.getVMSVirtualDomainInfo().getDefinedOnHosts()) {
                VMSXML vmsxml = this.getBrowser().getVMSXML(h);
                sourceFileDirs.addAll(vmsxml.getsourceFileDirs());
            }
            return sourceFileDirs.toArray(new String[sourceFileDirs.size()]);
        }
        if ("source_dev".equals(param)) {
            for (Host h : this.getVMSVirtualDomainInfo().getDefinedOnHosts()) {
                VMSXML vmsxml = this.getBrowser().getVMSXML(h);
                ArrayList<String> bds = new ArrayList<String>();
                bds.add(null);
                if (vmsxml == null) continue;
                for (BlockDevInfo bdi : h.getBrowser().getBlockDevInfos()) {
                    if (bdi.getBlockDevice().isDrbd()) {
                        bds.add(bdi.getDrbdVolumeInfo().getDeviceByRes());
                        continue;
                    }
                    bds.add(bdi.getName());
                }
                return bds.toArray(new String[bds.size()]);
            }
        }
        return POSSIBLE_VALUES.get(param);
    }

    @Override
    protected String getSection(String param) {
        return "Disk Options";
    }

    @Override
    protected boolean isRequired(String param) {
        String type = this.getComboBoxValue("type");
        if ("source_file".equals(param) && "file".equals(type) || "source_dev".equals(param) && BLOCK_TYPE.equals(type)) {
            return !"ide/cdrom".equals(this.getComboBoxValue("target_bus_type")) && !"fdc/floppy".equals(this.getComboBoxValue("target_bus_type"));
        }
        return IS_REQUIRED.contains(param);
    }

    @Override
    protected boolean isInteger(String param) {
        return false;
    }

    @Override
    protected boolean isLabel(String param) {
        return false;
    }

    @Override
    protected boolean isTimeType(String param) {
        return false;
    }

    @Override
    protected boolean isCheckBox(String param) {
        return false;
    }

    @Override
    protected String getParamType(String param) {
        return "undef";
    }

    @Override
    protected Widget.Type getFieldType(String param) {
        return FIELD_TYPES.get(param);
    }

    @Override
    protected Map<String, String> getHWParameters(boolean allParams) {
        Tools.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                VMSDiskInfo.this.getInfoPanel();
            }
        });
        String[] params = this.getRealParametersFromXML();
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (String param : params) {
            String value = this.getComboBoxValue(param);
            if ("type".equals(param)) {
                parameters.put(param, value);
                continue;
            }
            if ("target_bus_type".equals(param)) {
                if (value == null) {
                    parameters.put("target_bus", null);
                    parameters.put("target_type", null);
                    continue;
                }
                String[] values = value.split("/");
                if (values.length == 2) {
                    parameters.put("target_bus", values[0]);
                    parameters.put("target_type", values[1]);
                    continue;
                }
                Tools.appWarning("cannot parse: " + param + " = " + value);
                continue;
            }
            if (allParams) {
                if (Tools.areEqual(this.getParamDefault(param), value)) {
                    parameters.put(param, null);
                    continue;
                }
                parameters.put(param, value);
                continue;
            }
            if (Tools.areEqual(this.getParamSaved(param), value) && !"source_file".equals(param) && !"source_dev".equals(param)) continue;
            if (Tools.areEqual(this.getParamDefault(param), value)) {
                parameters.put(param, null);
                continue;
            }
            parameters.put(param, value);
        }
        parameters.put("saved_target_device", this.getName());
        this.setName(this.getParamSaved("target_device"));
        return parameters;
    }

    @Override
    void apply(boolean testOnly) {
        if (testOnly) {
            return;
        }
        Tools.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                VMSDiskInfo.this.getApplyButton().setEnabled(false);
                VMSDiskInfo.this.getRevertButton().setEnabled(false);
            }
        });
        this.getInfoPanel();
        this.waitForInfoPanel();
        Map<String, String> parameters = this.getHWParameters(this.getResource().isNew());
        String[] params = this.getRealParametersFromXML();
        for (Host h : this.getVMSVirtualDomainInfo().getDefinedOnHosts()) {
            VMSXML vmsxml = this.getBrowser().getVMSXML(h);
            if (vmsxml == null) continue;
            String domainName = this.getVMSVirtualDomainInfo().getDomainName();
            Node domainNode = vmsxml.getDomainNode(domainName);
            this.modifyXML(vmsxml, domainNode, domainName, parameters);
            String virshOptions = this.getVMSVirtualDomainInfo().getVirshOptions();
            vmsxml.saveAndDefine(domainNode, domainName, virshOptions);
        }
        this.getResource().setNew(false);
        this.getBrowser().reload(this.getNode(), false);
        this.getBrowser().periodicalVMSUpdate(this.getVMSVirtualDomainInfo().getDefinedOnHosts());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VMSDiskInfo.this.tablePanel.setVisible(true);
            }
        });
        if (!testOnly) {
            this.storeComboBoxValues(params);
        }
        this.checkResourceFieldsChanged(null, params);
    }

    @Override
    protected void modifyXML(VMSXML vmsxml, Node node, String domainName, Map<String, String> params) {
        if (vmsxml != null) {
            vmsxml.modifyDiskXML(node, domainName, params);
        }
    }

    @Override
    protected Object[][] getTableData(String tableName) {
        if ("header".equals(tableName)) {
            return this.getVMSVirtualDomainInfo().getMainTableData();
        }
        if ("disks".equals(tableName)) {
            if (this.getResource().isNew()) {
                return new Object[0][];
            }
            return new Object[][]{this.getVMSVirtualDomainInfo().getDiskDataRow(this.getName(), null, this.getVMSVirtualDomainInfo().getDisks(), true)};
        }
        return new Object[0][];
    }

    @Override
    protected boolean isAdvanced(String param) {
        return false;
    }

    @Override
    protected ConfigData.AccessType getAccessType(String param) {
        return ConfigData.AccessType.ADMIN;
    }

    @Override
    protected boolean checkParam(String param, final String newValue) {
        if ("type".equals(param)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (String p : VMSDiskInfo.this.sourceFileWi.keySet()) {
                        ((Widget)VMSDiskInfo.this.sourceFileWi.get(p)).setVisible("file".equals(newValue));
                    }
                    for (String p : VMSDiskInfo.this.sourceDeviceWi.keySet()) {
                        ((Widget)VMSDiskInfo.this.sourceDeviceWi.get(p)).setVisible(VMSDiskInfo.BLOCK_TYPE.equals(newValue));
                    }
                }
            });
            this.checkOneParam("source_file");
            this.checkOneParam("source_dev");
        } else if ("target_bus_type".equals(param)) {
            String[] targetDevices;
            LinkedHashSet<String> devices = new LinkedHashSet<String>();
            devices.add(null);
            if (newValue != null && (targetDevices = TARGET_DEVICES_MAP.get(newValue)) != null) {
                for (String dev : targetDevices) {
                    if (this.getVMSVirtualDomainInfo().isDevice(dev)) continue;
                    devices.add(dev);
                }
            }
            String saved = this.getParamSaved("target_device");
            String selected = null;
            devices.add(saved);
            if (saved != null) {
                selected = saved;
            } else if (devices.size() > 1) {
                selected = devices.toArray(new String[devices.size()])[1];
            }
            if (this.prevTargetBus == null || !this.prevTargetBus.equals(selected)) {
                String sel = selected;
                for (String p : this.targetDeviceWi.keySet()) {
                    this.targetDeviceWi.get(p).reloadComboBox(sel, devices.toArray(new String[devices.size()]));
                }
                this.prevTargetBus = selected;
            }
            if (this.getParamSaved("driver_name") == null) {
                if ("ide/cdrom".equals(newValue)) {
                    for (String p : this.readonlyWi.keySet()) {
                        this.readonlyWi.get(p).setValue("True");
                    }
                    for (String p : this.driverTypeWi.keySet()) {
                        if (this.getResource().isNew()) {
                            this.driverTypeWi.get(p).setValue("raw");
                            continue;
                        }
                        if (this.driverTypeWi.get(p).getValue() == null) continue;
                        this.driverTypeWi.get(p).setValue(null);
                    }
                } else if ("virtio/disk".equals(newValue)) {
                    for (String p : this.driverTypeWi.keySet()) {
                        this.driverTypeWi.get(p).setValue("raw");
                    }
                    for (String p : this.driverCacheWi.keySet()) {
                        this.driverCacheWi.get(p).setValue("none");
                    }
                } else {
                    for (String p : this.readonlyWi.keySet()) {
                        this.readonlyWi.get(p).setValue("False");
                        if (!this.getResource().isNew()) continue;
                        this.driverTypeWi.get(p).setValue("raw");
                    }
                }
            }
            this.checkOneParam("source_file");
            this.checkOneParam("source_dev");
        }
        return !this.isRequired(param) || newValue != null && !"".equals(newValue);
    }

    @Override
    protected String isEnabled(String param) {
        return null;
    }

    @Override
    protected boolean isEnabledOnlyInAdvancedMode(String param) {
        return IS_ENABLED_ONLY_IN_ADVANCED.contains(param);
    }

    @Override
    void updateParameters() {
        VMSXML.DiskData diskData;
        Map<String, VMSXML.DiskData> disks = this.getVMSVirtualDomainInfo().getDisks();
        if (disks != null && (diskData = disks.get(this.getName())) != null) {
            for (String param : this.getParametersFromXML()) {
                String oldValue = this.getParamSaved(param);
                String value = this.getParamSaved(param);
                Widget wi = this.getWidget(param, null);
                for (Host h : this.getVMSVirtualDomainInfo().getDefinedOnHosts()) {
                    String savedValue;
                    VMSXML vmsxml = this.getBrowser().getVMSXML(h);
                    if (vmsxml == null || (savedValue = diskData.getValue(param)) == null) continue;
                    value = savedValue;
                }
                if (Tools.areEqual(value, oldValue)) continue;
                this.getResource().setValue(param, value);
                if (wi == null) continue;
                wi.setValue(value);
            }
        }
        this.updateTable("header");
        this.updateTable("disks");
        this.setApplyButtons(null, this.getRealParametersFromXML());
    }

    @Override
    protected Widget createWidget(String param, String prefix, int width) {
        if ("source_file".equals(param)) {
            String sourceFile = this.getParamSaved("source_file");
            String regexp = ".*[^/]$";
            MyButton fileChooserBtn = new MyButton("Browse...");
            fileChooserBtn.miniButton();
            final Widget paramWi = WidgetFactory.createInstance(this.getFieldType(param), sourceFile, this.getParamPossibleChoices(param), ".*[^/]$", width, Widget.NO_ABBRV, new AccessMode(this.getAccessType(param), false), fileChooserBtn);
            paramWi.setAlwaysEditable(true);
            if (prefix == null) {
                this.sourceFileWi.put("", paramWi);
            } else {
                this.sourceFileWi.put(prefix, paramWi);
            }
            if (Tools.isWindows()) {
                paramWi.setTFButtonEnabled(false);
            }
            fileChooserBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            String oldFile = paramWi.getStringValue();
                            String file = oldFile == null || "".equals(oldFile) ? VMSDiskInfo.LIBVIRT_IMAGE_LOCATION : oldFile;
                            VMSDiskInfo.this.startFileChooser(paramWi, file, false);
                        }
                    });
                    t.start();
                }
            });
            this.widgetAdd(param, prefix, paramWi);
            return paramWi;
        }
        Widget paramWi = super.createWidget(param, prefix, width);
        if ("type".equals(param) || "target_bus_type".equals(param)) {
            paramWi.setAlwaysEditable(false);
        } else if ("source_dev".equals(param)) {
            paramWi.setAlwaysEditable(true);
            if (prefix == null) {
                this.sourceDeviceWi.put("", paramWi);
            } else {
                this.sourceDeviceWi.put(prefix, paramWi);
            }
        } else if ("target_device".equals(param)) {
            paramWi.setAlwaysEditable(true);
            if (prefix == null) {
                this.targetDeviceWi.put("", paramWi);
            } else {
                this.targetDeviceWi.put(prefix, paramWi);
            }
        } else if ("driver_name".equals(param)) {
            if (prefix == null) {
                this.driverNameWi.put("", paramWi);
            } else {
                this.driverNameWi.put(prefix, paramWi);
            }
        } else if ("driver_type".equals(param)) {
            if (prefix == null) {
                this.driverTypeWi.put("", paramWi);
            } else {
                this.driverTypeWi.put(prefix, paramWi);
            }
        } else if ("driver_cache".equals(param)) {
            if (prefix == null) {
                this.driverCacheWi.put("", paramWi);
            } else {
                this.driverCacheWi.put(prefix, paramWi);
            }
        } else if ("readonly".equals(param)) {
            if (prefix == null) {
                this.readonlyWi.put("", paramWi);
            } else {
                this.readonlyWi.put(prefix, paramWi);
            }
        }
        return paramWi;
    }

    @Override
    protected void removeMyselfNoConfirm(boolean testOnly) {
        String virshOptions = this.getVMSVirtualDomainInfo().getVirshOptions();
        for (Host h : this.getVMSVirtualDomainInfo().getDefinedOnHosts()) {
            VMSXML vmsxml = this.getBrowser().getVMSXML(h);
            if (vmsxml == null) continue;
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("saved_target_device", this.getName());
            vmsxml.removeDiskXML(this.getVMSVirtualDomainInfo().getDomainName(), parameters, virshOptions);
        }
        this.getBrowser().periodicalVMSUpdate(this.getVMSVirtualDomainInfo().getDefinedOnHosts());
        this.removeNode();
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder(30);
        String name = this.getName();
        if (name == null) {
            return "new disk...";
        }
        s.append(name);
        s.append(" (");
        String saved = this.getParamSaved("target_bus_type");
        if (saved == null) {
            s.append("new...");
        } else if (TARGET_BUS_TYPES.containsKey(saved)) {
            s.append(TARGET_BUS_TYPES.get(saved));
        } else {
            s.append(saved);
        }
        s.append(')');
        return s.toString();
    }

    @Override
    protected String isRemoveable() {
        return null;
    }

    static MyButton getNewBtn(final VMSVirtualDomainInfo vdi) {
        MyButton newBtn = new MyButton("Add Disk");
        newBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        vdi.addDiskPanel();
                    }
                });
                t.start();
            }
        });
        return newBtn;
    }

    @Override
    protected String getParamRegexp(String param) {
        if ("file".equals(this.getComboBoxValue("type")) && "source_file".equals(param)) {
            return ".*[^/]$";
        }
        return super.getParamRegexp(param);
    }

    static {
        FIELD_TYPES.put("type", Widget.Type.RADIOGROUP);
        FIELD_TYPES.put("source_file", Widget.Type.COMBOBOX);
        FIELD_TYPES.put("readonly", Widget.Type.CHECKBOX);
        FIELD_TYPES.put("shareable", Widget.Type.CHECKBOX);
        FIELD_TYPES.put("target_device", Widget.Type.COMBOBOX);
        SHORTNAME_MAP = new HashMap<String, String>();
        SHORTNAME_MAP.put("type", "Type");
        SHORTNAME_MAP.put("target_device", "Target Device");
        SHORTNAME_MAP.put("source_file", "Source File");
        SHORTNAME_MAP.put("source_dev", "Source Device");
        SHORTNAME_MAP.put("target_bus_type", "Disk Type");
        SHORTNAME_MAP.put("driver_name", "Driver Name");
        SHORTNAME_MAP.put("driver_type", "Driver Type");
        SHORTNAME_MAP.put("driver_cache", "Driver Cache");
        SHORTNAME_MAP.put("readonly", "Readonly");
        SHORTNAME_MAP.put("shareable", "Shareable");
        PREFERRED_MAP = new HashMap<String, String>();
        DEFAULTS_MAP = new HashMap<String, String>();
        POSSIBLE_VALUES = new HashMap<String, Object[]>();
        TARGET_BUS_TYPES = new HashMap<String, String>();
        DRIVER_NAME_DEFUALT = null;
        POSSIBLE_VALUES.put("type", new StringInfo[]{new StringInfo("Image file", "file", null), new StringInfo("Disk/block device", BLOCK_TYPE, null)});
        POSSIBLE_VALUES.put("target_bus_type", new StringInfo[]{new StringInfo("IDE Disk", "ide/disk", null), new StringInfo("IDE CDROM", "ide/cdrom", null), new StringInfo("Floppy Disk", "fdc/floppy", null), new StringInfo("SCSI Disk", "scsi/disk", null), new StringInfo("USB Disk", "usb/disk", null), new StringInfo("Virtio Disk", "virtio/disk", null)});
        POSSIBLE_VALUES.put("driver_name", new String[]{DRIVER_NAME_DEFUALT, "file", DRIVER_NAME_QEMU, DRIVER_NAME_PHY});
        POSSIBLE_VALUES.put("driver_type", new String[]{null, "raw"});
        POSSIBLE_VALUES.put("driver_cache", new String[]{null, "default", "none", "writethrough", "writeback", "directsync", "unsafe"});
        for (StringInfo tbt : (StringInfo[])POSSIBLE_VALUES.get("target_bus_type")) {
            TARGET_BUS_TYPES.put(tbt.getInternalValue(), tbt.toString());
        }
        DEFAULTS_MAP.put("readonly", "False");
        DEFAULTS_MAP.put("shareable", "False");
        PREFERRED_MAP.put("driver_name", "file");
        TARGET_DEVICES_MAP.put("ide/disk", new String[]{"hda", "hdb", "hdd"});
        TARGET_DEVICES_MAP.put("ide/cdrom", new String[]{"hdc"});
        TARGET_DEVICES_MAP.put("fdc/floppy", new String[]{"fda", "fdb", "fdc", "fdd"});
        TARGET_DEVICES_MAP.put("scsi/disk", new String[]{"sda", "sdb", "sdc", "sdd"});
        TARGET_DEVICES_MAP.put("usb/disk", new String[]{"sda", "sdb", "sdc", "sdd"});
        TARGET_DEVICES_MAP.put("virtio/disk", new String[]{"vda", "vdb", "vdc", "vdd", "vde"});
    }
}

