/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15.set;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;
import org.apache.commons.collections15.Unmodifiable;
import org.apache.commons.collections15.iterators.UnmodifiableIterator;
import org.apache.commons.collections15.set.AbstractSortedSetDecorator;

public final class UnmodifiableSortedSet<E>
extends AbstractSortedSetDecorator<E>
implements Unmodifiable,
Serializable {
    private static final long serialVersionUID = -725356885467962424L;

    public static <E> SortedSet<E> decorate(SortedSet<E> set) {
        if (set instanceof Unmodifiable) {
            return set;
        }
        return new UnmodifiableSortedSet<E>(set);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.collection);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.collection = (Collection)in.readObject();
    }

    private UnmodifiableSortedSet(SortedSet<E> set) {
        super(set);
    }

    @Override
    public Iterator<E> iterator() {
        return UnmodifiableIterator.decorate(this.getCollection().iterator());
    }

    @Override
    public boolean add(E object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> coll) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> coll) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        SortedSet sub = this.getSortedSet().subSet(fromElement, toElement);
        return new UnmodifiableSortedSet(sub);
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        SortedSet sub = this.getSortedSet().headSet(toElement);
        return new UnmodifiableSortedSet(sub);
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        SortedSet sub = this.getSortedSet().tailSet(fromElement);
        return new UnmodifiableSortedSet(sub);
    }
}

