/*
 * Decompiled with CFR 0.152.
 */
package rfb;

import rdr.InStream;
import rfb.CMsgHandler;
import rfb.CMsgReader;
import rfb.Decoder;

public class HextileDecoder
extends Decoder {
    static final int BPP = 8;
    CMsgReader reader;

    public HextileDecoder(CMsgReader reader_) {
        this.reader = reader_;
    }

    static final int readPixel(InStream is) {
        return is.readU8();
    }

    @Override
    public void readRect(int x, int y, int w, int h, CMsgHandler handler) {
        InStream is = this.reader.getInStream();
        byte[] buf = this.reader.getImageBuf(1024, 0);
        int bg = 0;
        int fg = 0;
        for (int ty = y; ty < y + h; ty += 16) {
            int th = Math.min(y + h - ty, 16);
            for (int tx = x; tx < x + w; tx += 16) {
                int tw = Math.min(x + w - tx, 16);
                int tileType = is.readU8();
                if ((tileType & 1) != 0) {
                    is.readBytes(buf, 0, tw * th * 1);
                    handler.imageRect(tx, ty, tw, th, buf, 0);
                    continue;
                }
                if ((tileType & 2) != 0) {
                    bg = HextileDecoder.readPixel(is);
                }
                int len = tw * th;
                int ptr = 0;
                while (len-- > 0) {
                    buf[ptr++] = (byte)bg;
                }
                if ((tileType & 4) != 0) {
                    fg = HextileDecoder.readPixel(is);
                }
                if ((tileType & 8) != 0) {
                    int nSubrects = is.readU8();
                    for (int i = 0; i < nSubrects; ++i) {
                        if ((tileType & 0x10) != 0) {
                            fg = HextileDecoder.readPixel(is);
                        }
                        int xy = is.readU8();
                        int wh = is.readU8();
                        int sx = xy >> 4 & 0xF;
                        int sy = xy & 0xF;
                        int sw = (wh >> 4 & 0xF) + 1;
                        int sh = (wh & 0xF) + 1;
                        ptr = sy * tw + sx;
                        int rowAdd = tw - sw;
                        while (sh-- > 0) {
                            len = sw;
                            while (len-- > 0) {
                                buf[ptr++] = (byte)fg;
                            }
                            ptr += rowAdd;
                        }
                    }
                }
                handler.imageRect(tx, ty, tw, th, buf, 0);
            }
        }
    }
}

