/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.application;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.application.ApplicationException;
import org.osgi.service.application.ApplicationHandle;
import org.osgi.service.application.ScheduledApplication;

public abstract class ApplicationDescriptor {
    public static final String APPLICATION_NAME = "application.name";
    public static final String APPLICATION_ICON = "application.icon";
    public static final String APPLICATION_PID = "service.pid";
    public static final String APPLICATION_VERSION = "application.version";
    public static final String APPLICATION_VENDOR = "service.vendor";
    public static final String APPLICATION_VISIBLE = "application.visible";
    public static final String APPLICATION_LAUNCHABLE = "application.launchable";
    public static final String APPLICATION_LOCKED = "application.locked";
    public static final String APPLICATION_DESCRIPTION = "application.description";
    public static final String APPLICATION_DOCUMENTATION = "application.documentation";
    public static final String APPLICATION_COPYRIGHT = "application.copyright";
    public static final String APPLICATION_LICENSE = "application.license";
    public static final String APPLICATION_CONTAINER = "application.container";
    public static final String APPLICATION_LOCATION = "application.location";
    private final String pid;
    Delegate delegate;

    protected ApplicationDescriptor(String string) {
        if (null == string) {
            throw new NullPointerException("Application ID must not be null!");
        }
        this.pid = string;
        try {
            this.delegate = new Delegate();
            this.delegate.setApplicationDescriptor(this, string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("No implementation available for ApplicationDescriptor, property is: " + Delegate.cName);
        }
    }

    public final String getApplicationId() {
        return this.pid;
    }

    public abstract boolean matchDNChain(String var1);

    public final Map getProperties(String string) {
        Map map = this.getPropertiesSpecific(string);
        boolean bl = this.delegate.isLocked();
        Boolean bl2 = (Boolean)map.remove(APPLICATION_LOCKED);
        if (bl2 != null && bl2 != bl) {
            try {
                if (bl) {
                    this.lockSpecific();
                } else {
                    this.unlockSpecific();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        map.put(APPLICATION_LOCKED, new Boolean(bl));
        return map;
    }

    protected abstract Map getPropertiesSpecific(String var1);

    public final ApplicationHandle launch(Map map) throws ApplicationException {
        try {
            this.delegate.launch(map);
        }
        catch (SecurityException securityException) {
            this.isLaunchableSpecific();
            throw securityException;
        }
        if (!this.isLaunchableSpecific()) {
            throw new ApplicationException(2, "Cannot launch the application!");
        }
        try {
            return this.launchSpecific(map);
        }
        catch (IllegalStateException illegalStateException) {
            throw illegalStateException;
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (ApplicationException applicationException) {
            throw applicationException;
        }
        catch (Exception exception) {
            throw new ApplicationException(3, (Throwable)exception);
        }
    }

    protected abstract ApplicationHandle launchSpecific(Map var1) throws Exception;

    protected abstract boolean isLaunchableSpecific();

    public final ScheduledApplication schedule(String string, Map map, String string2, String string3, boolean bl) throws InvalidSyntaxException, ApplicationException {
        this.isLaunchableSpecific();
        try {
            return this.delegate.schedule(string, map, string2, string3, bl);
        }
        catch (SecurityException securityException) {
            this.isLaunchableSpecific();
            throw securityException;
        }
    }

    public final void lock() {
        try {
            this.delegate.lock();
        }
        catch (SecurityException securityException) {
            this.isLaunchableSpecific();
            throw securityException;
        }
        this.lockSpecific();
    }

    protected abstract void lockSpecific();

    public final void unlock() {
        try {
            this.delegate.unlock();
        }
        catch (SecurityException securityException) {
            this.isLaunchableSpecific();
            throw securityException;
        }
        this.unlockSpecific();
    }

    protected abstract void unlockSpecific();

    static class Delegate {
        static String cName;
        static Class implementation;
        static Method setApplicationDescriptor;
        static Method isLocked;
        static Method lock;
        static Method unlock;
        static Method schedule;
        static Method launch;
        Object target = AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                return implementation.newInstance();
            }
        });

        Delegate() throws Exception {
        }

        void setApplicationDescriptor(ApplicationDescriptor applicationDescriptor, String string) {
            try {
                try {
                    setApplicationDescriptor.invoke(this.target, applicationDescriptor, string);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw invocationTargetException.getTargetException();
                }
            }
            catch (Error error) {
                throw error;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        boolean isLocked() {
            try {
                try {
                    return (Boolean)isLocked.invoke(this.target, new Object[0]);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw invocationTargetException.getTargetException();
                }
            }
            catch (Error error) {
                throw error;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        void lock() {
            try {
                try {
                    lock.invoke(this.target, new Object[0]);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw invocationTargetException.getTargetException();
                }
            }
            catch (Error error) {
                throw error;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        void unlock() {
            try {
                try {
                    unlock.invoke(this.target, new Object[0]);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw invocationTargetException.getTargetException();
                }
            }
            catch (Error error) {
                throw error;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        ScheduledApplication schedule(String string, Map map, String string2, String string3, boolean bl) throws InvalidSyntaxException, ApplicationException {
            try {
                try {
                    return (ScheduledApplication)schedule.invoke(this.target, string, map, string2, string3, new Boolean(bl));
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw invocationTargetException.getTargetException();
                }
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                throw invalidSyntaxException;
            }
            catch (ApplicationException applicationException) {
                throw applicationException;
            }
            catch (Error error) {
                throw error;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        void launch(Map map) throws ApplicationException {
            try {
                try {
                    launch.invoke(this.target, map);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw invocationTargetException.getTargetException();
                }
            }
            catch (ApplicationException applicationException) {
                throw applicationException;
            }
            catch (Error error) {
                throw error;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        static {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    cName = System.getProperty("org.osgi.vendor.application.ApplicationDescriptor");
                    if (cName == null) {
                        throw new NoClassDefFoundError("org.osgi.vendor.application.ApplicationDescriptor property must be set");
                    }
                    try {
                        implementation = Class.forName(cName);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.toString());
                    }
                    try {
                        setApplicationDescriptor = implementation.getMethod("setApplicationDescriptor", ApplicationDescriptor.class, String.class);
                        isLocked = implementation.getMethod("isLocked", new Class[0]);
                        lock = implementation.getMethod("lock", new Class[0]);
                        unlock = implementation.getMethod("unlock", new Class[0]);
                        schedule = implementation.getMethod("schedule", String.class, Map.class, String.class, String.class, Boolean.TYPE);
                        launch = implementation.getMethod("launch", Map.class);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        throw new NoSuchMethodError(noSuchMethodException.toString());
                    }
                    return null;
                }
            });
        }
    }
}

