/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.wireadmin;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import org.osgi.service.wireadmin.WirePermissionCollection;

public final class WirePermission
extends BasicPermission {
    static final long serialVersionUID = -5583709391516569321L;
    public static final String PRODUCE = "produce";
    public static final String CONSUME = "consume";
    private static final int ACTION_PRODUCE = 1;
    private static final int ACTION_CONSUME = 2;
    private static final int ACTION_ALL = 3;
    private static final int ACTION_NONE = 0;
    private transient int action_mask;
    private volatile String actions = null;

    public WirePermission(String string, String string2) {
        this(string, WirePermission.parseActions(string2));
    }

    WirePermission(String string, int n) {
        super(string);
        this.setTransients(n);
    }

    private synchronized void setTransients(int n) {
        if (n == 0 || (n & 3) != n) {
            throw new IllegalArgumentException("invalid action string");
        }
        this.action_mask = n;
    }

    synchronized int getActionsMask() {
        return this.action_mask;
    }

    private static int parseActions(String string) {
        boolean bl = false;
        int n = 0;
        if (string == null) {
            return n;
        }
        char[] cArray = string.toCharArray();
        int n2 = cArray.length - 1;
        if (n2 < 0) {
            return n;
        }
        while (n2 != -1) {
            int n3;
            char c;
            while (n2 != -1 && ((c = cArray[n2]) == ' ' || c == '\r' || c == '\n' || c == '\f' || c == '\t')) {
                --n2;
            }
            if (!(n2 < 6 || cArray[n2 - 6] != 'p' && cArray[n2 - 6] != 'P' || cArray[n2 - 5] != 'r' && cArray[n2 - 5] != 'R' || cArray[n2 - 4] != 'o' && cArray[n2 - 4] != 'O' || cArray[n2 - 3] != 'd' && cArray[n2 - 3] != 'D' || cArray[n2 - 2] != 'u' && cArray[n2 - 2] != 'U' || cArray[n2 - 1] != 'c' && cArray[n2 - 1] != 'C' || cArray[n2] != 'e' && cArray[n2] != 'E')) {
                n3 = 7;
                n |= 1;
            } else if (!(n2 < 6 || cArray[n2 - 6] != 'c' && cArray[n2 - 6] != 'C' || cArray[n2 - 5] != 'o' && cArray[n2 - 5] != 'O' || cArray[n2 - 4] != 'n' && cArray[n2 - 4] != 'N' || cArray[n2 - 3] != 's' && cArray[n2 - 3] != 'S' || cArray[n2 - 2] != 'u' && cArray[n2 - 2] != 'U' || cArray[n2 - 1] != 'm' && cArray[n2 - 1] != 'M' || cArray[n2] != 'e' && cArray[n2] != 'E')) {
                n3 = 7;
                n |= 2;
            } else {
                throw new IllegalArgumentException("invalid permission: " + string);
            }
            bl = false;
            while (n2 >= n3 && !bl) {
                switch (cArray[n2 - n3]) {
                    case ',': {
                        bl = true;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid permission: " + string);
                    }
                }
                --n2;
            }
            n2 -= n3;
        }
        if (bl) {
            throw new IllegalArgumentException("invalid permission: " + string);
        }
        return n;
    }

    @Override
    public boolean implies(Permission permission) {
        if (permission instanceof WirePermission) {
            WirePermission wirePermission = (WirePermission)permission;
            int n = wirePermission.getActionsMask();
            return (this.getActionsMask() & n) == n && super.implies(permission);
        }
        return false;
    }

    @Override
    public String getActions() {
        String string = this.actions;
        if (string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            int n = this.getActionsMask();
            if ((n & 1) == 1) {
                stringBuffer.append(PRODUCE);
                bl = true;
            }
            if ((n & 2) == 2) {
                if (bl) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(CONSUME);
            }
            this.actions = string = stringBuffer.toString();
        }
        return string;
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new WirePermissionCollection();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof WirePermission)) {
            return false;
        }
        WirePermission wirePermission = (WirePermission)object;
        return this.getActionsMask() == wirePermission.getActionsMask() && this.getName().equals(wirePermission.getName());
    }

    @Override
    public int hashCode() {
        int n = 527 + this.getName().hashCode();
        n = 31 * n + this.getActions().hashCode();
        return n;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(" \"");
        stringBuffer.append(this.getName());
        String string = this.getActions();
        if (string.length() > 0) {
            stringBuffer.append("\" \"");
            stringBuffer.append(string);
        }
        stringBuffer.append("\")");
        return stringBuffer.toString();
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.actions == null) {
            this.getActions();
        }
        objectOutputStream.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.setTransients(WirePermission.parseActions(this.actions));
    }
}

