/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.promise;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.osgi.util.promise.FailedPromisesException;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseImpl;

public class Promises {
    private Promises() {
    }

    public static <T> Promise<T> resolved(T t) {
        return new PromiseImpl<T>(t, null);
    }

    public static <T> Promise<T> failed(Throwable throwable) {
        return new PromiseImpl<Object>(null, PromiseImpl.requireNonNull(throwable));
    }

    public static <T, S extends T> Promise<List<T>> all(Collection<Promise<S>> collection) {
        if (collection.isEmpty()) {
            ArrayList arrayList = new ArrayList();
            return Promises.resolved(arrayList);
        }
        ArrayList arrayList = new ArrayList(collection);
        PromiseImpl promiseImpl = new PromiseImpl();
        All all = new All(promiseImpl, arrayList);
        for (Promise promise : arrayList) {
            promise.onResolve(all);
        }
        return promiseImpl;
    }

    public static <T> Promise<List<T>> all(Promise<? extends T> ... promiseArray) {
        List list = Arrays.asList(promiseArray);
        return Promises.all(list);
    }

    private static final class All<T>
    implements Runnable {
        private final PromiseImpl<List<T>> chained;
        private final List<Promise<? extends T>> promises;
        private final AtomicInteger promiseCount;

        All(PromiseImpl<List<T>> promiseImpl, List<Promise<? extends T>> list) {
            this.chained = promiseImpl;
            this.promises = list;
            this.promiseCount = new AtomicInteger(list.size());
        }

        @Override
        public void run() {
            if (this.promiseCount.decrementAndGet() != 0) {
                return;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>(this.promises.size());
            ArrayList arrayList2 = new ArrayList(this.promises.size());
            Throwable throwable = null;
            for (Promise<T> promise : this.promises) {
                Object e;
                Throwable throwable2;
                try {
                    throwable2 = promise.getFailure();
                    e = throwable2 != null ? null : (Object)promise.getValue();
                }
                catch (Throwable throwable3) {
                    this.chained.resolve(null, throwable3);
                    return;
                }
                if (throwable2 != null) {
                    arrayList2.add(promise);
                    if (throwable != null) continue;
                    throwable = throwable2;
                    continue;
                }
                arrayList.add(e);
            }
            if (arrayList2.isEmpty()) {
                this.chained.resolve(arrayList, null);
            } else {
                this.chained.resolve(null, new FailedPromisesException(arrayList2, throwable));
            }
        }
    }
}

