/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.condpermadmin;

import java.util.ArrayList;

public class ConditionInfo {
    private final String type;
    private final String[] args;

    public ConditionInfo(String string, String[] stringArray) {
        this.type = string;
        String[] stringArray2 = this.args = stringArray != null ? (String[])stringArray.clone() : new String[]{};
        if (string == null) {
            throw new NullPointerException("type is null");
        }
    }

    public ConditionInfo(String string) {
        if (string == null) {
            throw new NullPointerException("missing encoded condition");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("empty encoded condition");
        }
        try {
            char[] cArray = string.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (Character.isWhitespace(cArray[n2])) {
                ++n2;
            }
            if (cArray[n2] != '[') {
                throw new IllegalArgumentException("expecting open bracket");
            }
            ++n2;
            while (Character.isWhitespace(cArray[n2])) {
                ++n2;
            }
            int n3 = n2;
            while (!Character.isWhitespace(cArray[n2]) && cArray[n2] != ']') {
                ++n2;
            }
            if (n2 == n3 || cArray[n3] == '\"') {
                throw new IllegalArgumentException("expecting type");
            }
            this.type = new String(cArray, n3, n2 - n3);
            while (Character.isWhitespace(cArray[n2])) {
                ++n2;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            while (cArray[n2] == '\"') {
                n3 = ++n2;
                while (cArray[n2] != '\"') {
                    if (cArray[n2] == '\\') {
                        ++n2;
                    }
                    ++n2;
                }
                arrayList.add(ConditionInfo.unescapeString(cArray, n3, n2));
                if (!Character.isWhitespace(cArray[++n2])) continue;
                while (Character.isWhitespace(cArray[n2])) {
                    ++n2;
                }
            }
            this.args = arrayList.toArray(new String[arrayList.size()]);
            char c = cArray[n2];
            ++n2;
            while (n2 < n && Character.isWhitespace(cArray[n2])) {
                ++n2;
            }
            if (c != ']' || n2 != n) {
                throw new IllegalArgumentException("expecting close bracket");
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("parsing terminated abruptly");
        }
    }

    public final String getEncoded() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        stringBuffer.append(this.type);
        for (int i = 0; i < this.args.length; ++i) {
            stringBuffer.append(" \"");
            ConditionInfo.escapeString(this.args[i], stringBuffer);
            stringBuffer.append('\"');
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getEncoded();
    }

    public final String getType() {
        return this.type;
    }

    public final String[] getArgs() {
        return (String[])this.args.clone();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ConditionInfo)) {
            return false;
        }
        ConditionInfo conditionInfo = (ConditionInfo)object;
        if (!this.type.equals(conditionInfo.type) || this.args.length != conditionInfo.args.length) {
            return false;
        }
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i].equals(conditionInfo.args[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 527 + this.type.hashCode();
        for (int i = 0; i < this.args.length; ++i) {
            n = 31 * n + this.args[i].hashCode();
        }
        return n;
    }

    private static void escapeString(String string, StringBuffer stringBuffer) {
        int n = string.length();
        block5: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append(c);
                    continue block5;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block5;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block5;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
    }

    private static String unescapeString(char[] cArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(n2 - n);
        for (int i = n; i < n2; ++i) {
            int n3 = cArray[i];
            if (n3 == 92 && ++i < n2) {
                n3 = cArray[i];
                switch (n3) {
                    case 34: 
                    case 92: {
                        break;
                    }
                    case 114: {
                        n3 = 13;
                        break;
                    }
                    case 110: {
                        n3 = 10;
                        break;
                    }
                    default: {
                        n3 = 92;
                        --i;
                    }
                }
            }
            stringBuffer.append((char)n3);
        }
        return stringBuffer.toString();
    }
}

