#!/bin/bash

readonly NEWS_DIR=/usr/share/parabola-laf/news
readonly NEWS_STAMP=~/.local/share/parabola-laf/last_news
readonly CLEANUP_MSG="These old news files are no longer needed. It is safe to delete them."
readonly TITLE="_EDITION_TITLE_"
readonly BUTTONS="OK:1,Don't show this again:0"


GetXRootWinId()
{
  xprop -notype -root | awk '$1=="_NET_SUPPORTING_WM_CHECK:"{print $5}'
}

GetWmName()
{
  # wait for X root window to be ready
  n=10 ; while (( n = n - 1 )) && [[ -z "$(GetXRootWinId)" ]] ; do sleep 1 ; done ;

  xprop -notype -id "$(GetXRootWinId)" | awk '$1=="_NET_WM_NAME"{print $3}'
}

DisplayNotice()
{
  which gxmessage > /dev/null || return

  gxmessage -title    "$TITLE"           \
            -file     $notice            \
            -buttons  "$BUTTONS"         \
            -default  "OK"               \
            -geometry 620x460            \
            -center -wrap -ontop -sticky
}

Cleanup()
{
  return # TODO:

  which gxmessage > /dev/null || return

  current_news="news-$(pacman -Si parabola-laf | awk '$1=="Version"{print $3}').txt"
  declare -a read_notices=( $(grep -v $current_news $NEWS_STAMP) )
  (( ${#read_notices[*]} > 10 )) || return

  gxmessage -title    "Delete read news items ?"                     \
            -buttons  "Keep them:1,Delete them:0"                    \
            -default  "Keep them"                                    \
            -geometry 620x460                                        \
            -center -wrap -ontop -sticky                             \
            "$CLEANUP_MSG$(printf "\n\t%s" "${read_notices[*]}")" && \
  echo $current_news > $NEWS_STAMP                                && \
  chroot $NEWS_DIR "pkexec rm ${read_notices[*]}"
}


# display unread news items
mkdir -p $(dirname $NEWS_STAMP) ; touch $NEWS_STAMP ;
cd $NEWS_DIR
for notice in news-* # e.g. news-${pkgver}-${pkgrel}
do  [ -f $notice                       ] && notice_exists=1 || notice_exists=0
    [ -z "$(grep $notice $NEWS_STAMP)" ] && is_unread=1     || is_unread=0
    [ -z "$(echo $(cat $notice))"      ] && is_blank=1      || is_blank=0

    (( $notice_exists && $is_unread )) || continue

    ( (( $is_blank )) || DisplayNotice ) && echo "$notice" >> $NEWS_STAMP && Cleanup &
done

# WM-specific startup tasks
case $(GetWmName) in
  '"Openbox"') which octopi-notifier && octopi-notifier & ;; # FIXME: issue #1850
  '"MATE"'   ) ;;
esac


# FIXME: wbar faux alpha is buggy
which wbar && killall wbar && cd $HOME && wbar &
